/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbvtkUnaryOperations.h"
#include "bbvtkPackage.h"
namespace bbvtk
{


BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,UnaryOperations)
BBTK_BLACK_BOX_IMPLEMENTATION(UnaryOperations,bbtk::AtomicBlackBox);
void UnaryOperations::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')

	if (bbGetInputIn1() == NULL)
	{
		std::cout << "Set In1 at least" << std::endl;
		return;
	}

	ope->SetInput1((vtkDataObject*)bbGetInputIn1());


	switch (bbGetInputOperation())
	{
		case 0:
				ope->SetConstantC( bbGetInputInConstant() );
				ope->SetOperationToAddConstant();

		break;
		case 1:
				ope->SetConstantC( -1.0 * bbGetInputInConstant() );
				ope->SetOperationToAddConstant();
		break;
		case 2:
				ope->SetConstantK( bbGetInputInConstant() );
				ope->SetOperationToMultiplyByK();
printf("EED UnaryOperations::Process()  2 \n");

		break;
		case 3:
				ope->SetConstantK( 1.0/bbGetInputInConstant() );
				ope->SetOperationToMultiplyByK();
printf("EED UnaryOperations::Process()  3 \n");
		break;
		case 4:
			 ope->SetOperationToInvert();
		break;
		case 5:
				ope->SetOperationToSin();
		break;
		case 6:
			ope->SetOperationToCos();

		break;
		case 7:
				ope->SetOperationToExp();
		break;
		case 8:
				ope->SetOperationToLog();
		break;
		case 9:
			 ope->SetOperationToAbsoluteValue();
		break;
		case 10:
			 ope->SetOperationToSquareRoot();
		break;
		case 11:
			 ope->SetConstantC( bbGetInputInConstant() );
			 ope->SetConstantK( bbGetInputNewValue() );
			 ope->SetOperationToReplaceCByK();
		break;


			
			
		default:
			std::cout << "Invalid Operation" << std::endl;
			return;
		break;
	}

	ope->Modified();
	ope->Update();
	vtkImageData* salida = ope->GetOutput();

	bbSetOutputOut(salida);
	bbSignalOutputModification();

}



void UnaryOperations::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX
//    Here we initialize the input 'In' to 0
   bbSetInputIn1(NULL);
   bbSetOutputOut(NULL);
   bbSetInputInConstant(0);
   bbSetInputNewValue(0);
   bbSetInputOperation(0);
   ope = vtkImageMathematics::New();
   constante = NULL;
}
void UnaryOperations::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should allocate the internal/output pointers
//    if any


}
void UnaryOperations::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should desallocate the internal/output pointers
//    if any

}
}
// EO namespace bbvtk


