/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbvtkVecImageGaussianSmooth.h"
#include "bbvtkPackage.h"

#include "vtkImageGaussianSmooth.h"


namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,VecImageGaussianSmooth)
BBTK_BLACK_BOX_IMPLEMENTATION(VecImageGaussianSmooth,bbtk::AtomicBlackBox);

	
	
	//---------------------------------------------------------------------
	void VecImageGaussianSmooth::bbUserSetDefaultValues()
	{
		bbSetInputStdDevX(2); 
		bbSetInputStdDevY(2); 
		bbSetInputStdDevZ(2);  
		bbSetInputiImage(0);
	}
	
	void VecImageGaussianSmooth::bbUserInitializeProcessing()
	{
	}
	
	//---------------------------------------------------------------------
	void VecImageGaussianSmooth::bbUserFinalizeProcessing()
	{ 
		int i,size = (int)VecVtkimagegaussiansmooth.size();
		for (i=0 ;  i<size ; i++)
		{		
			VecVtkimagegaussiansmooth[i]->Delete();
		}
		VecVtkimagegaussiansmooth.clear();
	}
	
	
	
	//---------------------------------------------------------------------
	
	void VecImageGaussianSmooth::Process()
	{
		bbUserFinalizeProcessing();
		
		vtkImageGaussianSmooth *vtkimagegaussiansmooth;
		VecResult.clear();

		double stdvX=bbGetInputStdDevX();
		double stdvY=bbGetInputStdDevY();
		double stdvZ=bbGetInputStdDevZ();
		
		int i,size=(int)bbGetInputIn().size();
		for (i=0 ;  i<size ; i++)
		{	
			vtkimagegaussiansmooth = vtkImageGaussianSmooth::New();
			vtkimagegaussiansmooth->SetInput( bbGetInputIn()[i] );
			vtkimagegaussiansmooth->SetStandardDeviation( stdvX,stdvY, stdvZ ); 
			vtkimagegaussiansmooth->Modified();
			vtkimagegaussiansmooth->Update();
			VecResult.push_back( vtkimagegaussiansmooth->GetOutput() );
			VecVtkimagegaussiansmooth.push_back(vtkimagegaussiansmooth);
		} //for i
		
		bbSetOutputOut(VecResult);
		if (bbGetInputiImage() < (int)VecResult.size())
		{
			bbSetOutputOutImage(VecResult[bbGetInputiImage()]);
		} //if
		
	}


}
// EO namespace bbvtk


