/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbvtkVecIsoSurfaceExtractor.h"
#include "bbvtkPackage.h"

#include "vtkProperty.h"
#include "vtkLinearTransform.h"

namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,VecIsoSurfaceExtractor)
BBTK_BLACK_BOX_IMPLEMENTATION(VecIsoSurfaceExtractor,bbtk::AtomicBlackBox);
	
	//-----------------------------------------------------------	
	void VecIsoSurfaceExtractor::bbUserSetDefaultValues()
	{
//EED std::cout << "================================VecIsoSurfaceExtractor::bbUserSetDefaultValues()" << std::endl;
		std::vector<double> colour;
		// 1- red
		colour.push_back(1.0);
		colour.push_back(0.0);
		colour.push_back(0.0);
		// 2- blue
		colour.push_back(0.0);
		colour.push_back(0.0);
		colour.push_back(1.0);
		// 3- yellow
		colour.push_back(1.0);
		colour.push_back(1.0);
		colour.push_back(0.0);
		// 4- green
		colour.push_back(0.0);
		colour.push_back(1.0);
		colour.push_back(0.0);
		// 5- 
		colour.push_back(0.0);
		colour.push_back(1.0);
		colour.push_back(1.0);
		
		// 6- 
		colour.push_back(0.5);
		colour.push_back(0.5);
		colour.push_back(0.5);
		
		bbSetInputColour(colour);
		bbSetInputTransform(NULL);
		bbSetInputOpacity(1);
		
		bbSetInputRenderer(NULL);
		bbSetInputIsovalue(128);
		bbSetInputOpacity(1);
	}
	
	//-----------------------------------------------------------	
	void VecIsoSurfaceExtractor::bbUserInitializeProcessing() 
	
	{ 
		//    bbSetInputIn(NULL);
		//    bbSetInputInVtkObject(NULL);
//EED std::cout << "================================VecIsoSurfaceExtractor::bbUserInitializeProcessing()" << std::endl;	
	}
	
	//-----------------------------------------------------------	
	void VecIsoSurfaceExtractor::bbUserFinalizeProcessing()
	{
//EED std::cout << "================================VecIsoSurfaceExtractor::bbUserFinalizeProcessing()" << std::endl;
		int i,size = VecMarchingcubes.size();
		for (i=0;i<size;i++)
		{
			VecMarchingcubes[i]->Delete();
			VecPolydatamapper[i]->Delete();
			VecVtkactor[i]->Delete();
		}
		VecMarchingcubes.clear();
		VecPolydatamapper.clear();
		VecVtkactor.clear();
	}
	
	//-----------------------------------------------------------	
	void VecIsoSurfaceExtractor::Process()
	{
//EED std::cout <<"================================VecIsoSurfaceExtractor::Process()" << std::endl;
		double r,g,b;
		vtkMarchingCubes  *marchingcubes;
		vtkPolyDataMapper *polydatamapper;
		vtkActor          *vtkactor;

		 int i,size;

		size = VecVtkactor.size();
		for( i=0 ; i<size ; i++)
		{
			if (bbGetInputRenderer()!=NULL )
			{
				bbGetInputRenderer()->RemoveActor( VecVtkactor[i] );
				VecMarchingcubes[i]->Delete();
				VecPolydatamapper[i]->Delete();
				VecVtkactor[i]->Delete();
			}
		}
		VecMarchingcubes.clear();
		VecPolydatamapper.clear();
		VecVtkactor.clear();

		size = bbGetInputIn().size();
		for( i=0 ; i<size ; i++){
			marchingcubes  = vtkMarchingCubes::New();
			polydatamapper = vtkPolyDataMapper::New();
			vtkactor       = vtkActor::New();

			polydatamapper->SetInput(marchingcubes->GetOutput());
			vtkactor->SetMapper(polydatamapper);

			polydatamapper->ScalarVisibilityOff();
			polydatamapper->ImmediateModeRenderingOn();

			VecMarchingcubes.push_back(marchingcubes);
			VecPolydatamapper.push_back(polydatamapper);
			VecVtkactor.push_back(vtkactor);
		} // for i

		for( i=0 ; i<size ; i++){
			// Visualisation - result volume
			marchingcubes=VecMarchingcubes[i];
			vtkactor=(vtkActor*)VecVtkactor[i];

			marchingcubes->SetInput( bbGetInputIn()[i] );
			marchingcubes->SetValue(0, bbGetInputIsovalue() );
			marchingcubes->Update();
			 
			if ( (i*3+1)<(int)(bbGetInputColour().size()) ){
				r = bbGetInputColour()[0+i*3];
				g = bbGetInputColour()[1+i*3]; 
				b = bbGetInputColour()[2+i*3];
			} else {
				r = bbGetInputColour()[0];
				g = bbGetInputColour()[1]; 
				b = bbGetInputColour()[2];
			}
			vtkactor->GetProperty()->SetColor( r,g,b );
 
			vtkactor->GetProperty()->SetOpacity( bbGetInputOpacity() );
			
			if ( bbGetInputTransform()!=NULL )
			{
				vtkactor->SetUserTransform( bbGetInputTransform() );
			}

			// Interface Update
			if (bbGetInputRenderer()!=NULL )
			{
				bbGetInputRenderer()->AddActor( vtkactor );
			}
		} // for i

		 bbSetOutputOut( VecVtkactor );
	}
}
// EO namespace bbvtk
