/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkVolumeRenderer.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.6 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */



#ifdef _USE_VTK_


#include "bbvtkVolumeRenderer.h"
#include "bbvtkPackage.h"

namespace bbvtk
{


   BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,VolumeRenderer)
   BBTK_BLACK_BOX_IMPLEMENTATION(VolumeRenderer,bbtk::AtomicBlackBox);





   void VolumeRenderer::bbUserSetDefaultValues() 
   { 
	   mRayCastFunction = NULL;
	   mMapper			= NULL;
	   mVolume			= NULL;
	   bbSetInputColorFunction(0);
		bbSetInputColorFunction1(0);
	   bbSetInputOpacityFunction(0);
   }
	
   void VolumeRenderer::bbUserInitializeProcessing() 
   { 

    // Create the pipeline
     //    mCast = vtkImageShiftScale::New();
     //    mCast->SetOutputScalarTypeToUnsignedChar();
     //    mCast->ClampOverflowOn();
    
    //    mMIP = vtkVolumeRayCastMIPFunction::New();
    //    mMIP->SetMaximizeMethodToScalarValue();

    mRayCastFunction = vtkVolumeRayCastCompositeFunction::New();
    mMapper = vtkVolumeRayCastMapper::New();
	   mMapper->SetVolumeRayCastFunction(mRayCastFunction);
	   mMapper->AutoAdjustSampleDistancesOn();

	   _volumeProperty = vtkVolumeProperty::New();	
	_volumeProperty->SetInterpolationTypeToLinear();
	_volumeProperty->ShadeOn();
	_volumeProperty->DisableGradientOpacityOn();	
	//_volumeProperty->SetColor(_ctfun);
	//_volumeProperty->SetScalarOpacity(_tfun );

    mVolume = vtkVolume::New();
	   mVolume->SetMapper(mMapper);
	   mVolume->SetProperty(_volumeProperty );

    //  mMapper->ScalarVisibilityOff();
    //    mMapper->ImmediateModeRenderingOn();

}

	//---------------------------------------------------------------------
   void VolumeRenderer::bbUserFinalizeProcessing() 
   { 
	   if (mRayCastFunction!=NULL)
	   {
		   mRayCastFunction->Delete();
		   mRayCastFunction=NULL;
	   }	  
	   if (mMapper!=NULL)
	   {
		   mMapper->Delete();
		   mMapper=NULL;
	   }	  
	   if (mVolume!=NULL)
	   {
		   mVolume->Delete();
		   mVolume=NULL;
	   }	  

   }
//---------------------------------------------------------------------

   void VolumeRenderer::Process()
   {
     bool changed = false;
     if ( bbGetInputStatus("In") != bbtk::UPTODATE )
       {
	 mMapper->SetInput( bbGetInputIn() );
	 changed = true;
       }

	   if ( ( bbGetInputStatus("ColorFunction") != bbtk::UPTODATE ) &&
	  ( bbGetInputColorFunction() != 0 ) )
       {
	 mVolume->GetProperty()->SetColor( bbGetInputColorFunction() );
	 changed = true;
       }

     if ( ( bbGetInputStatus("ColorFunction1") != bbtk::UPTODATE ) &&
	  ( bbGetInputColorFunction1() != 0 ) )
       {
	 mVolume->GetProperty()->SetColor( bbGetInputColorFunction1() );
	 changed = true;
       }

     if ( ( bbGetInputStatus("OpacityFunction") != bbtk::UPTODATE ) &&
	  ( bbGetInputOpacityFunction() != 0 ) )
       {
	 mVolume->GetProperty()->SetScalarOpacity(bbGetInputOpacityFunction());
	 changed = true;
       }
    
     if (changed) mMapper->Update();

	 bbSetOutputOut(mVolume);
	   
   }

}//namespace bbtk

#endif // _USE_VTK_

