/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "names.h"

bool checknum(std::string s)
{
        std::istringstream iss(s);
        std::ostringstream oss;
        int x;
        iss >> x;
        oss << x;       
        
        if( s == oss.str())
                return true;
        
        return false;
}



std::string StringClear(std::string in, std::vector<std::string> no)
{
  size_t found;
  
for (int i=0; i<no.size(); i++)
{
  std::string viejo = no.at(i);
  found=in.find(viejo);
  while (found!=std::string::npos)
  {
    //Mienstras halla
    int inicio = int(found);
    in.replace(found,viejo.length(),"");
    found=in.find(viejo);
  }
}
  return in;
}

std::string StringReplace(std::string in, std::string viejo, std::string nuevo)
{
  size_t found;

  // different member versions of find in the same order as above:
  found=in.find(viejo);
  while (found!=std::string::npos)
  {
    //Mienstras halla
    //int inicio = int(found); // JPR
    in.replace(found,viejo.length(),nuevo);
    found=in.find(viejo);
  }
return in;
}

std::vector < std::string > StringSplit(std::string str, std::string delim)
{
	std::vector<std::string> results;
	int cutAt;
	while( (cutAt = (int)str.find_first_of(delim)) != str.npos )
	{
		if(cutAt > 0)
		{
			results.push_back(str.substr(0,cutAt));
		}
			str = str.substr(cutAt+1);
		}
		if(str.length() > 0)
		{
			results.push_back(str);
		}
	return results;
}

std::string generateFileName(std::string input, int number, std::string prefix)
{
	//
	int ceros = 6;
	int position = input.find( "\\" ); // find first space 
	while ( position != std::string::npos ) 
	{
		input.replace( position, 1, "/" );
		position = input.find( "\\", position + 1 );
	}
	
    bool comienza_con_slash = false;
   
    if (input.at(0) == '/')
   		comienza_con_slash = true;
	//
	std::vector< std::string > partes = StringSplit(input, "/");

	std::stringstream number_str;
	number_str << number;
    std::string	number_str_texto = number_str.str();
    
    
    int tamanio = number_str_texto.size();
    int diferencia = ceros-tamanio;
    for (int i=0; i<diferencia ; i++)
        number_str_texto="0"+number_str_texto;

	std::string rta = partes[0];

	for (unsigned int i=1; i<partes.size(); i++)
	{
		if (i==partes.size()-1)
		{
			std::vector<std::string> partes_punto;
			partes_punto = StringSplit(partes[i], ".");
			/*
			La extension es: partes_punto[partes_punto.size()-1]
			*/
			std::string oldname = "";
			for (unsigned int h=0; h<partes_punto.size();h++)
			{
				oldname += partes_punto.at(h)+"_";
			}
			if (partes_punto.size() > 1)
				rta+="/"+prefix+"_"+oldname+"_"+number_str_texto+"."+partes_punto[partes_punto.size()-1];
			else
				rta+="/"+prefix+"_"+oldname+"_"+number_str_texto;
		}
		else
		{
			rta+="/"+partes[i];
		}
	}
	if (comienza_con_slash)
		rta = "/"+rta;
	return rta;
}

bool existFile(std::string myFileName)
{
	std::ifstream inp;
inp.open(myFileName.c_str(), std::ifstream::in);
inp.close();
if (!inp.fail())
{
   return true;
}else{
   return false;
}    
}

std::string guessName(std::string nombre)
{
   int iterador = 0;
   int max_iter = 10000;
   
   while(iterador < max_iter)
   {
   std::string nuevo = generateFileName(nombre, iterador, "Data");
   
   if (existFile(nuevo))
   {
      iterador++;
   }
   else
   {
	   std::cout << nuevo << std::endl;
       return nuevo;
   }
   }
   std::cout << nombre << std::endl;
   return nombre;
}

std::string guessExistent(std::string nombre, int* actual, bool* hay)
{
	std::string nada = "";
	if (actual == NULL || hay == NULL)
		return nada;
   int iterador = *actual;
   int max_iter = 1000;
   
   while(iterador < max_iter)
   {
   std::string nuevo = generateFileName(nombre, iterador, "Data");
   
   if (existFile(nuevo))
   {
	   *hay = true;
	   *actual = iterador;
      return nuevo;
   }
   else
   {
	   iterador++;
   }
   }
   *hay = false;
   return nada;
}
