#include "bbwxBitmapButton.h"
#include "bbwxPackage.h"
#include "bbtkInterpreter.h"
#include "bbtkExecuter.h"
namespace bbwx
{
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx,BitmapButton)
  BBTK_BLACK_BOX_IMPLEMENTATION(BitmapButton,bbtk::WxBlackBox);

  void BitmapButton::Process()
  {
    BitmapButtonWidget* w = (BitmapButtonWidget*)bbGetOutputWidget();
    if (w) 
    {
      UpdateColour();
      UpdateLabel();
      UpdateIcon();
    }
  }

  void BitmapButton::CreateWidget(wxWindow* parent)
  {
    bbSetOutputWidget(
      new BitmapButtonWidget(
        this,
        parent,
        bbGetInputBitmap(),
        bbtk::std2wx(bbGetInputLabel())
      )
    );
    UpdateColour();
  }

  void BitmapButton::bbUserSetDefaultValues()
  {
    bbSetInputIn("");
    bbSetInputBitmap(NULL);
    bbSetInputLabel("");
    colorVector defaultColor;
    defaultColor.push_back(0.75);
    defaultColor.push_back(0.75);
    defaultColor.push_back(0.75);
    bbSetInputColour(defaultColor);
    bbSetOutputWidget(0);
  }

  void BitmapButton::bbUserInitializeProcessing()
  {

  }

  void BitmapButton::bbUserFinalizeProcessing()
  {

  }

  void BitmapButton::UpdateColour()
  {
    BitmapButtonWidget* w = (BitmapButtonWidget*)bbGetOutputWidget();
    if ((bbGetInputColour()[0] == -1) && 
        (bbGetInputColour()[1] == -1) &&
        (bbGetInputColour()[2] == -1)
       )
    {
      w->SetColour( w->GetParent()->GetBackgroundColour() );
    } 
    else 
    {
      int r=(int) (255*bbGetInputColour()[0]);
      int g=(int) (255*bbGetInputColour()[1]);
      int b=(int) (255*bbGetInputColour()[2]);
      w->SetColour( wxColour(r,g,b) );
    }

  } 
  
  void BitmapButton::UpdateLabel()
  {
    BitmapButtonWidget* w = (BitmapButtonWidget*)bbGetOutputWidget();
    w->SetLabel( bbtk::std2wx( bbGetInputLabel() ) );
  }   

  void BitmapButton::UpdateIcon()
  {
    if(bbGetInputBitmap() != NULL)
    {
      BitmapButtonWidget* w = (BitmapButtonWidget*)bbGetOutputWidget();
      w->SetIcon(bbGetInputBitmap());
    }
  }

//--------------------------------------------------------------------------

  BitmapButtonWidget::BitmapButtonWidget(
    BitmapButton* bx,
    wxWindow* parent,
    wxBitmap* bitmap,
    wxString title
    ) : wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL),
      box(bx)
  { 
    this->title = title;
    wxPanel* panel  = this;
    sizer = new wxBoxSizer(wxHORIZONTAL);
    
    if(bitmap != NULL)
    {
      button = new wxBitmapButton(panel, -1, *bitmap, wxDefaultPosition, wxSize(bitmap->GetWidth(),bitmap->GetHeight()));

      sizer -> Add(button, 0, wxALL | wxALIGN_CENTER, 3);
      sizer -> Add(new wxStaticText(panel,-1,title), 0, wxALL | wxALIGN_CENTER, 3);  
    }
    else
    {
      button = new wxButton( panel, -1, title);
      sizer -> Add(button,1,wxEXPAND | wxALL | wxALIGN_CENTER, 5); 
    }
    Connect( button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , 
       (wxObjectEventFunction) 
       (void (wxPanel::*)(wxEvent&))
       &BitmapButtonWidget::OnClick ); 
    
    
    
    panel -> SetSizer(sizer);
    sizer->Fit(panel);
  }
  
  BitmapButtonWidget::~BitmapButtonWidget()
  {
  }
  
  
  void BitmapButtonWidget::OnClick( wxEvent& )
  {
    // Look for the interpreter or the executer if no interpreter
    bbtk::Interpreter::Pointer I;
    bbtk::VirtualExec::Pointer E;
      if (box->bbGetParent() != 0) 
  {
    bbtk::Factory::Pointer f = boost::dynamic_pointer_cast<bbtk::ComplexBlackBoxDescriptor>(box->bbGetParent()->bbGetDescriptor())->GetFactory();
    if ((f != 0)&&
        (f->GetExecuter()))
      {
        E = f->GetExecuter();
        I = E->GetInterpreter();
      }
  }
      if (I==0) 
  {
    //    bbtkError("CommandButton::DoProcess() : could not find interpreter");
    if (E==0) 
      {
        // If no executer : create a totally independant interpreter
        I = bbtk::Interpreter::New();
      }
    else 
      {
        // If executer : create an interpreter using E
        I = bbtk::Interpreter::New(E);
      }
  }
      
      std::string commandstr(box->bbGetInputIn());
    
    //  bbtk::Interpreter::mGlobalInterpreter->InterpretLine( commandstr );
    unsigned int i;
    bool ok=true;
    int pos1=0,pos2;
    pos2 = commandstr.find(";",pos1);
    std::string ccommand;
    while (ok==true)
      {
  if (pos2==-1) 
    {
      ok=false;
      ccommand=commandstr.substr(pos1,commandstr.length()-pos1 );
    } 
  else 
    {
      ccommand=commandstr.substr(pos1,pos2-pos1);
    }
  for ( i=0 ; i < ccommand.length() ; i++)
    {
      if (ccommand[i]==39) // '
        {
    ccommand[i]=34;  // "
        }
    }   
  I->InterpretLine( ccommand );
  pos1=pos2+1;
  pos2 = commandstr.find(";",pos2+1);
  
      }
   
    box->UpdateLabel();
    box->UpdateColour();
    box->bbSignalOutputModification();
  }

  void BitmapButtonWidget::SetLabel(wxString title)
  {
    button->SetLabel(title);
  }
  
  void BitmapButtonWidget::SetColour(wxColour color)
  {
    button->SetBackgroundColour(color);
  }

  void BitmapButtonWidget::SetIcon( wxBitmap* bitmap)
  {
    if(bitmap != NULL)
    {
      wxPanel* panel  = this;
      sizer->Clear();
      button->Destroy();

      button = new wxBitmapButton(panel, -1, *bitmap, wxDefaultPosition, wxSize(bitmap->GetWidth(),bitmap->GetHeight()));
      
      Connect( button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , 
       (wxObjectEventFunction) 
       (void (wxPanel::*)(wxEvent&))
       &BitmapButtonWidget::OnClick ); 
      
      sizer->Add(button, 0, wxALL | wxALIGN_CENTER, 3);
      sizer -> Add(new wxStaticText(panel,-1,title), 0, wxALL | wxALIGN_CENTER, 3);  
      sizer->RecalcSizes();
    }
  }
}
// EO namespace bbwx


