/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxCheckBox.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.5 $
=========================================================================*/

/* ---------------------------------------------------------------------

* Copyright (c) CREATIS-LRMN (Centre de Recherche en Imagerie Medicale)
* Authors : Eduardo Davila, Laurent Guigues, Jean-Pierre Roux
*
*  This software is governed by the CeCILL-B license under French law and 
*  abiding by the rules of distribution of free software. You can  use, 
*  modify and/ or redistribute the software under the terms of the CeCILL-B 
*  license as circulated by CEA, CNRS and INRIA at the following URL 
*  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
*  or in the file LICENSE.txt.
*
*  As a counterpart to the access to the source code and  rights to copy,
*  modify and redistribute granted by the license, users are provided only
*  with a limited warranty  and the software's author,  the holder of the
*  economic rights,  and the successive licensors  have only  limited
*  liability. 
*
*  The fact that you are presently reading this means that you have had
*  knowledge of the CeCILL-B license and that you accept its terms.
* ------------------------------------------------------------------------ */                                                                         

/**
 * \file 
 * \brief Short description in one line
 *
 * Long 
 * description
 *  
 */

#ifdef _USE_WXWIDGETS_

#include "bbwxCheckBox.h"
#include "bbwxPackage.h"
#include "bbtkUtilities.h"

namespace bbwx
{
  //--------------------------------------------------------------------------
  // The widget created by the box 
  class CheckBoxWidget : public wxPanel 
  {
  public:
    /// Ctor with the two first params the parent window and the creator box
    /// which must be passed to the WxBlackBoxWidget constructor.
    /// The other params initialize the widget 
    CheckBoxWidget(CheckBox* box, wxWindow *parent,
		 wxString title,
		 bool value, int reactiveOnKeyStroke
                 );
    /// Dtor
    ~CheckBoxWidget();
    /// Events callbacks
    /// Called when the box is clicked
    void OnCheckBoxClick(wxCommandEvent& event);

    // Accessors
    bool GetValue() { return mwxCheckBox->GetValue(); }
    void SetValue(bool val);
    // Update the texts which display the min/max/current values of the slider
	
  private:
    CheckBox*    mBox;
    wxCheckBox   *mwxCheckBox;
    int          _reactiveOnKeyStroke;
    bool         val;
  };
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------

  
    
  //-------------------------------------------------------------------------
  CheckBoxWidget::CheckBoxWidget(CheckBox* box, wxWindow *parent,
			     wxString title,
			     bool value, int reactiveOnKeyStroke)
    :  
    wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL),
    mBox(box),
    _reactiveOnKeyStroke(reactiveOnKeyStroke),
    val(value)
  {
    wxPanel * panel = this;
    int sizeX, sizeY;
    
    sizeX = sizeY = -1; // just to see JPR
    
    

    //---------------------------------------------------------------------
    // 1) Creation of the components of the widget
    // Any top level sub-widget must have the panel returned by panel
    // for parent
    mwxCheckBox = new wxCheckBox( panel, 
			      -1, 
			      title,
			      wxDefaultPosition, 
			      //wxSize(sizeX,sizeY),
			      wxDefaultSize, 
			      wxCHK_2STATE | wxALIGN_RIGHT);      

    mwxCheckBox->SetValue(value);

    // Connecting events to callbacks
    Connect( mwxCheckBox->GetId(), 
	     wxEVT_COMMAND_CHECKBOX_CLICKED, 
	     (wxObjectEventFunction) 
	     (void (wxPanel::*)(wxScrollEvent&))
	     &CheckBoxWidget::OnCheckBoxClick);
	      
    //---------------------------------------------------------------------

    //---------------------------------------------------------------------
    // 2) Insertion of the components in the window
    
    // We use a FlexGridSizer
    wxFlexGridSizer *sizer;
   sizer	= new wxFlexGridSizer(1);
    // Insert the sizer in the main panel and refresh the layout
    panel->SetSizer(sizer);
  }
  //-------------------------------------------------------------------------
  

  //-------------------------------------------------------------------------
  CheckBoxWidget::~CheckBoxWidget()
  {
  }
  //-------------------------------------------------------------------------


  //-------------------------------------------------------------------------



  //-------------------------------------------------------------------------
  void CheckBoxWidget::OnCheckBoxClick(wxCommandEvent& event)
  {
	  // When user clicks the box 
	  // we update the output of the box
	  mBox->bbSetOutputOut( mwxCheckBox->GetValue() );
	  mBox->bbSetInputIn( mwxCheckBox->GetValue() );
	  // and signal that the output has changed
	  //if(_reactiveOnKeyStroke==1){
	  mBox->bbSignalOutputModification(std::string("Out"));
	  //}
  }
  //-------------------------------------------------------------------------

  //-------------------------------------------------------------------------
  

  //-------------------------------------------------------------------------
  void CheckBoxWidget::SetValue(bool value)
  {
    this->val = value;
    mwxCheckBox->SetValue(value);
  }
  //-------------------------------------------------------------------------

 
  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  // WxBlackBox implementation
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  BBTK_BLACK_BOX_IMPLEMENTATION(CheckBox,bbtk::WxBlackBox);
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx,CheckBox);
  

	//-----------------------------------------------------------------	
	void CheckBox::bbUserSetDefaultValues()
	{
		bbSetInputIn(false);
		bbSetOutputOut(false);
		bbSetInputReactiveOnKeystroke(1);
	}
	
	//-----------------------------------------------------------------	
	void CheckBox::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void CheckBox::bbUserFinalizeProcessing()
	{
	}	
	
	
  //--------------------------------------------------------------------------
  void CheckBox::Process() 
  {
    bbSetOutputOut( bbGetInputIn() );
  }

  void CheckBox::CreateWidget(wxWindow* parent)
  {
   
    CheckBoxWidget *w =  new CheckBoxWidget(this, 
					parent, 
					bbtk::std2wx( bbGetInputTitle() ),
					bbGetInputIn(),
					bbGetInputReactiveOnKeystroke()
					);
    bbSetOutputWidget( w );
  }
  

} //namespace bbwx

#endif // _USE_WXWIDGETS_ 


