/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxColourSelector.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.8 $
=========================================================================*/

/* ---------------------------------------------------------------------

* Copyright (c) CREATIS-LRMN (Centre de Recherche en Imagerie Medicale)
* Authors : Eduardo Davila, Laurent Guigues, Jean-Pierre Roux
*
*  This software is governed by the CeCILL-B license under French law and 
*  abiding by the rules of distribution of free software. You can  use, 
*  modify and/ or redistribute the software under the terms of the CeCILL-B 
*  license as circulated by CEA, CNRS and INRIA at the following URL 
*  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
*  or in the file LICENSE.txt.
*
*  As a counterpart to the access to the source code and  rights to copy,
*  modify and redistribute granted by the license, users are provided only
*  with a limited warranty  and the software's author,  the holder of the
*  economic rights,  and the successive licensors  have only  limited
*  liability. 
*
*  The fact that you are presently reading this means that you have had
*  knowledge of the CeCILL-B license and that you accept its terms.
* ------------------------------------------------------------------------ */                                                                         

/**
 * \file
 * \brief Short description in one line
 *
 * Long
 * description
 *
 */

#ifdef _USE_WXWIDGETS_

#include "bbwxColourSelector.h"
#include "bbwxPackage.h"

#include <wx/colordlg.h>

namespace bbwx
{

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx,ColourSelector);
  BBTK_BLACK_BOX_IMPLEMENTATION(ColourSelector,bbtk::AtomicBlackBox);

	//-----------------------------------------------------------------	
	void ColourSelector::bbUserSetDefaultValues()
	{
	}
	
	//-----------------------------------------------------------------	
	void ColourSelector::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void ColourSelector::bbUserFinalizeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
  void ColourSelector::Process()
   {
      bbtkDebugMessageInc("Core",9,"ColourSelector::Process() ["
                          <<bbGetFullName()<<"]"<<std::endl);

      wxColourDialog *colordialog = new wxColourDialog( 0 );
      int result_colordialog = colordialog->ShowModal();

	// This line is need it by windows // EED
	colordialog->SetReturnCode( result_colordialog );

      if (colordialog->GetReturnCode()==wxID_OK)
      {
         char col[100];
         wxColour& c = colordialog->GetColourData().GetColour();
         sprintf(col,"%f %f %f",c.Red()/255.,c.Green()/255.,c.Blue()/255.);
         bbSetOutputOut( col );
      } else {
         bbSetOutputOut("");
      }
      bbtkDebugDecTab("Core",9);
   }

//  void ColourSelector::CreateWidget()
//  {
//    mColorDialog = new wxColourSelector( 0 );
//    bbSetOutputWidget( mColourSelector );
//  }

}//namespace bbwx

#endif // _USE_WXWIDGETS_ 

