/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxColourSelectorButton.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.11 $
=========================================================================*/

/**
 * \file
 * \brief Short description in one line
 *
 * Long
 * description
 *
 */

#ifdef _USE_WXWIDGETS_

#include "bbwxColourSelectorButton.h"
#include "bbwxPackage.h"

#include <wx/clrpicker.h>

namespace bbwx
{
//-------------------------------------------------------------------------
class wxColourPickerCtrlWidget :public wxPanel
{

public:
   wxColourPickerCtrlWidget( ColourSelectorButton* box,
                             wxWindow *parent,
                             unsigned char  cr,
                             unsigned char  cg,
                             unsigned char  cb  );

   ~wxColourPickerCtrlWidget();
   void OnColorChange(wxColourPickerEvent& e);
   void UpdateBox();
private:
   wxColourPickerCtrl *picker;
   ColourSelectorButton *mBox;
};
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
wxColourPickerCtrlWidget::wxColourPickerCtrlWidget(	ColourSelectorButton* box,
													wxWindow *parent, 
													unsigned char  cr,
													unsigned char  cg,
													unsigned char  cb
													)
  :   wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL),
  	  mBox(box)
{
    bbtkDebugMessage("Process",9,"=> wxColourPickerCtrlWidget::wxColourPickerCtrlWidget"<<std::endl);

    wxPanel * panel = this;
    picker = new wxColourPickerCtrl(panel,-1,
					wxColour(cr,cg,cb),
					wxDefaultPosition,
					wxDefaultSize,
					wxCLRP_USE_TEXTCTRL
				);
    picker->SetPickerCtrlGrowable(false);
    picker->SetTextCtrlGrowable(false);

    Connect ( picker->GetId(),
	      wxEVT_COMMAND_COLOURPICKER_CHANGED,
	      wxColourPickerEventHandler( wxColourPickerCtrlWidget::OnColorChange ) );

    bbtkDebugMessage("Process",9,"<= wxColourPickerCtrlWidget::wxColourPickerCtrlWidget"<<std::endl);
    wxFlexGridSizer *sizer = new wxFlexGridSizer(10);
	sizer -> AddGrowableRow(0);
	sizer -> Add( picker, 1, wxEXPAND, 0 );
	panel -> SetSizer(sizer);
  }

wxColourPickerCtrlWidget::~wxColourPickerCtrlWidget()
{
}


//---------------------------------------------------------------------
void wxColourPickerCtrlWidget::OnColorChange(wxColourPickerEvent& e)
{
	UpdateBox();
}


//---------------------------------------------------------------------
void wxColourPickerCtrlWidget::UpdateBox()
{
    char col[100];
    wxColour c = picker->GetColour();
    sprintf(col,"%f %f %f",c.Red()/255.,c.Green()/255.,c.Blue()/255.);

    //    std::cout << col << std::endl;

    ColourSelectorButton* b = (ColourSelectorButton*)mBox;
    b->bbSetOutputOut( col );
    b->bbSignalOutputModification("Out");
}

  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  // WxBlackBox implementation
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------

  BBTK_BLACK_BOX_IMPLEMENTATION(ColourSelectorButton,bbtk::WxBlackBox);
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx,ColourSelectorButton);
  
	//-----------------------------------------------------------------	
	void ColourSelectorButton::bbUserSetDefaultValues()
	{
		// Default input value
		bbSetInputIn("1 1 1");
		// Initial output value = the same than input
		bbSetOutputOut("1 1 1");
		// IMPORTANT : Initialize output widget to null pointer to test it after 
		bbSetOutputWidget(0);
	}
	
	//-----------------------------------------------------------------	
	void ColourSelectorButton::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void ColourSelectorButton::bbUserFinalizeProcessing()
	{
	}	

  void ColourSelectorButton::Process() 
  { 
  // The widget may not be created : have to test it before using it
    wxColourPickerCtrlWidget* w = ( wxColourPickerCtrlWidget* )bbGetOutputWidget();
    if (w) 
      {
	w->UpdateBox();
      }
    else 
      {
      // If widget does not exist yet you have to update the output value according 
      // to the input (which may have changed if the user set it)
	bbSetOutputOut(bbGetInputIn());
      }
  }


  /**
   * \brief  Create wxWidget .
   *
   *
   */
  void ColourSelectorButton::CreateWidget(wxWindow* parent)
  {
    
    float r,g,b;
    sscanf( bbGetInputIn().c_str(), "%f %f %f", &r, &g ,&b);
    unsigned char cr,cg,cb;
    cr = (unsigned char)(255.*r);
    cg = (unsigned char)(255.*g);
    cb = (unsigned char)(255.*b);

    wxColourPickerCtrlWidget* w = new wxColourPickerCtrlWidget(this, //bbGetWxParent() , 
								parent,
								cr , cg , cb );    
    
    bbSetOutputWidget( w );
  }


}  //namespace bbwx

#endif  // _USE_WXWIDGETS_

