//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbwxComboBox.h"
#include "bbwxPackage.h"


#include <vector>
#include <string>

#include <wx/choice.h>
#include <wx/control.h>
#include <wx/listbox.h>

namespace bbwx
{
  //--------------------------------------------------------------------------
  // The widget created by the box 
  class ComboBoxWidget : public wxPanel
  {
  public:
	ComboBoxWidget( ComboBox* box, wxWindow *parent, 
                      int iSelection, 
                      std::string title, 
                      std::vector< std::string > lstIn, 
							 int typeForm );

	~ComboBoxWidget();

	void OnComboBox(wxEvent& event);

  private:
    int 				mTypeForm;
    ComboBox		*mBox;
	 wxListBox		*wxlistbox;
	 wxChoice		*wxchoice;
  };
  


  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------

  //-------------------------------------------------------------------------
  ComboBoxWidget::ComboBoxWidget( ComboBox* box,
               wxWindow *parent,
               int iSelection,
               std::string title,
               std::vector< std::string > lstIn,
					int typeForm)
    :
    wxPanel( parent, -1) ,
    mBox(box),
    mTypeForm(typeForm)
  {
   wxPanel 	*panel		= this;
	wxlistbox 				= NULL;
	wxchoice					= NULL;
   int i;



    //---------------------------------------------------------------------
    // 2) Insertion of the components in the window
    
    // We use a FlexGridSizer
    wxFlexGridSizer *sizer	= new wxFlexGridSizer(1);
    if (title!="")
    {
	   sizer->Add( new wxStaticText(panel,-1,  bbtk::std2wx(title) ) ); 
    }
    sizer->AddGrowableCol(0);
    panel->SetSizer(sizer);

   
    //---------------------------------------------------------------------
    // 1) Creation de wxChoise widget

		if (mTypeForm==1)
		{

	 		wxlistbox = new wxListBox ( panel , -1 );			
		 	Connect( wxlistbox->GetId(), wxEVT_COMMAND_CHOICE_SELECTED, (wxObjectEventFunction) (void (wxPanel::*)(wxEvent&))&ComboBoxWidget::OnComboBox ); 
    		for (i=0;i<lstIn.size(); i++)
    		{
	   		wxlistbox->Append(  bbtk::std2wx( lstIn[i] )  ); 
	 		} // for i
    		wxlistbox->SetSelection(iSelection);
		   sizer->Add( wxlistbox,1,wxGROW ); 

		} else {

	 		wxchoice = new wxChoice ( panel , -1 );
	 		Connect( wxchoice->GetId(), wxEVT_COMMAND_CHOICE_SELECTED, (wxObjectEventFunction) (void (wxPanel::*)(wxEvent&))&ComboBoxWidget::OnComboBox ); 
    		for (i=0;i<lstIn.size(); i++)
    		{
	   		wxchoice->Append(  bbtk::std2wx( lstIn[i] )  ); 
	 		} // for i
    		wxchoice->SetSelection(iSelection);
		   sizer->Add( wxchoice,1,wxGROW ); 
		}


//    panel->SetAutoLayout(true);
//    panel->Layout();

  }
  //-------------------------------------------------------------------------
  
  ComboBoxWidget::~ComboBoxWidget()
  {
  }

  //--------------------------------------------------------------------------
  void ComboBoxWidget::OnComboBox(wxEvent& event)
  {
	 int iSelection;
	 if (mTypeForm==1)
	 {
 		 iSelection = wxlistbox->GetSelection();
	 } else {
 		 iSelection = wxchoice->GetSelection();
	 }

    mBox->bbSetInputSelection( iSelection );
    mBox->bbSetOutputOut( iSelection );
    mBox->bbSetOutputOutString(    bbtk::wx2std( wxchoice->GetString(iSelection) )     );
    mBox->bbSignalOutputModification("Out");
    mBox->bbSignalOutputModification("OutString");
  }


BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx,ComboBox)
BBTK_BLACK_BOX_IMPLEMENTATION(ComboBox,bbtk::WxBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ComboBox::Process()
{
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ComboBox::CreateWidget(wxWindow* parent)
{

//   bbSetOutputWidget( new wxStaticText ( parent , -1 , _T("") ) );
//   bbSetOutputWidget( new wxComboBox ( parent , -1 , _T("ups") ) );  
//   bbSetOutputWidget( new wxChoice ( parent , -1 ) );  

    ComboBoxWidget *w = new ComboBoxWidget(
                         	this,
									parent,
                         	bbGetInputSelection() ,
                         	bbGetInputTitle(),
                         	bbGetInputIn(),
                         	bbGetInputForm() );

   bbSetOutputOut( bbGetInputSelection() );
   bbSetOutputOutString( bbGetInputIn()[ bbGetInputSelection() ] );
   bbSetOutputWidget( w );


}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ComboBox::bbUserSetDefaultValues()
{
	bbSetInputSelection(0);
	bbSetInputTitle("");
	bbSetInputForm(0);
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ComboBox::bbUserInitializeProcessing()
{

}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ComboBox::bbUserFinalizeProcessing()
{

}
}
// EO namespace bbwx


