/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxCommandButton.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.16 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */


#ifdef _USE_WXWIDGETS_


#include "bbwxCommandButton.h"
#include "bbwxPackage.h"
#include "bbtkInterpreter.h"
#include "bbtkExecuter.h"



namespace bbwx
{


   //--------------------------------------------------------------------------
  class CommandButtonWidget : public wxPanel
  {
  public:
    CommandButtonWidget(CommandButton* box, wxWindow *parent, 
			wxString title);
    ~CommandButtonWidget();
    void OnCommandButton( wxEvent& );
    void SetLabel(wxString title);
    void SetColour(wxColour color);
	
  private:
    CommandButton* mBox;
    wxButton	*mwxCommandButton;
  }; 
   
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------

  CommandButtonWidget::CommandButtonWidget(CommandButton* box,
					   wxWindow *parent, 
					   wxString title )
    : wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL),
      mBox(box)
  { 

    wxPanel *panel	= this;

    mwxCommandButton = new wxButton( panel, -1, title);
    Connect( mwxCommandButton->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , 
	     (wxObjectEventFunction) 
	     (void (wxPanel::*)(wxEvent&))
	     &CommandButtonWidget::OnCommandButton ); 
    
    wxFlexGridSizer *sizer	= new wxFlexGridSizer(1);
    sizer -> Add( mwxCommandButton,1,wxGROW | wxALL,10 ); 
    sizer	-> AddGrowableCol(0);
    
    panel	-> SetSizer(sizer);
    panel	-> SetAutoLayout(true);
    panel	-> Layout();
    
  }
  
  CommandButtonWidget::~CommandButtonWidget()
  {
  }
  
  
  void CommandButtonWidget::OnCommandButton( wxEvent& )
  {
    // Look for the interpreter or the executer if no interpreter
    bbtk::Interpreter::Pointer I;
    bbtk::VirtualExec::Pointer E;
      if (mBox->bbGetParent() != 0) 
	{
	  bbtk::Factory::Pointer f = boost::dynamic_pointer_cast<bbtk::ComplexBlackBoxDescriptor>(mBox->bbGetParent()->bbGetDescriptor())->GetFactory();
	  if ((f != 0)&&
	      (f->GetExecuter()))
	    {
	      E = f->GetExecuter();
	      I = E->GetInterpreter();
	    }
	}
      if (I==0) 
	{
	  //	  bbtkError("CommandButton::DoProcess() : could not find interpreter");
	  if (E==0) 
	    {
	      // If no executer : create a totally independant interpreter
	      I = bbtk::Interpreter::New();
	    }
	  else 
	    {
	      // If executer : create an interpreter using E
	      I = bbtk::Interpreter::New(E);
	    }
	}
      
      std::string commandstr(mBox->bbGetInputIn());
    
    //	bbtk::Interpreter::mGlobalInterpreter->InterpretLine( commandstr );
    unsigned int i;
    bool ok=true;
    int pos1=0,pos2;
    pos2 = commandstr.find(";",pos1);
    std::string ccommand;
    while (ok==true)
      {
	if (pos2==-1) 
	  {
	    ok=false;
	    ccommand=commandstr.substr(pos1,commandstr.length()-pos1 );
	  } 
	else 
	  {
	    ccommand=commandstr.substr(pos1,pos2-pos1);
	  }
	for ( i=0 ; i < ccommand.length() ; i++)
	  {
	    if (ccommand[i]==39) // '
	      {
		ccommand[i]=34;  // "
	      }
	  }		
	I->InterpretLine( ccommand );
	pos1=pos2+1;
	pos2 = commandstr.find(";",pos2+1);
	
      }
   
    mBox->UpdateLabel();
    mBox->UpdateColour();
    mBox->bbSignalOutputModification();
  }

  
  //--------------------------------------------------------------------------
  
  void CommandButtonWidget::SetLabel(wxString title)
  {
    mwxCommandButton->SetLabel(title);
  }
  //--------------------------------------------------------------------------
  
  void CommandButtonWidget::SetColour(wxColour color)
  {
    mwxCommandButton->SetBackgroundColour(color);
  }



  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------- 

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx,CommandButton);
  BBTK_BLACK_BOX_IMPLEMENTATION(CommandButton,bbtk::WxBlackBox);

//-----------------------------------------------------------------	
	void CommandButton::bbUserSetDefaultValues()
	{
		bbSetInputIn("");
		bbSetInputLabel("");
		std::vector<double> lstColour;
		lstColour.push_back(0.75);
		lstColour.push_back(0.75);
		lstColour.push_back(0.75);
		bbSetInputColour(lstColour);
		bbSetOutputWidget(0);
	}
	
	//-----------------------------------------------------------------	
	void CommandButton::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void CommandButton::bbUserFinalizeProcessing()
	{
	}
	
  
  void CommandButton::Process() 
  { 
    CommandButtonWidget* w = (CommandButtonWidget*)bbGetOutputWidget();
    if (w) 
      {
	UpdateColour();
	UpdateLabel();
      }
  }
  
  void CommandButton::UpdateColour()
  {
    CommandButtonWidget* wxwidget = (CommandButtonWidget*)bbGetOutputWidget();
    if  ( (bbGetInputColour()[0]==-1) && 
	  (bbGetInputColour()[1]==-1) &&
	  (bbGetInputColour()[2]==-1) )
      {
	wxwidget->SetColour( wxwidget->GetParent()->GetBackgroundColour() );
      } 
    else 
      {
      int r=(int) (255*bbGetInputColour()[0]);
      int g=(int) (255*bbGetInputColour()[1]);
      int b=(int) (255*bbGetInputColour()[2]);
      wxwidget->SetColour( wxColour(r,g,b) );
    }

  } 
	
  void CommandButton::UpdateLabel()
  {
    CommandButtonWidget* wxwidget = (CommandButtonWidget*)bbGetOutputWidget();
    wxwidget->SetLabel( bbtk::std2wx( bbGetInputLabel() ) );
  }   
 
  /** 
   * \brief  Create wxWidget .  
   * 
   * 
   */  
  void CommandButton::CreateWidget(wxWindow* parent) 
  { 
    bbSetOutputWidget
      ( new CommandButtonWidget ( this, //bbGetWxParent(), 
								 parent,
								 bbtk::std2wx(bbGetInputLabel()) ) );
    UpdateColour();
  } 
 
 
}  //namespace bbwx 
 
#endif  // _USE_WXWIDGETS_ 
 
