/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxFileSelector.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.8 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */


#ifdef _USE_WXWIDGETS_


#include "bbwxFileSelector.h"
#include "bbwxPackage.h"
#include "bbtkWx.h"

#include <wx/filedlg.h>


namespace bbwx
{

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx,FileSelector);
  BBTK_BLACK_BOX_IMPLEMENTATION(FileSelector,bbtk::AtomicBlackBox);


	//-----------------------------------------------------------------	
	void FileSelector::bbUserSetDefaultValues()
	{
		bbSetInputOpenSave("Open");
	}
	
	//-----------------------------------------------------------------	
	void FileSelector::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void FileSelector::bbUserFinalizeProcessing()
	{
	}	
	
  void FileSelector::Process() 
  { 
    bbtkDebugMessageInc("Core",9,"FileSelector::Process() ["
			<<bbGetFullName()<<"]"<<std::endl);

    long style;
    if (bbGetInputOpenSave()=="Save") 
      {
	style = wxSAVE | wxOVERWRITE_PROMPT;
      }
    else 
      {
	style = wxOPEN | wxFILE_MUST_EXIST;
      }
    
    std::string wc(bbGetInputWildcard());
    if (wc=="") 
      {
	wc = "*";  // Any file must be shown
      }
    
    
    wxFileDialog* FD = new wxFileDialog( 0, 
					 bbtk::std2wx(bbGetInputMessage()),
					 bbtk::std2wx(bbGetInputDefaultDir()),
					 bbtk::std2wx(bbGetInputDefaultFile()),
					 bbtk::std2wx(wc),
					 style,
					 wxDefaultPosition);
//EED

    int result_FD = FD->ShowModal();

	// This line is need it by windows //EED
	FD->SetReturnCode( result_FD );

    if (FD->GetReturnCode()==wxID_OK)
      {
	bbSetOutputOut( bbtk::wx2std (FD->GetPath()) );
	bbSignalOutputModification(std::string("Out"));
      }
    else
      { 
	bbSetOutputOut("");
      }
    
    bbtkDebugDecTab("Core",9); 
  }
  
	


}//namespace bbtk

#endif // _USE_WXWIDGETS_ 

