/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxInputText.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.13 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */

#ifdef _USE_WXWIDGETS_

#include "bbwxInputText.h"
#include "bbwxPackage.h"
//#include <wx/dialog.h>


namespace bbwx
{
 
  //--------------------------------------------------------------------------
  class InputTextWidget : wxPanel
  {
  public:
    InputTextWidget(InputText* box, wxWindow *parent,
		    wxString In, wxString title);
    ~InputTextWidget();

    std::string GetValue();
	void SetValue(std::string value);

    void OnTextEnter(wxCommandEvent& event);
    void OnTextUpdate(wxCommandEvent& event);

    void SetTitle(wxString);

  private:
    InputText    *mBox;
    wxTextCtrl	 *mwxTextCtrl;
    wxStaticText *mwxTitle;
  };
  
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------

  InputTextWidget::InputTextWidget(InputText* box,
				   wxWindow *parent, 
				   wxString In, 
				   wxString title)
    : wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL),
      mBox(box)
  {
    wxPanel			*panel	= this;
    
    mwxTextCtrl = new wxTextCtrl( panel, -1, In,wxDefaultPosition, wxSize(800,20),wxTE_PROCESS_ENTER);
    Connect( mwxTextCtrl->GetId(),  wxEVT_COMMAND_TEXT_ENTER, 
	     (wxObjectEventFunction) 
	     (wxEventFunction)
	     (wxCommandEventFunction) 
	     (void (wxPanel::*)(wxCommandEvent&))
	     &InputTextWidget::OnTextEnter ); 

    Connect( mwxTextCtrl->GetId(),  wxEVT_COMMAND_TEXT_UPDATED, 
	     (wxObjectEventFunction) 
	     (wxEventFunction)
	     (wxCommandEventFunction) 
	     (void (wxPanel::*)(wxCommandEvent&))
	     &InputTextWidget::OnTextUpdate ); 


    wxFlexGridSizer *sizer	= new wxFlexGridSizer(1);
    mwxTitle = new wxStaticText(panel, -1, title ); 
    sizer-> Add( mwxTitle ); 
    sizer-> Add( mwxTextCtrl, 1, wxGROW ); 
    sizer-> AddGrowableCol(0);
    
    panel-> SetSizer(sizer);
    panel-> SetAutoLayout(true);
    panel-> Layout();

  }
  //-------------------------------------------------------------------------
  
  InputTextWidget::~InputTextWidget()
  {
  }

  //-------------------------------------------------------------------------
  
 
   void InputTextWidget::SetTitle(wxString s)
  { 
    mwxTitle->SetLabel(s);
  }

  //-------------------------------------------------------------------------
  std::string InputTextWidget::GetValue()
  { 
    return bbtk::wx2std ( mwxTextCtrl->GetValue() );
  }
	
  void InputTextWidget::SetValue(std::string value)
  { 
	mwxTextCtrl->SetValue( bbtk::std2wx(value) ) ;
  }
	
  //--------------------------------------------------------------------------
  void InputTextWidget::OnTextUpdate(wxCommandEvent& event)
  {
	if (mBox->bbGetInputReactiveOnKeystroke()==2){
	    mBox->bbSetOutputOut( GetValue() );
	    mBox->bbSetInputIn( GetValue() );
	    mBox->bbSignalOutputModification("Out");
	}
  }

  //--------------------------------------------------------------------------
  void InputTextWidget::OnTextEnter(wxCommandEvent& event)
  {
	if (mBox->bbGetInputReactiveOnKeystroke()==1){
	    mBox->bbSetOutputOut( GetValue() );
		mBox->bbSetInputIn( GetValue() );
		mBox->bbSignalOutputModification("Out");
	}
  }


  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx, InputText);
  BBTK_BLACK_BOX_IMPLEMENTATION(InputText, bbtk::WxBlackBox);

  
	//-----------------------------------------------------------------	
	void InputText::bbUserSetDefaultValues()
	{
		firsttime=true;
		bbSetInputTitle("");
		bbSetInputIn("");
		bbSetOutputWidget(0);
		bbSetInputReactiveOnKeystroke(2);
	}
	
	//-----------------------------------------------------------------	
	void InputText::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void InputText::bbUserFinalizeProcessing()
	{
	}

	
	//-----------------------------------------------------------------	
  void InputText::Process() 
  { 
    InputTextWidget *w=(InputTextWidget *)bbGetOutputWidget();
	if (w) 
	{
		if (firsttime==true)
		{
			firsttime=false;
			w->SetValue(  bbGetInputIn().c_str() );
		}
		w->SetTitle( bbtk::std2wx ( bbGetInputTitle() ) );
		bbSetOutputOut( w->GetValue() );
	} else {
	  bbSetOutputOut( "<VOID>" );
	}
  }
  


  void InputText::CreateWidget(wxWindow* parent)
  {
    bbSetOutputWidget
      ( (wxWindow*) new InputTextWidget(this, //bbGetWxParent(),
					parent,
					bbtk::std2wx ( bbGetInputIn() ) , 
					bbtk::std2wx ( bbGetInputTitle() ) ) );	
  }

}//namespace bbtk

#endif // _USE_WXWIDGETS_ 

