/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxLayoutLine.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.10 $
=========================================================================*/


/**
 *  \file
 *  \brief
 */


#ifdef _USE_WXWIDGETS_

#include "bbwxLayoutLine.h"
#include "bbwxPackage.h"
#include "bbtkUtilities.h"


namespace bbwx
{
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx, LayoutLine);
  BBTK_BLACK_BOX_IMPLEMENTATION(LayoutLine,bbtk::WxBlackBox);
  
	//-----------------------------------------------------------------	
	void LayoutLine::bbUserSetDefaultValues()
	{
		bbSetInputOrientation("VERTICAL");
		bbSetInputWidget1(NULL);
		bbSetInputWidget2(NULL);
		bbSetInputWidget3(NULL);
		bbSetInputWidget4(NULL);
		bbSetInputWidget5(NULL);
		bbSetInputWidget6(NULL);
		bbSetInputWidget7(NULL);
		bbSetInputWidget8(NULL);
		bbSetInputWidget9(NULL);
	}
	
	//-----------------------------------------------------------------	
	void LayoutLine::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void LayoutLine::bbUserFinalizeProcessing()
	{
	}	
	
	
  void LayoutLine::Process()
  {
  }
  
	
/*
  void LayoutLine::TryInsertWindow(wxWindow *parent, wxWindow *w,wxBoxSizer *sizer)
  {
    if (w!=NULL)
      {
	w->Reparent(parent);
	sizer->Add(w, 1, wxEXPAND, 0);
      }
  }
  */
	
  void LayoutLine::CreateWidget(wxWindow* parent)
  {
    wxBoxSizer *sizer;
    wxPanel *w=new wxPanel(parent, //bbGetWxParent(),
						   -1);
    w->SetName( bbtk::std2wx( bbGetInputWinTitle() ) );
    
    int style=0;
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),
				    "0|H|HORIZONTAL")==true)  
      { style=wxHORIZONTAL; }
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),
				    "1|V|VERTICAL")==true) 	
      { style=wxVERTICAL;   }
    
    sizer	= new wxBoxSizer(style);

	  wxWindow* cw;
	if ((cw=bbCreateWidgetOfInput("Widget1",w)) != 0) sizer->Add(cw, 1, wxEXPAND, 0);
	  if ((cw=bbCreateWidgetOfInput("Widget2",w)) != 0) sizer->Add(cw, 1, wxEXPAND, 0);
	  if ((cw=bbCreateWidgetOfInput("Widget3",w)) != 0) sizer->Add(cw, 1, wxEXPAND, 0);
	  if ((cw=bbCreateWidgetOfInput("Widget4",w)) != 0) sizer->Add(cw, 1, wxEXPAND, 0);
	  if ((cw=bbCreateWidgetOfInput("Widget5",w)) != 0) sizer->Add(cw, 1, wxEXPAND, 0);
	  if ((cw=bbCreateWidgetOfInput("Widget6",w)) != 0) sizer->Add(cw, 1, wxEXPAND, 0);
	  if ((cw=bbCreateWidgetOfInput("Widget7",w)) != 0) sizer->Add(cw, 1, wxEXPAND, 0);
	  if ((cw=bbCreateWidgetOfInput("Widget8",w)) != 0) sizer->Add(cw, 1, wxEXPAND, 0);
	  if ((cw=bbCreateWidgetOfInput("Widget9",w)) != 0) sizer->Add(cw, 1, wxEXPAND, 0);
	  /*
    TryInsertWindow(w,bbGetInputWidget1(),sizer);
    TryInsertWindow(w,bbGetInputWidget2(),sizer);
    TryInsertWindow(w,bbGetInputWidget3(),sizer);
    TryInsertWindow(w,bbGetInputWidget4(),sizer);
    TryInsertWindow(w,bbGetInputWidget5(),sizer);
    TryInsertWindow(w,bbGetInputWidget6(),sizer);
    TryInsertWindow(w,bbGetInputWidget7(),sizer);
    TryInsertWindow(w,bbGetInputWidget8(),sizer);
    TryInsertWindow(w,bbGetInputWidget9(),sizer);
    */
    w	-> SetSizer(sizer);
    bbSetOutputWidget( w );
  }
  
  // This callback is necessary to get actual processing of the view 
  // when window is shown
  void  LayoutLine::OnShowWidget()
  {
  }

}//namespace bbwx

#endif // _USE_WXWIDGETS_

