/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxLayoutSplit.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.14 $
=========================================================================*/

/**
 *  \file
 *  \brief
 */


#ifdef _USE_WXWIDGETS_

#include "bbwxLayoutSplit.h"
#include "bbwxPackage.h"
#include "bbtkUtilities.h"


namespace bbwx
{
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx,LayoutSplit);
  BBTK_BLACK_BOX_IMPLEMENTATION(LayoutSplit,bbtk::WxBlackBox);

	//-----------------------------------------------------------------	
	void LayoutSplit::bbUserSetDefaultValues()
	{
		bbSetInputOrientation("VERTICAL");
		bbSetInputProportion(50);
		bbSetInputWidget1(NULL);
		bbSetInputWidget2(NULL);		
	}
	
	//-----------------------------------------------------------------	
	void LayoutSplit::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void LayoutSplit::bbUserFinalizeProcessing()
	{
	}	
	
  void LayoutSplit::Process()
  {
  }

  void LayoutSplit::CreateWidget(wxWindow* parent)
  {
    wxSplitterWindow* w = new wxSplitterWindow(parent, //bbGetWxParent(),
					       -1,
					       wxDefaultPosition,
					       wxDefaultSize,
					       //wxSize(400,200),
					       wxSP_3D |
					       wxSP_LIVE_UPDATE );
    w->SetName( bbtk::std2wx( bbGetInputWinTitle() ) );
	w->SetMinimumPaneSize(2);
	//RaC Nov2012 Correctly resize internal panels with the window resize event
	w->SetSashGravity(0.5);
/*
	  wxWindow* w1 = bbGetInputWidget1();
    wxWindow* w2 = bbGetInputWidget2();

    if (w1==NULL) { w1=new wxPanel(bbGetWxParent()); }
    if (w2==NULL) { w2=new wxPanel(bbGetWxParent()); }
    w1->Reparent(w);
    w2->Reparent(w);
 */ 

	  wxWindow* w1 = bbCreateWidgetOfInput("Widget1",w);
	  wxWindow* w2 = bbCreateWidgetOfInput("Widget2",w);
	  if (w1==NULL) { w1=new wxPanel(parent); }
	  if (w2==NULL) { w2=new wxPanel(parent); }
	  
	  int orientation=0;
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"0|H|HORIZONTAL")==true)  { orientation=0; }
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"1|V|VERTICAL")==true)    { orientation=1; }
    

    if (orientation==1) { w->SplitHorizontally( w1, w2, 100); }
    else                { w->SplitVertically( w1, w2, 100);   }
  
    bbSetOutputWidget( w );
  }


  // This callback is necessary to get actual processing of the view 
  // when window is shown
  void  LayoutSplit::OnShowWidget()
  {
    //    std::cout << "LayoutSplit::OnShowWidget()" << std::endl;
    if (bbGetOutputWidget()==0)
      {
	return;
	//bbtkError("LayoutSplit::OnShowWidget() : Output Widget == 0 !");
      }
    wxSplitterWindow* win = (wxSplitterWindow*)bbGetOutputWidget();
    int w,h;
    if (win==0)
      {
	return;
	//	bbtkError("LayoutSplit::OnShowWidget() : win == 0 !");
      }
    win->GetClientSize(&w,&h);
    int pos = 100;
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),
				    "0|H|HORIZONTAL")==true)  
      { 
	pos = (int)(w * bbGetInputProportion() * 0.01);
      }
    else 
      {
	pos = (int)(h * bbGetInputProportion() * 0.01);
      } 
    //    std::cout << "pos = "<<pos<<std::endl;
  
    win->SetSashPosition(pos,true);
    //RaC Nov2012 Correctly resize internal panels with the window resize event
    win->SetSashGravity(0.5);

  }



}//namespace bbwx

#endif // _USE_WXWIDGETS_

