/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxLayoutTab.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.12 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */


#ifdef _USE_WXWIDGETS_


#include "bbwxLayoutTab.h"
#include "bbwxPackage.h"
#include "bbtkUtilities.h"




namespace bbwx
{
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx , LayoutTab);
  

  BBTK_BLACK_BOX_IMPLEMENTATION(LayoutTab,bbtk::WxBlackBox);
  
	//-----------------------------------------------------------------	
	void LayoutTab::bbUserSetDefaultValues()
	{
		bbSetInputOrientation("TOP");
		bbSetInputWidget1(NULL);
		bbSetInputWidget2(NULL);
		bbSetInputWidget3(NULL);
		bbSetInputWidget4(NULL);
		bbSetInputWidget5(NULL);
		bbSetInputWidget6(NULL);
		bbSetInputWidget7(NULL);
		bbSetInputWidget8(NULL);
		bbSetInputWidget9(NULL);
	}
	
	//-----------------------------------------------------------------	
	void LayoutTab::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void LayoutTab::bbUserFinalizeProcessing()
	{
	}
	
	
	//-----------------------------------------------------------------	
  void LayoutTab::TryInsertWindow(wxNotebook *book, const std::string& input )
  {
    wxWindow* w = bbCreateWidgetOfInput(input,book); //panel);
    if (w!=NULL)
      {
	book->AddPage(w,w->GetName());
      }
  }

  void LayoutTab::Process() 
  { 
  }
  
  
  void LayoutTab::CreateWidget(wxWindow* parent) 
  { 
    long style = wxNB_TOP;
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"0|T|TOP")==true) 
      { style=wxNB_TOP; }
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"1|R|RIGHT")==true)
      { style=wxNB_RIGHT; }
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"2|B|BOTTOM")==true)
      { style=wxNB_BOTTOM; }
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"3|L|LEFT")==true)
      { style=wxNB_LEFT; }
    wxNotebook *w = new wxNotebook(parent, //bbGetWxParent(),
				   -1, 
				   wxDefaultPosition,
				   wxDefaultSize,
				   style );
    w->SetName( bbtk::std2wx( bbGetInputWinTitle() ) );
    
    TryInsertWindow(w,"Widget1");
    TryInsertWindow(w,"Widget2");
    TryInsertWindow(w,"Widget3");
    TryInsertWindow(w,"Widget4");
    TryInsertWindow(w,"Widget5");
    TryInsertWindow(w,"Widget6");
    TryInsertWindow(w,"Widget7");
    TryInsertWindow(w,"Widget8");
    TryInsertWindow(w,"Widget9");
    
    bbSetOutputWidget( w );
  }
  
  
  // This callback is necessary to get actual processing of the view 
  // when window is shown
  void  LayoutTab::OnShowWidget()
  {
    wxNotebook* w = (wxNotebook*)bbGetOutputWidget();
    if (w) 
      {
	if (w->GetPageCount()>0)
	  {
	    w->SetSelection(0);
	    for (unsigned int i=0; i<w->GetPageCount(); ++i)  w->AdvanceSelection();
	  }
      }
    
   
  }


}//namespace bbwx

#endif

