/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxRadioButton.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.10 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */


#ifdef _USE_WXWIDGETS_


#include "bbwxRadioButton.h"
#include "bbwxPackage.h"

#include <vector>

namespace bbwx
{
    
  
  //--------------------------------------------------------------------------
  // The widget created by the box 
  class RadioButtonWidget : public wxPanel
  {
  public:
    RadioButtonWidget( RadioButton* box, wxWindow *parent, 
                      int In, 
                      wxString title, 
                      std::vector<wxString> lstIn );

    ~RadioButtonWidget();

    int GetValue();
    void OnRadioButton(wxEvent& event);

  private:
    RadioButton      *mBox;
    int	             MAX_RADIOBUTTON;
    wxRadioButton    *mwxRadioButton[10];
  };
  
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------

  //-------------------------------------------------------------------------
  RadioButtonWidget::RadioButtonWidget( RadioButton* box,
               wxWindow *parent,
               int In,
               wxString title,
               std::vector<wxString> lstIn )
    :
    wxPanel( parent, -1) ,
    mBox(box)
  {
    wxPanel *panel	= this;
    MAX_RADIOBUTTON = lstIn.size();
    int i;
    long style=wxRB_GROUP;
    for (i=0;i<MAX_RADIOBUTTON; i++)
    {
	   if ( lstIn[i]!=_T(""))
	   {
    //---------------------------------------------------------------------
    // 1) Creation of the components of the widget
    // Any top level sub-widget must have the panel returned by panel
    // for parent
	      mwxRadioButton[i] = new wxRadioButton( panel, -1, lstIn[i],wxDefaultPosition, wxDefaultSize, style);
	      style=0;
	      if (In==i)
	      {
		      mwxRadioButton[i]->SetValue(true);
	      } 
	      else 
	      {
		      mwxRadioButton[i]->SetValue(false);
	      }
	       Connect( mwxRadioButton[i]->GetId(),  
                   wxEVT_COMMAND_RADIOBUTTON_SELECTED, 
                  (wxObjectEventFunction) 
                  (void (wxPanel::*)(wxEvent&))
                  &RadioButtonWidget::OnRadioButton ); 
	   } 
	   else 
	   {
	       mwxRadioButton[i]=NULL;
	   }
    }
    
    //---------------------------------------------------------------------
    // 2) Insertion of the components in the window
    
    // We use a FlexGridSizer
    wxFlexGridSizer *sizer	= new wxFlexGridSizer(1);
    if (title!=_T(""))
    {
	   sizer->Add( new wxStaticText(panel,-1, title ) ); 
    }
    for (i=0;i<MAX_RADIOBUTTON; i++)
    {
       if (mwxRadioButton[i]!=NULL)
       {
          sizer->Add( mwxRadioButton[i],1,wxGROW ); 
       }
    }
    sizer->AddGrowableCol(0);
    panel->SetSizer(sizer);

//    panel->SetAutoLayout(true);
//    panel->Layout();

  }
  //-------------------------------------------------------------------------
  
  RadioButtonWidget::~RadioButtonWidget()
  {
  }

  //-------------------------------------------------------------------------
 
  int RadioButtonWidget::GetValue()
  { 
    int result=-1;
    int i;
    for (i=0;i<MAX_RADIOBUTTON; i++)
      {
	if ( mwxRadioButton[i]!=NULL)
	  {
	    if (mwxRadioButton[i]->GetValue()==true)
	      {
		result=i;
	      }
	  }
      }
    return result;
  }

  //--------------------------------------------------------------------------
  void RadioButtonWidget::OnRadioButton(wxEvent& event)
  {
    mBox->bbSetOutputOut( GetValue() );
    mBox->bbSetInputIn( GetValue() );
    mBox->bbSignalOutputModification("Out");
  }

  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wx,RadioButton);
  BBTK_BLACK_BOX_IMPLEMENTATION(RadioButton,bbtk::WxBlackBox);

  
	//-----------------------------------------------------------------	
	void RadioButton::bbUserSetDefaultValues()
	{
		bbSetInputIn(0);
		bbSetOutputOut( bbGetInputIn() );
		bbSetInputIn0("");
		bbSetInputIn1("");
		bbSetInputIn2("");
		bbSetInputIn3("");
		bbSetInputIn4("");
		bbSetInputIn5("");
		bbSetInputIn6("");
		bbSetInputIn7("");
		bbSetInputIn8("");
		bbSetInputIn9("");		
	}
	
	//-----------------------------------------------------------------	
	void RadioButton::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void RadioButton::bbUserFinalizeProcessing()
	{
	}
	
  void RadioButton::Process() 
  { 
    bbtkDebugMessageInc("Core",9,"RadioButton::Process()"<<std::endl);
    bbtkDebugDecTab("Core",9);
  }

  /**
   * \brief  Create wxWidget . 
   *
   *
   */ 
 void RadioButton::CreateWidget(wxWindow* parent)
  {

    std::vector<wxString> lstIn;
    lstIn.push_back( bbtk::std2wx(bbGetInputIn0()) );
    lstIn.push_back( bbtk::std2wx(bbGetInputIn1()) );
    lstIn.push_back( bbtk::std2wx(bbGetInputIn2()) );
    lstIn.push_back( bbtk::std2wx(bbGetInputIn3()) );
    lstIn.push_back( bbtk::std2wx(bbGetInputIn4()) );
    lstIn.push_back( bbtk::std2wx(bbGetInputIn5()) );
    lstIn.push_back( bbtk::std2wx(bbGetInputIn6()) );
    lstIn.push_back( bbtk::std2wx(bbGetInputIn7()) );
    lstIn.push_back( bbtk::std2wx(bbGetInputIn8()) );
    lstIn.push_back( bbtk::std2wx(bbGetInputIn9()) );

    RadioButtonWidget *w = new RadioButtonWidget(
                         this,
//                         bbGetWxParent(),
							parent,	
                         bbGetInputIn() ,
                         bbtk::std2wx(bbGetInputTitle()),
                         lstIn );

   bbSetOutputOut( bbGetInputIn() );
   bbSetOutputWidget( w );

  }




}//namespace bbtk

#endif // _USE_WXWIDGETS_ 

