/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
                                                                                
  Program:   bbtk
  Module:    $RCSfile: bbwxvtkViewer2D.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:36 $
  Version:   $Revision: 1.39 $
                                                                                
=========================================================================*/
/**
 *  \file 
 *  \brief 
 */


#ifdef USE_WXWIDGETS
#ifdef USE_VTK

#include "bbwxvtkViewer2D.h"
#include "bbwxvtkPackage.h"
//#include <wx/dialog.h>

#include "vtkInteractorStyleImage.h"
#include "vtkCamera.h"
#include "vtkRenderer.h"
#include <vtkInteractorStyleImage.h>
#include <vtkCommand.h>
#include <vtkImageActor.h>
namespace bbwxvtk
{
  //--------------------------------------------------------------------------
  class Viewer2DWidget : public wxPanel
  {
  public:
    Viewer2DWidget(Viewer2D* box, wxWindow *parent);
    ~Viewer2DWidget();
    void UpdateView();
    vtkRenderer		*GetRenderer();
    vtkImageActor       *GetImageActor();
  private:
    bool                        mFirstTime;
    Viewer2D                    *mBox;
    wxvtkImageViewer2		*imageViewer;
    vtkImageData		*backImageData;
    vtkImageData		*mDefaultImage;
    wxVTKRenderWindowInteractor *wxvtkrenderwindowinteractor;
    bool mUpdateCamera;

    vtkImplicitPlaneWidget * maPlane1, * maPlane2, * mbPlane1, * mbPlane2;
  };
  
  Viewer2DWidget::Viewer2DWidget(Viewer2D* box,
				 wxWindow *parent)
    :  
    wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL),
    mFirstTime(true),
    mBox(box)
  {
    wxPanel *panel	= this;

    wxvtkrenderwindowinteractor = new wxVTKRenderWindowInteractor(panel,-1);
    wxvtkrenderwindowinteractor->UseCaptureMouseOn();	

    imageViewer	= wxvtkImageViewer2::New();
    imageViewer->SetSlice( 1 );
    imageViewer->SetupInteractor ( wxvtkrenderwindowinteractor );
    
    mDefaultImage = vtkImageData::New();
    int dim[3];
    dim[0] = dim[1] = 256 ; 
    dim[2] = 2; 
    mDefaultImage->SetDimensions ( dim );
    mDefaultImage->SetSpacing(1,1,1);
    mDefaultImage->SetExtent(0,dim[0]-1,0,dim[1]-1,0,dim[2]-1);
    mDefaultImage->SetWholeExtent(0,dim[0]-1,0,dim[1]-1,0,dim[2]-1);

    mDefaultImage->SetScalarTypeToUnsignedChar();
    mDefaultImage->AllocateScalars();    
    for (int i=0;i<dim[0];i++) 
      for (int j=0;j<dim[1];j++) 
        for (int k=0;k<dim[2];k++) 
	   mDefaultImage->SetScalarComponentFromFloat(i,j,k,0,0);

    for (int i=0;i<dim[0];i++) 
      {
	/*
	mDefaultImage->SetScalarComponentFromFloat(i,0,0,0,255);
	mDefaultImage->SetScalarComponentFromFloat(i,dim[1]-1,0,0,255);
	mDefaultImage->SetScalarComponentFromFloat(0,i,0,0,255);
	mDefaultImage->SetScalarComponentFromFloat(dim[0]-1,i,0,0,255);
	mDefaultImage->SetScalarComponentFromFloat(i,0,1,0,255);
	mDefaultImage->SetScalarComponentFromFloat(i,dim[1]-1,1,0,255);
	mDefaultImage->SetScalarComponentFromFloat(0,i,1,0,255);
	mDefaultImage->SetScalarComponentFromFloat(dim[0]-1,i,1,0,255);
	*/
	mDefaultImage->SetScalarComponentFromFloat(i,i,0,0,255);
	mDefaultImage->SetScalarComponentFromFloat(i,dim[1]-i-1,0,0,255);
	mDefaultImage->SetScalarComponentFromFloat(i,i,1,0,255);
	mDefaultImage->SetScalarComponentFromFloat(i,dim[1]-i-1,1,0,255);
      }

    backImageData = mDefaultImage;
    imageViewer->SetInput( backImageData );
    mUpdateCamera = true;

    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    sizer->Add( wxvtkrenderwindowinteractor, 1, wxEXPAND, 0);
    panel->SetSizer(sizer);
    panel->SetAutoLayout(true);
    panel->Layout();


    //  wxvtkrenderwindowinteractor->Refresh();
    //  wxvtkrenderwindowinteractor->Render();
    //  imageViewer->GetRenderer()->ResetCameraClippingRange();

    imageViewer->GetRenderer()->SetBackground(0.1,0.1,0.2);

  }
  //-------------------------------------------------------------------------
  
  Viewer2DWidget::~Viewer2DWidget()
  {
    //    delete wxvtkrenderwindowinteractor;
    // pourquoi pas wxvtkrenderwindowinteractor->Delete(); // JP
    // LG : because it has been allocated with operator new not method ::New 
    // we want to force its destruction without taking care of vtk ref counting
    // on the contrary the following vtk objects are deleted with vtk Delete
    //    std::cout << "Viewer2DWidget::~Viewer2DWidget()" << std::endl;
    mDefaultImage->Delete();

    if (backImageData)
      {
	//	backImageData->UnRegister(NULL);
      }
    if (imageViewer) 
      {
	imageViewer->Delete();
      }
    delete wxvtkrenderwindowinteractor;
    //    std::cout << "Viewer2DWidget::~Viewer2DWidget() OK" << std::endl;
  }

  //-------------------------------------------------------------------------


  void Viewer2DWidget::UpdateView()
  {
    //    std::cout << "Viewer2DWidget::UpdateView() " << std::endl;
    //    std::cout << "slice="<<mBox->bbGetInputSlice()<<std::endl;
    mUpdateCamera = false; //JPR  
    if ( ( mBox->bbGetInputIn() == NULL ) &&
	 ( backImageData != mDefaultImage ) )
      {
	// 
	//	std::cout << "** Viewer2DWidget::UpdateView() : NULL Input (reset)" <<std::endl;
	backImageData = mDefaultImage;
	mUpdateCamera = true;
      }
    else if ( ( mBox->bbGetInputIn() != NULL ) && 
	      (( mBox->bbGetInputStatus("In") != bbtk::UPTODATE  ) ||
	       ( mFirstTime))
	      )
	      //(backImageData != mBox->bbGetInputIn()) ) 
      {	
	//	std::cout << "** Viewer2DWidget::UpdateView() : Input changed"	<<std::endl;
	mFirstTime = false;
	if (backImageData != mBox->bbGetInputIn()) // Don't update if just Slice changed
	  {
	  backImageData = mBox->bbGetInputIn();
	  backImageData->Update();
	  imageViewer->SetInput( backImageData );
	  mUpdateCamera = true;
	  }
      }

    if (mUpdateCamera)
      {
	//	std::cout << "** Viewer2DWidget::UpdateView() : Update Camera"
	//		  <<std::endl;
	int x1,x2,y1,y2,z1,z2;
	double spx,spy,spz;
	backImageData->GetSpacing(spx,spy,spz);
	backImageData->GetExtent (x1,x2,y1,y2,z1,z2);
	
	double *range = backImageData->GetScalarRange();
	imageViewer->SetColorWindow(range[1] - range[0]);
	imageViewer->SetColorLevel(0.5 * (range[1] + range[0]));

	imageViewer->GetRenderer()->ResetCamera();
	double bounds[6];
	imageViewer->GetRenderer()->ComputeVisiblePropBounds(bounds);
	imageViewer->GetRenderer()->ResetCameraClippingRange(bounds);
	
	//	bbtkMessage("Output",2,"Viewer2D '"<<mBox->bbGetName()<<"' - Image :"<<std::endl);
	//	std::cout << " extent  = "<< x1<<"-"<<x2<<" x "<<y1<<"-"<<y2<<" x "<<z1<<"-"<<z2<<std::endl;
	//	std::cout << " spacing = "<<spx << " - "<< spy << " - "<<spz<<std::endl;
	/*
	vtkCamera *camera = imageViewer->GetRenderer()->GetActiveCamera();

	camera->SetViewUp    ( spx*0,         -spy*1,        spz*0 );
	camera->SetPosition  ( spx*(x1+x2)/2, spy*(y1+y2)/2, -spz*10000000 ); 
	camera->SetFocalPoint( spx*(x1+x2)/2, spy*(y1+y2)/2, spz*0 ); 

	camera->ComputeViewPlaneNormal();
	camera->SetParallelScale(  spx*(x2-x1)/2.0 );
	//   
	//	imageViewer->GetRenderer()->ResetCamera(x1,x2,y1,y2,z1,z2);
	mUpdateCamera = false;
	//	std::cout << "Viewer2DWidget::UpdateView() passe par 3" << std::endl;
	imageViewer->SetColorWindow(512);
	imageViewer->SetColorLevel(256);
  	*/
	 /*
	for (int i=0;i<10;i++)
	  for (int j=0;j<10;j++)
	    std::cout << mBox->bbGetInputIn()->GetScalarComponentAsFloat(i,j,0,0)
		      << std::endl;
	 */
    }

    //  std::cout << "OW = "<< mBox->bbGetWindow() << std::endl;
    //  std::cout << "CW = "<< mBox->bbGetContainingWindow() << std::endl;
    //  std::cout << "Sh = "<< mBox->bbIsShown() << std::endl;

    bool interp = mBox->bbGetInputInterpolate();
    if ( interp )
    	imageViewer->GetImageActor()->InterpolateOn();
    else
    	imageViewer->GetImageActor()->InterpolateOff();
	
    
    int orientation = mBox->bbGetInputOrientation();
    if (orientation<0 || orientation>2) {
       bbtkMessage("Output", 2, "Viewer2D : Orientation was not 0< <2 "<<std::endl);
       orientation=2; // Why not?      
    }

    // mBox->bbIsShown() is necessary to be sure that the wxWindow is already 
    // created and displayed. 
    // Else when slice != 0 we get an X Window System error with wxGTK
    if (
	(backImageData!=NULL)&&
	(mBox->bbIsShown()))
    {
		int z = mBox->bbGetInputSlice();
		int ext[6];
		backImageData->GetWholeExtent(ext);
		/*
		std::cout << "ext = "<<ext[0]<<" - "<<ext[1]<<" ; "
			  <<ext[2]<<" - "<<ext[3]<<" ; "
			  <<ext[4]<<" - "<<ext[5]
			  <<std::endl;
		*/
            switch(orientation){
	       case 0:
		if (z<ext[0]) { z=ext[0]; }
		if (z>ext[1]) { z=ext[1]; }
		 
                break;
				   
	       case 1:
		if (z<ext[2]) { z=ext[2]; }
		if (z>ext[3]) { z=ext[3]; }
                break;
						    
	       case 2:
		if (z<ext[4]) { z=ext[4]; }
		if (z>ext[5]) { z=ext[5]; }
                break;
		
              default:
	        bbtkMessage("Output", 2, "Viewer2D : Orientation was not 0< <2 (shouldn't arrive here!"<<std::endl);
	        z = ext[5]; // Why not?
           }
	    wxvtkrenderwindowinteractor->Refresh();
	    wxvtkrenderwindowinteractor->Render();
	    bbtkDebugMessage("Output",3,"Viewer2D : slice = "<<z<<std::endl);
	    imageViewer->SetSliceOrientation (orientation);
	    imageViewer->SetSlice( z );

    }   
  }


  vtkRenderer * Viewer2DWidget::GetRenderer()
  {
	  return imageViewer->GetRenderer();
  }



  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------


  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wxvtk,Viewer2D);
  BBTK_BLACK_BOX_IMPLEMENTATION(Viewer2D,bbtk::WxBlackBox);

	
	//-----------------------------------------------------------------	
	void Viewer2D::bbUserSetDefaultValues()
	{
		bbSetInputIn(NULL);
		bbSetInputInterpolate(true);  // JP
		bbSetInputSlice(0);
		bbSetOutputWidget(0);
		bbSetOutputRenderer(0);
		bbSetInputOrientation(2);
	}
	
	//-----------------------------------------------------------------	
	void Viewer2D::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void Viewer2D::bbUserFinalizeProcessing()
	{
	}
	
	//--------------------------------------------------------------------------
  void Viewer2D::Process() 
  { 
    //    std::cout << "Viewer2D::Process" << std::endl;
    //    std::cout << "In="<<bbtk::GetIOStatusString(bbGetInputStatus("In")) << std::endl;
    //    std::cout << "Slice="<<bbtk::GetIOStatusString(bbGetInputStatus("Slice")) << std::endl;
    Viewer2DWidget* w = (Viewer2DWidget*)bbGetOutputWidget(); 
    if (w)
      {      
	w->UpdateView();
      }
    bbSetOutputOut( bbGetInputSlice() );  
  }
  



	//--------------------------------------------------------------------------
  void Viewer2D::CreateWidget(wxWindow* parent)
  {
    Viewer2DWidget* w = new Viewer2DWidget(this,parent);
    w->UpdateView();
    bbSetOutputWidget(w);
    bbSetOutputRenderer( ((Viewer2DWidget*)bbGetOutputWidget())->GetRenderer() );
  }



}//namespace bbtk

#endif
#endif

