/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
                                                                                
  Program:   bbtk
  Module:    $RCSfile: bbwxvtkViewer3D.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:36 $
  Version:   $Revision: 1.23 $
 
=========================================================================*/
/**
 *  \file 
 *  \brief 
 */


#ifdef _USE_WXWIDGETS_


#include "bbwxvtkViewer3D.h"
#include "bbwxvtkPackage.h"

#include "vtkCamera.h"



namespace bbwxvtk
{
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(wxvtk,Viewer3D);
  
  //-------------------------------------------------------------------------
  Viewer3DWidget::Viewer3DWidget(Viewer3D* box, wxWindow *parent, bool stereo)
    : 
    wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL),
    mBox(box)
  {
    wxPanel *panel = this;

    wxvtkrenderwindowinteractor = new wxVTKRenderWindowInteractor(panel,-1);
    wxvtkrenderwindowinteractor->UseCaptureMouseOn();

   renderer     = vtkRenderer::New();
   renderwindow = vtkRenderWindow::New();

   renderwindow->AddRenderer(renderer);

   if (stereo==true){
      renderwindow->SetStereoCapableWindow(1);
	   
//      renderwindow->SetStereoTypeToCrystalEyes();  
//      renderwindow->SetStereoTypeToRedBlue();         // OK 2.
	   
	   renderwindow->SetAnaglyphColorMask(4,3);
	   renderwindow->SetAnaglyphColorSaturation(0.65);
	   renderwindow->SetStereoTypeToAnaglyph();         // OK 1.
	   
//	   renderwindow->SetStereoTypeToInterlaced();	   // ??
//	   renderwindow->SetStereoTypeToCheckerboard();
//	   renderwindow->SetStereoTypeToDresden();
		
      renderwindow->SetStereoRender(1);
   }

   wxvtkrenderwindowinteractor->SetRenderWindow(renderwindow);
   
   interactorstyle = vtkInteractorStyleTrackballCamera ::New();
   interactorstyle->SetInteractor (  wxvtkrenderwindowinteractor );
   wxvtkrenderwindowinteractor->SetInteractorStyle( interactorstyle );
   
   int x1=0,x2=200,y1=0,y2=200,z1=0,z2=200;
   double spx=1,spy=1,spz=1;
   vtkCamera *camera = renderer->GetActiveCamera();
   camera->SetViewUp ( spx*0, -spy*1, spz*0);
   camera->SetPosition( spx*(x1+x2)/2, spy*(y1+y2)/2, -spz*10000000); 
   camera->SetFocalPoint	( spx*(x1+x2)/2	, spy*(y1+y2)/2	, spz*0); 
	  
	  
   //		camera->SetParallelScale(  spx*(x2-x1)/2.0 );
   renderer->ResetCamera(x1,x2,y1,y2,z1,z2);
   
   renderer->SetBackground(0.1, 0.1, 0.2);
  
   wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
   sizer->Add( wxvtkrenderwindowinteractor , 1, wxEXPAND, 0);
   panel->SetSizer(sizer);
   panel->SetAutoLayout(true);
   panel->Layout();
  
  }
  //-------------------------------------------------------------------------

  //-------------------------------------------------------------------------
  Viewer3DWidget::~Viewer3DWidget()
  {
    mBox->DisableObservers();
    mBox->bbSetOutputWidget(NULL);
    renderwindow->Delete();
    renderer->Delete();
    interactorstyle->Delete();
    delete wxvtkrenderwindowinteractor;
  }
  //-------------------------------------------------------------------------
  
  //-------------------------------------------------------------------------
  void Viewer3DWidget::Update()
  {
    //    wxvtkrenderwindowinteractor->Update();
    wxvtkrenderwindowinteractor->Render();
    renderer->ResetCameraClippingRange();
  }
  //-------------------------------------------------------------------------

  //-------------------------------------------------------------------------
  vtkRenderer *Viewer3DWidget::GetRenderer()
  {
     return renderer;
  }
  //-------------------------------------------------------------------------

  //-------------------------------------------------------------------------
  wxVTKRenderWindowInteractor * Viewer3DWidget::GetInteractor()
  {
    return wxvtkrenderwindowinteractor;
  }
  //-------------------------------------------------------------------------

void Viewer3DWidget::Refresh(bool eraseBackground , const wxRect* rect )
{
//  wxPanel::Refresh(false,rect);
}



  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------


  BBTK_BLACK_BOX_IMPLEMENTATION(Viewer3D,bbtk::WxBlackBox);

	
	//-----------------------------------------------------------------	
	void Viewer3D::bbUserSetDefaultValues()
	{ 
		firsttime=true;
		bbSetInputIn1(NULL);
		bbSetInputIn2(NULL);
		bbSetInputIn3(NULL);
		bbSetInputIn4(NULL);
		bbSetInputIn5(NULL);
		bbSetInputObs1(NULL);
		bbSetInputObs2(NULL);
		bbSetInputObs3(NULL);
		bbSetInputObs4(NULL);
		bbSetInputObs5(NULL);
		bbSetInputStereo(false);
		bbSetOutputRenderer( NULL );
		bbSetOutputInteractor( NULL );
		bbSetOutputWidget(NULL);
		std::vector<double> bckgrndColor(3);
		bckgrndColor[0] = 0.1;
		bckgrndColor[1] = 0.1;
		bckgrndColor[2] = 0.2;
		bbSetInputBackgroundColor(bckgrndColor);
	}
	
	//-----------------------------------------------------------------	
	void Viewer3D::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void Viewer3D::bbUserFinalizeProcessing()
	{  
	  DisableObservers();
	}

	void Viewer3D::DisableObservers()
	{  
	  Viewer3DWidget* w = (Viewer3DWidget*)bbGetOutputWidget();
	  if (w!=NULL)
	    { 
	      vtkRenderWindowInteractor *interactor = w->GetInteractor();
	      if (interactor!=NULL)
		{
		  if (bbGetInputObs1()!=NULL) 
		    {
		      if (bbGetInputObs1()->GetInteractor()!=NULL)
			bbGetInputObs1()->EnabledOff();
		    }
		  if (bbGetInputObs2()!=NULL) 
		    {
		      if (bbGetInputObs2()->GetInteractor()!=NULL)
		  //bbGetInputObs2()->SetInteractor(NULL);
		      bbGetInputObs2()->EnabledOff();
		    }
		  if (bbGetInputObs3()!=NULL) 
		    {
		     if (bbGetInputObs3()->GetInteractor()!=NULL)
		   //bbGetInputObs3()->SetInteractor(NULL);
		      bbGetInputObs3()->EnabledOff();
		    }
		  if (bbGetInputObs4()!=NULL) 
		    {
		     if (bbGetInputObs4()->GetInteractor()!=NULL)
		   //bbGetInputObs4()->SetInteractor(NULL);
		      bbGetInputObs4()->EnabledOff();
		    }
		  if (bbGetInputObs5()!=NULL) 
		    {
		   if (bbGetInputObs5()->GetInteractor()!=NULL)
		     //bbGetInputObs5()->SetInteractor(NULL);
		      bbGetInputObs5()->EnabledOff();
		    }
		}	
	    }
	}
	
	//--------------------------------------------------------------------------
  void Viewer3D::Process() 
  { 
	  
    if (!bbIsShown()) return;
//EED	  
//	  Viewer3DWidget* w = (Viewer3DWidget*)bbGetOutputWidget();
//	  if (w)   w->Update();


	  
    Viewer3DWidget* w = (Viewer3DWidget*)bbGetOutputWidget();
	  if ((firsttime==true) && (w!=NULL)){ 
		  firsttime=false;
		  
		  vtkRenderWindowInteractor *interactor = w->GetInteractor();
		  if (interactor!=NULL)
		  {

			  if (bbGetInputObs1()!=NULL) 
			  {
				  bbGetInputObs1()->SetInteractor(interactor);
				  bbGetInputObs1()->EnabledOn();
			  }
			  if (bbGetInputObs2()!=NULL) 
			  {
				  bbGetInputObs2()->SetInteractor(interactor);
				  bbGetInputObs2()->EnabledOn();
			  }
			  if (bbGetInputObs3()!=NULL) 
			  {
				  bbGetInputObs3()->SetInteractor(interactor);
				  bbGetInputObs3()->EnabledOn();
			  }
			  if (bbGetInputObs4()!=NULL) 
			  {
				  bbGetInputObs4()->SetInteractor(interactor);
				  bbGetInputObs4()->EnabledOn();
			  }
			  if (bbGetInputObs5()!=NULL) 
			  {
				  bbGetInputObs5()->SetInteractor(interactor);
				  bbGetInputObs5()->EnabledOn();
			  }
			  bbSetOutputInteractor(  w->GetInteractor() );
		  } // interactor
	
		  vtkRenderer *renderer = w->GetRenderer();
		  if (renderer!=NULL)
		  {
			  std::vector<double> bckgrndColor = bbGetInputBackgroundColor();
			  renderer->SetBackground(bckgrndColor[0], bckgrndColor[1], bckgrndColor[2]);
			  bbSetOutputRenderer( renderer );
			  
			  /*if (bbGetInputIn1()!=NULL) {renderer->AddActor( bbGetInputIn1() ); }
			  if (bbGetInputIn2()!=NULL) {renderer->AddActor( bbGetInputIn2() ); }
			  if (bbGetInputIn3()!=NULL) {renderer->AddActor( bbGetInputIn3() ); }
			  if (bbGetInputIn4()!=NULL) {renderer->AddActor( bbGetInputIn4() ); }
			  if (bbGetInputIn5()!=NULL) {renderer->AddActor( bbGetInputIn5() ); }
			  renderer->ResetCamera();
			  double bounds[6];
			  renderer->ComputeVisiblePropBounds(bounds);
			  renderer->ResetCameraClippingRange(bounds);*/
			  
		  } // renderer
		  
		  		  
	  } // w && firsttime

	  if(bbGetOutputRenderer()!=NULL){
		   vtkRenderer *renderer = w->GetRenderer();
		  if (bbGetInputIn1()!=NULL) {renderer->AddActor( bbGetInputIn1() ); }
		  if (bbGetInputIn2()!=NULL) {renderer->AddActor( bbGetInputIn2() ); }
		  if (bbGetInputIn3()!=NULL) {renderer->AddActor( bbGetInputIn3() ); }
		  if (bbGetInputIn4()!=NULL) {renderer->AddActor( bbGetInputIn4() ); }
		  if (bbGetInputIn5()!=NULL) {renderer->AddActor( bbGetInputIn5() ); }
		  renderer->ResetCamera();
		  double bounds[6];
		  renderer->ComputeVisiblePropBounds(bounds);
		  renderer->ResetCameraClippingRange(bounds);

	  }

	  if (w!=NULL)   w->Update();

  }
  

  /**
   * \brief  Create Widget . 
   *
   *
   */ 
  void Viewer3D::CreateWidget(wxWindow* parent)
  {
 
    bbtkDebugMessageInc("Core",9,"Viewer3D::CreateWidget()"<<std::endl);

    Viewer3DWidget* w = new Viewer3DWidget(this,
					   parent,
					   //bbGetWxParent(),
					   bbGetInputStereo());
    //EED  w->Update();
    //...
	  
    bbSetOutputWidget(w);
    
    bbtkDebugDecTab("Core",9);
    
  }

  // This callback is necessary to get actual processing of the view 
  // when window is shown
  void  Viewer3D::OnShowWidget()
  {
    Process();
	//    Viewer3DWidget* w = (Viewer3DWidget*)bbGetOutputWidget();
    //    if (w) w->Update();
  }


}//namespace bbwxvtk

#endif

