/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include <bbwxSlider.h>
#include <bbwxLayoutLine.h>
#include <creaWx.h>
//=========================================================================
// Illustrates how to insert a WxBlackBox into his own wxFrame
//=========================================================================

//==========================================================================
// A custom wxFrame which own a bbwx::Slider widget
class Frame : public wxFrame
{
public:
  Frame();
  // Slider callback
  void OnSlider( bbtk::BlackBox::Pointer p, const std::string& o,
		 bbtk::IOStatus s);
private:
  bbwx::Slider::Pointer mSlider;
  wxStaticText* mText;
};
//==========================================================================

//==========================================================================
Frame::Frame() :
  wxFrame((wxFrame *)0, -1, _T("A frame which contains a bbwx::Slider"), 
	  wxDefaultPosition, wxDefaultSize)
{
  wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);

  //========================================  
  // 1) Create the WxBlackBox
  mSlider = bbwx::Slider::New("slider");
  // 2) Create the widget giving it the parent
  mSlider->bbUserCreateWidget(this);
  // 3) Add an observer to process output modifications
  mSlider->bbAddOutputObserver ( "Out", 
				 BBTK_MAKE_OUTPUT_OBSERVER ( this,
							     &Frame::OnSlider ) );
  // 4) Add the created widget in the sizer
  sizer->Add(mSlider->bbGetOutputWidget(),1,wxGROW);
  //=========================================
  
  //=========================================
  // Create the static text as usual
  mText = new wxStaticText ( this, -1 , _T("") );
  sizer->Add(mText,1,wxGROW);
  //=========================================

  SetSizer(sizer);
  SetAutoLayout(true);
  Layout();
}
//==========================================================================

//==========================================================================
void Frame::OnSlider( bbtk::BlackBox::Pointer p, const std::string& o,
		      bbtk::IOStatus s)
{
  std::cout << "New slider value = " << mSlider->bbGetOutputOut() << std::endl;
  std::ostringstream val;
  val << mSlider->bbGetOutputOut();
  mText->SetLabel( bbtk::std2wx ( val.str() ) );
}
//==========================================================================

//==========================================================================
class App : public wxApp
{
public:
  bool OnInit( );
  int  OnExit() { return true; }
};
//==========================================================================

//==========================================================================
// The `main program' equivalent, creating the windows and returning the
// main frame
bool App::OnInit( )
{
  wxApp::OnInit();
#ifdef __WXGTK__
  //See http://www.wxwindows.org/faqgtk.htm#locale
  setlocale(LC_NUMERIC, "C");
#endif
  Frame* I = new Frame();
  I->Show(true);
  return true;
}
//=========================================================================

//=========================================================================
IMPLEMENT_APP(App);
CREA_WXMAIN_WITH_CONSOLE;
//=========================================================================
