/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=========================================================================
// How to create and use a script defined black box
//=========================================================================

//=========================================================================
#include <bbtkInterpreter.h>
//=========================================================================

//=========================================================================
int main(int argv, char* argc[])
{
  // To track all ...
  //bbtk::MessageManager::SetMessageLevel("all",9);
  
  try
    {
      // Create an interpreter
      bbtk::Interpreter::Pointer I = bbtk::Interpreter::New();
      
      // We tell the interpreter to throw exceptions on error
      I->SetThrow(true);

      // Interpret the file supposed to define a box called 'Processing'
      I->InterpretFile("bbProcessing.bbs");
      
      // Create an instance 'p' of the 'Processing' box
      bbtk::BlackBox::Pointer p 
	= I->GetExecuter()->GetFactory()->NewBlackBox("Processing","p");
      
      // Prompt the user
      std::cout << "Enter a number : ";
      double num = 0;
      std::cin >> num;

      // Set its input 'In' to num
      p->bbSetInput("In",num);

      // Execute it
      p->bbExecute();
      
      // Print out the output 'Out':
      // 1) We get the output with the generic bbGetOutput method.
      // 2) It returns a bbtk::Data which can store any data type
      // 3) We get the value of the data as a double using get<TYPE>()
      // (because we know it's a double !)
      double v = p->bbGetOutput("Out").get<double>();
      
      std::cout << num << "+1 = "<<v<<std::endl;
	
      //============================================================
      // Second example : imagine the bbProcessing.bbs script has created
      // the box "a" of type Processing
      // Here we simulate it using:
      I->InterpretLine("new Processing a");
      // We get a the black box "a" in the workspace:
      bbtk::BlackBox::Pointer a 
	= I->GetExecuter()->GetWorkspace()->GetPrototype()->bbGetBlackBox("a");
      // Then the same as previously...
      a->bbSetInput("In",num);
      a->bbExecute();
      double w = p->bbGetOutput("Out").get<double>();
      std::cout << "In case you did not understand:"<<std::endl<<num << "+1 = "<<w<<std::endl;

      // That's all !
   }
  catch (bbtk::Exception e)
    {
      std::cout << "* ERROR : "<<e.GetErrorMessage()<<std::endl;
      return 1;
    }
  return 0; 


  // To get the list of bbtk object still allocated after main ends
  // bbtk::StaticInitTime::PrintObjectListInfo = true;
  // bbtk::MessageManager::SetMessageLevel("object",1);
}
//=========================================================================
