/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include <bbwxSlider.h>
#include <bbwxOutputText.h>

//=========================================================================
// Different examples of using black boxes in C++
// Here we do not use wxWidgets however WxBlackBox work in **Dialog** mode 
//=========================================================================

//=========================================================================
void SimpleSliderDialog()
{
  std::cout << "============== Simple Slider dialog 1" << std::endl;
   try
    {
      bbwx::Slider::Pointer slider = bbwx::Slider::New("slider");
		std::cout << "============== Simple Slider dialog " << std::endl;
      //      slider->bbGetHelp();
      slider->bbSetInputWinDialog(true);  // mandatory
		std::cout << "============== Simple Slider dialog 3" << std::endl; 
      slider->bbExecute();
      std::cout << "Slider Output = "<< slider->bbGetOutputOut() << std::endl;
    }
  catch (bbtk::Exception e)
    {
      e.Print();
    } 
}
//=========================================================================

//=========================================================================
void SliderOutputTextWithoutFactory()
{
  std::cout << "============== Slider->OutputText without Factory" 
	    << std::endl;
  try
    {
      bbwx::Slider::Pointer slider = bbwx::Slider::New("slider");
      bbwx::OutputText::Pointer text = bbwx::OutputText::New("text");
      bbtk::Connection::Pointer s2t = bbtk::Connection::New(slider,"Out",
							    text,"In");
      text->bbExecute();
    }
  catch (bbtk::Exception e)
    {
      bbtk::MessageManager::SetMessageLevel("Error",1);
      e.Print();
    }
}
//=========================================================================


//=========================================================================
#include <bbtkFactory.h>
#include <bbwxLayoutLine.h>
void SliderOutputTextWithFactory()
{
  std::cout << "============== Slider->OutputText **WITH** Factory" 
	    << std::endl;
  try
    {
      bbtk::Factory::Pointer factory = bbtk::Factory::New();
  
      factory->LoadPackage("std");

      bbwx::Slider::Pointer     slider   = bbwx::Slider::New("slider");
      bbwx::OutputText::Pointer text     = bbwx::OutputText::New("text");
      bbtk::Connection::Pointer s2t      = bbtk::Connection::New(slider,"Out",
							    text,"In",
							    factory);
      bbwx::LayoutLine::Pointer layout   = bbwx::LayoutLine::New("layout");
      bbtk::Connection::Pointer c1       = bbtk::Connection::New(slider,"Widget",
							   layout,"Widget1");
      bbtk::Connection::Pointer c2       = bbtk::Connection::New(text,"Widget",
							   layout,"Widget2");
							   
      bbtk::Connection::Pointer c3       = bbtk::Connection::New(slider,"BoxChange",
							   text,"BoxExecute");
      // OR 
      //      text->bbSetInputBoxProcessMode("Reactive");
      
      layout->bbSetInputWinDialog(true);
      layout->bbExecute();
    }
  catch (bbtk::Exception e)
    {
      bbtk::MessageManager::SetMessageLevel("Error",1);
      e.Print();
    }
}
//=========================================================================

//=========================================================================
int main(int argv, char* argc[])
{
  // To track all ...
  //  bbtk::MessageManager::SetMessageLevel("all",9);
  
  SimpleSliderDialog();
  SliderOutputTextWithoutFactory();
  SliderOutputTextWithFactory();

  // To get the list of bbtk object still allocated after main ends
  // bbtk::StaticInitTime::PrintObjectListInfo = true;
  // bbtk::MessageManager::SetMessageLevel("object",1);
}
//=========================================================================
