#===========================================================================
# DOES THE USER WANT TO BUILD THE PACKAGE ?
OPTION(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME} 
  "Build the bbtk package ${BBTK_PACKAGE_NAME} ?" OFF)
#===========================================================================

IF(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME})
  #===========================================================================
  # THE USER HAS CHOSEN TO BUILD THE PACKAGE  
  #===========================================================================

  #===========================================================================
  # If the package is not a "core" bbtk package (included into the toolkit)
  # then we have to find and use bbtk 
  IF(NOT BBTK_CORE_PACKAGE)
    FIND_PACKAGE(BBTK REQUIRED)
    INCLUDE(${BBTK_USE_FILE})
  ENDIF(NOT BBTK_CORE_PACKAGE)
  #===========================================================================
  
  #===========================================================================
  # Include package configuration cmake script from bbtk cmake dir
  INCLUDE(${BBTK_CMAKE_DIR}/BBTKConfigurePackage.cmake)
  #=========================================================================== 
  
ELSE(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME})

  #===========================================================================
  # Else if it is a core package we have to reset some things...
  IF(BBTK_CORE_PACKAGE)
    INCLUDE(${BBTK_CMAKE_DIR}/BBTKConfigurePackage_BuildOff.cmake)   
  ENDIF(BBTK_CORE_PACKAGE)
  #===========================================================================

ENDIF(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME})
