/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------

#include "wxContourGUIExample.h"
#include "wxContourMainFrame.h"
//#include "OutlineModelManager.h"
//#include "wxContourEventHandler.h"

//#include <creaImageIOWxGimmickDialog.h>
//#include <creaImageIOWxGimmickReaderDialog.h>
#include <creaImageIOWxSimpleDlg.h>

#include <creaImageIOSystem.h>

#include <creaVtkBasicSlicer.h>
//#include "wxContourMainPanel.h"

#include "vtkMetaImageReader.h"
#include <map>
#include "vtkImageData.h"

#include "wx/artprov.h"
#include <wx/filedlg.h>


/* EED EraseMe
//#include "OutlineModelBuilder.h"
//#include "ContourThing.h"
//#include "AxeThing.h"
//#include "ImageSourceThing.h"
//#include "ImageSectionThing.h"
//#include "SomeEnvironment.h"
//#include "ReaderEnvironment.h"

//#include "interfMainPanel.h"

#if defined(MACOSX) // assume this is OSX
# include <sys/param.h>
# include <mach-o/dyld.h> // _NSGetExecutablePath : must add -framework CoreFoundation to link line
# include <string.h>
# ifndef PATH_MAX
#  define PATH_MAX MAXPATHLEN
# endif
#endif // MACOSX
*/

#ifndef PATH_MAX // If not defined yet : do it
#  define PATH_MAX 2048
#endif

#if defined(WIN32)
  #include <direct.h>
#else
   #include <dirent.h>
#endif

#include <stdlib.h>



wxContourMainFrame* wxTheApplication::frame = 0;

//----------------------------------------------------------------------------------------------------------------
// This macro implements the entry point (main function) for the application
//----------------------------------------------------------------------------------------------------------------






//=========================================================================
//=========================================================================
IMPLEMENT_APP( wxTheApplication );
/*
wxContourGUIExample :: wxContourGUIExample(const wxString& title, const wxPoint& pos, const wxSize& size)
: wxFrame((wxFrame *) NULL, -1, title, pos, size)
{
}
*/

#ifdef _DEBUG
void wxAppConsole::OnAssert(char const *,int,char const *,char const *)
{
}

void wxAppConsole::OnAssertFailure(char const *,int,char const *,char const *,char const *)
{
}
#endif



bool wxTheApplication :: OnInit()
{
	vtkOutputWindowCreaContour *outputWindowCreaContour= vtkOutputWindowCreaContour::New();
	vtkOutputWindow::SetInstance( outputWindowCreaContour );
	outputWindowCreaContour->Delete();

	wxString infoImage;
	wxInitAllImageHandlers();

//EED01Juin2010	int min_image_type = GIMMICK_2D_IMAGE_SELECTION;
//EED01Juin2010	int max_image_type = GIMMICK_3D_IMAGE_SELECTION;
//EED01Juin2010	int output_dim = NATIVE;
//EED01Juin2010	int threads = 1;


//EED 1Juin2010
      creaImageIO::WxSimpleDlg w(0,_T("Select your image"),"creaContours_Descriptor.dscp","creatisContours DB");
      w.ShowModal();

	std::vector<vtkImageData*> images;
//EED 1Juin2010
//	creaImageIO::WxGimmickReaderDialog w(0,
//										-1,
//										"creaContours_Descriptor.dscp",
//										"creatisContours DB",
//										_T("WxGimmickDialog test"),
//										wxDefaultPosition,wxSize(1200,800)
//										,min_image_type,
//										max_image_type,
//										output_dim,
//										threads);
//	w.ShowModal();


//JCP
	//std::string datadir(  crea::wx2std(GetExecutablePath()) );
	std::string datadir(  crea::System::GetExecutablePath() );
//JCP

   	    #ifdef LINUX /* assume this is OSX */
                   datadir=datadir+"/../share/creaContours";
	    #endif // MACOSX

		#ifdef MACOSX /* assume this is OSX */
			datadir=datadir+"/../../../../share/creaContours";
		#endif // MACOSX


		if(w.GetReturnCode() == wxID_OK)
		{
				std::vector<std::string> s;
//EED 01Juin2010				w.GetSelectedFiles(s);


//EED			std::vector<std::string>::iterator i;
//				for (i=s.begin();i!=s.end();++i)
//				{
//					std::cout << *i << std::endl;
//				}
//				std::cout << "$$$$ "<<std::endl;
				//w.GetSelectedImages(images);

//EED31mai2010				w.GetSelectedImages(images,output_dim);


//EED 1Juin2010
//				std::vector<creaImageIO::OutStrGimmick> out;
//				std::vector<std::string> attr;
////				attr.push_back("D0028_0010");
////				attr.push_back("D0008_0023");
////				attr.push_back("D0008_1070");
//				w.getSelected(out, attr,true,"");
////				std::cout<<out.size()<<std::endl;
////				crea::VtkBasicSlicer(out.front().img);
//				int size=out.size();
//				int ii;
//				for (ii=0;ii<size;ii++)
//				{
//					images.push_back(out[ii].img);
//				}

//EED 1Juin2010
//				printf("EED creaContours wxTheApplication :: OnInit  %d\n", w.getImagesSelected().size() );
				images	  = w.getImagesSelected();
				infoImage = w.getInfoImage();
//				printf("EED creaContours wxTheApplication :: OnInit  %d\n", images.size() );

		}
		else if (w.GetReturnCode() == wxID_CANCEL)
		{
				vtkMetaImageReader *reader = vtkMetaImageReader::New();
				std::string filename= datadir + "/data/hola.mhd";
				infoImage=_T("DEFAULT-Image:")+crea::std2wx(filename);
				reader->SetFileName( filename.c_str() );
				reader->Update();
				images.push_back(reader->GetOutput());
  			}
			else
			{
				return -1;
			}


	wxFrame* frame1 = new wxFrame(NULL, wxID_ANY, wxT("Creatis- ROI Application- Evaluation version,01 Agost 2010 ")+infoImage, wxPoint(400,50), wxSize(800, 600) );

	//frame = new wxContourMainFrame( frame1, wxID_ANY, wxString(_T("")), wxPoint(50,50), wxSize(800, 600), images );
	frame = wxContourMainFrame::getInstance(frame1, wxID_ANY, wxString(_T("")), wxPoint(200,50), wxSize(800, 600), images,  wxDEFAULT_FRAME_STYLE | wxSUNKEN_BORDER,datadir );
	frame1->CreateStatusBar();
	frame1->Show(TRUE);
    frame->RefreshInterface();
	return TRUE;
}

#if(WIN32)
int main(int argc, char* argv[])
  {
    return WinMain(::GetModuleHandle(NULL), NULL,
		   ::GetCommandLine(), SW_SHOWNORMAL);
  }
#else
#endif

