/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbCreaContournDimensions.h"
#include "bbcreaContoursPackage.h"

#include "creaSystem.h"
namespace bbcreaContours
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaContours,nDimensions)
BBTK_BLACK_BOX_IMPLEMENTATION(nDimensions,bbtk::WxBlackBox);
void nDimensions::Process()
{
	double **vectx = 0, **vecty = 0, **vectz = 0;

	std::vector< void * > vectortemp;
	std::vector<int> size;
	vtkImageData **mask = 0, **value = 0;

	vtkImageData* img = bbGetInputIn();

	std::vector<vtkImageData*> selectedimages;
	if(img!=NULL && currentimg!=img){

		printf("EED nDimensions::Process 02\n");	
		wxContourMainFrame::getInstance()->ShowToolsPanel(true);
		currentimg=img;
		selectedimages.push_back(img);
		wxContourMainFrame::getInstance()->setVectImages(selectedimages);
		printf("EED nDimensions::Process 03\n");	
	}

	if(currentimg != NULL){
		int contourtype = bbGetInputContourType();
		//wxContourMainFrame::getInstance()->getValuesXYZ(vectx, vecty, vectz, &size);
		//wxContourMainFrame::getInstance()->getMaskValue(mask, value, contourtype);
	}

	bbSetOutputX(vectx);
	bbSetOutputY(vecty);
	bbSetOutputZ(vectz);
	bbSetOutputSizeContour(size);
	bbSetOutputMask(*mask);
	bbSetOutputValue(*value);
}

//-----------------------------------------------------------------
void nDimensions::CreateWidget(wxWindow* parent)
{
	//vtkImageData* img = bbGetInputIn();

	std::vector<vtkImageData*> selectedimages;
	//selectedimages.push_back(img);

	//wxFrame* frame1 = new wxFrame(parent, wxID_ANY, wxT("ROI Application  -    Evaluation version, 23 Oct 2008 "), wxPoint(400,50), wxSize(800, 600) );
	//frame = wxContourMainFrame::getInstance(frame1, wxID_ANY, wxString(_T("")), wxPoint(100,50), wxSize(800, 600), selectedimages );
	//new wxContourMainFrame( frame1, wxID_ANY, _T(""), wxPoint(50,50), wxSize(800, 600),selectedimages );
	//frame1->CreateStatusBar();
	//bbSetOutputWidget( frame1 );
std::string datadir=".";
#ifdef WIN32
printf("EED WARNING Verify that GetDllAppPath in  nDimensions::CreateWidget bbCreaContournDimensions is working.. \n");
	datadir = crea::System::GetDllAppPath("bbCreaContours.dll");
#else
	datadir= crea::System::GetExecutablePath();
#endif
	
	
#ifdef LINUX /* assume this is OSX */
	datadir=datadir+"/../share/creaContours";
#endif // MACOSX	
	
#ifdef MACOSX /* assume this is OSX */
	datadir=datadir+"/../../../../share/creaContours";
#endif // MACOSX	
	
	
	printf("EED nDimensions::CreateWidget path=%s\n",datadir.c_str() );

	wxPanel* panel = wxContourMainFrame::getInstance(parent, wxID_ANY, wxString(_T("")), wxPoint(100,50), wxSize(800, 600), selectedimages,wxDEFAULT_FRAME_STYLE | wxSUNKEN_BORDER,datadir );
	wxContourMainFrame::getInstance()->ShowToolsPanel(false);
//EED	bbSetOutputWidget( panel );
		bbSetOutputWidget( new wxPanel(parent,-1) );
}

//-----------------------------------------------------------------
void nDimensions::bbUserSetDefaultValues()
{
	bbSetInputContourType(0);
	bbSetInputIn(NULL);
}

//-----------------------------------------------------------------
void nDimensions::bbUserInitializeProcessing()
{
}

//-----------------------------------------------------------------
void nDimensions::bbUserFinalizeProcessing()
{
}

}  // EO namespace bbCreaContour
