/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfDeleteMenu.h"

interfDeleteMenu::interfDeleteMenu(wxWindow * parent, int sizex, int sizey,wxEvtHandler* evtHandler, std::string datdir)
	: interfMenuBar(parent, sizex, sizey)
{
	this->datadir = datdir;
	initButtons(this);
}

void interfDeleteMenu::initButtons(wxEvtHandler* evtHandler) {

	std::vector<std::string> path, nom;
	std::vector<wxObjectEventFunction> funct;

	path.push_back(datadir + "/DeleteContour.png");
	nom.push_back("Delete the selected contour");
	funct.push_back((wxObjectEventFunction)&interfDeleteMenu::onDeleteContour);

	path.push_back(datadir + "/DeleteAllContourSlide.png");
	nom.push_back("Delete all contours in the current slide");
	funct.push_back((wxObjectEventFunction)&interfDeleteMenu::onDeleteContoursActSlice);

	path.push_back(datadir + "/DeleteAll.png");
	nom.push_back("Delete all contours in all slides");
	funct.push_back((wxObjectEventFunction)&interfDeleteMenu::onDeleteAllContours);

    this->addButtons(path, nom);

	this->setVectorFunction(funct);	
	this->connectEvents(evtHandler);

}

interfDeleteMenu::~interfDeleteMenu()
{
}


void interfDeleteMenu::onDeleteContour(wxCommandEvent& event){
	interfMainPanel::getInstance()->onDeleteContour();
}
void interfDeleteMenu::onDeleteContoursActSlice(wxCommandEvent& event){
	interfMainPanel::getInstance()->onDeleteContoursActSlice();
}
void interfDeleteMenu::onDeleteAllContours(wxCommandEvent& event){
	interfMainPanel::getInstance()->onDeleteAllContours();
}

