/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfEditMenu.h"


interfEditMenu::interfEditMenu(wxWindow * parent, int sizex, int sizey,wxEvtHandler* evtHandler, std::string datdir)
	: interfMenuBar(parent, sizex, sizey)
{
	this->datadir = datdir;
//	eventHandler = evtHandler;
	initButtons(this);
}

void interfEditMenu::initButtons(wxEvtHandler* evtHandler) {

	std::vector<std::string> path, nom;
	std::vector<wxObjectEventFunction> funct;

	path.push_back(datadir + "/copy.png");
	nom.push_back("Copy the selected contour  ctrl + c");
	funct.push_back((wxObjectEventFunction) &interfEditMenu:: onCopy);

	path.push_back(datadir + "/paste.png");
	nom.push_back("Paste the copied contour  ctrl + v");
	funct.push_back((wxObjectEventFunction) &interfEditMenu:: onPaste);

	path.push_back(datadir + "/undo.png");
	nom.push_back("Undo  ctrl + z");
	funct.push_back((wxObjectEventFunction) &interfEditMenu:: onUndo);

	path.push_back(datadir + "/redo.png");
	nom.push_back("Redo  ctrl + y");
	funct.push_back((wxObjectEventFunction) &interfEditMenu:: onRedo);


    this->addButtons(path, nom);
	this->setVectorFunction(funct);

	this->setButtonName(0, 'C');
	this->setButtonName(1, 'P');
	this->setButtonName(2, '-');
	this->setButtonName(3, '-');

	this->connectEvents(evtHandler);

}
void interfEditMenu::onCopy(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onCopy();
}

void interfEditMenu::onPaste(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onPaste();
}

void interfEditMenu::onUndo(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onUndo();
}

void interfEditMenu::onRedo(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onRedo();
}

interfEditMenu::~interfEditMenu()
{
}

