/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfIOMenu.h"
#include "interfMainPanel.h"

interfIOMenu::interfIOMenu(wxWindow * parent, int sizex, int sizey,wxEvtHandler* evtHandler, std::string datdir)
	: interfMenuBar(parent, sizex, sizey)
{
	this->datadir = datdir;
//	eventHandler = evtHandler;
	initButtons(this);
}

void interfIOMenu::initButtons(wxEvtHandler* evtHandler) {

	std::vector<std::string> path, nom;
	std::vector<wxObjectEventFunction> funct;

	path.push_back(datadir + "/Open.png");
	nom.push_back("Open a previously saved file that contains contours information  ctrl + o");
	funct.push_back((wxObjectEventFunction) &interfIOMenu:: onLoad);

	path.push_back(datadir + "/Save.png");
	nom.push_back("Save all contours created ctrl + s");
	funct.push_back((wxObjectEventFunction) &interfIOMenu:: onSave);

	path.push_back(datadir + "/Import.png");
	nom.push_back("Import an OSIRIX XML file with contours");
	funct.push_back((wxObjectEventFunction) &interfIOMenu:: onImport);

	/******            ******
	******* New Button *******
	*******            ******/
	path.push_back(datadir + "/test.png");
	nom.push_back("Performing a test on how to add a new button");
	funct.push_back((wxObjectEventFunction) &interfIOMenu:: onTest);

	this->addButtons(path, nom);
	this->setVectorFunction(funct);

	//this->setButtonName(0, 'O');
	//this->setButtonName(1, ');

	this->connectEvents(evtHandler);

}
void interfIOMenu::onLoad(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onLoad();
}
void interfIOMenu::onSave(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onSave();
}

void interfIOMenu::onImport(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onImport();
}

void interfIOMenu::onTest(wxCommandEvent& event)
{
	printf("EED interfIOMenu::onTest\n");
	interfMainPanel::getInstance()->onTest();
}

interfIOMenu::~interfIOMenu()
{
}

