/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfImageToolsMenu.h"
#include "interfMainPanel.h"

interfImageToolsMenu::interfImageToolsMenu(wxWindow * parent, int sizex, int sizey,wxEvtHandler* evtHandler, std::string datdir)
	: interfMenuBar(parent, sizex, sizey)
{
	this->datadir	= datdir;
	//contourevent	= (wxContourEventHandler*)evtHandler;

/*Borrame
	infoWin			= NULL;
	configPanel		= NULL;
	spreadPanel		= NULL;
	segmentPanelITK = NULL;
*/

	//eventHandler = evtHandler;

	initButtons(this);
}

void interfImageToolsMenu::initButtons(wxEvtHandler* evtHandler) {

	std::vector<std::string> path, nom;
	std::vector<wxObjectEventFunction> funct;

/*EED Borrame
	path.push_back(datadir + "/Segmentation.png");
	nom.push_back("Find shapes by automatic segmentation");
	funct.push_back((wxObjectEventFunction) &interfSegmentationMenu:: onSegmentationPressed);

	path.push_back(datadir + "/ITK.png");
	nom.push_back("Find shapes by automatic segmentation with ITK");
	funct.push_back((wxObjectEventFunction) &interfSegmentationMenu:: onSegmentationPressedITK);

	path.push_back(datadir + "/snake.png");
	nom.push_back("Find shapes using border snake interaction");
	funct.push_back((wxObjectEventFunction) &interfSegmentationMenu:: onSnakePressed);
*/
	path.push_back(datadir + "/pignon.png");
	nom.push_back("Configuration of the window");
	funct.push_back((wxObjectEventFunction) &interfImageToolsMenu:: onConfigurationPressed);

	path.push_back(datadir + "/info.png");
	nom.push_back("Information of the contours in the scene");
	funct.push_back((wxObjectEventFunction) &interfImageToolsMenu:: onInformationPressed);
	
	path.push_back(datadir + "/Threshold.png");
	nom.push_back("Superpose a 'Red Image' to the selected Image Threshold");
	funct.push_back((wxObjectEventFunction)&interfImageToolsMenu::onThreshold);

	path.push_back(datadir + "/Threshold.png");
	nom.push_back("Superpose a Color Image");
	funct.push_back((wxObjectEventFunction)&interfImageToolsMenu::onColorLayerImage);

	path.push_back(datadir + "/Help.png");
	nom.push_back("Show help page with information about the tools");
	funct.push_back((wxObjectEventFunction) &interfImageToolsMenu:: onHelpPressed);


	this->addButtons(path, nom);	
	this->setVectorFunction(funct);

	this->connectEvents(evtHandler);
	   

}

interfImageToolsMenu::~interfImageToolsMenu()
{
}

/**
	**	Responds to the events of the buttons, when the same panel is responsible for it. It gets the name
	**	of the button corresponding to the method that has to be executed,
	**	it uses attribute eventHandler to call the methods define by the application.
	**	see setEventHandler(wxEventHandler*)
	**/

/*EED Borrame
void  interfSegmentationMenu::onSegmentationPressed(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onSegmentationPressed();
}

void  interfSegmentationMenu::onSegmentationPressedITK(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onSegmentationPressedITK();    
}

void  interfSegmentationMenu::onSnakePressed(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onSnakePressed();
}
*/

void  interfImageToolsMenu::onInformationPressed(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onInformationPressed();
}

void  interfImageToolsMenu::onConfigurationPressed(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onConfigurationPressed();
}

void interfImageToolsMenu::onThreshold(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onThresholdPressed();
}

void interfImageToolsMenu::onColorLayerImage(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onColorLayerImagePressed();
}

void interfImageToolsMenu::onHelpPressed(wxCommandEvent& event)
{
  wxLaunchDefaultBrowser(_T("http://www.creatis.insa-lyon.fr/site/fr/EndUserGuide"), 0);
}

//------------------------------------------------------------------------------------------------------------

