/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfMainPanel.h"


interfMainPanel* interfMainPanel::interfmainpanel=NULL;
wxFrame* interfMainPanel::_newframe=NULL;

interfMainPanel::interfMainPanel(wxWindow * parent, int sizex, int sizey, wxEvtHandler * evtHandler, std::string datadir)
: wxPanel(parent, -1, wxDefaultPosition, wxSize(sizex, sizey), wxBORDER_SUNKEN)
{

	PANEL					= "New Contour";
	PANEL1					= "I/O";
	PANEL2					= "Edit";
	PANEL3					= "Delete";
	PANEL4					= "Contour Tools";
	PANEL5					= "Segmentation";
//EED 07/07/2010
	PANEL6					= "Image Tools";

	segmentPanel			= NULL;
	segmentPanelITK			= NULL;
	configPanel				= NULL;
	spreadPanel				= NULL;
	infoWin					= NULL;
	infoPanel				= NULL;
	infoPanelMask			= NULL;
	informationPanel		= NULL;
	mirrorPanel				= NULL;
	thresholdPanel			= NULL;
	colorImageLayerPanel	= NULL;
	currentWindow			= NULL;
	testPanel				= NULL;
	flipPanel				= NULL;

//CMRU 17-08-09 ------------------------------------------------------------------
	infoPanelCalibration = NULL;
	panelAux = NULL;
//--------------------------------------------------------------------------------
	splitterwindow = new wxSplitterWindow(this,-1, wxDefaultPosition, wxSize(sizex, sizey), wxSP_3DSASH, wxString(_T("")));

	splitterwindow->SetMinimumPaneSize( 10 );
	sizey = sizey/8;

	wxPanel* toolpanel = new wxPanel(splitterwindow, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_DOUBLE, wxString(_T("")));

	wxFlexGridSizer* flexsizer = new wxFlexGridSizer(6,2,1,1);
	toolpanel->SetSizer(flexsizer, true);
	toolpanel->SetAutoLayout( true );

	wxButton* b = getButton(toolpanel);
	b->SetClientData(&PANEL);
	wxButton* b1 = getButton(toolpanel);
	b1->SetClientData(&PANEL1);
	wxButton* b2 = getButton(toolpanel);
	b2->SetClientData(&PANEL2);
	wxButton* b3 = getButton(toolpanel);
	b3->SetClientData(&PANEL3);
	wxButton* b4 = getButton(toolpanel);
	b4->SetClientData(&PANEL4);
	wxButton* b5 = getButton(toolpanel);
	b5->SetClientData(&PANEL5);
//EED 07/07/2010
	wxButton* b6 = getButton(toolpanel);
	b6->SetClientData(&PANEL6);


	wxPanel* mentex  = new wxPanel(toolpanel, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE, wxString(_T("")));
	wxPanel* mentex1 = new wxPanel(toolpanel, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE, wxString(_T("")));
	wxPanel* mentex2 = new wxPanel(toolpanel, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE, wxString(_T("")));
	wxPanel* mentex3 = new wxPanel(toolpanel, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE, wxString(_T("")));
	wxPanel* mentex4 = new wxPanel(toolpanel, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE, wxString(_T("")));
	wxPanel* mentex5 = new wxPanel(toolpanel, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE, wxString(_T("")));
//EED 07/07/2010
	wxPanel* mentex6 = new wxPanel(toolpanel, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE, wxString(_T("")));

	menubar  = new interfNewContourMenu  (mentex,  sizex, sizey, evtHandler, datadir);
	menubar1 = new interfIOMenu          (mentex1, sizex, sizey, evtHandler, datadir);
	menubar2 = new interfEditMenu        (mentex2, sizex, sizey, evtHandler, datadir);
	menubar3 = new interfDeleteMenu      (mentex3, sizex, sizey, evtHandler, datadir);
	menubar4 = new interfToolsMenu       (mentex4, sizex ,sizey, evtHandler, datadir);
	menubar5 = new interfSegmentationMenu(mentex5, sizex, sizey, evtHandler, datadir);
	menubar6 = new interfImageToolsMenu(mentex6, sizex, sizey, evtHandler, datadir);

	statictext  = getText(mentex,  PANEL);
	statictext1 = getText(mentex1, PANEL1);
	statictext2 = getText(mentex2, PANEL2);
	statictext3 = getText(mentex3, PANEL3);
	statictext4 = getText(mentex4, PANEL4);
	statictext5 = getText(mentex5, PANEL5);
	statictext6 = getText(mentex6, PANEL6);

	flexsizer->Add(b, wxFIXED_MINSIZE);
	flexsizer->Add(setMenuTextSizer(mentex, menubar,statictext), wxFIXED_MINSIZE);

	flexsizer->Add(b1, wxFIXED_MINSIZE);
	flexsizer->Add(setMenuTextSizer(mentex1, menubar1,statictext1), wxFIXED_MINSIZE);

	flexsizer->Add(b2, wxFIXED_MINSIZE);
	flexsizer->Add(setMenuTextSizer(mentex2, menubar2,statictext2), wxFIXED_MINSIZE);

	flexsizer->Add(b3, wxFIXED_MINSIZE);
	flexsizer->Add(setMenuTextSizer(mentex3, menubar3,statictext3), wxFIXED_MINSIZE);

	flexsizer->Add(b4, wxFIXED_MINSIZE);
	flexsizer->Add(setMenuTextSizer(mentex4, menubar4,statictext4), wxFIXED_MINSIZE);

	flexsizer->Add(b5, wxFIXED_MINSIZE);
	flexsizer->Add(setMenuTextSizer(mentex5, menubar5,statictext5), wxFIXED_MINSIZE);
	flexsizer->Add(b6, wxFIXED_MINSIZE);
	flexsizer->Add(setMenuTextSizer(mentex6, menubar6,statictext6), wxFIXED_MINSIZE);

	toolpanel->Update();
	toolpanel->Layout();

	infoPanel = new wxPanel(splitterwindow, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_DOUBLE, wxString(_T("")));
	wxFlexGridSizer* infosizer = new wxFlexGridSizer(1,1,2,2);
	infoPanel->SetSizer(infosizer, true);
	infoPanel->SetAutoLayout( true );

	splitterwindow->Initialize(toolpanel);
	splitterwindow->SetSashGravity(1);
//EED	splitterwindow->SetSashPosition(600);
	splitterwindow->SetSashSize(5);
	splitterwindow->SplitHorizontally(toolpanel, infoPanel,8*73);

	Connect(b->GetId(),  wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&interfMainPanel::onActionButtonPressed1);
	Connect(b1->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&interfMainPanel::onActionButtonPressed1);
	Connect(b2->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&interfMainPanel::onActionButtonPressed1);
	Connect(b3->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&interfMainPanel::onActionButtonPressed1);
	Connect(b4->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&interfMainPanel::onActionButtonPressed1);
	Connect(b5->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&interfMainPanel::onActionButtonPressed1);
	Connect(b6->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&interfMainPanel::onActionButtonPressed1);

	this->Layout();
}

interfMainPanel::~interfMainPanel(void)
{

}

interfMainPanel* interfMainPanel::getInstance(wxWindow* parent, std::string datadir, wxEvtHandler * evtHandler)
{
	_newframe = new wxFrame(parent, -1, wxT(" Contour Tools "), wxPoint(25,50), wxSize(350,900),wxFRAME_TOOL_WINDOW|wxSYSTEM_MENU | wxCAPTION |  wxCLIP_CHILDREN |wxFRAME_FLOAT_ON_PARENT);

	if(interfmainpanel == NULL){
		interfmainpanel = new interfMainPanel(_newframe, 350, 900, evtHandler, datadir);
	}
	_newframe->Show(TRUE);
	return interfmainpanel;
}

interfMainPanel* interfMainPanel::getInstance(wxWindow* parent, wxEvtHandler * evtHandler)
{

	_newframe = new wxFrame(parent, -1, wxT(" Contour Tools "), wxPoint(25,50), wxSize(350,900),wxFRAME_TOOL_WINDOW|wxSYSTEM_MENU | wxCAPTION |  wxCLIP_CHILDREN |wxFRAME_FLOAT_ON_PARENT );

	if(interfmainpanel == NULL){
		interfmainpanel = new interfMainPanel(_newframe, 350, 900, evtHandler);
	}
	_newframe->Show(TRUE);
	return interfmainpanel;
}

bool interfMainPanel::Show(bool show)
{
	return _newframe->Show(show);
}

interfMainPanel* interfMainPanel::getInstance()
{
	return interfmainpanel;
}

void interfMainPanel :: resetInstance()
{
	//delete interfmainpanel;
	delete _newframe;
	interfmainpanel = NULL;
}

wxPanel* interfMainPanel::initializeToolsPanel(wxWindow* parent, int sizex, int sizey, wxEvtHandler * evtHandler)
{
	wxPanel* panel = new wxPanel(parent, -1, wxDefaultPosition, wxSize(sizex, sizey), wxBORDER_SUNKEN, wxString(_T("Spread")));

	wxFlexGridSizer* flexsizer = new wxFlexGridSizer(2,1,2,2)	;
	panel->SetSizer(flexsizer, true);
	panel->SetAutoLayout( true );

	interfToolsMenu* menu = new interfToolsMenu(panel, sizex, sizey, evtHandler);
	toolspread = new interfToolsSpreadPanel(panel, sizex, 300, evtHandler);

	flexsizer->Add(menu, wxFIXED_MINSIZE);
	flexsizer->Add(toolspread, wxFIXED_MINSIZE);

	panel->Layout();

	return panel;
}

/**
**	Adds a new checkbox to the scrolledwindow using the checkboxsizer
**	@Params id of contour
**
**/
void interfMainPanel::addContourCheckBox(std::string id)
{
	toolspread->addContourCheckBox(id);
}

/**
**	Removes a checkbox from the list of checkboxes in the flexsizer (checkboxsizer)
**	@Params id of contour
**
**/
void interfMainPanel::removeContourCheckBox(std::string id)
{
	toolspread->removeContourCheckBox(id);
}

void interfMainPanel::onActionButtonPressed1( wxCommandEvent& event )
{
	//((interfToolsMenu*)menubar4)->hideAxis();
	wxButton* b = (wxButton*)event.GetEventObject();
	wxPanel* dmenu;
	wxStaticText* text;
	std::string dstring = *((std::string*) b->GetClientData());
	int sizechange=0;

	if(dstring.compare(PANEL)==0){
		dmenu = menubar;
		text = statictext;
	}else if(dstring.compare(PANEL1)==0 ){
		dmenu = menubar1;
		text = statictext1;
	}else if(dstring.compare(PANEL2)==0){
		dmenu = menubar2;
		text = statictext2;
	}else if(dstring.compare(PANEL3)==0){
		dmenu = menubar3;
		text = statictext3;
	}else if(dstring.compare(PANEL4)==0){
		dmenu = menubar4;
		text = statictext4;
	}else if(dstring.compare(PANEL5)==0){
		dmenu = menubar5;
		text = statictext5;
	}else if(dstring.compare(PANEL6)==0){
		dmenu = menubar6;
		text = statictext6;
	}

	if(wxStrcmp(b->GetLabel(),_T("+"))==0 ){
		dmenu->Show(true);
		sizechange = 1;
		b->SetLabel(_T("-"));
	}else{
		dmenu->Show(false);
		sizechange = -1;
		b->SetLabel(_T("+"));
	}

	sizechange *= (dmenu->GetSize().GetHeight()-10);
	splitterwindow->SetSashPosition(splitterwindow->GetSashPosition()+sizechange);

	this->Layout();
	this->Refresh();
}

wxStaticText* interfMainPanel::getText(wxWindow* parent, std::string nom)
{
	return new wxStaticText(parent, -1, wxString(nom.c_str(),wxConvUTF8), wxDefaultPosition,
					wxDefaultSize, wxALIGN_CENTRE, wxString(nom.c_str(),wxConvUTF8));
}

wxButton* interfMainPanel::getButton(wxWindow* parent)
{
	wxButton* b = new wxButton(parent, -1, wxString(_T("-")), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT,
					wxDefaultValidator, wxString(_T("-")));
	return b;
}

wxPanel* interfMainPanel::setMenuTextSizer(wxWindow* parent, wxPanel* panel, wxStaticText* text)
{

	wxFlexGridSizer* flexsizer = new wxFlexGridSizer(2,1,2,2);
	parent->SetSizer(flexsizer, true);
	parent->SetAutoLayout( true );

	flexsizer->Add(text, wxFLEX_GROWMODE_ALL);
	flexsizer->Add(panel, wxFLEX_GROWMODE_ALL);

	parent->Layout();
	return (wxPanel*)parent;
}

/**
**	Shows the panel in the
**/
void interfMainPanel::showPanel(wxWindow* panel)
{
	wxContourMainFrame::getInstance()->showAxis(false);
	wxSizer* sizer = infoPanel->GetSizer();

	if(currentWindow != NULL){
		currentWindow->Hide();
		/// \TODO fix warning: virtual bool wxSizer::Remove(wxWindow*) is deprecated 
		sizer->Remove(currentWindow);
	}
	sizer->Add(panel);
	currentWindow = panel;
	currentWindow->Show(true);

	splitterwindow->SetSashPosition(splitterwindow->GetSashPosition()+1);
	splitterwindow->SetSashPosition(splitterwindow->GetSashPosition()-1);

	infoPanel->Layout();
	infoPanel->Refresh();
	this->Layout();
	this->Refresh();
}

/**
**	Hide the panel in the lower box
**/
void interfMainPanel::hidePanel( )
{
	wxContourMainFrame::getInstance()->showAxis(false);
	wxSizer* sizer = infoPanel->GetSizer();

	if(currentWindow != NULL){
		currentWindow->Hide();
		/// \TODO fix warning: virtual bool wxSizer::Remove(wxWindow*) is deprecated 
		sizer->Remove(currentWindow);
	}
	wxPanel * emptyPanel = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxBORDER_STATIC, wxString(_T("")));
	sizer->Add(emptyPanel);
	currentWindow = emptyPanel;
	currentWindow->Show(true);

	splitterwindow->SetSashPosition(splitterwindow->GetSashPosition()+1);
	splitterwindow->SetSashPosition(splitterwindow->GetSashPosition()-1);

	infoPanel->Layout();
	infoPanel->Refresh();
	this->Layout();
	this->Refresh();
}

/**
**	Gets the Information panel
**/
wxPanel* interfMainPanel::getInfoPanel()
{
	return infoPanel;
}

void interfMainPanel::onCreateContourSpline( )
{
	wxContourMainFrame::getInstance()->showAxis(false);
	wxContourMainFrame::getInstance()->onCreateContourSpline();
}

void interfMainPanel::onCreateContourRectangle( )
{
	wxContourMainFrame::getInstance()->showAxis(false);
    wxContourMainFrame::getInstance()->onCreateContourRectangle();
}
void interfMainPanel::onCreateContourCircle( )
{
	wxContourMainFrame::getInstance()->showAxis(false);
    wxContourMainFrame::getInstance()->onCreateContourCircle();
}

void interfMainPanel::onCreateContourLine( )
{
	wxContourMainFrame::getInstance()->showAxis(false);
    wxContourMainFrame::getInstance()->onCreateContourLine();
}

// RaC 09-09 ---------------------
void interfMainPanel::onCreateContourPoints( )
{
	wxContourMainFrame::getInstance()->showAxis(false);
    wxContourMainFrame::getInstance()->onCreateContourPoints();
}
// RaC 09-09 ---------------------

// RaC 10-09 ---------------------
void interfMainPanel::onCreateContourPolygon( )
{
	wxContourMainFrame::getInstance()->showAxis(false);
    wxContourMainFrame::getInstance()->onCreateContourPolygon();
}
// RaC 10-09 ---------------------

void interfMainPanel::onCreateContoursBullEye(wxPanel* panBull)
{
	wxContourMainFrame::getInstance()->showAxis(false);
	wxContourMainFrame::getInstance()->onCreateContourBullEye(panBull);
}

void interfMainPanel::onDeleteContour()
{
	wxContourMainFrame::getInstance()->showAxis(false);
	wxContourMainFrame::getInstance()->onDeleteContour();
}

void interfMainPanel::onDeleteContoursActSlice()
{
	wxContourMainFrame::getInstance()->showAxis(false);
	wxContourMainFrame::getInstance()->onDeleteContoursActSlice();
}

void interfMainPanel::onDeleteAllContours()
{
	wxContourMainFrame::getInstance()->showAxis(false);
	wxContourMainFrame::getInstance()->onDeleteAllContours();
}

void interfMainPanel::onCopy()
{
	wxContourMainFrame::getInstance()->onCopy();
}

void interfMainPanel::onPaste()
{
	wxContourMainFrame::getInstance()->onPaste();
}

void interfMainPanel::onUndo()
{
	wxContourMainFrame::getInstance()->onUndo();
}

void interfMainPanel::onRedo()
{
	wxContourMainFrame::getInstance()->onRedo();
}

void interfMainPanel::onLoad()
{
	wxContourMainFrame::getInstance()->onLoad();
}

void interfMainPanel::onSave()
{
	wxContourMainFrame::getInstance()->onSave();
}

void interfMainPanel::onImport()
{
	wxContourMainFrame::getInstance()->onImport();
}

void interfMainPanel::onTest()
{
	printf("EED interfMainPanel::onTest \n");
	if(testPanel==NULL)
	{
		testPanel = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition,
			wxDefaultSize, wxBORDER_STATIC, wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		testPanel->SetSizer(flexsizer, true);
		testPanel->SetAutoLayout( true );
		panelTest = new interfTestPanel(testPanel);
		wxStaticText* stattext = new wxStaticText(testPanel,  -1,
			wxString(_T("   Test Panel   ")),
			wxDefaultPosition, wxDefaultSize,
			wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));
		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(panelTest, wxEXPAND);
		testPanel->Layout();
	}
	showPanel(testPanel);
}

void interfMainPanel::RefreshInterface()
{
	wxContourMainFrame::getInstance()->RefreshInterface();
}

vtkImageData* interfMainPanel::getImageData()
{
	return wxContourMainFrame::getInstance()->getImageData();
}

void interfMainPanel::getImageRange(double  range[2] )
{
	vtkImageData * img = getImageData();
	img->GetScalarRange(range);
}

void interfMainPanel::onSegmentationOneSlice(int isovalue,int sampling,int method)
{
	wxContourMainFrame::getInstance()->onSegmentationOneSlice(isovalue, sampling, method);
}

void interfMainPanel::onSegmentationOneSliceITK(wxString distance, wxString sigma, wxString alfa, wxString beta, wxString propagation, wxString iterations, wxString inflation)
{
	wxContourMainFrame::getInstance()->onSegmentationOneSliceITK(distance, sigma, alfa, beta, propagation, iterations, inflation);
}

int interfMainPanel::GetImageDataSizeZ()
{
	return wxContourMainFrame::getInstance()->GetImageDataSizeZ();
}

void interfMainPanel::onSegmentationAllSlice(int minZ,int maxZ,int isovalue,int sampling,int method)
{
	wxContourMainFrame::getInstance()->onSegmentationAllSlice(minZ, maxZ,isovalue,sampling,method);
}

void interfMainPanel::setLabelSegmentationPanelVTK(wxString tmpString)
{
    ((interfSegmentationPanelVTK*)segmentationPanel)->setLabel(tmpString);
}
void interfMainPanel::onSegmentationPressed()
{
	if(segmentPanel == NULL){
		segmentPanel = new wxPanel(getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxBORDER_STATIC, wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		segmentPanel->SetSizer(flexsizer, true);
		segmentPanel->SetAutoLayout(true);
		segmentPanel->SetEventHandler(this);

		//wxPanel* panel = contourevent->getSegmentationPanel(segmentPanel);
		segmentationPanel = new interfSegmentationPanelVTK(segmentPanel);


		wxStaticText* stattext = new wxStaticText(segmentPanel, -1, wxString(_T("   Automatic Segmentation   ")), wxDefaultPosition,
			wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));

		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(segmentationPanel, wxEXPAND);
		segmentPanel->Layout();
	}
	showPanel(segmentPanel);
	wxContourMainFrame::getInstance()->showAxis(true);
	axisshown = true;
}

void interfMainPanel::onSegmentationPressedITK()
{
    if(segmentPanelITK == NULL){
		segmentPanelITK = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxBORDER_STATIC, wxString(_T("")));


		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		segmentPanelITK->SetSizer(flexsizer, true);
		segmentPanelITK->SetAutoLayout( true );
		//segmentPanelITK->SetEventHandler(this->contourevent);

		//wxPanel* panel = contourevent->getSegmentationPanelITK(segmentPanelITK);
		wxPanel* panel = new interfSegmentationPanelITK(segmentPanelITK);

		wxStaticText* stattext = new wxStaticText(segmentPanelITK, -1, wxString(_T("   Automatic ITK Segmentation   ")), wxDefaultPosition,
			wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));

		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(panel, wxEXPAND);
		segmentPanelITK->Layout();
	}
	showPanel(segmentPanelITK);
	wxContourMainFrame::getInstance()->showAxis(true);
	axisshown = true;
}

void interfMainPanel::onRigidPressed()
{
	wxContourMainFrame::getInstance()->onRigidPressed();
}

void interfMainPanel::onWidthOfContour(double width)
{
	wxContourMainFrame::getInstance()->onWidthOfContour(width);
}

int interfMainPanel::getColorWindow()
{
	return wxContourMainFrame::getInstance()->getColorWindow();
}
int interfMainPanel::getWindowLevel()
{
	return wxContourMainFrame::getInstance()->getWindowLevel();
}
void interfMainPanel::onBrigthnessColorWindowLevel(int colorwindow,int windowlevel)
{
	wxContourMainFrame::getInstance()->onBrigthnessColorWindowLevel(colorwindow, windowlevel);
}

void interfMainPanel::onInterpolation(bool interpolate)
{
	wxContourMainFrame::getInstance()->onInterpolation(interpolate);
}


void interfMainPanel::onConfigurationPressed()
{
	if(configPanel == NULL){
		configPanel = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxNO_BORDER, wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		configPanel->SetSizer(flexsizer, true);
		configPanel->SetAutoLayout( true );
		//configPanel->SetEventHandler(this->contourevent);
		wxPanel* panel = new interfConfigurationPanel(configPanel);
		wxStaticText* stattext = new wxStaticText(configPanel, -1, wxString(_T("   Interface Configuration   ")), wxDefaultPosition,
			wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));
		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(panel, wxEXPAND);
		configPanel->Layout();
	}
	showPanel(configPanel);
}

void interfMainPanel::onSpreadPressed()
{
    if(spreadPanel==NULL){

		spreadPanel = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxBORDER_STATIC, wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		spreadPanel->SetSizer(flexsizer, true);
		spreadPanel->SetAutoLayout( true );
		//spreadPanel->SetEventHandler(this->contourevent);

		//wxPanel* panel = contourevent->getSpreadPanel(spreadPanel);
		panelSpread = new interfSpreadPanel(spreadPanel);


		wxStaticText* stattext = new wxStaticText(spreadPanel, -1, wxString(_T("   Automatic Spread   ")), wxDefaultPosition,
			wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));

		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(panelSpread, wxEXPAND);
		spreadPanel->Layout();
	}
	showPanel(spreadPanel);
	//hideAxis();
}

void interfMainPanel::resetAppend()
{
	wxContourMainFrame::getInstance()->resetAppend();
}

void interfMainPanel::onSpreadAdd()
{
	wxContourMainFrame::getInstance()->onSpreadAdd();
}

void interfMainPanel::onSpreadAddAll()
{
	wxContourMainFrame::getInstance()->onSpreadAddAll();
}


void interfMainPanel::appendStringSpread(std::string val)
{
    panelSpread->appendStringSpread(val);
}

void interfMainPanel::onSpreadGo(int type)
{
	wxContourMainFrame::getInstance()->onSpreadGo(type);
}

void interfMainPanel::setStringSpread(std::string stringtemp)
{
	panelSpread->setStringSpread(stringtemp);
}

void interfMainPanel::onInformationPressed()
{

	// Statistics frame
	if(infoWin ==NULL){
		infoWin			= new wxFrame (this, -1,_T("  Statistics  "), wxDefaultPosition, wxDefaultSize, wxFRAME_TOOL_WINDOW|wxSYSTEM_MENU | wxCAPTION |  wxCLIP_CHILDREN |wxFRAME_FLOAT_ON_PARENT | wxRESIZE_BORDER  );
		infoWin->SetSize( wxSize(825,650) );

		wxSize sizepanel(825,675);
		informationPanel	= new interfInformationPanel(infoWin);//contourevent->getInformationPanel(infoWin);

		wxBoxSizer * sizerPanel	= new wxBoxSizer(wxHORIZONTAL);
		sizerPanel -> Add( informationPanel, 1, wxEXPAND ,0);

		infoWin->SetSizer( sizerPanel );
		infoWin->SetAutoLayout( true );
		infoWin->Layout();
		infoWin->Show();
	}else {

		if (infoWin->IsShown()==true)
		{
			infoWin->Show(false);
		} else  {
			//contourevent->FillGridWithContoursInformation();
			infoWin->Show(true);
		}
	}

//CMRU 29-08-09-----------------------------------------------------------------------------------------------
	if(panelAux == NULL)
	{
		panelAux = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxNO_BORDER, wxString(_T("")));
	}
//------------------------------------------------------------------------------------------------------------

	// mask view control panel
	if(infoPanelMask == NULL){
		infoPanelMask = new wxPanel(panelAux, -1, wxDefaultPosition, wxDefaultSize, wxNO_BORDER, wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		infoPanelMask->SetSizer(flexsizer, true);
		infoPanelMask->SetAutoLayout( true );
		//configPanel->SetEventHandler(this->contourevent);
		wxPanel *panel = wxContourMainFrame::getInstance()->getMaskImageViewPanel( infoPanelMask );
		wxStaticText* stattext = new wxStaticText(infoPanelMask, -1, wxString(_T("   Mask segmentation    ")), wxDefaultPosition,
												  wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));

		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);

		flexsizer->Add(panel, wxEXPAND);
		infoPanelMask->Layout();

	}

//CMRU 29-08-09-----------------------------------------------------------------------------------------------
	//Calibration panel
	if(infoPanelCalibration == NULL)
	{
		infoPanelCalibration = new wxPanel(panelAux, -1, wxDefaultPosition, wxDefaultSize, wxNO_BORDER , wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		infoPanelCalibration->SetSizer(flexsizer, true);
		infoPanelCalibration->SetAutoLayout( true );

		wxPanel *panel = new interfCalibrationPanel(infoPanelCalibration);
		wxStaticText* stattext = new wxStaticText(infoPanelCalibration, -1, wxString(_T("              Calibration               ")), wxDefaultPosition,
												  wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));

		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);

		flexsizer->Add(panel, wxEXPAND);
		infoPanelCalibration->Layout();
	}

	wxFlexGridSizer* sizer = new wxFlexGridSizer(1);
	panelAux->SetSizer(sizer, true);
	panelAux->SetAutoLayout( true );
	sizer->Add(infoPanelMask);
	sizer->Add(infoPanelCalibration);

	showPanel(panelAux);

//------------------------------------------------------------------

	wxContourMainFrame::getInstance()->changeInstant();
}

void interfMainPanel::getInstantVector(std::vector<int>& tempVector)
{
	wxContourMainFrame::getInstance()->getInstantVector(tempVector);
}

std::vector<std::string> interfMainPanel::getOutlinesName(int slide)
{
	return wxContourMainFrame::getInstance()->getOutlinesName(slide);
}

void interfMainPanel::onInformationContourLabels(int typeContourGroup,int selection,int minZ,int maxZ,int grayRangeMin,int grayRangeMax){
	wxContourMainFrame::getInstance()->onInformationContourLabels(typeContourGroup, selection, minZ, maxZ,grayRangeMin,grayRangeMax);
}

void interfMainPanel::setStringInfoPanel(wxString tmpString)
{
	if(informationPanel!=NULL){
		((interfInformationPanel*)informationPanel)->setStringInfoPanel(tmpString);
	}
}

void interfMainPanel::setRowLabelInfoPanel(int z, wxString tempString)
{
	((interfInformationPanel*)informationPanel)->setRowLabelInfoPanel(z, tempString);
}

int interfMainPanel::getNumberColsInformationPanel()
{
	return ((interfInformationPanel*)informationPanel)->getNumberCols();
}

void interfMainPanel::appendColsInformationPanel(int _numberOfVariablesStatistics)
{
	((interfInformationPanel*)informationPanel)->appendCols(_numberOfVariablesStatistics);
}

void interfMainPanel::setCellValueInfoPanel(int z,int tmpIntA,wxString tempString)
{
	((interfInformationPanel*)informationPanel)->setCellValue(z, tmpIntA, tempString);
}

void interfMainPanel::setColLableInfoPanel(int tmpIntB,wxString tmpTitleString)
{
	((interfInformationPanel*)informationPanel)->setColLabel(tmpIntB, tmpTitleString);

}

void interfMainPanel::SetScalarRange(int grayRangeMin,int grayRangeMax)
{
	wxContourMainFrame::getInstance()->SetScalarRange(grayRangeMin, grayRangeMax);
}

void interfMainPanel::onSaveResults(std::string directory,std::string namefile, std::string filename,
									int typeContourGroup, int selection, int minZ, int maxZ ,bool XYZValues, bool contourImage, bool statistics)
{
	wxContourMainFrame::getInstance()->onSaveResults(directory, namefile, filename,
		typeContourGroup, selection, minZ,maxZ, XYZValues, contourImage, statistics);
}

wxString interfMainPanel::getCellValue(int j,int i){
	return ((interfInformationPanel*)informationPanel)->getCellValue(j, i );
}

void interfMainPanel::onSnakePressed()
{
	axisshown=false;
	wxContourMainFrame::getInstance()->showAxis(axisshown);
	wxContourMainFrame::getInstance()->onSnakePressed();
}

void interfMainPanel::onMirrorPressed(){
    if(mirrorPanel==NULL)
	{

		mirrorPanel = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxBORDER_STATIC, wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		mirrorPanel->SetSizer(flexsizer, true);
		mirrorPanel->SetAutoLayout( true );
		panelMirror = new interfMirrorPanel(mirrorPanel);

		wxStaticText* stattext = new wxStaticText(mirrorPanel, -1, wxString(_T("   Mirroring Tool   ")), wxDefaultPosition,
			wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));

		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(panelMirror, wxEXPAND);
		mirrorPanel->Layout();

		refLineShown=true;
		wxContourMainFrame::getInstance()->referenceLine();
	}

	else
	{

		if (!refLineShown)
		{
			wxContourMainFrame::getInstance()->refLineShow();
			refLineShown=true;
		}
	}

	showPanel(mirrorPanel);
}

void interfMainPanel::onMirror()
{
	wxContourMainFrame::getInstance()->onMirror();
}

void interfMainPanel::onMirrorAxisShow()
{
	if (!refLineShown)
	{
		wxContourMainFrame::getInstance()->refLineShow();
		refLineShown=true;
	}
}

void interfMainPanel::onMirrorAxisHide()
{
	if (refLineShown)
	{
		wxContourMainFrame::getInstance()->refLineHide();
		refLineShown=false;
	}
}

void interfMainPanel::onMirrorChangeWidth(int width)
{
	wxContourMainFrame::getInstance()->refLineChangeWidth(width);
}

//EED 07/07/2010
void interfMainPanel::onColorLayerImagePressed()
{
	// Color Image Layer  view control panel
	if(colorImageLayerPanel == NULL){
		colorImageLayerPanel = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxNO_BORDER, wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		colorImageLayerPanel->SetSizer(flexsizer, true);
		colorImageLayerPanel->SetAutoLayout( true );
		//configPanel->SetEventHandler(this->contourevent);
		wxPanel *panel = wxContourMainFrame::getInstance()->getColorLayerImageViewPanel( colorImageLayerPanel );
		wxStaticText* stattext = new wxStaticText(colorImageLayerPanel, -1, wxString(_T("   Color Image Layer     ")), wxDefaultPosition,
												  wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));
		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(panel, wxEXPAND);
		colorImageLayerPanel->Layout();
	}
	showPanel(colorImageLayerPanel);
	wxContourMainFrame::getInstance()->changeInstant();
}

//EED01
void interfMainPanel::onThresholdPressed()
{
	// Threshold view control panel
	if(thresholdPanel == NULL){
		thresholdPanel = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxNO_BORDER, wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		thresholdPanel->SetSizer(flexsizer, true);
		thresholdPanel->SetAutoLayout( true );
		//configPanel->SetEventHandler(this->contourevent);
		wxPanel *panel = wxContourMainFrame::getInstance()->getThresholdImageViewPanel( thresholdPanel );
		wxStaticText* stattext = new wxStaticText(thresholdPanel, -1, wxString(_T("   Threshold segmentation    ")), wxDefaultPosition,
												  wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));
		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(panel, wxEXPAND);
		thresholdPanel->Layout();
	}
	showPanel(thresholdPanel);
	wxContourMainFrame::getInstance()->changeInstant();
}


void interfMainPanel::ShowResultImages(int typeContourGroup, int selection, int minZ, int maxZ)
{
	wxContourMainFrame::getInstance()->ShowResultImages(typeContourGroup, selection, minZ, maxZ);
}


void interfMainPanel::SetContourGroup(int contourGroup)
{
	wxContourMainFrame::getInstance()->SetContourGroup( contourGroup);
}


void interfMainPanel::onFlipContours()
{
	printf("EED interfMainPanel::onFlipContours() \n");
	if(flipPanel==NULL)
	{
		flipPanel = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition,
			wxDefaultSize, wxBORDER_STATIC, wxString(_T("")));
		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);
		flipPanel->SetSizer(flexsizer, true);
		flipPanel->SetAutoLayout( true );
		panelFlip = new interfFlipPanel(flipPanel);
		wxStaticText* stattext = new wxStaticText(flipPanel,  -1,
			wxString(_T("         Flip Contours   ")),
			wxDefaultPosition, wxDefaultSize,
			wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));
		flexsizer->Add(stattext,wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(panelFlip, wxEXPAND);
		flipPanel->Layout();
	}
	showPanel(flipPanel);
}


void interfMainPanel::FlipContours(int typeContourFlip, int flipDirection)
{
	printf("EED interfMainPanel::FlipContours( %d , %d ) \n",typeContourFlip,  flipDirection );
	wxContourMainFrame::getInstance()->FlipContours( typeContourFlip , flipDirection );
}



//CMRU 17-08-09 ---------------------------------------------
void interfMainPanel::onPrintLabel ()
{
	wxString label;
	manualBaseModel* manualModel = wxContourMainFrame::getInstance()->getContour();

	if(manualModel==NULL)
	{
        wxMessageDialog *dial = new wxMessageDialog(NULL, wxT("Please select a Contour"), wxT("Warning"), wxOK | wxICON_EXCLAMATION);
		dial->ShowModal();
		return;
	}

	wxTextEntryDialog* dialog = new wxTextEntryDialog(this,_T("Enter a tag name: ")) ;

	if (dialog->ShowModal() == wxID_OK)
	{
		label = dialog->GetValue();

		if(label.Len()!=0)
		{
			wxContourMainFrame::getInstance()->onPrintLabel(label,manualModel);
			wxMessageDialog *dial = new wxMessageDialog(NULL, wxT("The tag name was updated"), wxT("Information"), wxOK | wxICON_INFORMATION);
			dial->ShowModal();
		}
		else
		{
			wxMessageDialog *dial = new wxMessageDialog(NULL, wxT("Please enter a valid tag"), wxT("Warning"), wxOK | wxICON_EXCLAMATION);
			dial->ShowModal();
		}
	}
}

void interfMainPanel::onCalibration(wxString size, int unit)
{
	int type = 0;
	double contourSize = 0.0;
	double realSizeDouble = 0.0;

	type = wxContourMainFrame::getInstance()->getType();
	contourSize = wxContourMainFrame::getInstance()->getContourSizeInPixels();

	std::cout<<"Cata->Tama�o del contorno en pixeles:"<<contourSize<<endl;

	if ( type == 6 )
	{
		if (size.ToDouble(&realSizeDouble))
		{
			if(unit==1)
			{
				realSizeDouble = realSizeDouble * 10;
			}
			if(unit==2)
			{
				realSizeDouble = realSizeDouble * 25.4;
			}
			std::cout<< "Valor del usuario" << realSizeDouble<< endl ;
			onePixelSize (realSizeDouble,contourSize);
		 }
		 else
		 {
			wxMessageDialog *dial = new wxMessageDialog(NULL, wxT("Please enter a numeric value"), wxT("Warning"), wxOK | wxICON_EXCLAMATION);
			dial->ShowModal();
		 }
	}
	else
	{
		wxMessageDialog *dial = new wxMessageDialog(NULL, wxT("Please select a line contour"), wxT("Warning"), wxOK | wxICON_EXCLAMATION);
		dial->ShowModal();
	}

	wxMessageDialog *dial = new wxMessageDialog(NULL, wxT("The calibration was made"), wxT("Information"), wxOK | wxICON_INFORMATION);
	dial->ShowModal();
	std::cout<< "Cata-> Se ha realizado la calibracion" << endl ;
}

double interfMainPanel::onePixelSize (double realSize,double sizePixel)
{
	_pixelValue = realSize/sizePixel;
	std::cout<< "Valor del un pixel = " << _pixelValue<< endl ;
	wxContourMainFrame::getInstance()->onePixelSize (_pixelValue);
	return _pixelValue ;
}

double interfMainPanel::GetPixelValue()
{
	return _pixelValue;
}
//------------------------------------------------------------------------------------------------------------
