/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __interfMENUBARH__
#define __interfMENUBARH__

#include <string>
#include <wx/wx.h>
#include <vector>
#include <wx/image.h>
#include <wx/bitmap.h>
#include <wx/bmpbuttn.h>
#include <wx/stattext.h>
#include <wx/sizer.h>

//#include "interfMainPanel.h"
//#include "wxContourEventHandler.h"


class interfMenuBar :
	public wxPanel
{
public:
	interfMenuBar(wxWindow * parent, int sizex, int sizey)
		: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN){
		//this initialice all the handlers to load any type of image, in this case the png handler is needed
		wxInitAllImageHandlers();
		
				
	}
	//~interfMenuBar();

	virtual void initButtons(wxEvtHandler* evtHandler) = 0;

	/**
	** This method add a series of button in a line, it uses the method getbutton to create the button
	** and static text to create the text, it also initialice the flexgridsizer to add the buttons and
	** the text into the panel
	** @param vector path, this parameter contains the path of the images to include in the path
	** @param vector nom, this parameter contains the names corresponding to each path of image given
	**/
    virtual void addButtons(std::vector<std::string> vpath, std::vector<std::string> vnom){
		
		int sizex = 80;
		int sizey = 80;
	
		//RaC 11-09
		//This constructor function as well but it is neccessary to change vpath.size() by 6
		//flexsizer = new wxFlexGridSizer(2,vpath.size(),2,2);
		flexsizer = new wxFlexGridSizer(6);
		this->SetSizer(flexsizer, true);
		this->SetAutoLayout( true );
		
		//first row of the sizer, the buttons are being added
		for(int i = 0; i < (int)(vpath.size());i++){
			std::string p = vpath[i];
			wxBitmapButton* bitmapbutton = this->getButton(p, sizex, sizey);
			flexsizer->Add(bitmapbutton,wxFIXED_MINSIZE);
			
		}
		//second row of the sizer, the names are being added
		
		for(int i = 0; i < (int)(vnom.size()); i++){
			//sizex = vectbutton[i]->GetSize().GetWidth();
			std::string n = vnom[i];
			vectbutton[i]->SetToolTip(wxString(n.c_str(),wxConvUTF8));
			//wxStaticText* statictext = getText(n, sizex, 15);
			//flexsizer->Add(statictext, wxEXPAND |wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTRE_HORIZONTAL|wxSHAPED);
		}
		this->Layout();
	}

	/**
	**  This method creates the button with the given image and returns it
	** @param string imgpath is the string containing the path to the image of the button being created
	** @param int x indicates the x coordinate where the button should be located
	** @param int y indicates the y coordinate where the button should be located
	**/

	virtual wxBitmapButton* getButton(std::string imgpath, int sizex, int sizey){
		vectimgpath.push_back(imgpath);
				
		
		wxBitmap* bitmap = new wxBitmap(wxString(imgpath.c_str(),wxConvUTF8), wxBITMAP_TYPE_PNG);

		//wxSize(sizex,sizey)
		wxBitmapButton* bitmapbutton = new wxBitmapButton(this, -1, *bitmap, wxDefaultPosition, wxDefaultSize,
											wxBU_AUTODRAW, wxDefaultValidator, wxString(_T("")));

		vectbutton.push_back(bitmapbutton);
		return bitmapbutton;
	}

	/**
	**	This method create the static text with the given string and returns it, it also push it back into 
	**	the vector nom
	**	@param string nom  text wich will be added to the statictext
	**	@param int sizex   size of the text
	**	@param int sizey   size of the text
	**/
	virtual wxStaticText* getText(std::string nom, int sizex, int sizey){
		vectnom.push_back(nom);
		return new wxStaticText(this, -1, wxString(nom.c_str(),wxConvUTF8), wxDefaultPosition, 
								wxSize(sizex,sizey), wxALIGN_CENTRE, wxString(nom.c_str(),wxConvUTF8));
	}
    /**
	**	Sets the vector funcion, this vector must contain a function for each button created
	**	they must be ordered in the same way as the vector that contains the image path
	**	and name of the button. See addButton(<vect>, <vect>)
	**/
	virtual void setVectorFunction(std::vector<wxObjectEventFunction> vectf){
		for(int i = 0; i < (int)(vectf.size());i++){
			vectfunct.push_back(vectf[i]);
		}		
	}

	/**
	**	This method connect the events seted in the vector vectfunct
	**	each function must have a button to relate with, see function setVectorFunction()
	**/
	virtual void connectEvents(wxEvtHandler* evtHandler){	

		for(int i = 0; i < (int)(vectbutton.size());i++){
			Connect(vectbutton[i]->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, vectfunct[i],NULL,evtHandler);
		}
	}

	/**
	**	This method connect the events seted in the vector vectfunct
	**	each function must have a button to relate with, see function setVectorFunction()
	**/
	virtual void connectEvents(){	

		for(int i = 0; i < (int)(vectbutton.size());i++){
			Connect(vectbutton[i]->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, vectfunct[i],NULL,vecthand[i]);
		}
	}

	/**
	**	Sets the name of the button, this is used to relate the name of the button to a specific command
	**	@params int i	index in the array of buttons use fuction setVectorFuncion(<vect>) to set the vector
	**			first
	**	@params const char	name of the button see wxContour_ActionCommandsID.h to view the commands
	**/
	virtual void setButtonName(int i, const char c){
		if(i < (int)(vectbutton.size())){
			std::string ac = c+"";
			vectbutton[i]->SetName(wxString(ac.c_str(),wxConvUTF8));
		}
	}

	/**
	**	Responds to the events of the buttons, when the same panel is responsible for it. It gets the name
	**	of the button corresponding to the method that has to be executed,
	**	it uses attribute eventHandler to call the methods define by the application.
	**	see setEventHandler(wxEventHandler*)
	**/
	void onActionButtonPressed( wxCommandEvent& event )
	{
		if(true)//if(eventHandler!=NULL)
		{
			std::string theStr = std::string( ((wxButton *)event.GetEventObject())->GetName().ToAscii());
			const char * toolCommand = theStr.c_str();
			event.SetId( GetId() );
			event.SetEventObject( this );
			event.SetClientData( (void *) toolCommand);
			//eventHandler->ProcessEvent( event );
		}
	}

	virtual void setEventHandlers(std::vector<wxEvtHandler*> hand){

		for(int i = 0; i < (int)(hand.size());i++){
			vecthand.push_back(hand[i]);
		}
	}
	
private:
	std::vector<std::string> vectimgpath;
	std::vector<std::string> vectnom;
	
	std::vector<wxButton*> vectbutton;
	std::vector<wxObjectEventFunction> vectfunct;
	std::vector<wxEvtHandler*> vecthand;

	wxFlexGridSizer* flexsizer;

protected:
	//wxEvtHandler* eventHandler;
	std::string datadir;

	

};

#endif
