/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfNewContourMenu.h"


interfNewContourMenu::interfNewContourMenu(wxWindow * parent, int sizex, int sizey, wxEvtHandler* evtHandler, std::string datdir)
	: interfMenuBar(parent, sizex, sizey)
{
	this->datadir = datdir;
	//eventHandler = (wxContourEventHandler*)evtHandler;

	panBull = NULL;
	created = false;

	initButtons(this);	
}

void interfNewContourMenu::initButtons(wxEvtHandler* evtHandler) {

	std::vector<std::string> path, nom;
	std::vector<wxObjectEventFunction> funct;
	std::vector<wxEvtHandler*> hand;
	
	path.push_back(datadir + "/Spline.png");
	nom.push_back("Create a contour using splines");	
	funct.push_back((wxObjectEventFunction)&interfNewContourMenu::onCreateContourSpline);
	hand.push_back(evtHandler);

	path.push_back(datadir+"/Rectangle.png");
	nom.push_back("Create a contour using the basic shape of a rectangle");
	funct.push_back((wxObjectEventFunction)&interfNewContourMenu::onCreateContourRectangle);
	hand.push_back(evtHandler);

	path.push_back(datadir + "/Circle.png");
	nom.push_back("Create a contour using the basic shape of a Circle");
	funct.push_back((wxObjectEventFunction)&interfNewContourMenu::onCreateContourCircle);
	hand.push_back(evtHandler);

	path.push_back(datadir + "/bullseye.png");
	nom.push_back("Create a contour using the bulls eye");
	funct.push_back((wxObjectEventFunction) &interfNewContourMenu::onCreateContourBullseye);
	hand.push_back(this);

	path.push_back(datadir + "/Line.png");
	nom.push_back("Create a Line");
	funct.push_back((wxObjectEventFunction) &interfNewContourMenu::onCreateContourLine);
	hand.push_back(this);

	// RaC 09-09 ---------------------
	path.push_back(datadir + "/Points.png");
	nom.push_back("Create Points");
	funct.push_back((wxObjectEventFunction) &interfNewContourMenu::onCreateContourPoints);
	hand.push_back(this);
	// RaC 09-09 ---------------------	

	// RaC 10-09 ---------------------
	path.push_back(datadir + "/Polygon.png");
	nom.push_back("Create Polygon");
	funct.push_back((wxObjectEventFunction) &interfNewContourMenu::onCreateContourPolygon);
	hand.push_back(this);
	// RaC 10-09 ---------------------	

    this->addButtons(path, nom);

	this->setVectorFunction(funct);	
	this->setEventHandlers(hand);	
	this->connectEvents();

}



interfNewContourMenu::~interfNewContourMenu()
{
}

void interfNewContourMenu::onCreateContourBullseye(wxCommandEvent& event){


	if(!created){

		panBull = new PanelBullEyeOptions(interfMainPanel::getInstance()->getInfoPanel(), 
								wxSize(100,200));
		created = true;
	}
	interfMainPanel::getInstance()->onCreateContoursBullEye(panBull);
	//eventHandler->createContourBullsEye(panBull);
	interfMainPanel::getInstance()->showPanel(panBull);

}

void interfNewContourMenu::onCreateContourSpline( wxCommandEvent& event ){
	interfMainPanel::getInstance()->onCreateContourSpline();
}
void interfNewContourMenu::onCreateContourRectangle( wxCommandEvent& event ){
	interfMainPanel::getInstance()->onCreateContourRectangle();
}
void interfNewContourMenu::onCreateContourCircle( wxCommandEvent& event ){
	interfMainPanel::getInstance()->onCreateContourCircle();
}
void interfNewContourMenu::onCreateContourLine( wxCommandEvent& event ){
	interfMainPanel::getInstance()->onCreateContourLine();
}

// RaC 09-09 ---------------------
void interfNewContourMenu::onCreateContourPoints( wxCommandEvent& event ){
	interfMainPanel::getInstance()->onCreateContourPoints();
}
// RaC 09-09 ---------------------

// RaC 10-09 ---------------------
void interfNewContourMenu::onCreateContourPolygon( wxCommandEvent& event ){
	interfMainPanel::getInstance()->onCreateContourPolygon();
}
// RaC 10-09 ---------------------

