/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfSegmentationMenu.h"
#include "interfMainPanel.h"

interfSegmentationMenu::interfSegmentationMenu(wxWindow * parent, int sizex, int sizey,wxEvtHandler* evtHandler, std::string datdir)
	: interfMenuBar(parent, sizex, sizey)
{
	this->datadir	= datdir;

/*EED Borrame
	//contourevent	= (wxContourEventHandler*)evtHandler;
	infoWin			= NULL;
	configPanel		= NULL;
	spreadPanel		= NULL;
	segmentPanelITK = NULL;
	
	//eventHandler	= evtHandler;
*/

	initButtons(this);
}

void interfSegmentationMenu::initButtons(wxEvtHandler* evtHandler) {

	std::vector<std::string> path, nom;
	std::vector<wxObjectEventFunction> funct;

	path.push_back(datadir + "/Segmentation.png");
	nom.push_back("Find shapes by automatic segmentation");
	funct.push_back((wxObjectEventFunction) &interfSegmentationMenu:: onSegmentationPressed);

	path.push_back(datadir + "/ITK.png");
	nom.push_back("Find shapes by automatic segmentation with ITK");
	funct.push_back((wxObjectEventFunction) &interfSegmentationMenu:: onSegmentationPressedITK);

	path.push_back(datadir + "/snake.png");
	nom.push_back("Find shapes using border snake interaction");
	funct.push_back((wxObjectEventFunction) &interfSegmentationMenu:: onSnakePressed);

/*EED Borrame
	path.push_back(datadir + "/Threshold.png");
	nom.push_back("Superpose a 'Red Image' to the selected Image Threshold");
	funct.push_back((wxObjectEventFunction)&interfSegmentationMenu::onThreshold);
*/
	this->addButtons(path, nom);	
	this->setVectorFunction(funct);

	this->connectEvents(evtHandler);
	   

}

interfSegmentationMenu::~interfSegmentationMenu()
{
}

/**
	**	Responds to the events of the buttons, when the same panel is responsible for it. It gets the name
	**	of the button corresponding to the method that has to be executed,
	**	it uses attribute eventHandler to call the methods define by the application.
	**	see setEventHandler(wxEventHandler*)
	**/


void  interfSegmentationMenu::onSegmentationPressed(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onSegmentationPressed();
}



void  interfSegmentationMenu::onSegmentationPressedITK(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onSegmentationPressedITK();    
}

void  interfSegmentationMenu::onSnakePressed(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onSnakePressed();
}

/*EED Borrame
void interfSegmentationMenu::onThreshold(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onThresholdPressed();
}
*/
//------------------------------------------------------------------------------------------------------------

