/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfSegmentationPanels.h"
#include "interfMainPanel.h"

interfSegmentationPanelVTK::interfSegmentationPanelVTK(wxWindow * parent)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{
	int sizeZ = interfMainPanel::getInstance()->GetImageDataSizeZ();

	double range[2];
	interfMainPanel::getInstance()->getImageRange(range);

	int min = (int)floor (range[0]);
	int max = (int)ceil (range[1]);

	wxButton *segmentationOneSliceBtn   = new wxButton(this,-1,_T("Current slice"), wxDefaultPosition, wxSize(200,35) );
	wxButton *segmentationAllSliceBtn   = new wxButton(this,-1,_T("All slices") ,wxDefaultPosition, wxSize(200,35) );
	_isovalue                           = new wxSlider(this, -1, 40 , min, max, wxDefaultPosition, wxSize(200,35), wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
	_sampling                           = new wxSlider(this, -1, 20 , 4, 50, wxDefaultPosition, wxSize(200,35), wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
	wxString lstOptions[3];
	lstOptions[0]=_T("A");
	lstOptions[1]=_T("B");
	lstOptions[2]=_T("C");
	methodRadiobox                      = new wxRadioBox(this, -1, _T("Method (find ctrl. Points)"), wxDefaultPosition, wxSize(200,45), 3 , lstOptions,  3, wxRA_SPECIFY_COLS);
	methodRadiobox->SetSelection(2);
	_staticTextSegmentation             = new wxStaticText(this,-1,_T("    "));

	_mbarrange                          = new mBarRange(this,70, 65);
	_mbarrange->SetMin(0);
	_mbarrange->SetStart(0);

	_mbarrange->SetOrientation( true );
	_mbarrange->setActiveStateTo(true);
	_mbarrange->setVisibleLabels( true );
	_mbarrange->setDeviceEndMargin(10);
   	_mbarrange->setRepresentedValues( 0 , sizeZ );
	_mbarrange->setDeviceBlitStart(10,10); 
	_mbarrange->setIfWithActualDrawed( false );
	_mbarrange->SetStart( 0 );
	_mbarrange->SetEnd( sizeZ );  

	wxFlexGridSizer * sizer             = new wxFlexGridSizer(1);
	sizer->Add( new wxStaticText(this, -1, _T("Isovalue (Gray level)")), 1, wxGROW );
	sizer->Add( _isovalue, 1, wxGROW );
	sizer->Add( methodRadiobox , 1, wxGROW );
	sizer->Add( new wxStaticText(this, -1 ,_T("Sampling (%)")), 1, wxGROW );
	sizer->Add( _sampling, 1, wxGROW );
	sizer->Add( segmentationOneSliceBtn, 1, wxGROW );
	sizer->Add( new wxStaticText(this, -1, _T(" ")), 1, wxGROW );
	sizer->Add( _staticTextSegmentation, 1, wxGROW );
	sizer->Add( segmentationAllSliceBtn, 1, wxGROW );
	sizer->Add( _mbarrange, 1, wxGROW );

	this->SetSizer( sizer );
//		panel->SetSize( sizePanel );
	this->SetSize( wxDefaultSize );
	this->SetAutoLayout( true );
	this->Layout();
	
//_segmentationFrame->SetEventHandler( this );
	//segmentationOneSliceBtn->SetEventHandler( this );
	//segmentationAllSliceBtn->SetEventHandler( this );
	//panel->SetEventHandler(this);
	Connect( segmentationOneSliceBtn->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) &interfSegmentationPanelVTK::onSegmentationOneSlice); 
	Connect( segmentationAllSliceBtn->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) &interfSegmentationPanelVTK::onSegmentationAllSlice); 
}


interfSegmentationPanelVTK::~interfSegmentationPanelVTK()
{
}

/**
	**	Responds to the events of the buttons, when the same panel is responsible for it. It gets the name
	**	of the button corresponding to the method that has to be executed,
	**	it uses attribute eventHandler to call the methods define by the application.
	**	see setEventHandler(wxEventHandler*)
	**/

void  interfSegmentationPanelVTK::onSegmentationPressedITK(wxCommandEvent& event){
   if(segmentPanelITK == NULL) {
		segmentPanelITK = new wxPanel(interfMainPanel::getInstance()->getInfoPanel(), -1, wxDefaultPosition, wxDefaultSize, wxBORDER_STATIC, wxString(_T("")));			

		wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1);	
		segmentPanelITK->SetSizer(flexsizer, true);
		segmentPanelITK->SetAutoLayout( true );	
				
		wxPanel* panel = new wxPanel(this, -1);//contourevent->getSegmentationPanelITK(segmentPanelITK);
	
		wxStaticText* stattext = new wxStaticText(segmentPanelITK, -1, wxString(_T("   Automatic ITK Segmentation   ")), wxDefaultPosition,
			wxDefaultSize, wxALIGN_CENTRE|wxBORDER_SIMPLE|wxFULL_REPAINT_ON_RESIZE, wxString(_T("")));

		flexsizer->Add(stattext, wxALIGN_CENTER | wxALIGN_CENTRE);
		flexsizer->Add(panel, wxEXPAND);
		segmentPanelITK->Layout();
   }
	interfMainPanel::getInstance()->showPanel(segmentPanelITK);
	//contourevent->showAxis(true);
	//axisshown = true;
}

void interfSegmentationPanelVTK::onSegmentationOneSlice( wxCommandEvent& event )
{
	int isovalue = _isovalue->GetValue();
	int sampling = _sampling->GetValue();
	int method = methodRadiobox->GetSelection();
	interfMainPanel::getInstance()->onSegmentationOneSlice(isovalue, sampling, method);
	
}
void interfSegmentationPanelVTK::onSegmentationAllSlice( wxCommandEvent& event )
{
	int minZ=_mbarrange->GetStart();
	int maxZ=_mbarrange->GetEnd();

	int isovalue = _isovalue->GetValue();
	int sampling = _sampling->GetValue();
	int method   = methodRadiobox->GetSelection();

	interfMainPanel::getInstance()->onSegmentationAllSlice(minZ, maxZ, isovalue, sampling, method);	
}

void interfSegmentationPanelVTK::setLabel(wxString tmpString){
	_staticTextSegmentation->SetLabel(tmpString);
}
/**
** start of new implementation
**	interfSegmentationPanelITK
**/
interfSegmentationPanelITK::interfSegmentationPanelITK(wxWindow * parent)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{
	double range[2];
	interfMainPanel::getInstance()->getImageRange(range);

//	int min = (int)floor (range[0]);
//	int max = (int)ceil (range[1]);
	
	//The labels
	//wxStaticText * distance =    
	new wxStaticText(this, wxID_ANY, wxT("Initial Distance"),   wxPoint(5, 5));
	//wxStaticText * sigma =       
	new wxStaticText(this, wxID_ANY, wxT("Sigma"),              wxPoint(5, 30));
	//wxStaticText * alfa =        
	new wxStaticText(this, wxID_ANY, wxT("Sigmoid Alfa"),       wxPoint(5, 55));
	//wxStaticText * beta =        
	new wxStaticText(this, wxID_ANY, wxT("Sigmoid Beta"),       wxPoint(5, 80));
	//wxStaticText * propagation = 
	new wxStaticText(this, wxID_ANY, wxT("Propagation Scaling"),wxPoint(5, 105));
	//wxStaticText * iterations =  
	new wxStaticText(this, wxID_ANY, wxT("Iterations"),         wxPoint(5, 130));
	//wxStaticText * infStrength = 
	new wxStaticText(this, wxID_ANY, wxT("Inflation Strength"), wxPoint(5, 155));

	//Text Controls

	_distance =      new wxTextCtrl(this, wxID_ANY, wxT("5.0"),  wxPoint(98,5),   wxSize(80, 20), 0, wxDefaultValidator, wxTextCtrlNameStr);
	_sigma =         new wxTextCtrl(this, wxID_ANY, wxT("1.2"),  wxPoint(98,30),  wxSize(80, 20), 0, wxDefaultValidator, wxTextCtrlNameStr);
	_alfa =          new wxTextCtrl(this, wxID_ANY, wxT("-1.0"), wxPoint(98,55),  wxSize(80, 20), 0, wxDefaultValidator, wxTextCtrlNameStr);	
	_beta =          new wxTextCtrl(this, wxID_ANY, wxT("5.0"),  wxPoint(98,80),  wxSize(80, 20), 0, wxDefaultValidator, wxTextCtrlNameStr);	
	_propagation =   new wxTextCtrl(this, wxID_ANY, wxT("6.0"),  wxPoint(98,105), wxSize(80, 20), 0, wxDefaultValidator, wxTextCtrlNameStr);	
	_iterations =    new wxTextCtrl(this, wxID_ANY, wxT("800"),  wxPoint(98,130), wxSize(80, 20), 0, wxDefaultValidator, wxTextCtrlNameStr);	
	_infStrength =   new wxTextCtrl(this, wxID_ANY, wxT("3.0"),  wxPoint(98,155), wxSize(80, 20), 0, wxDefaultValidator, wxTextCtrlNameStr);
	
	//El boton
	//wxButton * bot = 
	new wxButton(this, 6, wxT("One Slice"), wxPoint(98, 180), wxSize(70, 25), 0, wxDefaultValidator, wxT("button"));

	//Conexion del boton con su respectivo manejador
	Connect(6, wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction) &interfSegmentationPanelITK::onSegmentationOneSlice);
	
	
}
interfSegmentationPanelITK::~interfSegmentationPanelITK(){

}

void interfSegmentationPanelITK::onSegmentationOneSlice( wxCommandEvent& event )
{
	wxString distanc=_distance->GetValue();
	wxString sigm=_sigma->GetValue();
	wxString alf=_alfa->GetValue();
	wxString bet=_beta->GetValue();
	wxString prop=_propagation->GetValue();
	wxString iter=_iterations->GetValue();
	wxString infS=_infStrength->GetValue();
	
	interfMainPanel::getInstance()->onSegmentationOneSliceITK(distanc, sigm, alf, bet, prop, iter, infS);
	
}
void interfSegmentationPanelITK::onSegmentationAllSlice( wxCommandEvent& event )
{

	/*int minZ=_mbarrange->GetStart();
	int maxZ=_mbarrange->GetEnd();

	int				isovalue	= _isovalue->GetValue();
	int				sampling	= _sampling->GetValue();
	int method = methodRadiobox->GetSelection();


	interfMainPanel::getInstance()->onSegmentationAllSlice(minZ, maxZ, isovalue, sampling, method);*/
	
}

//------------------------------------------------------------------------------------------------------------


/**
** Begin of the mirror panel
**/

interfMirrorPanel::interfMirrorPanel(wxWindow* parent)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{
	_axisStatus = true;

	wxButton *axisShowBtn = new wxButton(this,wxID_ANY,_T("Show/Hide Axis"), wxDefaultPosition, wxSize(200,35) );
	wxButton *mirrorGoBtn = new wxButton(this,wxID_ANY,_T("Mirror Contour"), wxDefaultPosition, wxSize(200,35) );
	_thickness = new wxSlider(this, -1, 4, 1, 10, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
	
	Connect( axisShowBtn->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfMirrorPanel::onAxisShow );
	Connect( mirrorGoBtn->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfMirrorPanel::onMirrorGo ); 

	wxFlexGridSizer * sizer		= new wxFlexGridSizer(1);
	sizer -> Add( axisShowBtn, 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1,_T(" "))  , 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1,_T("Thickness"))  , 1, wxGROW );
	sizer -> Add( _thickness, 1, wxGROW );
	sizer -> Add( mirrorGoBtn, 1, wxGROW );

	this->SetSizer( sizer );
	this->SetAutoLayout( true );
	this->Layout();
}

interfMirrorPanel::~interfMirrorPanel(){
}

void interfMirrorPanel::onAxisShow(wxCommandEvent& event)
{
	
	if (!_axisStatus)
	{
		interfMainPanel::getInstance()->onMirrorAxisShow();
		_axisStatus=true;
	}
	else
	{	
		interfMainPanel::getInstance()->onMirrorAxisHide();
		_axisStatus=false;		
	}
}

void interfMirrorPanel::onMirrorGo(wxCommandEvent& event)
{
	if (_axisStatus)
	{
		interfMainPanel::getInstance()->onMirror();
	}
}

void interfMirrorPanel::onChangeWidth(wxScrollEvent& event)
{
	int width = _thickness->GetValue();
	interfMainPanel::getInstance()->onMirrorChangeWidth(width);
}


BEGIN_EVENT_TABLE(interfMirrorPanel, wxPanel)
EVT_SCROLL(interfMirrorPanel :: onChangeWidth)
END_EVENT_TABLE()


//////////////////////////////////////////////////////////////

interfTestPanel::interfTestPanel(wxWindow* parent)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{
	wxButton *button1 = new wxButton(this,wxID_ANY,_T("Button 1"), wxDefaultPosition, wxSize(200,35) );
	wxButton *button2 = new wxButton(this,wxID_ANY,_T("Button 2"), wxDefaultPosition, wxSize(200,35) );
	
	Connect( button1->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfTestPanel::onButton1Pressed );
	Connect( button2->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfTestPanel::onButton2Pressed ); 
	
	wxFlexGridSizer * sizer		= new wxFlexGridSizer(1);
	sizer -> Add( button1, 1, wxGROW );
	sizer -> Add( button2, 1, wxGROW );

	this->SetSizer( sizer );
	this->SetAutoLayout( true );
	this->Layout();
}

interfTestPanel::~interfTestPanel(){
}

void interfTestPanel::onButton1Pressed(wxCommandEvent& event)
{
	std::cout << "Button 1 has been pressed" << std::endl;
}

void interfTestPanel::onButton2Pressed(wxCommandEvent& event)
{
	std::cout << "Button 2 has been pressed" << std::endl;
}




