/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __interfSegmentationPanelsH__
#define __interfSegmentationPanelsH__

#include <wx/wx.h>
#include "mBarRange.h"


class interfSegmentationPanelVTK 
	: public wxPanel
{
public:
	interfSegmentationPanelVTK(wxWindow * parent);		
	~interfSegmentationPanelVTK();

	/**
	**	Responds to the events of the buttons, when the same panel is responsible for it. It gets the name
	**	of the button corresponding to the method that has to be executed,
	**	it uses attribute eventHandler to call the methods define by the application.
	**	see setEventHandler(wxEventHandler*)
	**/
	
	void  onSegmentationPressed(wxCommandEvent& event);

	void  onSegmentationPressedITK(wxCommandEvent& event);

	void setLabel(wxString tmpString);

private:

	//wxContourEventHandler* contourevent;
	wxPanel* configPanel;
	wxWindow* infoWin;
	wxPanel* segmentPanel;
	wxPanel* spreadPanel;
	wxPanel* segmentPanelITK;
	bool axisshown;

	void hideAxis();

	wxPanel* getSegmentationPanel(wxWindow* parent);

	void onSegmentationOneSlice( wxCommandEvent& event );

	void onSegmentationAllSlice( wxCommandEvent& event );

	wxSlider* _isovalue;

	mBarRange* _mbarrange;
	
	wxSlider* _sampling;

	wxStaticText* _staticTextSegmentation;

	wxRadioBox* methodRadiobox;
};

class interfSegmentationPanelITK
	: public wxPanel
{
public:
	interfSegmentationPanelITK(wxWindow * parent);		
	~interfSegmentationPanelITK();


	void onSegmentationOneSlice( wxCommandEvent& event );

	void onSegmentationAllSlice( wxCommandEvent& event );
	
private:

	wxTextCtrl * _distance;
	wxTextCtrl * _sigma;
	wxTextCtrl * _alfa;
	wxTextCtrl * _beta;
	wxTextCtrl * _propagation;
	wxTextCtrl * _iterations;
	wxTextCtrl * _infStrength;
};


class interfMirrorPanel
	: public wxPanel
{
public:
	interfMirrorPanel(wxWindow * parent);		
	~interfMirrorPanel();

private:

	wxSlider* _thickness;

	bool _axisStatus;

	void onAxisShow(wxCommandEvent& event);

	void onMirrorGo(wxCommandEvent& event);

	void onChangeWidth(wxScrollEvent& event);

	DECLARE_EVENT_TABLE()
};




class interfTestPanel
	: public wxPanel
{
public:
	interfTestPanel(wxWindow * parent);		
	~interfTestPanel();

private:
	void onButton1Pressed(wxCommandEvent& event);

	void onButton2Pressed(wxCommandEvent& event);

};


#endif
 
 
