/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfToolsMenu.h"
#include "interfMainPanel.h"

interfToolsMenu::interfToolsMenu(wxWindow * parent, int sizex, int sizey,wxEvtHandler* evtHandler, std::string datdir)
	: interfMenuBar(parent, sizex, sizey)
{
	this->datadir = datdir;
	//contourevent = (wxContourEventHandler*)evtHandler;
	//infoWin		= NULL;

/*EED Borrame
	configPanel		= NULL;
	segmentPanel	= NULL;
	spreadPanel		= NULL;
	segmentPanelITK = NULL;
	
//	eventHandler = evtHandler;
*/

	initButtons(this);
}

void interfToolsMenu::initButtons(wxEvtHandler* evtHandler) {

	std::vector<std::string> path, nom;
	std::vector<wxObjectEventFunction> funct;

	path.push_back(datadir + "/Spread.png");
	nom.push_back("The selected contour will spread through all slides");
	funct.push_back((wxObjectEventFunction) &interfToolsMenu:: onRigidPressed);

	path.push_back(datadir + "/Spread1.png");
	nom.push_back("Select more than one contour and find the contours between them");
	funct.push_back((wxObjectEventFunction) &interfToolsMenu:: onSpreadPressed);
	
	path.push_back(datadir + "/Mirror.png");
	nom.push_back("Create an Axis and select a contour to mirror it accordingly");
	funct.push_back((wxObjectEventFunction) &interfToolsMenu:: onMirrorPressed);

//CMRU 17-08-09 ------------------------------------------------------------------
	path.push_back(datadir + "/Letter.PNG");
	nom.push_back("Insert a Label");
	funct.push_back((wxObjectEventFunction)&interfToolsMenu::onPrintLabel);
//-------------------------------------------------------------------------------


	path.push_back(datadir + "/FlipContours.png");
	nom.push_back("Flop contours");
	funct.push_back((wxObjectEventFunction) &interfToolsMenu:: onFlipPressed);

	
	this->addButtons(path, nom);	
	this->setVectorFunction(funct);

	//this->setButtonName(0, wxContour_ActionCommandsID::CHANGE_TOOL);

	this->connectEvents(evtHandler);
	   

}

interfToolsMenu::~interfToolsMenu()
{
}

/**
	**	Responds to the events of the buttons, when the same panel is responsible for it. It gets the name
	**	of the button corresponding to the method that has to be executed,
	**	it uses attribute eventHandler to call the methods define by the application.
	**	see setEventHandler(wxEventHandler*)
	**/
void interfToolsMenu::onRigidPressed(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onRigidPressed();
}

void  interfToolsMenu::onSpreadPressed(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onSpreadPressed();
}

void interfToolsMenu::onMirrorPressed(wxCommandEvent& event)
{
  interfMainPanel::getInstance()->onMirrorPressed();
}

void interfToolsMenu::onPrintLabel(wxCommandEvent& event)
{
	interfMainPanel::getInstance()->onPrintLabel();
}

void interfToolsMenu::onFlipPressed(wxCommandEvent& event)
{
	printf("EED interfToolsMenu::onFlipLabel \n");
	interfMainPanel::getInstance()->onFlipContours();
}
