/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfToolsPanels.h"
#include "interfMainPanel.h"

interfConfigurationPanel::interfConfigurationPanel(wxWindow * parent)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{
//	wxPanel *panel							= new wxPanel(parent,-1,wxDefaultPosition, wxDefaultSize,wxNO_BORDER, wxString(_T("")));
	_withOfContourLine						= new wxSlider(this, -1, 1 , 1, 10, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);

	double range[2];
	interfMainPanel::getInstance()->getImageRange(range);
	//this->_theViewPanel->getSceneManager()->GetImageDataRange(range);

	//wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)this->_theViewPanel->getWxVtkBaseView();
	//vtkImageViewer2 *imageviewer = wxvtk2dbaseview->_imageViewer2XYZ->GetVtkImageViewer2();
	//int colorwindow = (int)imageviewer->GetWindowLevel()->GetLevel();
	//int windowlevel = (int)imageviewer->GetWindowLevel()->GetWindow();

	int colorwindow = interfMainPanel::getInstance()->getColorWindow();
	int windowlevel = interfMainPanel::getInstance()->getWindowLevel();

	int min = (int)floor (range[0]);
	int max = (int)ceil (range[1]);


	_brithtnessWindowLevel					= new wxSlider(this, -1, windowlevel , min, max, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
	_brithtnessColorLevel					= new wxSlider(this, -1, colorwindow , min, max, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);

	_interpolationCheckBox = new wxCheckBox(this, -1, _T("Image interpolation") );
	_interpolationCheckBox->SetValue(true);

	Connect( _withOfContourLine->GetId(),     wxEVT_SCROLL_CHANGED,           (wxObjectEventFunction) &interfConfigurationPanel::onWidthOfContour);
	Connect( _withOfContourLine->GetId(),     wxEVT_SCROLL_THUMBTRACK,        (wxObjectEventFunction) &interfConfigurationPanel::onWidthOfContour);

	Connect( _brithtnessWindowLevel->GetId(), wxEVT_SCROLL_CHANGED,           (wxObjectEventFunction) &interfConfigurationPanel::onBrigthnessColorWindowLevel);
	Connect( _brithtnessWindowLevel->GetId(), wxEVT_SCROLL_THUMBTRACK,        (wxObjectEventFunction) &interfConfigurationPanel::onBrigthnessColorWindowLevel);
	Connect( _brithtnessColorLevel->GetId()	, wxEVT_SCROLL_CHANGED,           (wxObjectEventFunction) &interfConfigurationPanel::onBrigthnessColorWindowLevel);
	Connect( _brithtnessColorLevel->GetId()	, wxEVT_SCROLL_THUMBTRACK,        (wxObjectEventFunction) &interfConfigurationPanel::onBrigthnessColorWindowLevel);
	Connect( _interpolationCheckBox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &interfConfigurationPanel::OnInterpolation);

	wxFlexGridSizer * sizer					= new wxFlexGridSizer(1);
	sizer -> Add( new wxStaticText(this,-1, _T("Contour width"))  , 1, wxGROW );
	sizer -> Add( _withOfContourLine		, 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1, _T(" "))  , 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1, _T(" "))  , 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1, _T("Brightness of the image"))  , 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1, _T("--Window level--"))  , 1, wxGROW );
	sizer -> Add( _brithtnessWindowLevel		, 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1, _T("--Color level--"))  , 1, wxGROW );
	sizer -> Add( _brithtnessColorLevel, 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1, _T(" "))  , 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1, _T(" "))  , 1, wxGROW );
	sizer -> Add( _interpolationCheckBox		, 1, wxGROW );

	this->SetSizer( sizer );
	//JCP 13-10-08
	//panel->SetSize( sizepanel );
	//13-10-08
	this->SetAutoLayout( true );
	this->Layout();

}


interfConfigurationPanel::~interfConfigurationPanel()
{
}

void interfConfigurationPanel::onWidthOfContour(wxScrollEvent& event){

    double width = (double)_withOfContourLine->GetValue() / 2.0;
	interfMainPanel::getInstance()->onWidthOfContour(width);
}

void interfConfigurationPanel::onBrigthnessColorWindowLevel(wxScrollEvent& event){
	int colorwindow				= _brithtnessColorLevel->GetValue();
	int windowlevel				= _brithtnessWindowLevel->GetValue();

	interfMainPanel::getInstance()->onBrigthnessColorWindowLevel(colorwindow, windowlevel);

}

void interfConfigurationPanel::OnInterpolation(wxCommandEvent& event)
{

	interfMainPanel::getInstance()->onInterpolation(_interpolationCheckBox->GetValue());


}

/**
** Begin of the spread panel
**/

interfSpreadPanel::interfSpreadPanel(wxWindow* parent)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{

	//wxPanel *panel				= new wxPanel(parent,-1);

	//_contourPropagation			= new ContourPropagation();

	//wxPanel *panel							= new wxPanel(parent,-1,wxDefaultPosition, wxDefaultSize,wxNO_BORDER, wxString("",wxConvUTF8));

	wxButton *spreadResetBtn	= new wxButton(this,-1,_T("Reset"),wxDefaultPosition, wxDefaultSize );
	wxButton *spreadAddBtn		= new wxButton(this,-1,_T("Add key contour "),wxDefaultPosition, wxDefaultSize);
	wxButton *spreadAddAllBtn	= new wxButton(this,-1,_T("Add All to key contour"),wxDefaultPosition, wxDefaultSize);

	wxString lstOptions[3];
	lstOptions[0]=_T("A");
	lstOptions[1]=_T("B");
	lstOptions[2]=_T("C");
	_spreadMethodRadiobox						= new wxRadioBox(this, -1, _T("Method (find ctrl. Points)"), wxDefaultPosition, wxDefaultSize, 3 , lstOptions,  3, wxRA_SPECIFY_COLS);
	_spreadMethodRadiobox->SetSelection(2);

	wxButton *spreadGoBtn		= new wxButton(this,-1,_T("Go"),wxDefaultPosition, wxDefaultSize);
	_staticTextSpread			= new wxStaticText(this,-1,_T("    "));

	_wxtextctrlSpread           = new wxTextCtrl(this,-1, _T(""),wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE );
	_wxtextctrlSpread->SetEditable(false);

	Connect( spreadResetBtn->GetId(),	wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfSpreadPanel::onSpreadReset );
	Connect( spreadAddBtn->GetId(),		wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfSpreadPanel::onSpreadAdd );
	Connect( spreadAddAllBtn->GetId(),	wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfSpreadPanel::onSpreadAddAll );
	Connect( spreadGoBtn->GetId(),		wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfSpreadPanel::onSpreadGo );

	wxFlexGridSizer * sizer		= new wxFlexGridSizer(1);
	sizer -> Add( spreadResetBtn		, 1, wxGROW );
	sizer -> Add( spreadAddBtn			, 1, wxGROW );
	sizer -> Add( spreadAddAllBtn		, 1, wxGROW );
	sizer -> Add( _spreadMethodRadiobox	, 1, wxGROW );
	sizer -> Add( spreadGoBtn			, 1, wxGROW );
	sizer -> Add( _staticTextSpread		, 1, wxGROW );
	sizer -> Add( _wxtextctrlSpread		, 1, wxGROW );


	this->SetSizer( sizer );
	//this->SetSize( wxDefaultSize );
	this->SetAutoLayout( true );
	this->Layout();
	//return panel;
}

interfSpreadPanel::~interfSpreadPanel(){
}

void interfSpreadPanel::onSpreadReset(wxCommandEvent& event){
	setStringSpread("   ");
	_wxtextctrlSpread->SetValue(wxString("",wxConvUTF8));
	interfMainPanel::getInstance()->resetAppend();
}

void interfSpreadPanel::onSpreadAdd(wxCommandEvent& event){
	interfMainPanel::getInstance()->onSpreadAdd();
}

void interfSpreadPanel::onSpreadAddAll(wxCommandEvent& event){
	interfMainPanel::getInstance()->onSpreadAddAll();
}

void interfSpreadPanel::onSpreadGo(wxCommandEvent& event){
	setStringSpread("   ");
	int typeMethodFindCtrlPoints=_spreadMethodRadiobox->GetSelection();
printf("EED interfSpreadPanel::onSpreadGo %d\n",typeMethodFindCtrlPoints);
	interfMainPanel::getInstance()->onSpreadGo(typeMethodFindCtrlPoints);

}

void interfSpreadPanel::appendStringSpread(std::string val){
	/* // if */
	wxString newstring;
	//newstring.Printf("%s %d -",_wxtextctrlSpread->GetValue(), actualSlice );
	newstring.append(wxString(_wxtextctrlSpread->GetValue(),wxConvUTF8));
	newstring.append(wxString(" ",wxConvUTF8));
	newstring.append(wxString(val.c_str(),wxConvUTF8));
	_wxtextctrlSpread->SetValue(newstring);
}

void interfSpreadPanel::setStringSpread(std::string stringtemp){

	wxString newstring(stringtemp.c_str(),wxConvUTF8);
	//_wxtextctrlSpread->SetEditable(true);
	_staticTextSpread->SetLabel(newstring);
	//_wxtextctrlSpread->SetEditable(false);
}

/**
** Begin of information panel
**/
interfInformationPanel::interfInformationPanel(wxWindow * parent)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{
	//wxPanel *panel									= new wxPanel(parent,-1,wxDefaultPosition, wxDefaultSize,wxTAB_TRAVERSAL);
	wxString lstOptions[4];
	lstOptions[0]=_T("Current Slice");
	lstOptions[1]=_T("Range Slices");
//	lstOptions[2]=_T("All Slices");
	_informationRadiobox     = new wxRadioBox(this, -1, _T("Slice analysis"), wxDefaultPosition, wxSize(270,45), 2 , lstOptions,  2, wxRA_SPECIFY_COLS);


	wxString lstOptContOperation[5];
	lstOptContOperation[0]=_T("AND");
	lstOptContOperation[1]=_T("OR");
	lstOptContOperation[2]=_T("XOR");
	lstOptContOperation[3]=_T("ALL");
	_radiolstboxContourGroup = new wxRadioBox(this, -1, _T("Contour group"), wxDefaultPosition, wxSize(270,45), 4 , lstOptContOperation,  4, wxRA_SPECIFY_COLS);
	_radiolstboxContourGroup->SetSelection(1);
	Connect( _radiolstboxContourGroup->GetId(), wxEVT_COMMAND_RADIOBOX_SELECTED , (wxObjectEventFunction) &interfInformationPanel::onContourGroup );


	_XYZValues = new wxCheckBox(this, -1, _T("Save Contour Values") );
	_XYZValues->SetValue(true);

	_contourImage = new wxCheckBox(this, -1, _T("Extract Contours as Images") );
	_contourImage->SetValue(true);

	_statistics = new wxCheckBox(this, -1, _T("Save Statistics") );
	_statistics->SetValue(true);

	wxButton *informationContourLabelsBtn		= new wxButton(this,-1,_T("Contour labels"),wxDefaultPosition, wxSize(140,35) );
	informationContourLabelsBtn->SetEventHandler( this );
	Connect( informationContourLabelsBtn->GetId(),		wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfInformationPanel::onInformationContourLabels );

	wxButton *statisticsContourBtn			= new wxButton(this,-1,_T("Contour statistics"),wxDefaultPosition, wxSize(140,35) );
	statisticsContourBtn->SetEventHandler( this );
	Connect( statisticsContourBtn->GetId(),		wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfInformationPanel::onExtractInformation );

	wxButton *showResultImagesBtn			= new wxButton(this,-1,_T("Show result images"),wxDefaultPosition, wxSize(140,35) );
	showResultImagesBtn->SetEventHandler( this );
	Connect( showResultImagesBtn->GetId(),		wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfInformationPanel::onShowResultImages );


	wxButton *saveResultsBtn			= new wxButton(this,-1,_T("Save Results"),wxDefaultPosition, wxSize(140,35) );
	saveResultsBtn->SetEventHandler( this );
	Connect( saveResultsBtn->GetId(),		wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfInformationPanel::onSaveResults );


	int sizeZ = interfMainPanel::getInstance()->GetImageDataSizeZ();
	//_theViewPanel->getSceneManager()->GetImageDataSizeZ();
	_mbarrangeSliceInformation			=  new mBarRange(this,65,65);
	_mbarrangeSliceInformation->SetMin(0);
	_mbarrangeSliceInformation->SetStart(0);
	_mbarrangeSliceInformation-> SetOrientation( true );
	_mbarrangeSliceInformation-> setActiveStateTo(true);
	_mbarrangeSliceInformation-> setVisibleLabels( true );
	_mbarrangeSliceInformation-> setDeviceEndMargin(10);
   	_mbarrangeSliceInformation-> setRepresentedValues( 0 , sizeZ-1 );
	_mbarrangeSliceInformation-> setDeviceBlitStart(10,10);
	_mbarrangeSliceInformation-> setIfWithActualDrawed( false );
	_mbarrangeSliceInformation-> SetStart( 0 );
	_mbarrangeSliceInformation-> SetEnd( sizeZ-1 );



	double range[2];
	interfMainPanel::getInstance()->getImageRange(range);

	int min = (int)floor (range[0]);
	int max = (int)ceil (range[1]);

	_mbarrangeRangeInformation	=  new mBarRange(this,65,65);
	_mbarrangeRangeInformation->SetMin(0);
	_mbarrangeRangeInformation->SetStart(0);
	_mbarrangeRangeInformation->SetOrientation( true );
	_mbarrangeRangeInformation->setActiveStateTo(true);
	_mbarrangeRangeInformation->setVisibleLabels( true );
	_mbarrangeRangeInformation->setDeviceEndMargin(10);
   	_mbarrangeRangeInformation->setRepresentedValues( min , max );
	_mbarrangeRangeInformation->setDeviceBlitStart(10,10);
	_mbarrangeRangeInformation->setIfWithActualDrawed( false );
	_mbarrangeRangeInformation->SetStart( min );
	_mbarrangeRangeInformation->SetEnd( max );

//	_mbarrangeSliceInformation->PushEventHandler(this);
//	Connect(_mbarrangeRangeInformation->GetId(),wxEVT_TSBAR,(wxObjectEventFunction) (wxCommandEventFunction) &interfInformationPanel::onRangeSliceInformation );
//	Connect(_mbarrangeRangeInformation->GetId(),wxEVT_TSBAR_ACTUAL,(wxObjectEventFunction) (wxCommandEventFunction)  &interfInformationPanel::onRangeSliceInformation );
	Connect(_mbarrangeRangeInformation->GetId(),wxEVT_TSBAR_START,(wxObjectEventFunction) (wxCommandEventFunction)  &interfInformationPanel::onRangeSliceInformation );
	Connect(_mbarrangeRangeInformation->GetId(),wxEVT_TSBAR_END,(wxObjectEventFunction) (wxCommandEventFunction)  &interfInformationPanel::onRangeSliceInformation );
//	Connect(_mbarrangeRangeInformation->GetId(),wxEVT_SELECTION_END,(wxObjectEventFunction) (wxCommandEventFunction)  &interfInformationPanel::onRangeSliceInformation );
	Connect(_mbarrangeRangeInformation->GetId(),wxEVT_TSBAR_MOVED,(wxObjectEventFunction) (wxCommandEventFunction)  &interfInformationPanel::onRangeSliceInformation );


	_staticTextInformation	= new wxStaticText(this,-1,_T("    "));

	_grid = new wxGrid( this,
                wxID_ANY,
                wxPoint( 0, 0 ),
                wxSize( 200, 500 ) );

	int i,gridCol=10,gridRow=sizeZ+2;
	_grid->CreateGrid( 0, 0 );
	_grid->AppendRows(gridRow);
	_grid->AppendCols(gridCol);

	for (i=0;i<gridRow;i++)
	{
		_grid->SetRowLabelValue(i, _T(" ") );
	}
//			_grid->SetColLabelSize(0);


	FillGridWithContoursInformation();

	wxFlexGridSizer * sizerSave		= new wxFlexGridSizer(2,2);
	sizerSave -> Add( new wxStaticText(this,-1,_T("Save Options: "))  , 1, wxGROW );
	sizerSave->Add( _XYZValues,    1, wxALL, 2 );
	sizerSave->Add( _statistics,   1, wxALL, 2 );
	sizerSave->Add( _contourImage, 1, wxALL, 2 );

	wxFlexGridSizer * sizerA		= new wxFlexGridSizer(10);
	sizerA->Add( _informationRadiobox,     1, wxALL, 2 );
	sizerA->Add( _radiolstboxContourGroup, 1, wxALL, 2 );
	sizerA->Add( sizerSave,                1, wxALL, 2 );


	wxFlexGridSizer * sizerB		= new wxFlexGridSizer(10);
	sizerB->Add( informationContourLabelsBtn, 1, wxALL, 2 );
	sizerB->Add( statisticsContourBtn,        1, wxALL, 2 );
	sizerB->Add( showResultImagesBtn,         1, wxALL, 2 );
	sizerB->Add( saveResultsBtn,              1, wxALL, 2 );

	wxFlexGridSizer * sizer		= new wxFlexGridSizer(1,8);
	sizer->Add( sizerA                     , 1, wxALL		, 0 );
	sizer->Add( new wxStaticText(this      ,-1,_T("Slice Range"))	, 1, wxALL , 0 );
	sizer->Add( _mbarrangeSliceInformation , 1, wxALL|wxGROW        , 2 );
	sizer->Add( new wxStaticText(this      ,-1,_T("Gray Range"))	, 1, wxALL , 0 );
	sizer->Add( _mbarrangeRangeInformation , 1, wxALL|wxGROW        , 2 );
	sizer->Add( sizerB                     , 1, wxEXPAND		, 0 );
	sizer->Add( _staticTextInformation     , 1, wxEXPAND		, 0 );
	sizer->Add( _grid                      , 1, wxEXPAND	        , 0 );

	this->SetSizer( sizer );
	this->SetSize( wxSize(1500,1500) );
	//this->SetBackgroundColour( wxColour(100,100,100) );
	this->SetAutoLayout( true );
	this->Layout();
	//return panel;
}

interfInformationPanel::~interfInformationPanel()
{
}


void interfInformationPanel::onRangeSliceInformation(wxCommandEvent& event)
{
	int	grayRangeMin	= _mbarrangeRangeInformation->GetStart();
	int	grayRangeMax	= _mbarrangeRangeInformation->GetEnd();
	interfMainPanel::getInstance()->SetScalarRange(grayRangeMin,grayRangeMax);
	interfMainPanel::getInstance()->RefreshInterface();
}


void interfInformationPanel::onInformationContourLabels(wxCommandEvent& event){
	wxBusyCursor wait;
	FillGridWithContoursInformation();
}


void interfInformationPanel::onShowResultImages(wxCommandEvent& event)
{
//	onExtractInformation( event );
	int selection        = _informationRadiobox->GetSelection();
	int minZ             = _mbarrangeSliceInformation->GetStart();
	int maxZ             = _mbarrangeSliceInformation->GetEnd();
	int typeContourGroup = _radiolstboxContourGroup->GetSelection();
	interfMainPanel::getInstance()->ShowResultImages(typeContourGroup, selection, minZ, maxZ);
}


void interfInformationPanel::onExtractInformation(wxCommandEvent& event){
	wxBusyCursor wait;
	_grid->ClearGrid();

	int typeContourGroup = this->_radiolstboxContourGroup->GetSelection();
	int selection        = _informationRadiobox->GetSelection();
	int minZ             = _mbarrangeSliceInformation->GetStart();
	int maxZ             = _mbarrangeSliceInformation->GetEnd();
	int grayRangeMin     = _mbarrangeRangeInformation->GetStart();
	int grayRangeMax     = _mbarrangeRangeInformation->GetEnd();

	interfMainPanel::getInstance()->onInformationContourLabels(typeContourGroup, selection, minZ, maxZ, grayRangeMin, grayRangeMax);
}

void interfInformationPanel::onSaveResults(wxCommandEvent& event)
{
	wxFileDialog dialog(this, _T("Choose a filename"), _T(""), _T(""), wxFileSelectorDefaultWildcardStr, wxSAVE );
	if (dialog.ShowModal() == wxID_OK)
	{
		onExtractInformation( event );
		int selection         = _informationRadiobox->GetSelection();
		int minZ              = _mbarrangeSliceInformation->GetStart();
		int maxZ              = _mbarrangeSliceInformation->GetEnd();
		std::string directory = (const char *)(dialog.GetDirectory().mb_str());
		std::string namefile  = (const char *)(dialog.GetFilename().mb_str());
		std::string filename  = (const char *)(dialog.GetPath().mb_str() );
		int typeContourGroup  = _radiolstboxContourGroup->GetSelection();
		interfMainPanel::getInstance()->onSaveResults(directory, namefile, filename,
			typeContourGroup,
			selection,minZ,maxZ,
			_XYZValues->GetValue(), _contourImage->GetValue(), _statistics->GetValue());
	}
}

void interfInformationPanel::FillGridWithContoursInformation(){

	wxString tempString;
	_grid->ClearGrid();
	_grid->SetColLabelValue(0, _T("A") );
	_grid->SetColLabelValue(1, _T("B") );
	_grid->SetColLabelValue(2, _T("C") );
	_grid->SetColLabelValue(3, _T("D") );
	_grid->SetColLabelValue(4, _T("E") );
	_grid->SetColLabelValue(5, _T("F") );
	//_instantPanel->getInstant( tempVector );

	int z,sizeZ = interfMainPanel::getInstance()->GetImageDataSizeZ();//->getSceneManager()->GetImageDataSizeZ();
	int ii,sizeLstContourThings;
	for ( z=0 ; z<sizeZ ; z++)
	{

		std::vector<std::string> lstContourThings = interfMainPanel::getInstance()->getOutlinesName(z);

			//this->_modelManager->getOutlinesAtInstant( &instant );

		sizeLstContourThings = lstContourThings.size();
		tempString.Printf(_T("%d - %d"),z, sizeLstContourThings);
		_grid->SetRowLabelValue(z, tempString );

		for (ii=0 ; ii<sizeLstContourThings ; ii++)
		{
			//ContourThing **contourthing = lstContourThings[ii];
			//tempString = wxString((*contourthing)->getName().c_str(),wxConvUTF8) ;
			tempString = wxString(lstContourThings[ii].c_str(),wxConvUTF8) ;
			_grid->SetCellValue( z, ii, tempString );
		} // for ii
	}// for z

	// Last line
	_grid->SetRowLabelValue(sizeZ, _T(" ") );
	for (ii=0 ; ii<sizeLstContourThings ; ii++)
	{
		_grid->SetCellValue( sizeZ, ii, _T(" ") );
	} // for ii

}

void interfInformationPanel::setStringInfoPanel(wxString tmpString){
	_staticTextInformation->SetLabel(tmpString);
}

void interfInformationPanel::setRowLabelInfoPanel(int z,wxString tempString){
	_grid->SetRowLabelValue(z, tempString );
}

int interfInformationPanel::getNumberCols(){
	return _grid->GetNumberCols();
}

void interfInformationPanel::appendCols(int numcols){
    _grid->AppendCols(numcols);
}

void interfInformationPanel::setCellValue(int z,int tmpIntA,wxString tempString){
	_grid->SetCellValue( z, tmpIntA , tempString );
}

void interfInformationPanel::setColLabel(int tmpIntB,wxString tmpTitleString){
	_grid->SetColLabelValue(tmpIntB, tmpTitleString);
}

wxString interfInformationPanel::getCellValue(int j,int i){
	return _grid->GetCellValue( j , i );
}

void interfInformationPanel::onContourGroup(wxCommandEvent& event)
{
	printf("EED interfInformationPanel::onContourGroup \n");
	int contourGroup=_radiolstboxContourGroup->GetSelection();
	if (contourGroup==3)
	{
		contourGroup=0;
	}
	interfMainPanel::getInstance()->SetContourGroup( _radiolstboxContourGroup->GetSelection() );
}

//CMRU 29-08-09-----------------------------------------------------------------------------------------------
interfCalibrationPanel:: interfCalibrationPanel(wxWindow * parent)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{
	double range[2];
	interfMainPanel::getInstance()->getImageRange(range);

	//Radio buttons
	wxString options[3];
	options[0]=_T("mm");
	options[1]=_T("cm");
	options[2]=_T("inch");

	_unitsRadiobox = new wxRadioBox(this, -1, _T("Unit of measurement"), wxPoint(2, 25), wxSize(145,45), 3 , options,  3, wxRA_SPECIFY_COLS);
	_unitsRadiobox->SetSelection(0);

	//The label
	new wxStaticText(this, wxID_ANY, wxT("Real Size: "),   wxPoint(2, 5));

	//Text Control
	_size = new wxTextCtrl(this, wxID_ANY, wxT(""),  wxPoint(78,3),   wxSize(70, 20), 0, wxDefaultValidator, wxTextCtrlNameStr);

	//The button
	new wxButton(this, 1, wxT("Calibrate"), wxPoint(78, 70), wxSize(70, 25), 0, wxDefaultValidator, wxT("button"));

	//Conexion del boton con su respectivo manejador
	Connect(1, wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction) &interfCalibrationPanel::onCalibrate);

}

interfCalibrationPanel:: ~interfCalibrationPanel()
{
}

void interfCalibrationPanel::onCalibrate(wxCommandEvent& event)
{
	wxString size =_size->GetValue();
	int unit = _unitsRadiobox->GetSelection();
	interfMainPanel::getInstance()->onCalibration(size, unit);
}
//------------------------------------------------------------------------------------------------------------



//////////////////////////////////////////////////////////////

interfFlipPanel::interfFlipPanel(wxWindow* parent)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{
	wxButton *buttonFlipX = new wxButton(this,wxID_ANY,_T("Flip Horizontally"), wxDefaultPosition, wxSize(200,35) );
	wxButton *buttonFlipY = new wxButton(this,wxID_ANY,_T("Flip Vertically"), wxDefaultPosition, wxSize(200,35) );

	wxString lstOptions[3];
	lstOptions[0]=_T("Flip selected contours");
	lstOptions[1]=_T("Flip all contours of actual slice");
	lstOptions[2]=_T("Flip all contours");
	_wichContoursRadioBox = new wxRadioBox(this, -1, _T("Transform"), wxDefaultPosition, wxDefaultSize, 3 , lstOptions,  1, wxRA_SPECIFY_COLS);
	_wichContoursRadioBox->SetSelection(2);

	
	Connect( buttonFlipX->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfFlipPanel::onFlipXPressed );
	Connect( buttonFlipY->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &interfFlipPanel::onFlipYPressed ); 
	
	wxFlexGridSizer * sizer		= new wxFlexGridSizer(1);
	sizer -> Add( _wichContoursRadioBox, 1, wxGROW );
	sizer -> Add( buttonFlipX, 1, wxGROW );
	sizer -> Add( buttonFlipY, 1, wxGROW );

	this->SetSizer( sizer );
	this->SetAutoLayout( true );
	this->Layout();
}




interfFlipPanel::~interfFlipPanel(){
}

void interfFlipPanel::onFlipXPressed(wxCommandEvent& event)
{
	std::cout << "interfToolsPanels.cxx  interfFlipPanel::onFlipXPressed     FlipX (btn)" << std::endl;
	int typeContoursFlip = _wichContoursRadioBox->GetSelection(); 
	interfMainPanel::getInstance()->FlipContours( typeContoursFlip , 0 );  // type, direction
}

void interfFlipPanel::onFlipYPressed(wxCommandEvent& event)
{
	std::cout << "interfToolsPanels.cxx   interfFlipPanel::onFlipYPressed FlipY  (btn)" << std::endl;
	int typeContoursFlip = _wichContoursRadioBox->GetSelection(); 
	interfMainPanel::getInstance()->FlipContours( typeContoursFlip , 1 );  // type, direction
}


