/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "interfToolsSpreadPanel.h"

interfToolsSpreadPanel::interfToolsSpreadPanel(wxWindow * parent, int sizex, int sizey,wxEvtHandler* evtHandler)	
	: wxPanel(parent, -1, wxDefaultPosition, wxSize(sizex, sizey), wxBORDER_THEME){
	wxFlexGridSizer* flexsizer = new wxFlexGridSizer(3,1,2,2);	
	this->SetSizer(flexsizer, true);
	this->SetAutoLayout( true );

	resetbuttxt = initializeButton("data/Icons/reset.png", "Reset");

	wxFlexGridSizer* flexsizer1 = new wxFlexGridSizer(1,2,2,2);	
	radiobox = initializeRadioBox();
	addremovecont = initializeAddRemoveContour();	
	flexsizer1->Add(radiobox,wxFIXED_MINSIZE);
	flexsizer1->Add(addremovecont,wxEXPAND | wxALIGN_CENTRE_VERTICAL);

	gobuttxt = initializeButton("data/Icons/Go.png", "Go");	

	flexsizer->Add(resetbuttxt, wxFIXED_MINSIZE);
	flexsizer->Add(flexsizer1, wxFIXED );
	flexsizer->Add(gobuttxt, wxFIXED_MINSIZE);
	
	
	this->Layout();
	
}


interfToolsSpreadPanel::~interfToolsSpreadPanel()
{
}

wxPanel* interfToolsSpreadPanel::initializeRadioBox(){
	wxPanel* panel = new wxPanel(this, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE, wxString(_T("")));
	wxString lstOptions[3];
	lstOptions[0]=_T("A");
	lstOptions[1]=_T("B");
	lstOptions[2]=_T("C");
	wxRadioBox* _spreadMethodRadiobox	= new wxRadioBox(panel, -1, _T("Method"), wxDefaultPosition, wxSize(45,80), 3 , lstOptions,  3, wxRA_SPECIFY_ROWS);
	_spreadMethodRadiobox->SetSelection(2);
	return panel;
}

wxPanel* interfToolsSpreadPanel::initializeButton(std::string path, std::string nom){
			

	wxPanel* panel = new wxPanel(this, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE, wxString(_T("")));

	wxFlexGridSizer* flexsizer = new wxFlexGridSizer(1,2,2,2);	
	panel->SetSizer(flexsizer, true);
	panel->SetAutoLayout( true );
	
	wxBitmap* bitmap = new wxBitmap(wxString(path.c_str(),wxConvUTF8), wxBITMAP_TYPE_PNG);

	wxBitmapButton* bitmapbutton = new wxBitmapButton(panel, -1, *bitmap, wxDefaultPosition, wxDefaultSize,
										wxBU_AUTODRAW, wxDefaultValidator, wxString(_T("")));

	
	wxStaticText* statictext = new wxStaticText(panel, -1, wxString(nom.c_str(),wxConvUTF8), wxDefaultPosition, 
								wxDefaultSize, wxALIGN_CENTRE, wxString(nom.c_str(),wxConvUTF8));

	
	flexsizer->Add(bitmapbutton, wxFIXED_MINSIZE);
	flexsizer->Add(statictext, wxALIGN_CENTRE_VERTICAL | wxALIGN_CENTER_HORIZONTAL |wxEXPAND);

	panel->Layout();
	
	return panel;
}

wxPanel* interfToolsSpreadPanel::initializeAddRemoveContour(){
	
	wxPanel* panel = new wxPanel(this, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE |wxVSCROLL , wxString(_T("")));

	scrollwin = new wxScrolledWindow(panel, -1, wxDefaultPosition, wxSize(80,50), wxVSCROLL, wxString(_T("")));

	checkboxsizer = new wxFlexGridSizer(0,1,2,2);	


	scrollwin->SetSizer(checkboxsizer, true);
	scrollwin->SetAutoLayout( false );
	//scrollwin->SetInitialSize(wxSize(200,200));

	
	return panel;
}

void interfToolsSpreadPanel::addContourCheckBox(std::string id){


	wxCheckBox* check = new wxCheckBox(scrollwin, -1, wxString(id.c_str(),wxConvUTF8), wxDefaultPosition, wxDefaultSize, 0,
							wxDefaultValidator, wxString(id.c_str(),wxConvUTF8));

	checkvect.push_back(id);

	checkboxsizer->Add(check, wxFIXED_MINSIZE | wxALIGN_LEFT );
	scrollwin->Layout();
	checkboxsizer->Layout();

}

void interfToolsSpreadPanel::removeContourCheckBox(std::string id){

	int index=-1;
	for(int i = 0; i < checkvect.size(); i++){
		std::string temp = checkvect[i];
		if(id == temp){
			index = i;
		}
	}
	if( index != -1){
		if(checkboxsizer->Remove(index)){
			checkboxsizer->Layout();
		}else{
            throw "The checkbox could not be removed";
		}
	}
}


