/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "ConceptDataWrap.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file ConceptDataWrap.cxx */


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------


	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

ConceptDataWrap :: ConceptDataWrap(std::string theName)
	{
		_minValue = -1;
		_maxValue = -1;
		_minShow = -1;
		_maxShow = -1;
		_actual = -1;
		_name = theName;
	}

	ConceptDataWrap :: ~ConceptDataWrap()
	{

	}
	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------

	/**
	* Sets the data concept values and name
	* @param theName The name of the concept 
	* @param minRepresent The minRepresent value of the concept 
	* @param maxRepresent The maxRepresent value of the concept 
	* @param minShowed The minShowed value of the concept 
	* @param maxShowed The maxShowed value of the concept 
	* @param actualShow The actualShow value of the concept 
	*/
	void ConceptDataWrap :: fillData( std::string theName, int minRepresent, int maxRepresent, int minShowed, int maxShowed, int actualShow )
	{
		_name = theName;
		_minValue = minRepresent;
		_maxValue = maxRepresent;
		_minShow = minShowed;
		_maxShow = maxShowed;
		_actual = actualShow;
	}


	std::string ConceptDataWrap :: getName()
	{
		return _name;
	}

	int ConceptDataWrap :: getMinShowedValue()
	{
		return _minShow;
	}

	int ConceptDataWrap :: getMaxShowedValue()
	{
		return _maxShow;
	}

	void ConceptDataWrap :: setMinValue(int theMin)
	{
		_minValue = theMin;
	}

	int  ConceptDataWrap :: getMinValue()
	{
		return _minValue;
	}

	void ConceptDataWrap :: setMaxValue(int theMax)
	{
		_maxValue = theMax;
	}

	int  ConceptDataWrap :: getMaxValue()
	{
		return _maxValue;
	}

	void ConceptDataWrap :: setActualValue(int theActual)
	{
		_actual = theActual;
	}

	int  ConceptDataWrap :: getActualValue()
	{
		return _actual;
	}

	bool ConceptDataWrap :: isEmpty()
	{
		return _actual == -1;
	}
	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

		
	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------
	

