/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
//#include "wxContourEventHandler.h"
#include "PanelBullEyeOptions.h"

//------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------

PanelBullEyeOptions::PanelBullEyeOptions (wxWindow * parent, wxSize size) :
		 wxPanel(parent, -1, wxDefaultPosition, size)
{

	_maxLevels		= 5;
	_maxSections	= 10;
	wxSize sizepanel(190,300);
	wxPanel *panel = this;


	wxString lstOptions[2];
	lstOptions[0]= wxString("General options",wxConvUTF8);
	lstOptions[1]= wxString("Detail options",wxConvUTF8);
	_radioboxBullEyeGenOpt	= new wxRadioBox(panel, -1, wxString("General/Detail options",wxConvUTF8), wxDefaultPosition, wxSize(200,45), 2 , lstOptions,  2, wxRA_SPECIFY_COLS);
	_radioboxBullEyeGenOpt->SetSelection(0);

	_spinctrlBullEyeNumOfCrowns = new wxSpinCtrl( panel , -1,_T("B"),wxDefaultPosition, wxSize(40,20) );
	_spinctrlBullEyeNumOfCrowns->SetRange(1,_maxLevels);
	_spinctrlBullEyeNumOfCrowns->SetValue(3);

	_spinctrlBullEyeNumOfSec = new wxSpinCtrl( panel , -1,_T("A"),wxDefaultPosition, wxSize(40,20) );
	_spinctrlBullEyeNumOfSec->SetRange(1,_maxSections);
	_spinctrlBullEyeNumOfSec->SetValue(5);


	_sliderBullEyeAngle = new wxSlider( panel , -1 ,0,0,180, wxDefaultPosition, wxSize(200,35), wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);

	wxFlexGridSizer * sizerGeneralOptions				= new wxFlexGridSizer(10);

	wxFlexGridSizer * sizerGeneralOptionsA				= new wxFlexGridSizer(1);
	wxFlexGridSizer * sizerGeneralOptionsB				= new wxFlexGridSizer(1);
	wxFlexGridSizer * sizerGeneralOptionsC				= new wxFlexGridSizer(1);
	sizerGeneralOptionsA -> Add( new wxStaticText(panel,-1,_T("Crowns")) , 1, wxGROW );
	sizerGeneralOptionsA -> Add( _spinctrlBullEyeNumOfCrowns , 1/*, wxGROW*/ );
	sizerGeneralOptionsB -> Add( new wxStaticText(panel,-1,_T("Sections")) , 1, wxGROW );
	sizerGeneralOptionsB -> Add( _spinctrlBullEyeNumOfSec , 1/*, wxGROW*/ );
	sizerGeneralOptionsC -> Add( new wxStaticText(panel,-1,_T("      Angle")) , 1, wxGROW );
	sizerGeneralOptionsC -> Add( _sliderBullEyeAngle , 1/*, wxGROW*/ );

	sizerGeneralOptions -> Add( sizerGeneralOptionsA  , 1/*, wxGROW*/ );
	sizerGeneralOptions -> Add( new wxStaticText(panel,-1,_T("   ")) , 1, wxGROW );
	sizerGeneralOptions -> Add( sizerGeneralOptionsB  , 1/*, wxGROW*/ );
	sizerGeneralOptions -> Add( new wxStaticText(panel,-1,_T("   ")) , 1, wxGROW );
	sizerGeneralOptions -> Add( sizerGeneralOptionsC  , 1/*, wxGROW*/ );


	wxSpinCtrl	*tmpSpinSection;
	wxSlider	*tmpSliderRadio;
	wxSlider	*tmpSliderAng;

	wxFlexGridSizer * sizerDetailOptions				= new wxFlexGridSizer(6);

	sizerDetailOptions -> Add( new wxStaticText(panel,-1,_T("Crown ")) , 1, wxGROW );
	sizerDetailOptions -> Add( new wxStaticText(panel,-1,_T("  Sections  ")) , 1, wxGROW );
	sizerDetailOptions -> Add( new wxStaticText(panel,-1,_T("  ")) , 1, wxGROW );
	sizerDetailOptions -> Add( new wxStaticText(panel,-1,_T("      Radio %")) , 1, wxGROW );
	sizerDetailOptions -> Add( new wxStaticText(panel,-1,_T("  ")) , 1, wxGROW );
	sizerDetailOptions -> Add( new wxStaticText(panel,-1,_T("      Angle")) , 1, wxGROW );

	wxString tmpwxstring;
	int i;
	for (i=0;i<_maxLevels;i++){
		tmpSpinSection = new wxSpinCtrl( panel	, -1,_T(""),wxDefaultPosition, wxSize(40,20) );
		tmpSliderRadio = new wxSlider( panel	, -1 ,0,0,100, wxDefaultPosition, wxSize(110,35), wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
		tmpSliderAng   = new wxSlider( panel	, -1 ,0,0,180, wxDefaultPosition, wxSize(200,35), wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);

		tmpSpinSection ->SetRange(1,_maxSections);

		tmpwxstring.Printf(_T("  %d.  "),i+1);
		sizerDetailOptions -> Add( new wxStaticText(panel,-1,tmpwxstring) , 1, wxGROW );
		sizerDetailOptions -> Add( tmpSpinSection, 1 );
		sizerDetailOptions -> Add( new wxStaticText(panel,-1,_T("  ")) , 1, wxGROW );
		sizerDetailOptions -> Add( tmpSliderRadio, 1, wxGROW );
		sizerDetailOptions -> Add( new wxStaticText(panel,-1,_T("  ")) , 1, wxGROW );
		sizerDetailOptions -> Add( tmpSliderAng, 1, wxGROW );

		tmpSpinSection	-> SetValue(5);
		tmpSliderRadio	-> SetValue( 100-(double)((i)*100.0/_maxLevels) );
		tmpSliderAng	-> SetValue(0);
		
		Connect( tmpSliderRadio->GetId(),	wxEVT_SCROLL_THUMBRELEASE  , (wxObjectEventFunction) &PanelBullEyeOptions::onRefreshPanel );
		Connect( tmpSliderRadio->GetId(),	wxEVT_SCROLL_CHANGED  , (wxObjectEventFunction) &PanelBullEyeOptions::onRefreshPanel );

		_lstBullEyeDetailNumOfSec.push_back( tmpSpinSection );
		_lstBullEyeDetailRadio.push_back( tmpSliderRadio );
		_lstBullEyeDetailAngle.push_back( tmpSliderAng );

	} //for

	wxFlexGridSizer * sizer				= new wxFlexGridSizer(1);
	sizer -> Add( new wxStaticText(panel,-1,_T("")) , 1, wxGROW );
	sizer -> Add( new wxStaticText(panel,-1,_T("")) , 1, wxGROW );
	sizer -> Add( _radioboxBullEyeGenOpt , 1, wxGROW );
	sizer -> Add( new wxStaticText(panel,-1,_T("")) , 1, wxGROW );
	sizer -> Add( new wxStaticText(panel,-1,_T("      -- Bull Eye general options --")) , 1, wxGROW );
	sizer -> Add( new wxStaticText(panel,-1,_T("")) , 1, wxGROW );
	sizer -> Add(  sizerGeneralOptions , 1, wxGROW );
	sizer -> Add( new wxStaticText(panel,-1,_T("")) , 1, wxGROW );
	sizer -> Add( new wxStaticText(panel,-1,_T("")) , 1, wxGROW );
	sizer -> Add( new wxStaticText(panel,-1,_T("      -- Bull Eye detail options --")) , 1, wxGROW );
	sizer -> Add( new wxStaticText(panel,-1,_T("")) , 1, wxGROW );
	sizer -> Add(  sizerDetailOptions  , 1, wxGROW );

	Connect( _radioboxBullEyeGenOpt->GetId(),	wxEVT_COMMAND_RADIOBOX_SELECTED , (wxObjectEventFunction) &PanelBullEyeOptions::onRefreshPanel ); 
	Connect( _spinctrlBullEyeNumOfCrowns->GetId(),	wxEVT_COMMAND_TEXT_UPDATED		, (wxObjectEventFunction) &PanelBullEyeOptions::onRefreshPanel );
	
	panel->SetSizer( sizer );
	panel->SetSize( sizepanel );
	panel->SetAutoLayout( true );
	panel->Layout();

	RefreshPanel();

}

//------------------------------------------------------------------------------------------------------------
PanelBullEyeOptions::~PanelBullEyeOptions() 
{
}

//------------------------------------------------------------------------------------------------------------
void PanelBullEyeOptions::onRefreshPanel( wxCommandEvent& event )
{
	RefreshPanel();
}

//------------------------------------------------------------------------------------------------------------
void PanelBullEyeOptions::RefreshPanel()
{
	int i;
	bool ok;
	if (this->_radioboxBullEyeGenOpt->GetSelection()==0){
		for (i=0; i<_maxLevels; i++)
		{
			_lstBullEyeDetailNumOfSec[i]	-> Enable(false);
			_lstBullEyeDetailRadio[i]		-> Enable(false);
			_lstBullEyeDetailAngle[i]		-> Enable(false);
		} // for
	} else {
		int spinSelec = _spinctrlBullEyeNumOfCrowns->GetValue(); 
		for (i=0; i<_maxLevels; i++)
		{
			ok = (i < spinSelec);
			_lstBullEyeDetailNumOfSec[i]	-> Enable(ok);
			_lstBullEyeDetailRadio[i]		-> Enable(ok);
			_lstBullEyeDetailAngle[i]		-> Enable(ok);

			if (i>0){
				if (_lstBullEyeDetailRadio[i]->GetValue() > _lstBullEyeDetailRadio[i-1]->GetValue())
				{
					_lstBullEyeDetailRadio[i]->SetValue( _lstBullEyeDetailRadio[i-1]->GetValue() );
				} 
			}// if i>0
		} // for
	} // if
}

//------------------------------------------------------------------------------------------------------------
int PanelBullEyeOptions::GetNumberOfCrowns()
{
	return this->_spinctrlBullEyeNumOfCrowns->GetValue();
}

//------------------------------------------------------------------------------------------------------------
int PanelBullEyeOptions::GetNumberOfSections(int nCrown)
{
	int result;
	if (this->_radioboxBullEyeGenOpt->GetSelection()==0)
	{ 
		result = this->_spinctrlBullEyeNumOfSec->GetValue();
	} else {
		result = this->_lstBullEyeDetailNumOfSec[nCrown]->GetValue();
	}
	return result;
}

//------------------------------------------------------------------------------------------------------------
int PanelBullEyeOptions::GetRadioOfCrown(int nCrown)
{
	int result;
	double sizeCrowns;
	if (this->_radioboxBullEyeGenOpt->GetSelection()==0)
	{ 
		sizeCrowns = (double)( this->_spinctrlBullEyeNumOfCrowns->GetValue() );
		result = 100.0 * (nCrown+1)/sizeCrowns ;
	} else {
		result = this->_lstBullEyeDetailRadio[nCrown]->GetValue();
	}
	return result;
}

//------------------------------------------------------------------------------------------------------------
double PanelBullEyeOptions::GetAngOfCrownSection(int nCrown,int section)
{
	double angle;
	if (this->_radioboxBullEyeGenOpt->GetSelection()==0)
	{ 
		angle = this->_sliderBullEyeAngle->GetValue();
	} else {
		angle = this->_lstBullEyeDetailAngle[nCrown]->GetValue();
	}
//	double numOfSec = (double)GetNumberOfSections(nCrown);
	double deltaSec = GetAngDeltaOfCrownSection(nCrown);
	return angle + section*deltaSec ;
}

//------------------------------------------------------------------------------------------------------------
double PanelBullEyeOptions::GetAngDeltaOfCrownSection(int nCrown)
{
	double numOfSec = (double)GetNumberOfSections(nCrown);
	return 360.0/numOfSec;
}

