/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "PerformingOperation.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file PerformingOperation.cxx */


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------------------------
// Generated events declaration and definition
//------------------------------------------------------------------------------------------------------------

//DEFINE_EVENT_TYPE( wxEVT_CONCEPT_RELEASE )


	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	PerformingOperation :: PerformingOperation()
	{
		_startCommand = '\0';
		_endCommand = '\0';
	}

	PerformingOperation :: ~PerformingOperation()
	{
		reset();
	}
		
	
	//------------------------------------------------------------------------------------------------------------
	//  Attributes PerformingOperation :: getters and PerformingOperation :: setters
	//------------------------------------------------------------------------------------------------------------

	void PerformingOperation :: setStartOperationInstantVector( std::vector<int> instantData )
	{
		for (int i =0; i< instantData.size(); i++)
		{
			_startOperationInstantVector.push_back( instantData[i] );
		}
	}
	//------------------------------------------------------------------------------------------------------------
	std::vector<int> PerformingOperation :: getStartOperationInstantVector( )
	{
		return _startOperationInstantVector;
	}
	//------------------------------------------------------------------------------------------------------------
	void PerformingOperation :: setEndOperationInstantVector( std::vector<int> instantData )
	{
		for (int i =0; i< instantData.size(); i++)
		{
			_endOperationInstantVector.push_back( instantData[i] );
		}		
	}
	//------------------------------------------------------------------------------------------------------------
	std::vector<int> PerformingOperation :: getEndOperationInstantVector( )
	{
		return _endOperationInstantVector;
	}
	//------------------------------------------------------------------------------------------------------------
	char PerformingOperation :: getStartCommand()
	{
		return _startCommand;
	}
	//------------------------------------------------------------------------------------------------------------
	void PerformingOperation :: setStartCommand( char theCommand )
	{
		_startCommand = theCommand;
	}
	//------------------------------------------------------------------------------------------------------------
	char PerformingOperation :: getEndCommand()
	{
		return _endCommand;
	}

	//------------------------------------------------------------------------------------------------------------
	void PerformingOperation :: setEndCommand( char theCommand )
	{
		_endCommand = theCommand;
	}

	//------------------------------------------------------------------------------------------------------------
	std::vector<std::string> PerformingOperation:: getKeyNamesOperationElems(  )
	{
		return _keyNamesOperationElems;
	}
	//------------------------------------------------------------------------------------------------------------
	void PerformingOperation:: setKeyNamesOperationElems( std::vector<std::string> dataVector)
	{
		_keyNamesOperationElems = dataVector;
	}

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	void PerformingOperation :: reset()
	{
		_startCommand = '\0';
		_endCommand = '\0';
		_startOperationInstantVector.clear();
		_endOperationInstantVector.clear();
		_keyNamesOperationElems.clear();
	}

	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

