/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "wxConceptControl.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file wxConceptControl.cxx */
//IMPLEMENT_CLASS(wxConceptControl, wxScrolledWindow)
//------------------------------------------------------------------------------------------------------------
// Generated events declaration and definition
//------------------------------------------------------------------------------------------------------------


DEFINE_EVENT_TYPE( wxEVT_CONCEPT_RELEASE )

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	
	wxConceptControl :: wxConceptControl(wxWindow *parent, bool orientation, int minV, int maxV,  int actualV, std::string &aConceptName, std::string elementsDef )
	:wxPanel(parent, -1, wxDefaultPosition, parent->GetSize(), wxTAB_TRAVERSAL)
	{

		minValue = minV;
		maxValue = maxV;
		_numCheckBox = 0;
		
		showLabels = true;

		wxFlexGridSizer* sizer = new wxFlexGridSizer (1, 3, 15, 15);

		conceptName = new wxStaticText(this, -1, wxString(aConceptName.c_str(),wxConvUTF8), wxDefaultPosition, wxSize(90,20), wxALIGN_CENTRE );		
		sizer->Add( conceptName, 0, wxALIGN_CENTRE |wxALIGN_CENTER_HORIZONTAL);
		
		if(orientation)
		{
			sizer->AddGrowableCol(1);
			conceptSlider = new wxSlider(this, -1, actualV, minV, maxV, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL| wxSL_AUTOTICKS | wxSL_LABELS, wxDefaultValidator, wxString(aConceptName.c_str(),wxConvUTF8));			
		}
		else
		{			
			sizer->AddGrowableRow(1);
			conceptSlider = new wxSlider(this, -1, actualV, minV, maxV, wxDefaultPosition, wxDefaultSize, wxSL_LEFT| wxSL_AUTOTICKS | wxSL_LABELS, wxDefaultValidator, wxString(aConceptName.c_str(),wxConvUTF8) );			
		}
		sizer->Add(conceptSlider, 0, wxGROW |wxALL );		
		createElements( sizer, elementsDef );
		SetSizer( sizer );

		Connect( conceptSlider->GetId(), wxEVT_SCROLL_THUMBTRACK, wxScrollEventHandler(wxConceptControl::onSliderTrack));//(wxObjectEventFunction) &wxConceptControl :: onSliderRelease ); 
		Connect( conceptSlider->GetId(),  wxEVT_SCROLL_THUMBRELEASE, wxScrollEventHandler(wxConceptControl::onSliderRelease));//(wxObjectEventFunction) &wxConceptControl :: onSliderTrack );     

		this->SetAutoLayout( true );
		this->Layout();	
	}

	wxConceptControl :: ~wxConceptControl()
	{

	}

	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events
	//------------------------------------------------------------------------------------------------------------
	

	void wxConceptControl ::onUpdateUICheckBox( wxCommandEvent& event )
	{
		lastUpdate = (wxCheckBox * ) event.GetEventObject();
		std::string groupId = std::string(lastUpdate->GetName().ToAscii());
		event.SetClientData( (void *) atoi(groupId.c_str()) );
		event.SetId( GetId() );
		event.SetEventObject( this );
		GetEventHandler()->ProcessEvent( event );
	}
	//------------------------------------------------------------------------------------------------------------
	void wxConceptControl :: onSliderTrack( wxScrollEvent& event )
	{
		
	}
  
	//------------------------------------------------------------------------------------------------------------

	void wxConceptControl :: onSliderRelease( wxScrollEvent& event )
	{
	//	if( !resolutionChange )
		sendEnvent( wxEVT_CONCEPT_RELEASE );		
	}

	
	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------

	void wxConceptControl :: sendEnvent(WXTYPE theEventType)
	{
		wxCommandEvent cevent( theEventType, GetId() );
		cevent.SetEventObject( this );
		GetEventHandler()->ProcessEvent( cevent );
	}

	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------

	std::string wxConceptControl :: getName()
	{
		return std::string(conceptName->GetLabel().ToAscii());  //wxString to std::string convertor ?
	}

	int wxConceptControl :: getMinShowedValue()
	{
		return conceptSlider->GetMin();
	}

	int wxConceptControl :: getMaxShowedValue()
	{
		return conceptSlider->GetMax();
	}

	void wxConceptControl :: setMinValue(int theMin)
	{
		minValue = theMin;
	}

	int  wxConceptControl :: getMinValue()
	{
		return minValue;
	}

	void wxConceptControl :: setMaxValue(int theMax)
	{
		maxValue = theMax;
	}

	int  wxConceptControl :: getMaxValue()
	{
		return maxValue;
	}

	void wxConceptControl :: setActualValue(int theActual)
	{
		conceptSlider->SetValue(theActual);
	}

	int  wxConceptControl :: getActualValue()
	{
		return conceptSlider->GetValue();
	}

	void wxConceptControl :: setShowLables(bool ifShowCondition)
	{
		showLabels = ifShowCondition;
		//TODO -----UPDATE the slider too!!
	}

	

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	void wxConceptControl :: clearCheckAt( int position )
	{
		checkBoxes[position]->SetValue( false );
	}
	//------------------------------------------------------------------------------------------------------------
	bool wxConceptControl :: getIfChecked( int position )
	{
		return checkBoxes[position]->GetValue();
	}
	//------------------------------------------------------------------------------------------------------------
	void wxConceptControl :: setRange(int minShow, int maxShow)
	{
		/*
		if( minShow < minVal )
			minShow = minVal;
		if( maxShow > maxVal )
			maxShow = maxVal;
		*/
		conceptSlider->SetRange(minShow, maxShow);
		int actual = getActualValue();
		if( actual<minShow )
			conceptSlider->SetValue( minShow );
		else if( actual>maxShow )
			conceptSlider->SetValue( maxShow );		
	}
	//------------------------------------------------------------------------------------------------------------
	void wxConceptControl :: reset()
	{
		conceptSlider->SetRange(minValue, maxValue);
		conceptSlider->SetValue(minValue);
		int i, size = checkBoxes.size();
		for(i=0; i<size; i++)
		{
			(checkBoxes[i])->SetValue( false );
		}
		size = textBoxes.size();
		for ( i =0; i<size; i++)
		{
			textBoxes[i]->Clear();
		}
	}

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------
	void wxConceptControl :: createElements(wxSizer *sizer , std::string elementsDef )
	{
		const char * elements = elementsDef.c_str();
		int elementsNum = elementsDef.size();
		wxFlexGridSizer* checkSizer = new wxFlexGridSizer (1, elementsNum, 5, 5);
		int i,ckecks = 0;
		for( i = 0;*elements!= 0; elements++)
		{			
			char a = *elements;	
			if( a == 67 || a == 99 )// Including C:67 or c:99 as a checkBox (ASCII)
			{
				/*if(ckecks==0){
					createCheckBoxAndAddToSizer( checkSizer, "X", -1, ckecks);
				}else{
					createCheckBoxAndAddToSizer( checkSizer, "Y", -1, ckecks);
				}*/
				createCheckBoxAndAddToSizer( checkSizer, "X", -1, ckecks);
				ckecks++;
			}
			else if ( a == 84 || a==116 )// Including T:84 or t t:116 as textCtrl (ASCII)
			{

			}
			i++;
		}
		_numCheckBox = ckecks;
		sizer->Add(checkSizer, 0, wxGROW |wxALL );	
	}

	int wxConceptControl :: getNumCheckBox(){
		return _numCheckBox;
	}

	//------------------------------------------------------------------------------------------------------------
	wxCheckBox * wxConceptControl :: createCheckBoxAndAddToSizer(wxSizer *sizer, std::string label, wxWindowID id,int groupID)
	{
		//char buffer[33];
		//itoa( groupID, buffer, 10);

		std::string buffer;
		
		if(groupID == 0){
			buffer = "0";
		}else{
			int k=groupID;
			while (k > 0){
				char temp = k % 10 + 48;
				k = k / 10;
				buffer = temp + buffer;	
			}
		}

		//wxCheckBox *checkbox = new wxCheckBox( this, -1, wxString(  label.c_str(), wxConvUTF8), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, wxString( buffer, wxConvUTF8) );
		wxCheckBox *checkbox = new wxCheckBox( this, -1, wxString(  label.c_str(), wxConvUTF8), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, wxString( buffer.c_str(), wxConvUTF8) );
		sizer->Add(checkbox, 0, wxLEFT | wxRIGHT, 5);
		sizer->Add(0, 2, 0, wxGROW); 
		checkBoxes.push_back( checkbox );
		Connect( checkbox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) (wxCommandEventFunction) &wxConceptControl::onUpdateUICheckBox );

		return checkbox;		
	}

	//------------------------------------------------------------------------------------------------------------
	/*wxCheckBox * wxConceptControl :: createCheckBoxAndAddToSizer(wxSizer *sizer, std::string label, wxWindowID id,int groupID)
	{
		wxCheckBox *checkbox = new wxCheckBox(this, -1, wxString(  label.c_str(), wxConvUTF8));
		sizer->Add(checkbox, 0, wxLEFT | wxRIGHT, 5);
		sizer->Add(0, 2, 0, wxGROW); 		
		return checkbox;		
	}*/
	
   
