/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "wxContourMainFrame.h"



//----------------------------------------------------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------------------------------------------------


#include "NameWrapper.h"
#include "wx/artprov.h"
#include "ConceptDataWrap.h"
#include <creaWx.h>

#include <string>
using namespace std;

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file wxContourMainFrame.cxx */

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

wxContourMainFrame* wxContourMainFrame:: instance = NULL;
char wxContourMainFrame::COPY = 'C';

	wxContourMainFrame :: wxContourMainFrame(wxWindow* parent, wxWindowID id,const wxString& title,const wxPoint& pos,const wxSize& size,long style)
		//: wxPanel(parent, id, title, pos, size, style)
		//: wxWindow(parent, id, pos, size, style)
		: wxPanel(parent, id, pos, size, style)
	{
		m_mgr.SetManagedWindow(this);
		_contourGroup				= 1;
		_creatingContoursActive		= false;
		_theViewPanel				= NULL;
//		_modelManager				= NULL;
		_instantPanel				= NULL;
//		_buttonsBar					= NULL;
//		_gridPanel					= NULL;
//		_drawToolsPanel				= NULL;
//		_operationsToolsPanel		= NULL;
		//_autoFormsPanel				= NULL;
//		_standardToolsPanel			= NULL;
//		_editionToolsPanel			= NULL;
//		_listViewPanel				= NULL;
//		_sceneManager				= NULL;
		//_actualInstant				= NULL;
		_numberOfVariablesStatistics = 6+1;

		_refLineControl				= NULL;
		_refLineModel				= NULL;
		_refLineView				= NULL;
//		_actorPresent				= false;

		// set up default notebook style
//		m_notebook_style =wxAUI_NB_TAB_SPLIT | wxAUI_NB_TAB_EXTERNAL_MOVE | wxNO_BORDER;
//		m_notebook_theme = 0;
		//wxContour_ActionCommandsID a;

		_contourextractdata			= NULL;
		_viewMaskImage				= NULL;
		_viewMaskImagePanel			= NULL;
		_viewThresholdImage			= NULL;
		_viewThresholdImagePanel		= NULL;
		_viewColorLayerImagePanel		= NULL;
	}

	wxContourMainFrame :: wxContourMainFrame(wxWindow* parent, wxWindowID id,const wxString& title,const wxPoint& pos,const wxSize& size,std::vector<vtkImageData*> images, long style,std::string datadir)
		: wxPanel(parent, id, pos, size, style)
	{
		m_mgr.SetManagedWindow(this);
		_contourGroup				= 1;
		_creatingContoursActive		= false;
		_theViewPanel				= NULL;

		_instantPanel				= NULL;
		_refLineControl				= NULL;
		_refLineModel				= NULL;
		_refLineView				= NULL;
//		_actorPresent				= false;
		_viewMaskImage				= NULL;
		_viewMaskImagePanel			= NULL;
		_viewThresholdImage			= NULL;
		_viewThresholdImagePanel		= NULL;
		_viewColorLayerImagePanel		= NULL;

		// set up default notebook style
		m_notebook_style =wxAUI_NB_TAB_SPLIT | wxAUI_NB_TAB_EXTERNAL_MOVE | wxNO_BORDER;
		m_notebook_theme = 0;
		//wxContour_ActionCommandsID a;
		_numberOfVariablesStatistics = 7;

		_datadir = datadir;


		inredo = 0;
		inundo = 0;

		_pannew = interfMainPanel::getInstance(this,datadir+"/data/Icons");//, eventHandler);
		_performingOperation = new PerformingOperation();

		if(images.size() > 0)
		{
			this->setVectImages(images);
		}

		_contourextractdata			= NULL;
}

void wxContourMainFrame::setVectImages(std::vector<vtkImageData*> imgs)
{

	_images = imgs;

	#if defined(__GNUC__)
		std::string str_home(getenv("HOME"));
	#elif defined(_WIN32)
			std::string str_home(getenv("USERPROFILE"));
	#endif
		std::string strCreaContourDataTmp = str_home + "/.creaContourDataTemp/";

	std::vector<std::string> conceptNameVect;
	std::vector<int> conceptSizeVect;

	notebook = this->createNotebook();


	kernelManager = new KernelManagerContour( imgs , _datadir+"/data/" , strCreaContourDataTmp );


	_instantPanel				= new wxInstantChooserPanel( notebook, "Instant Chooser", true, false, "c" );
	_theViewPanel				= new wxContourViewPanel( kernelManager->getSourceImage(), notebook );

//-------------------------------------------------------------
	kernelManager->getConceptsInformation(conceptNameVect, conceptSizeVect);
	_instantPanel->addConcepts(conceptNameVect, conceptSizeVect);


	double val = _theViewPanel->getCurrentDeep();
	_instantPanel->setConceptValue( "Axe Depth", (int)val );
	//JCP _instantPanel->setConceptValue("time", num de imagenes);
	ConceptDataWrap * data = _instantPanel->getConceptDataOf( "Axe Depth" );
	//*******************changeInstant();
	_theViewPanel->setVerticalConcept( "Axe Depth", data->getMinValue(), data->getMaxValue(), data->getMinShowedValue(),  data->getMaxShowedValue(), data->getActualValue() );

	this->configurePanels( );

}


	wxContourMainFrame* wxContourMainFrame :: getInstance(wxWindow* parent, wxWindowID id,const wxString& title,const wxPoint& pos,const wxSize& size,std::vector<vtkImageData*> images, long style,std::string datadir )
	{
		if(instance == NULL){
			instance = new wxContourMainFrame(parent, id, title, pos, size, images, style,datadir);
		}
		return instance;
	}

	std::vector<vtkImageData*> wxContourMainFrame ::getVectImages()
	{
		return kernelManager->getVectImages();
	}

	wxContourMainFrame* wxContourMainFrame :: getInstance()
	{
		return instance;
	}

	void wxContourMainFrame :: resetInstance()
	{
		instance->Destroy();
	}

	wxContourMainFrame :: ~wxContourMainFrame()
	{
		delete _contourextractdata;
		deleteAllContours();
		_pannew->Close();
		interfMainPanel::resetInstance();
		delete kernelManager;
		instance = NULL;
		//_pannew->Destroy();
		//delete _pannew;

		m_mgr.UnInit();
		//delete m_mgr;

		//El problema al cerrar la aplicacion puede estar asociado
		//a que  wxAUINotebook esta en la aplicacion
		//principal (wxContourGUIExample)tambien
		//EED????		delete _theViewPanel;
		//EED????		delete _instantPanel;
		//EED????		delete _buttonsBar;
		//EED????		delete _actualInstant;
		//EED????		delete _sceneManager;
	}


	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods using WxAui
	//------------------------------------------------------------------------------------------------------------
	//
	wxAuiNotebook * wxContourMainFrame :: createNotebook()
	{
		wxSize client_size = GetClientSize();
		wxAuiNotebook* noteBook = new wxAuiNotebook(this, -1, wxPoint(client_size.x, client_size.y), wxSize(430,200), m_notebook_style);
		wxBitmap page_bmp = wxArtProvider::GetBitmap(wxART_NORMAL_FILE, wxART_OTHER, wxSize(16,16));
		return noteBook;
	}


	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------
	bool wxContourMainFrame :: configurePanels( )
	{
		bool configured = _theViewPanel!=NULL;

		configured &= _theViewPanel!=NULL;
		if( _theViewPanel!=NULL )
		{
			notebook->AddPage( _theViewPanel, wxT("       View       ") );
			m_mgr.Update();
		}


		if( configured )
		{
			notebook->AddPage( _instantPanel, wxT("Instant Page") );
			m_mgr.Update();
		}

		m_mgr.AddPane(notebook, wxAuiPaneInfo().Name(wxT("notebook_content")).CenterPane().PaneBorder(false));
		m_mgr.Update();

		SetMinSize(wxSize(300,300));
		m_mgr.Update();
		return configured;
	}


	bool wxContourMainFrame::addNewPanel(wxPanel* panel)
		{
		bool configured = panel!=NULL;
		configured &= panel!=NULL;

		if( configured )
		{
			notebook->AddPage( panel, wxT("       Viewer       "), true );
			m_mgr.Update();
		}
		return configured;
	}

	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------



	void wxContourMainFrame :: setInstantChooserPanel(  wxInstantChooserPanel * theInstantChooserPanel )
	{
		_instantPanel = theInstantChooserPanel;
	}

//	void wxContourMainFrame :: setButtonsBar(  wxContour_ButtonsBar * theButtonsBar )
//	{
//		_buttonsBar = theButtonsBar;
//	}

//	void wxContourMainFrame :: setGrid(  wxContour_Grid * theGridPanel )
//	{
//		_gridPanel = theGridPanel;
//	}

//	void wxContourMainFrame :: setDrawToolsPanel(  wxContour_DrawToolsPanel * theDrawToolsPanel )
//	{
//		_drawToolsPanel = theDrawToolsPanel;
//	}

//	void wxContourMainFrame :: setOperationsToolsPanel(  wxContour_OperationsToolsPanel * theOperationsToolsPanel )
//	{
//		_operationsToolsPanel = theOperationsToolsPanel;
//	}

//	void wxContourMainFrame :: setAutomaticFormsPanel(  wxContour_AutomaticFormsToolsPanel * theAutoFormsPanel )
//	{
//		_autoFormsPanel = theAutoFormsPanel;
//	}

//	void wxContourMainFrame :: setStandardToolsPanel(  wxContour_StandardToolsPanel * theStandardToolsPanel )
//	{
//		_standardToolsPanel= theStandardToolsPanel;
//	}

//	void wxContourMainFrame :: setEditionToolsPanel(  wxContour_EdtionToolsPanel * theEditionToolsPanel )
//	{
//		_editionToolsPanel =  theEditionToolsPanel;
//	}

//	void wxContourMainFrame :: setListViewPanel(  wxContour_ListViewPanel * theListViewPanel )
//	{
//		_listViewPanel = theListViewPanel;
//	}



void wxContourMainFrame::onCreateContourSpline( ){

	//JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation
	createContour( 1 );

}
void wxContourMainFrame::onCreateContourRectangle( ){
    //JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation
	createContour( 2 );
}
void wxContourMainFrame::onCreateContourCircle( ){
    //JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation
	createContour( 3 );
}

void wxContourMainFrame::onCreateContourLine( ){
    //JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation
	createContour( 6 );
}

// RaC 09-09 --------------------------------------
void wxContourMainFrame::onCreateContourPoints( ){
    //JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation
	createContour( 7 );
}
// RaC 09-09 --------------------------------------

// RaC 10-09 --------------------------------------
void wxContourMainFrame::onCreateContourPolygon( ){
    //JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation
	createContour( 10 );
}
// RaC 10-09 --------------------------------------

//------------------------------------------------------------------------------------------------------------

void wxContourMainFrame :: onCreateContourBullEye(wxPanel* panel )
{
	//Creating the manualBaseModel and including in the model
	manualBaseModel * manModelContour = factoryManualContourModel(panel );

	std::vector<int> instantVector;
	_instantPanel->getInstant( instantVector );
	std::string theName = kernelManager->createOutline(manModelContour, instantVector);

	/*std::vector<int> instantVector;
	_instantPanel->getInstant( instantVector );
	std::string theName;
	theName= _modelManager->createOutline( manModelContour, instantVector );*/
	bool addedModel = theName.compare("") != 0;//??

	if( addedModel )
	{
		double spc[3];//Si no hay imagen pero hay contornos que spacing se pone por default
		_theViewPanel->getSpacing(spc);
		//Adding the manualContourControler to interface objects structure
		//Adding the manualViewContour to interface objects structure
		//_theViewPanel->getSceneManager()->setControlActiveStateOfALL( false );//This call is being done here because if the ROI is created underneath the previously created ROIS will still be active.
		_theViewPanel->getSceneManager()->configureViewControlTo( theName, manModelContour,spc , 4) ;
	}
}
void wxContourMainFrame :: createContour( int typeContour )
{
	//Creating the manualContourModel and including in the model
	manualBaseModel * manModelContour = kernelManager->factoryManualContourModel(typeContour);

	std::vector<int> instantVector;
	_instantPanel->getInstant( instantVector );
	std::string theName = kernelManager->createOutline(manModelContour, instantVector);

	/*std::vector<int> instantVector;
	_instantPanel->getInstant( instantVector );
	std::string theName;
	theName= _modelManager->createOutline( manModelContour, instantVector );*/
	bool addedModel = theName.compare("") != 0;//??
	if( addedModel )
	{
		double spc[3];//Si no hay imagen pero hay contornos que spacing se pone por default
		_theViewPanel->getSpacing(spc);
		//Adding the manualContourControler to interface objects structure
		//Adding the manualViewContour to interface objects structure
		//_sceneManager->setControlActiveStateOfALL( false );//This call is being done here because if the ROI is created underneath the previously created ROIS will still be active.
		_theViewPanel->getSceneManager()->configureViewControlTo( theName, manModelContour,spc , typeContour) ;
	}

}
manualBaseModel * wxContourMainFrame::factoryManualContourModel(wxPanel* panel){

	manualContourModelBullEye *manModelContourBullEye = new manualContourModelBullEye();
	manualBaseModel *manModelContour=NULL;
	manModelContour = manModelContourBullEye;
	if (panel!=NULL){
		int iCrown,sizeCrowns,iSector,sizeSectors;
		double radioA,radioB,ang,angDelta ;
		sizeCrowns = ((PanelBullEyeOptions*)panel)->GetNumberOfCrowns();
		for ( iCrown=0 ; iCrown<sizeCrowns ; iCrown++ )
		{
			sizeSectors = ((PanelBullEyeOptions*)panel)->GetNumberOfSections(iCrown);
			radioB	= ((PanelBullEyeOptions*)panel)->GetRadioOfCrown(iCrown);
			if (iCrown==sizeCrowns-1)
			{
				radioA	= 0;
			} else {
				radioA	= ((PanelBullEyeOptions*)panel)->GetRadioOfCrown(iCrown+1);
			}
			radioA=radioA/100.0;
			radioB=radioB/100.0;
			for ( iSector=0 ; iSector<sizeSectors  ; iSector++ )
			{
				ang		= ((PanelBullEyeOptions*)panel)->GetAngOfCrownSection(iCrown,iSector);
				angDelta= ((PanelBullEyeOptions*)panel)->GetAngDeltaOfCrownSection(iCrown);
				manModelContourBullEye->AddSector(radioA,radioB,ang,angDelta);
			} // for iSector
		} // for iCrown
	} // if _panelBullEyeOptions

	return manModelContour;
}
void wxContourMainFrame :: saveState(){

	std::string temp = kernelManager->saveState();
	saveFileWithContours(temp);
}

void wxContourMainFrame::onDeleteContour(){
	//JCP 20-10-08 Undo redo implementation
		saveState();
		//JCP 20-10-08 Undo redo implementation

		std::vector<std::string> lstKeyNameToBeErase;
		lstKeyNameToBeErase		= _theViewPanel->getSceneManager()->getSelectedObjects();
		deleteContours( lstKeyNameToBeErase );
/*JCP 19 - 11 - 08
		int i,size=_sceneManager->getSelectedObjects().size();
		for(i=0;i<size;i++)
		{
			std::string keyName		= _sceneManager->getSelectedObjects()[i];
			int ispartofstaticlist	= this->_modelManager->IsPartOfStaticList( keyName );
			if ( ispartofstaticlist>=0 )
			{
				std::vector<int> tempVector;
				_instantPanel->getInstant( tempVector );
				Instant instant(&tempVector);
				this->_modelManager->ChangeContourOfList(keyName, &instant);
			}
		}

		std::vector<std::string> lstKeyName;
		std::vector<std::string> lstKeyNameActualSlice;
		std::vector<std::string> lstKeyNameToBeErase;

		lstKeyNameToBeErase		= _sceneManager->getSelectedObjects();
		lstKeyNameActualSlice	= _sceneManager->GetlstContoursNameActualSlice();
		int k,kSize=lstKeyNameToBeErase.size();
		int j,jSize=lstKeyNameActualSlice.size();
		bool ok;
		for (k=0;k<kSize; k++)
		{
			ok=false;
			for (j=0;j<jSize; j++)
			{
				if (lstKeyNameToBeErase[k]==lstKeyNameActualSlice[j])
				{
					ok=true;
				}
			} // for j
			if (ok==true)
			{
				lstKeyName.push_back( lstKeyNameToBeErase[k] );
			} // if ok
		} // for k

		deleteContours( lstKeyName );
JCP 19 - 11 - 08*/
}

void wxContourMainFrame :: deleteContours( std::vector<std::string>  keyNamesVector )
{
	int i,size=keyNamesVector.size();
	for (i=0;i<size;i++)
	{
		deleteContour( keyNamesVector[i] );
	}
}

void wxContourMainFrame :: deleteContour( std::string theKeyName ){
	/*
	manualContourModel			* cModel;
	manualViewBaseContour		* cViewer;
	manualContourBaseControler	* cControler;

	ContourWrap_ViewControl *conwrapviewControl =  _theViewPanel->getSceneManager()->getContourWrap_ViewControlOf( theKeyName );
	cControler	= conwrapviewControl->getControler();*/

	//JCP 21 - 11 - 2008
	bool isedit = _theViewPanel->isEditableCControler(theKeyName);
	bool ispartofstaticlst = kernelManager->IsPartOfStaticList(theKeyName);

	if (isedit  && ispartofstaticlst)
	{
		_theViewPanel->removeFromScene(theKeyName);

		kernelManager->deleteCModel(theKeyName);
		//_theViewPanel->getSceneManager()->removeFromScene( theKeyName );
		//cViewer		= conwrapviewControl->getViewer();
		//_theViewPanel->getSceneManager()->removeWrap( theKeyName );
		//cControler* conwrapviewControl->getControler();
	//	delete cModel;
	//	delete cViewer;
	//	delete cControler;
	} // if editable
//JCP 21 - 11 - 08
}

void wxContourMainFrame::onDeleteContoursActSlice(){
	//JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation
	deleteContours( (std::vector<std::string>)_theViewPanel->getSceneManager()->GetlstContoursNameActualSlice() );
}
void wxContourMainFrame::onDeleteAllContours(){
	//JCP 20-10-08 Undo redo implementation
	saveState();
	deleteAllContours();
}
void wxContourMainFrame::deleteAllContours(){
	//JCP 20-10-08 Undo redo implementation

	wxBusyCursor wait;
	std::vector<int> tempVector;
	_instantPanel->getInstant( tempVector );

//JCP --08-09-2008 When using a diferent interface the _mbarrangeDeleteAll might not be initialize
//		the values in GetStart and GetEnd will then not be initialize also.
//		We use instead the values given when initializing the _deletepanel.

	//int minZ = _mbarrangeDeleteAll->GetStart();
	//int maxZ = _mbarrangeDeleteAll->GetEnd();
	int minZ, maxZ;

	minZ = 0;
	maxZ = _theViewPanel->getSceneManager()->GetImageDataSizeZ();

//JCP --08-09-2008

	_theViewPanel->getSceneManager()->removeSceneContours( );
	_theViewPanel->getSceneManager()->removeAllOutlines();
	kernelManager->removeAllOutlines();
//JCP --08-09-2008
	/*
	if ( (minZ==0) && (maxZ==_mbarrangeDeleteAll->GetMax() ))
	{
		_theViewPanel->getSceneManager()->removeSceneContours( );
		_modelManager->removeAllOutlines();
		_theViewPanel->getSceneManager()->removeAllOutlines();

	} else {
		for ( z=minZ ; z<=maxZ ; z++)
		{
			tempVector[1]=z;
			Instant instant(&tempVector);
			std::vector<ContourThing**> lstContourThings = this->_modelManager->getOutlinesAtInstant( &instant );

			sizeLstContourThings = lstContourThings.size();
			for (ii=0 ; ii<sizeLstContourThings ; ii++)
			{
				ContourThing **contourthing = lstContourThings[ii];
				deleteContour( (*contourthing)->getName() );
			} //for ii
		}// for z
	} // if
JCP --08-09-2008 */
}

void wxContourMainFrame::setConceptValue( std::string name, int value ){
	_instantPanel->setConceptValue(name, value);
}


ConceptDataWrap* wxContourMainFrame::getLastConceptData(){
	return _instantPanel->getLastConceptData();
}


bool wxContourMainFrame::getIfConceptCheckedAt( std::string name, int pos ){
	return _instantPanel->getIfConceptCheckedAt( name, pos );
}



void wxContourMainFrame::ShowResultImages(int typeContourGroup, int selection, int minZ, int maxZ)
{
	vtkImageData * mask;
	vtkImageData * value;
	this->getMaskValue(&mask, &value, typeContourGroup, selection, minZ, maxZ);

	std::vector<int> nTypeView;
	nTypeView.push_back(5);
	nTypeView.push_back(1);
	nTypeView.push_back(2);
	nTypeView.push_back(0);

	wxFrame *frame = new wxFrame(this, -1,_T("Result image extracted.."),wxDefaultPosition,wxSize(600,600), wxDEFAULT_FRAME_STYLE|wxSTAY_ON_TOP);
	wxAuiManager *m_mgr_noteBookViewerResult = new wxAuiManager();
	m_mgr_noteBookViewerResult->SetManagedWindow(frame);

	wxAuiNotebook* noteBookViewerResult = new wxAuiNotebook(frame, -1, wxPoint(600, 600), wxSize(430,200), m_notebook_style);
	m_mgr_noteBookViewerResult->AddPane(noteBookViewerResult, wxAuiPaneInfo().Name(wxT("notebook_content")).CenterPane().PaneBorder(false));

	wxPanel *panelViewer1 = new wxMaracas_N_ViewersWidget(noteBookViewerResult, value,&nTypeView);
	wxPanel *panelViewer2 = new wxMaracas_N_ViewersWidget(noteBookViewerResult, mask,&nTypeView);


	noteBookViewerResult->AddPage( panelViewer1, wxT("Image result") );
	noteBookViewerResult->AddPage( panelViewer2, wxT("Mask result") );
	m_mgr_noteBookViewerResult->Update();
	frame->Show();
}




void wxContourMainFrame::changeInstant()
{
		std::vector<int> instantVect;
		_instantPanel->getInstant( instantVect );
		int actualSlice = instantVect[1];

		kernelManager->setInstant(instantVect);

	    // Refresh Mask image
		if(_viewMaskImage!=NULL){
			_viewMaskImage->SetZ(actualSlice);
			if (_viewMaskImagePanel->IsVisible()==true)
			{
				vtkImageData *mask, *value;
				getMaskValue(&mask,&value, _contourGroup , 0, -1, -1);
				_viewMaskImage->onThreshold();
			}
		}

	// Refresh Threshold image
		if(_viewThresholdImage!=NULL){
			_viewThresholdImage->SetZ(actualSlice);
			if (_viewThresholdImagePanel->IsVisible()==true){
				_viewThresholdImage->onThreshold();
			}
		}


		updateInstantOutlines();
		updateInstantImageData();
		updateInstantAxes();
}



void wxContourMainFrame :: updateInstantOutlines()
{
	_theViewPanel->removeSceneContours();
	_theViewPanel->addNameWrapperToScene();

	//for( int i=0; i<size; i++)
	//{
	//	_theViewPanel->getSceneManager()->addToScene(namesWrapping[i]->getKeyName(), true, true, true, false, false );
	//}
}

int wxContourMainFrame::getNamesWrappingSize(){
	return kernelManager->getNamesWrappingSize();
}
std::string wxContourMainFrame::getNameWrapping(int i){
	return kernelManager->getNameWrapping(i);
}

void wxContourMainFrame::updateInstantImageData()
{
	std::vector<int> inst;
	_instantPanel->getInstant(inst);

	vtkImageData* img = kernelManager->getImageAtInstant(inst);
	if(img!=NULL){
		_theViewPanel->changeImage(img);
		showAxis(false);
	}else{
		int z = _instantPanel->getConceptDataOf("Axe Depth")->getActualValue();
		_theViewPanel->setImageSlice(z);
	}
}

void wxContourMainFrame::updateInstantAxes()
{
}


void wxContourMainFrame::onChangeDeep(int val){
	_instantPanel->setConceptValue( "Axe Depth", (int)val );
	changeInstant();
}


void wxContourMainFrame::onCopy(){
	std::vector<std::string> currentSelection = _theViewPanel->getSelectedObjects();

	std::vector<int> tempVector;
	_instantPanel->getInstant( tempVector );
    _performingOperation->reset();
	_performingOperation->setStartCommand( COPY );
	_performingOperation->setStartOperationInstantVector( tempVector );
	_performingOperation->setKeyNamesOperationElems( currentSelection );
}

void wxContourMainFrame::onPaste(){


	char theStartCommand = _performingOperation->getStartCommand();
	if (  theStartCommand == COPY )
	{
		//JCP 20-10-08 Undo redo implementation
		saveState();
		//JCP 20-10-08 Undo redo implementation
		std::vector<int> tempVector;
		_instantPanel->getInstant( tempVector );
		_performingOperation->setEndOperationInstantVector ( tempVector );
		std::vector<std::string> elems = _performingOperation->getKeyNamesOperationElems();
		int i,size = elems.size();
		for( i=0; i<size; i++ )
		{
			createCopyContourOf( elems[i], tempVector, i>0 );
		}
	}
}
void wxContourMainFrame::onUndo(){
	std::string filename;
	if(kernelManager->onUndoSaveFile(filename)){
		saveFileWithContours(filename);
	}
	if(kernelManager->onUndo(filename)){
		loadState(filename);
	}
}
void wxContourMainFrame::onRedo(){
	std::string filename;
	if(kernelManager->onRedo(filename)){
		loadState(filename);
	}

}
void wxContourMainFrame :: createCopyContourOf ( std::string anExistingKName, std::vector<int> &instantNoTouchData, bool append )
{
	std::string cloneName = kernelManager->createCopyContourOf( anExistingKName, instantNoTouchData );
	manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(cloneName);//_modelManager->getOutlineByKeyName( cloneName )->getModel();
	_theViewPanel->getSceneManager()->createCopyContourOf( anExistingKName, cloneName, manualModel , append );
}

///AD: 03-09	Copy the object and apply the given transformation
void wxContourMainFrame :: createMirrorContourOf ( std::string anExistingKName, std::vector<int> &instantNoTouchData, bool append )
{
	std::string cloneName = kernelManager->createCopyContourOf( anExistingKName, instantNoTouchData );
	manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(cloneName);

	manualPoint * refPoint1 = _refLineModel->GetManualPoint(0);
	manualPoint * refPoint2 = _refLineModel->GetManualPoint(1);

	double pnt1X = refPoint1->GetX();
	double pnt1Y = refPoint1->GetY();
//	double pnt1Z = refPoint1->GetZ();
	double pnt2X = refPoint2->GetX();
	double pnt2Y = refPoint2->GetY();
//	double pnt2Z = refPoint2->GetZ();

	double angle = (atan2(pnt2Y - pnt1Y, pnt2X - pnt1X) * 180 / 3.1415926535897932384626433832795)+90;
	vtkTransform *t = vtkTransform::New();

	t->PostMultiply();
	t->Identity();
	t->Translate(-pnt1X, -pnt1Y, 0);
	t->RotateZ(-angle);
	t->Scale(-1,1,1);
	t->RotateZ(angle);
	t->Translate(pnt1X, pnt1Y, 0);
	t->Update();

	int i,size=manualModel->GetSizeLstPoints();
	for (i=0;i<size;i++)
	{
		manualPoint * mp = manualModel->GetManualPoint(i);
		float vecIn[3];
		float vecOut[3];
		vecIn[0]=mp->GetX();
		vecIn[1]=mp->GetY();
		vecIn[2]=mp->GetZ();
		t->TransformPoint( vecIn, vecOut );
		mp->SetPointX( vecOut[0] );
		mp->SetPointY( vecOut[1] );
		mp->SetPointZ( vecOut[2] );
	}

	_theViewPanel->getSceneManager()->createCopyContourOf( anExistingKName, cloneName, manualModel , append );
}

//EED04
void wxContourMainFrame ::loadState(std::string filename){

	deleteAllContours();
	onLoadContours(filename,false);

	/* EED Borrame
	char tmp[255];
	FILE *pFile=fopen(filename.c_str(),"r+");

	fscanf(pFile,"%s",tmp); // --CreaContour--

	fscanf(pFile,"%s",tmp); // Version
	fscanf(pFile,"%s",tmp); // 1.0.3 || 1.0.2 || 1.0.1 || 1.0.0

	deleteAllContours();

	loadContours(pFile, false);
	loadContours(pFile, true);

	fclose(pFile);
	*/
}


//EED03
/*EED Borrame
void wxContourMainFrame::loadContours( FILE *pFile, bool staticContour )
{
	char tmp[255];

	if (staticContour==false)
	{
		fscanf(pFile,"%s",tmp); // ImageDimensions
		fscanf(pFile,"%s",tmp); // X
		fscanf(pFile,"%s",tmp); // Y
		fscanf(pFile,"%s",tmp); // Z

		fscanf(pFile,"%s",tmp); // ImageSpacing
		fscanf(pFile,"%s",tmp); // X
		fscanf(pFile,"%s",tmp); // Y
		fscanf(pFile,"%s",tmp); // Z
	}

	fscanf(pFile,"%s",tmp); // NumberOfContours
	fscanf(pFile,"%s",tmp); // ##
	int numberOfContours = atoi(tmp);

	std::vector<int> instantVector;
	int typeContourModel;
	manualBaseModel *manModelContour;
	int typeView;

	int i;
	for (i=0;i<numberOfContours;i++)
	{
		instantVector.clear();
		fscanf(pFile,"%s",tmp); // Instant
		fscanf(pFile,"%s",tmp); // 1
		instantVector.push_back( atoi(tmp) );
		fscanf(pFile,"%s",tmp); // 2
		instantVector.push_back( atoi(tmp) );
		fscanf(pFile,"%s",tmp); // 3
		instantVector.push_back( atoi(tmp) );
		fscanf(pFile,"%s",tmp); // 4
		instantVector.push_back( atoi(tmp) );
		fscanf(pFile,"%s",tmp); // 5
		instantVector.push_back( atoi(tmp) );
		fscanf(pFile,"%s",tmp); // 6
		instantVector.push_back( atoi(tmp) );

		fscanf(pFile,"%s",tmp); // TypeContourModel
		fscanf(pFile,"%s",tmp); // ##
		typeContourModel = atoi(tmp);

		manModelContour =  kernelManager->factoryManualContourModel(typeContourModel);
		manModelContour->Open(pFile);

		fscanf(pFile,"%s",tmp); // TypeView
		fscanf(pFile,"%s",tmp); // ##
		typeView = atoi(tmp);

		std::string theName;
		theName = kernelManager->createOutline( manModelContour, instantVector );
		bool addedModel = theName.compare("") != 0;
		if( addedModel )
		{
			double spc[3];//Si no hay imagen pero hay contornos que spacing se pone por default
			_theViewPanel->getSpacing(spc);
			//Adding the manualContourControler to interface objects structure
			//Adding the manualViewContour to interface objects structure
			//_theViewPanel->getSceneManager()->setControlActiveStateOfALL( false );//This call is being done here because if the ROI is created underneath the previously created ROIS will still be active.
			_theViewPanel->getSceneManager()->configureViewControlTo( theName, manModelContour,spc , typeView) ;
		}

		if (staticContour==true)
		{
			Instant instant(&instantVector);
			kernelManager->changeContourOfManager( theName , &instant );
		}
	}// for  numberOfContours
}
*/


void wxContourMainFrame::onLoad()
{
	std::string fileNameContourROI = GetFileLocation();
//CMRU 03-09-09-----------------------------------------------------------------------------------------------
	if(GetFileLocation().empty())
	{
//------------------------------------------------------------------------------------------------------------
		wxFileDialog dialog(NULL, _T("Choose a file"), _T(""), _T(""), _T("*.roi"), wxOPEN );
		if (dialog.ShowModal() == wxID_OK)
		{
			fileNameContourROI = (const char *)(dialog.GetPath().mb_str());
		}
	}

	onLoadContours(fileNameContourROI,true);
}


void  wxContourMainFrame::SetZForAllContours(int pz)
{
	printf("EED wxContourMainFrame::SetZForAllContours\n");

	//-- Normal Contours

	std::vector< std::string > lstNameThings;	
	int i,sizeLstNameThings;
	int ii,sizeLstPoints;
	
	lstNameThings		= kernelManager->GetLstNameThings();
	sizeLstNameThings	= lstNameThings.size();	
	for (i=0 ; i<sizeLstNameThings ; i++)
	{
printf("EED wxContourMainFrame::SetZForAllContours contour=%d \n", i );
		manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(lstNameThings[i]);
		sizeLstPoints = manualModel->GetSizeLstPoints();
		for (ii=0 ; ii<sizeLstPoints ; ii++)
		{
			 manualModel->GetManualPoint(ii)->SetPointZ(-900);
		}// for ii  list of points
	}// for i  list of Things

	//-- Static Contours

	lstNameThings		= kernelManager->GetLstNameThingsStatic();
	sizeLstNameThings	= lstNameThings.size();
	for (i=0 ; i<sizeLstNameThings ; i++)
	{
		manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(lstNameThings[i]);
		sizeLstPoints = manualModel->GetSizeLstPoints();
		for (ii=0 ; ii<sizeLstPoints ; ii++)
		{
			 manualModel->GetManualPoint(ii)->SetPointZ(-900);
		}// for ii  list of points
	}// for i  list of static things
}



void wxContourMainFrame::onLoadContours(std::string fileNameContourROI, bool interactiveInterface)
{
	char tmp[255];
	char tmpD[255];

	FILE *pFile =fopen(fileNameContourROI.c_str(),"r+");


//CMRU 03-09-09- ----------------------------------------------------------------------------------------------
	if(pFile != NULL)
	{
//------------------------------------------------------------------------------------------------------------
        fileNameContourROI.append("data");
		FILE *pFileData=fopen(fileNameContourROI.c_str(),"r+");
		if(pFileData != NULL)
		{
			fscanf(pFileData,"%s",tmpD); // --CreaContour--
			fscanf(pFileData,"%s",tmpD); // Version
			fscanf(pFileData,"%s",tmpD); // 1.0.3 || 1.0.2 || 1.0.1 || 1.0.0

			fscanf(pFileData,"%s",tmpD); //	onePixelSize
			fscanf(pFileData,"%s",tmpD); //	#
			_onePixelSize = atof(tmpD);
			fscanf(pFileData,"%s",tmpD); // NumberOfContours
			fscanf(pFileData,"%s",tmpD); // #
		}

		fscanf(pFile,"%s",tmp); // --CreaContour--

		fscanf(pFile,"%s",tmp); // Version
		fscanf(pFile,"%s",tmp); // 1.0.3 || 1.0.2 || 1.0.1 || 1.0.0
		std::string version(tmp);


printf("EED wxContourMainFrame::onLoadContours  version%s \n", version.c_str() );


		//AD:02-06-09
        _tmpReadFileTypeOfTransformation=-1;
		if (version=="1.0.3")
		{
		    readDimSpc(pFile,interactiveInterface);   // DimSpc interactive ON
			openContours(pFile,pFileData,false);
			openContours(pFile,pFileData,true);	//Load StaticContours
		}	

		if (version=="1.0.2")
		{
//EED001
			readDimSpc(pFile,interactiveInterface); // DimSpc interactive ON
 			openContours(pFile,pFileData,false);
			readDimSpc(pFile,false);  		// DimSpc interactive OFF
			openContours(pFile,pFileData,true);	// Load StaticContours
			SetZForAllContours(-900);
		}

		//AD:02-06-09
		else if (version=="1.0.1")
		{
			openContours(pFile,pFileData,false); //Skips ImageDimensions and ImageSpacing
			openContours(pFile,pFileData,true); //Load StaticContours, skips ImageDimensions and ImageSpacing
		}

		//AD:02-06-09
		else if (version=="1.0.0")
		{
			openContours(pFile,pFileData,false); //Skips ImageDimensions and ImageSpacing
		}

		fclose(pFile);

		if(pFileData != NULL)
		{
			fclose(pFileData);
		}
	}
	_theViewPanel->getSceneManager()->removeSceneContours();
	changeInstant();
}



void wxContourMainFrame::onImport(){
	std::string filename, filenamecontours;
	wxFileDialog dialog(NULL, _T("Choose a XML Osirix File"), _T(""), _T(""), _T("*.xml"), wxOPEN );

	if (dialog.ShowModal() == wxID_OK)
	{
		filename = dialog.GetPath().mb_str();
		filenamecontours = kernelManager->parseOsirixFile(filename);

		if(filenamecontours.compare("") != 0){
			onLoadContours(filenamecontours,true);
		}

	}
}
void wxContourMainFrame::onTest(){
	std::string filename, filenamecontours;
	wxFileDialog dialog(NULL, _T("Choose a File"), _T(""), _T(""), _T("*.*"), wxOPEN );

	if (dialog.ShowModal() == wxID_OK)
	{
		filename = dialog.GetPath().mb_str();
		std::cout << "This is the filename: " << filename << std::endl;
	}
}


//AD: 29-05-09
void wxContourMainFrame::onSave(){
//CMRU 03-09-09-----------------------------------------------------------------------------------------------
	if(GetFileLocation().empty())
	{
//------------------------------------------------------------------------------------------------------------
		wxFileDialog dialog(NULL, _T("Choose a file"), _T(""), _T(""), _T("*.roi"), wxSAVE );
		if (dialog.ShowModal() == wxID_OK)
		{
			std::string fileNameContourROI = (const char *)(dialog.GetPath().mb_str());
			kernelManager->setCurrentFileName(fileNameContourROI);
			saveFileWithContours( fileNameContourROI );
		}
	}
//CMRU 03-09-09-----------------------------------------------------------------------------------------------
	else
	{
		std::cout<<"Nombre del archivo: "<<GetFileLocation()<<std::endl;
		std::string fileNameContourROI = GetFileLocation();
		std::cout<<"Nombre del archivo: "<<fileNameContourROI<<std::endl;
		kernelManager->setCurrentFileName(fileNameContourROI);
		saveFileWithContours( fileNameContourROI);
	}
//------------------------------------------------------------------------------------------------------------
}

//AD: 29-05-09
void wxContourMainFrame::saveFileWithContours( std::string filename )
{

	FILE *pFile=fopen(filename.c_str(),"w+");

//CMRU 03-09-09-----------------------------------------------------------------------------------------------
	filename.append("data");
	std::cout<<"Nombre del archivo: "<<filename<<std::endl;
	FILE *pFileData=fopen(filename.c_str(),"w+");
//------------------------------------------------------------------------------------------------------------

	std::vector< std::string > lstNameThings;
	int i,sizeLstNameThings;

	fprintf(pFile,"--CreaContour--\n");
	fprintf(pFile,"Version %s\n", "1.0.3" );

//CMRU 03-09-09-----------------------------------------------------------------------------------------------
	fprintf(pFileData,"--CreaContour--\n");
	fprintf(pFileData,"Version %s\n", "1.0.3" );
	fprintf(pFileData,"OnePixelSize %f\n", _onePixelSize);

//------------------------------------------------------------------------------------------------------------

	vtkImageData *image = _images[0];

	int dimRange[3];
	image->GetDimensions(dimRange);

	fprintf(pFile,"ImageDimensions %d %d %d\n", dimRange[0], dimRange[1], dimRange[2] );

	double spaRange[3];
	image->GetSpacing(spaRange);

	fprintf(pFile,"ImageSpacing %f %f %f\n", spaRange[0], spaRange[1], spaRange[2] );

	// Normal Contours

	lstNameThings		= kernelManager->GetLstNameThings();
	sizeLstNameThings	= lstNameThings.size();
	fprintf(pFile,"NumberOfContours %d\n", sizeLstNameThings );

//CMRU 03-09-09-----------------------------------------------------------------------------------------------
	fprintf(pFileData,"NumberOfContours %d\n", sizeLstNameThings );
//------------------------------------------------------------------------------------------------------------

	for (i=0 ; i<sizeLstNameThings ; i++)
	{
//CMRU 03-09-09-----------------------------------------------------------------------------------------------
		manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(lstNameThings[i]);
		double sizeInPixel = manualModel ->GetPathSize();
		double realContourSize = sizeInPixel*_onePixelSize;
		manualModel ->SetRealSize(realContourSize);
//------------------------------------------------------------------------------------------------------------

	//int size= kernelManager->GetLstNameThings().size();

		kernelManager->SaveThingName( pFile, pFileData, lstNameThings[i] );
		_theViewPanel->getSceneManager()->SaveThingName( pFile, lstNameThings[i] );
	}// for i

	//-- Static Contours

//	fprintf(pFile,"ImageDimensions %d %d %d\n", dimRange[0], dimRange[1], dimRange[2] );
//	fprintf(pFile,"ImageSpacing %f %f %f\n", spaRange[0], spaRange[1], spaRange[2] );

	lstNameThings		= kernelManager->GetLstNameThingsStatic();
	sizeLstNameThings	= lstNameThings.size();
	fprintf(pFile,"NumberOfContoursStatic %d\n", sizeLstNameThings );

//CMRU 03-09-09-----------------------------------------------------------------------------------------------
	fprintf(pFileData,"NumberOfContoursStatic %d\n", sizeLstNameThings );
//------------------------------------------------------------------------------------------------------------

	for (i=0 ; i<sizeLstNameThings ; i++)
	{
		kernelManager->SaveThingName( pFile, pFileData, lstNameThings[i] );
		_theViewPanel->getSceneManager()->SaveThingName( pFile, lstNameThings[i] );
	}// for i
	fclose(pFile);
	fclose(pFileData);
}


//EED02
void wxContourMainFrame::readDimSpc(FILE *pFile, bool interactiveOption)
{
	char tmp[255];
	int             imageDim[3];
	double          imageSpac[3];
	vtkImageData    *image          = _images[0];
    image->GetDimensions(imageDim);
    image->GetSpacing(imageSpac);

    fscanf(pFile,"%s",tmp); // ImageDimensions
    fscanf(pFile,"%s",tmp); // X
    _tmpReadFileImageDim[0] = atoi(tmp);
    fscanf(pFile,"%s",tmp); // Y
    _tmpReadFileImageDim[1] = atoi(tmp);
    fscanf(pFile,"%s",tmp); // Z
    _tmpReadFileImageDim[2] = atoi(tmp);

    fscanf(pFile,"%s",tmp); // ImageSpacing
    fscanf(pFile,"%s",tmp); // X
    _tmpReadFileImageSpac[0] = atof(tmp);
    fscanf(pFile,"%s",tmp); // Y
    _tmpReadFileImageSpac[1] = atof(tmp);
    fscanf(pFile,"%s",tmp); // Z
    _tmpReadFileImageSpac[2] = atof(tmp);


	if (interactiveOption==true)
    {
		//Compare Spacing and Dims in X and Y (Necessary in Z?) - Just for Version 2
		if (imageDim[0]!=_tmpReadFileImageDim[0] || imageDim[1]!=_tmpReadFileImageDim[1] || imageSpac[0]!=_tmpReadFileImageSpac[0] || imageSpac[1]!=_tmpReadFileImageSpac[1])
		{
			wxDialog* dial = new wxDialog (this,-1,_T("Tools"),wxDefaultPosition, wxSize(460,360));
			wxSizer* buttonsSizer = dial->CreateSeparatedButtonSizer(wxOK|wxCANCEL);
			wxBoxSizer *dialSizer = new wxBoxSizer(wxVERTICAL);

			wxString lstOptOperation[2];
			lstOptOperation[0]=_T("By Dimension");
			lstOptOperation[1]=_T("By Spacing");
			wxRadioBox * radioOpts = new wxRadioBox(dial, -1, _T("Type of Transformation"), wxDefaultPosition, wxSize(270,45), 2 , lstOptOperation,  2, wxRA_SPECIFY_COLS);

			dialSizer->Add( new wxStaticText(dial,-1,_T("The image resolution is not compatible with the "))  , 0, wxGROW );
			dialSizer->Add( new wxStaticText(dial,-1,_T("selected Roi file. Do you want to tranform it?"))  , 0, wxGROW );
			dialSizer->Add( new wxStaticText(dial,-1,_T(" "))  , 0, wxGROW );
			dialSizer->Add(radioOpts,0,wxGROW);
			dialSizer->Add( new wxStaticText(dial,-1,_T(" "))  , 0, wxGROW );
			dialSizer->Add(buttonsSizer,0,wxGROW);
			dial->SetSizer(dialSizer, true);
			dial->Layout();
			dial->ShowModal();

			int _tmpReadFileTypeOfTransformation = -1;
//EED			bool transform = false;

			if (dial->GetReturnCode() == wxID_OK)
			{
				_tmpReadFileTypeOfTransformation    = radioOpts->GetSelection();
			}// if wxOK

		} // if dim spc
    } // if interactiveOption
}




//AD:04-06-09
void wxContourMainFrame::openContours( FILE *pFile, FILE *pFileData, bool staticContour )
{

	char tmp[255];

	vtkImageData    *image = _images[0];

	int             imageDim[3];
	double          imageSpac[3];
    image->GetDimensions(imageDim);
    image->GetSpacing(imageSpac);


	fscanf(pFile,"%s",tmp); // NumberOfContours
	fscanf(pFile,"%s",tmp); // ##
	int numberOfContours = atoi(tmp);

	std::vector<int> instantVector;
	int typeContourModel;
	manualBaseModel *manModelContour;
	int typeView;

/*
	if (compatible==true)
	{
		int i;
		for (i=0;i<numberOfContours;i++)
		{
			instantVector.clear();
			fscanf(pFile,"%s",tmp); // Instant

			fscanf(pFile,"%s",tmp); // 1
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 2
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 3
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 4
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 5
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 6
			instantVector.push_back( atoi(tmp) );


			fscanf(pFile,"%s",tmp); // TypeContourModel
			fscanf(pFile,"%s",tmp); // ##
			typeContourModel = atoi(tmp);

			manModelContour =  kernelManager->factoryManualContourModel(typeContourModel);
			manModelContour->Open(pFile);
			if(pFileData != NULL)
			{
				manModelContour->OpenData(pFileData);
			}

			fscanf(pFile,"%s",tmp); // TypeView
			fscanf(pFile,"%s",tmp); // ##
			typeView = atoi(tmp);

			std::string theName;
			theName = kernelManager->createOutline( manModelContour, instantVector );
			bool addedModel = theName.compare("") != 0;
			if( addedModel )
			{
				double spc[3];//Si no hay imagen pero hay contornos que spacing se pone por default
				_theViewPanel->getSpacing(spc);
				//Adding the manualContourControler to interface objects structure
				//Adding the manualViewContour to interface objects structure
				//_theViewPanel->getSceneManager()->setControlActiveStateOfALL( false );//This call is being done here because if the ROI is created underneath the previously created ROIS will still be active.
				_theViewPanel->getSceneManager()->configureViewControlTo( theName, manModelContour,spc , typeView) ;
			}

			if (staticContour) //StaticContours (will appear in all slices)
			{
				Instant instant(&instantVector);
				kernelManager->changeContourOfManager( theName , &instant );
			}

		}// for  numberOfContours
	}

	else if (compatible==false)
	{
*/

		int i;
		for (i=0;i<numberOfContours;i++)
		{
			instantVector.clear();
			fscanf(pFile,"%s",tmp); // Instant

			fscanf(pFile,"%s",tmp); // 1
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 2
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 3
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 4
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 5
			instantVector.push_back( atoi(tmp) );
			fscanf(pFile,"%s",tmp); // 6
			instantVector.push_back( atoi(tmp) );

			fscanf(pFile,"%s",tmp); // TypeContourModel
			fscanf(pFile,"%s",tmp); // ##
			typeContourModel = atoi(tmp);

			manModelContour =  kernelManager->factoryManualContourModel(typeContourModel);
			manModelContour->Open(pFile);
			if(pFileData != NULL)
			{
				manModelContour->OpenData(pFileData);
			}

            if (_tmpReadFileTypeOfTransformation==-1){
                //nothing to do..
            } else if (_tmpReadFileTypeOfTransformation==0){
                double transX, transY;
                transX = (double) imageDim[0]/_tmpReadFileImageDim[0];
                transY = (double) imageDim[1]/_tmpReadFileImageDim[1];
                manModelContour->Transform_Ax_Plus_B(transX,0,transY,0);
            } else if (_tmpReadFileTypeOfTransformation==1) {
                double transX, transY;
                transX = (double) _tmpReadFileImageSpac[0]/imageDim[0];
                transY = (double) _tmpReadFileImageSpac[1]/imageDim[1];
                manModelContour->Transform_Ax_Plus_B(transX,0,transY,0);
            }

			fscanf(pFile,"%s",tmp); // TypeView
			fscanf(pFile,"%s",tmp); // ##
			typeView = atoi(tmp);

			std::string theName;
			theName = kernelManager->createOutline( manModelContour, instantVector );
			bool addedModel = theName.compare("") != 0;
			if( addedModel )
			{
				double spc[3];//Si no hay imagen pero hay contornos que spacing se pone por default
				_theViewPanel->getSpacing(spc);
				//Adding the manualContourControler to interface objects structure
				//Adding the manualViewContour to interface objects structure
				//_theViewPanel->getSceneManager()->setControlActiveStateOfALL( false );//This call is being done here because if the ROI is created underneath the previously created ROIS will still be active.
				_theViewPanel->getSceneManager()->configureViewControlTo( theName, manModelContour,spc , typeView) ;
			}

			if (staticContour) //StaticContours (will appear in all slices)
			{
				Instant instant(&instantVector);
				kernelManager->changeContourOfManager( theName , &instant );
			}
		}// for  numberOfContours

/*	}    */

}

void wxContourMainFrame::RefreshInterface(){
	changeInstant();
	_theViewPanel->RefreshInterface();
	//wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)this->_theViewPanel->getWxVtkBaseView();
	//wxvtk2dbaseview->Refresh();
}

vtkImageData* wxContourMainFrame::getImageData(){
	return _theViewPanel->getImageData();
}

void wxContourMainFrame::onSegmentationOneSliceITK(wxString distance, wxString sigma, wxString alfa, wxString beta, wxString propagation, wxString iterations, wxString inflation)
{
	//JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation

	wxBusyCursor wait;
	int					x					= _theViewPanel->GetX();
	int					y					= _theViewPanel->GetY();
	int					z					= _theViewPanel->GetZ();
	SegmentationOneSliceITK( x,y,z,distance, sigma, alfa, beta, propagation, iterations, inflation);
	RefreshInterface();
}

void wxContourMainFrame::SegmentationOneSliceITK(int x, int y, int z, wxString distanc, wxString sigm, wxString alf, wxString bet, wxString prop, wxString iter, wxString inflation)
{
	int typeofcontour = 1;
	//Image Data
	vtkImageData	*imagedata	= getImageData();

	//Tipo de pixeles a utilizar internamente en ITK
	typedef   float  InternalPixelType;
	const     unsigned int    Dimension = 2;
	typedef itk::Image< InternalPixelType, Dimension >  InternalImageType;

	//Tipo de pixeles de salida 1
	typedef unsigned char OutputPixelType;
	typedef itk::Image< OutputPixelType, Dimension > OutputImageType;

	//Tipo de pixeles de salida 2
	typedef unsigned short OutputPixelType2;
	typedef itk::Image< OutputPixelType2, Dimension > OutputImageType2;

	//DefiniciÛn del thresholder
	typedef itk::BinaryThresholdImageFilter<
							InternalImageType,
							OutputImageType    >    ThresholdingFilterType;

	//DefiniciÛn del primer filtro de conversiÛn de pixeles
	typedef itk::CastImageFilter<
				OutputImageType, OutputImageType2 >  CastFilterType;

	//DefiniciÛn del segundo tipo de conversiÛn de pixeles
	typedef itk::CastImageFilter<
				OutputImageType2, InternalImageType >  CastFilterType2;

	//Tercer tipo de conversiÛn
	typedef itk::RescaleIntensityImageFilter<
								InternalImageType,
								OutputImageType >   CastFilterType3;

	//Cuarto tipo de conversiÛn
	typedef itk::RescaleIntensityImageFilter<
								OutputImageType,
								OutputImageType >   CastFilterType4;

	ThresholdingFilterType::Pointer thresholder = ThresholdingFilterType::New();

	thresholder->SetLowerThreshold( 0.0 );
	thresholder->SetUpperThreshold( 128 );

	thresholder->SetOutsideValue(  255  );
	thresholder->SetInsideValue(  0 );

	//DefinciÛn de conexiÛnes entre VTK e ITK y el writer
	typedef itk::VTKImageToImageFilter<OutputImageType2> ConnectorType;
	typedef itk::ImageToVTKImageFilter<OutputImageType> ConnectorType2;
//EED10JUIN2011	typedef  itk::ImageFileWriter<  OutputImageType  > WriterType;

	ConnectorType::Pointer connector= ConnectorType::New();
	ConnectorType2::Pointer connector2= ConnectorType2::New();


	CastFilterType::Pointer filter=CastFilterType::New();
	CastFilterType2::Pointer filter2=CastFilterType2::New();

	connector->SetInput( imagedata );
	filter2->SetInput(connector->GetOutput());

	typedef   itk::CurvatureAnisotropicDiffusionImageFilter<
								InternalImageType,
								InternalImageType >  SmoothingFilterType;

	SmoothingFilterType::Pointer smoothing = SmoothingFilterType::New();

	typedef   itk::GradientMagnitudeRecursiveGaussianImageFilter<
								InternalImageType,
								InternalImageType >  GradientFilterType;

	typedef   itk::SigmoidImageFilter<
								InternalImageType,
								InternalImageType >  SigmoidFilterType;

	GradientFilterType::Pointer  gradientMagnitude = GradientFilterType::New();

	SigmoidFilterType::Pointer sigmoid = SigmoidFilterType::New();

	sigmoid->SetOutputMinimum(  0.0  );
	sigmoid->SetOutputMaximum(  255.0  );


	typedef  itk::FastMarchingImageFilter<
								InternalImageType,
								InternalImageType >    FastMarchingFilterType;


	FastMarchingFilterType::Pointer  fastMarching = FastMarchingFilterType::New();
	
printf("EED wxContourMainFrame::SegmentationOneSliceITK  Skypping this code.  Not compiling   GeodesicActiveContourLevelSetImageFilter     in fedora 17 with ITK 3.20.1 \n ");
/*EED 17 sept 2010
 > - > - > - > - > - > - > - > - > - > - > - > - > - > - > - > -   Not compiling   GeodesicActiveContourLevelSetImageFilter     in fedora 17 with ITK 3.20.1
 
 
	typedef  itk::GeodesicActiveContourLevelSetImageFilter< InternalImageType,
					InternalImageType >    GeodesicActiveContourFilterType;
	GeodesicActiveContourFilterType::Pointer geodesicActiveContour =
										GeodesicActiveContourFilterType::New();

	typedef  itk::ZeroCrossingImageFilter<
								InternalImageType,
								InternalImageType >    ZeroCrossingFilterType;
	ZeroCrossingFilterType::Pointer zeroCrossing =
							ZeroCrossingFilterType::New();

	const double propagationScaling = atof( crea::wx2std(prop).c_str() );

	geodesicActiveContour->SetPropagationScaling( propagationScaling );
	geodesicActiveContour->SetCurvatureScaling( 1.0 );
	geodesicActiveContour->SetAdvectionScaling( 1.0 );

	geodesicActiveContour->SetMaximumRMSError( 0.02 );
	int it=atoi(  crea::wx2std(iter).c_str() );
	geodesicActiveContour->SetNumberOfIterations( it );

	smoothing->SetInput( filter2->GetOutput() );
	gradientMagnitude->SetInput( smoothing->GetOutput() );
	sigmoid->SetInput( gradientMagnitude->GetOutput() );
	fastMarching->SetInput( sigmoid->GetOutput() );
	geodesicActiveContour->SetInput( fastMarching->GetOutput() );
	geodesicActiveContour->SetFeatureImage( sigmoid->GetOutput() );

	zeroCrossing->SetInput( geodesicActiveContour->GetOutput() );
	//thresholder->SetInput( zeroCrossing->GetOutput() );
	thresholder->SetInput( geodesicActiveContour->GetOutput() );
	connector2->SetInput( thresholder->GetOutput()  );
 
< - < - < - < - < - < - < - < - < - < - < - < - < - < - < - < - < - < - < - < - 
*/
	
	
	

	smoothing->SetTimeStep( 0.125 );
	smoothing->SetNumberOfIterations(  5 );
	smoothing->SetConductanceParameter( 9.0 );


	const double sigma = atof(  crea::wx2std(sigm).c_str() );
	gradientMagnitude->SetSigma(  sigma  );

	const double alpha =  atof(  crea::wx2std(alf).c_str() );
	const double beta  =  atof(  crea::wx2std(bet).c_str() );

	sigmoid->SetAlpha( alpha );
	sigmoid->SetBeta(  beta  );

	typedef FastMarchingFilterType::NodeContainer  NodeContainer;
	typedef FastMarchingFilterType::NodeType       NodeType;

	NodeContainer::Pointer seeds = NodeContainer::New();

	InternalImageType::IndexType  seedPosition;
	seedPosition[0] = x;
	seedPosition[1] = y;

	const double initialDistance = atof( crea::wx2std(distanc).c_str() );

	NodeType node;

	const double seedValue = - initialDistance;

	node.SetValue( seedValue );
	node.SetIndex( seedPosition );

	seeds->Initialize();
	seeds->InsertElement( 0, node );

	fastMarching->SetTrialPoints( seeds );

	fastMarching->SetSpeedConstant( 1.0 );

	fastMarching->SetOutputSize(
			connector->GetOutput()->GetBufferedRegion().GetSize() );

	fastMarching->SetStoppingValue( 800 );
	try
    {

	connector2->Update();
	vtkImageData *idata = connector2->GetOutput();

	vtkMarchingContourFilter* cntVTK = vtkMarchingContourFilter::New( );

	cntVTK->SetInput( idata );

	cntVTK->SetNumberOfContours( 1 );
	cntVTK->SetValue( 0, 255 );
	cntVTK->Update( );
	cntVTK->UpdateInformation();

	vtkCleanPolyData* cpd = vtkCleanPolyData::New( );
	cpd->SetInput( cntVTK->GetOutput( ) );
	cpd->Update( );
	cpd->UpdateInformation();

	vtkPolyDataConnectivityFilter* conn = vtkPolyDataConnectivityFilter::New( );
	conn->SetExtractionModeToLargestRegion( );
	conn->SetInput( cpd->GetOutput( ) );
	conn->Update( );
	conn->UpdateInformation();

	vtkStripper* vtkstripper = vtkStripper::New( );
	vtkstripper->SetInput( conn->GetOutput() );
	vtkstripper->Update();
	vtkstripper->UpdateInformation();

	vtkPolyData* polyDataResult =  cntVTK->GetOutput();
	//std::cout<<"Points "<<polyDataResult->GetNumberOfPoints()<<std::endl;
	polyDataResult->Update( );
	polyDataResult->UpdateInformation();

	//EED
		/*
	ofstream myfile;
	myfile.open ("C:/Creatis/example.txt");
	myfile << "\n";
	polyDataResult->Print(myfile);
	myfile << "-------------------------------------\n";
	polyDataResult->GetLines()->Print(myfile);
	myfile.close();*/

	cntVTK		-> Delete();
	cpd			-> Delete();
	conn		-> Delete();


	//--Calculating control points

	std::vector<double> vecX;
	std::vector<double> vecY;
	std::vector<double> vecXo;
	std::vector<double> vecYo;
	std::vector<double>::iterator vecXoi;
	std::vector<double>::iterator vecYoi;
	std::vector<double> vecZ;

	std::vector<double> vecCtrlPointX;
	std::vector<double> vecCtrlPointY;
	std::vector<double> vecCtrlPointZ;


	double *p;
	double xAct=0;
	double yAct=0;
	int ii,size=polyDataResult->GetNumberOfPoints();
	ofstream myfile;
	myfile.open ("C:/Creatis/example2.txt");

	size=polyDataResult->GetNumberOfPoints();
	for (ii=0;ii<size;ii++)
	{
		if(ii==0)
		{
			xAct=x;
			yAct=y;
		}
		p	= polyDataResult->GetPoint(ii);
		double x=p[0];
		double y=p[1];
		/*if(fabs(yAct-y)>20)
		{
			if((xAct-x)>1 || (xAct-x)<-1)
			{
			vecX.push_back( p[0] );
			vecY.push_back( p[1] );
			myfile <<p[0]<<","<<p[1]<<"\n";
			std::cout<<" x Anterior "<<xAct<<" x actual "<<x<<std::endl;
		std::cout<<" y Anterior "<<yAct<<" y actual "<<y<<std::endl;
		std::cout<<" x "<<p[0]<<" y "<<p[1]<<std::endl;
			vecZ.push_back( 900 );
			xAct=x;
			yAct=y;
			}
			else
			{
				vecXo.push_back(p[0]);
				vecYo.push_back(p[1]);
			}

		}
		else*/ if(fabs(xAct-x)>11)
		{
			vecXo.push_back(p[0]);
			vecYo.push_back(p[1]);
		}
		else
		{
		vecX.push_back( p[0] );
		myfile <<p[0]<<","<<p[1]<<"\n";
		//std::cout<<" x Anterior "<<xAct<<" x actual "<<x<<std::endl;
		//std::cout<<" y Anterior "<<yAct<<" y actual "<<y<<std::endl;
		//std::cout<<" x "<<p[0]<<" y "<<p[1]<<std::endl;
		vecY.push_back( p[1] );
		vecZ.push_back( 900 );
		xAct=x;
		yAct=y;
		}


	}

	while(!vecXo.empty())
	{
		vecX.push_back(vecXo.back());
		//std::cout<<" x Siguiente "<<vecXo.back();
		vecXo.pop_back();
		vecZ.push_back( 900 );
	}
	while(!vecYo.empty())
	{
		vecY.push_back(vecYo.back());
			vecYo.pop_back();
	}
	myfile.close();

	/*for(int l=0;l<vecX.size();l++)
	{
		if(l==0)
		{
            vecXo.push_back(p[0]);
			vecYo.push_back(p[1]);
		}
		else
		{
			if(vecXoi[l-1]==)
			{
			}
		}

	}*/

	ExtractControlPoints2D *extractcontrolpoints2d = new ExtractControlPoints2D();

	extractcontrolpoints2d->SetContour( &vecX , &vecY , &vecZ );

	int method=2;
	if (method==0){
		extractcontrolpoints2d->GetInitialControlPoints( &vecCtrlPointX , &vecCtrlPointY , &vecCtrlPointZ );
	}
	else if (method==1){
		extractcontrolpoints2d->GetControlPoints(  &vecCtrlPointX , &vecCtrlPointY , &vecCtrlPointZ );
	}
	else if (method==2){
		extractcontrolpoints2d->SetSamplingControlPoints( 15 );
		extractcontrolpoints2d->GetSamplingControlPoints(  &vecCtrlPointX , &vecCtrlPointY , &vecCtrlPointZ );
	}
	//--Adding contour to the system

	std::vector<int> actualInstantVector;
	_instantPanel->getInstant( actualInstantVector );
	actualInstantVector[1]=z;

	int j,sizeCtrPt = vecCtrlPointX.size();

	manualBaseModel *manModelContour =  kernelManager->factoryManualContourModel( typeofcontour );
	manModelContour->SetNumberOfPointsSpline( ((sizeCtrPt/100)+1)*100 );
	if (sizeCtrPt>=3){
		for (j=0 ; j<sizeCtrPt ; j++)
		{
			manModelContour->AddPoint( vecCtrlPointX[j] , vecCtrlPointY[j] , vecCtrlPointZ[j]  );
		} // for
		std::string theName;
		//theName = _modelManager->createOutline( manModelContour, actualInstantVector );
		theName = kernelManager->createOutline( manModelContour, actualInstantVector );
		bool addedModel = theName.compare("") != 0;
		if( addedModel )
		{
			double spc[3];//Si no hay imagen pero hay contornos que spacing se pone por default
			_theViewPanel->getSpacing(spc);
			//Adding the manualContourControler to interface objects structure
			//Adding the manualViewContour to interface objects structure
			//_theViewPanel->getSceneManager()->setControlActiveStateOfALL( false );//This call is being done here because if the ROI is created underneath the previously created ROIS will still be active.
			_theViewPanel->configureViewControlTo(theName, manModelContour, spc, typeofcontour);
			//_theViewPanel->getSceneManager()->configureViewControlTo( theName, manModelContour,spc, typeofcontour ) ;
		}	// if addedModel
	} // if sizeCtrPt


/*
//EED10JUIN2011
		 WriterType::Pointer writer = WriterType::New();
         CastFilterType3::Pointer caster = CastFilterType3::New();

		 caster->SetInput( gradientMagnitude->GetOutput() );
		 writer->SetInput( caster->GetOutput() );
		 writer->SetFileName("Gradient Magnitude.png");
		 caster->SetOutputMinimum(   0 );
		 caster->SetOutputMaximum( 255 );
		 writer->Update();

		 CastFilterType3::Pointer caster2 = CastFilterType3::New();
		 WriterType::Pointer writer2 = WriterType::New();

		 caster2->SetInput( sigmoid->GetOutput() );
		 writer2->SetInput( caster2->GetOutput() );
		 writer2->SetFileName("Sigmoid.png");
		 caster2->SetOutputMinimum(   0 );
		 caster2->SetOutputMaximum( 255 );
		 writer2->Update();

		 CastFilterType3::Pointer caster3 = CastFilterType3::New();
		 WriterType::Pointer writer3 = WriterType::New();

		 caster3->SetInput( fastMarching->GetOutput() );
		 writer3->SetInput( caster3->GetOutput() );
		 writer3->SetFileName("FastMarching.bmp");
		 caster3->SetOutputMinimum(   0 );
		 caster3->SetOutputMaximum( 255 );
		 writer3->Update();

		 CastFilterType3::Pointer caster4 = CastFilterType3::New();
		 WriterType::Pointer writer4 = WriterType::New();

		 caster4->SetInput( geodesicActiveContour->GetOutput() );
		 writer4->SetInput( caster4->GetOutput() );
		 writer4->SetFileName("GeodesicActiveContour.png");
		 caster4->SetOutputMinimum(   0 );
		 caster4->SetOutputMaximum( 255 );
		 writer4->Update();

		 CastFilterType3::Pointer caster5 = CastFilterType3::New();
		 WriterType::Pointer writer5 = WriterType::New();

		 caster5->SetInput( zeroCrossing->GetOutput() );
		 writer5->SetInput( caster5->GetOutput() );
		 writer5->SetFileName("ZeroCrossing.bmp");
		 caster5->SetOutputMinimum(   0 );
		 caster5->SetOutputMaximum( 255 );
		 writer5->Update();
*/
    }
  catch( itk::ExceptionObject & excep )
    {
    std::cerr << "Exception caught !" << std::endl;
    std::cerr << excep << std::endl;
    }
}

void wxContourMainFrame::onSegmentationOneSlice(int isovalue,int sampling,int method){

	//JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation

	wxBusyCursor wait;
	int					x					= _theViewPanel->GetX();
	int					y					= _theViewPanel->GetY();
	int					z					= _theViewPanel->GetZ();
	SegmentationOneSlice( x,y,z,isovalue, sampling, method );
	RefreshInterface();
}


void wxContourMainFrame::SegmentationOneSlice( int x, int y, int z, int isovalue, int sampling, int method )
{
	int typeofcontour = 1;
	//--Extracting Contour
	//vtkImageData	*imagedata	= _theViewPanel->getSceneManager()->GetImageData();
	vtkImageData	*imagedata	= getImageData();
//		double			*range		= imagedata->GetScalarRange();
//		double			thr			= 1;

	vtkImageReslice *imageReslice = vtkImageReslice::New();
//EED
//		double spc[3];
//		imagedata->GetSpacing(spc);
//		x = x*spc[0];
//		y = y*spc[1];
//		z = z*spc[3];

	imageReslice->SetInput( imagedata );
	imageReslice->SetInformationInput(imagedata);
	imageReslice->SetResliceAxesDirectionCosines(1,0,0, 0,1,0 ,0,0,1);
	imageReslice->SetResliceAxesOrigin(0,0,z);
	imageReslice->SetOutputDimensionality(2);
	imageReslice->SetInterpolationModeToLinear();

	imagedata = imageReslice->GetOutput();
	imagedata->Update();
	imagedata->UpdateInformation();

	vtkContourFilter* cntVTK = vtkContourFilter::New( );
	cntVTK->SetInput( imagedata );

	cntVTK->SetNumberOfContours( 1 );
	//cntVTK->SetValue( 0, vmin );
//		cntVTK->SetValue( 0, (range[1]*thr/100) );
	cntVTK->SetValue( 1, isovalue );
//	cntVTK->SetValue( 1, vmax );
	cntVTK->Update( );
	cntVTK->UpdateInformation();

	vtkCleanPolyData* cpd = vtkCleanPolyData::New( );
	cpd->SetInput( cntVTK->GetOutput( ) );
	cpd->ConvertLinesToPointsOff( );
	cpd->Update( );
	cpd->UpdateInformation();

	vtkPolyDataConnectivityFilter* conn = vtkPolyDataConnectivityFilter::New( );
	conn->SetExtractionModeToClosestPointRegion( );
	//conn->SetMaxRecursionDepth( 3000 );

	conn->SetInput( cpd->GetOutput( ) );

	conn->SetClosestPoint( x, y, 0 );
	conn->Update( );
	conn->UpdateInformation();

	vtkCleanPolyData* cpd2 = vtkCleanPolyData::New( );
	cpd2->SetInput( conn->GetOutput( ) );
	cpd2->Update();
	cpd2->UpdateInformation();

	vtkStripper* vtkstripper = vtkStripper::New( );
	vtkstripper->SetInput( cpd2->GetOutput() );
	vtkstripper->Update();
	vtkstripper->UpdateInformation();


	vtkPolyData* polyDataResult =  vtkstripper->GetOutput();

	polyDataResult->Update( );
	polyDataResult->UpdateInformation();

/* EED
ofstream myfile;
myfile.open ("c:/temp/example.txt");
myfile << "\n";
polyDataResult->Print(myfile);
myfile << "-------------------------------------\n";
polyDataResult->GetLines()->Print(myfile);
myfile.close();
*/

	cntVTK		-> Delete();
	cpd2		-> Delete();
	cpd			-> Delete();
	conn		-> Delete();


//--Calculating control points

	std::vector<double> vecX;
	std::vector<double> vecY;
	std::vector<double> vecZ;

	std::vector<double> vecCtrlPointX;
	std::vector<double> vecCtrlPointY;
	std::vector<double> vecCtrlPointZ;


	double *p;
	int ii,size=polyDataResult->GetNumberOfPoints();
	int id;
	for (ii=1;ii<=size;ii++)
	{
		id	= polyDataResult->GetLines()->GetData()->GetValue(ii);
		p	= polyDataResult->GetPoint(id);
//		double x=p[0];
//		double y=p[1];
		vecX.push_back( p[0] );
		vecY.push_back( p[1] );
		vecZ.push_back( 900 );
//			vecZ.push_back( p[2] );
	}


	ExtractControlPoints2D *extractcontrolpoints2d = new ExtractControlPoints2D();
	extractcontrolpoints2d->SetContour( &vecX , &vecY , &vecZ );

//PROOFS
	/*if (methodRadiobox->GetSelection()==0){
		extractcontrolpoints2d->GetInitialControlPoints( &vecCtrlPointX , &vecCtrlPointY , &vecCtrlPointZ );
	}
	if (methodRadiobox->GetSelection()==1){
		extractcontrolpoints2d->GetControlPoints(  &vecCtrlPointX , &vecCtrlPointY , &vecCtrlPointZ );
	}
	if (methodRadiobox->GetSelection()==2){
		extractcontrolpoints2d->SetSamplingControlPoints( sampling );
		extractcontrolpoints2d->GetSamplingControlPoints(  &vecCtrlPointX , &vecCtrlPointY , &vecCtrlPointZ );
	}*/

	if (method==0){
		extractcontrolpoints2d->GetInitialControlPoints( &vecCtrlPointX , &vecCtrlPointY , &vecCtrlPointZ );
	}
	else if (method==1){
		extractcontrolpoints2d->GetControlPoints(  &vecCtrlPointX , &vecCtrlPointY , &vecCtrlPointZ );
	}
	else if (method==2){
		extractcontrolpoints2d->SetSamplingControlPoints( sampling );
		extractcontrolpoints2d->GetSamplingControlPoints(  &vecCtrlPointX , &vecCtrlPointY , &vecCtrlPointZ );
	}

	//--Adding contour to the system

	std::vector<int> actualInstantVector;
	_instantPanel->getInstant( actualInstantVector );
	actualInstantVector[1]=z;

	int j,sizeCtrPt = vecCtrlPointX.size();
	manualBaseModel *manModelContour =  kernelManager->factoryManualContourModel( typeofcontour );
	manModelContour->SetNumberOfPointsSpline( ((sizeCtrPt/100)+1)*100 );
	if (sizeCtrPt>=3){
		for (j=0 ; j<sizeCtrPt ; j++)
		{
			manModelContour->AddPoint( vecCtrlPointX[j] , vecCtrlPointY[j] , vecCtrlPointZ[j]  );
		} // for
		std::string theName;
		//theName = _modelManager->createOutline( manModelContour, actualInstantVector );
		theName = kernelManager->createOutline( manModelContour, actualInstantVector );
		bool addedModel = theName.compare("") != 0;
		if( addedModel )
		{
			double spc[3];//Si no hay imagen pero hay contornos que spacing se pone por default
			_theViewPanel->getSpacing(spc);
			//Adding the manualContourControler to interface objects structure
			//Adding the manualViewContour to interface objects structure
			//_theViewPanel->getSceneManager()->setControlActiveStateOfALL( false );//This call is being done here because if the ROI is created underneath the previously created ROIS will still be active.
			_theViewPanel->configureViewControlTo(theName, manModelContour, spc, typeofcontour);
			//_theViewPanel->getSceneManager()->configureViewControlTo( theName, manModelContour,spc, typeofcontour ) ;
		}	// if addedModel
	} // if sizeCtrPt
}
int wxContourMainFrame::GetImageDataSizeZ(){
	return _theViewPanel->GetImageDataSizeZ();
}

void wxContourMainFrame::GetImageDataRange(double *range){
	_theViewPanel->GetImageDataRange(range);
}

void wxContourMainFrame::onSegmentationAllSlice(int minZ,int maxZ,int isovalue,int sampling,int method){
	//JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation

	wxBusyCursor wait;
	int					x					= _theViewPanel->GetX();
	int					y					= _theViewPanel->GetY();
	int z;
	double porcent;
	wxString tmpString;
	double totalZ = maxZ-minZ+1;
	for( z=minZ ; z<=maxZ ; z++ )
	{
		porcent = 100.0* (z-minZ)/totalZ;
		tmpString.Printf(_T("  %d %c            %d/%d            %d"), (int)porcent , 37 , z-minZ+1, (int)totalZ,z );
		interfMainPanel::getInstance()->setLabelSegmentationPanelVTK(tmpString);
		//_staticTextSegmentation->SetLabel(tmpString);
		SegmentationOneSlice( x,y,z,isovalue, sampling,method );
	}
	interfMainPanel::getInstance()->setLabelSegmentationPanelVTK(_T("   "));
	RefreshInterface();
}


//Creates a reference line to be used as the axis of the mirroring
void wxContourMainFrame::referenceLine()
{
	if (_refLineControl==NULL)
	{
		wxBusyCursor wait;
		double spc[3];

		vtkImageData *vtkimagedata = _theViewPanel->getImageData();
		vtkimagedata->GetSpacing(spc);

		wxVtkBaseView * viewer2D = _theViewPanel->getWxVtkBaseView();

		_refLineControl	= new manualLineControler();
		_refLineModel	= new manualContourModelLine();
		_refLineView = new manualViewLine();
		_refLineView->SetModel( _refLineModel );
		_refLineView->SetWxVtkBaseView( viewer2D );
		_refLineView->SetRange( 2 );
		_refLineView->SetZ( 1200 );

		_refLineView->SetSpacing(spc);

		_refLineView->SetColorNormalContour(0, 0, 1);
		_refLineView->SetColorEditContour(0, 0.5, 0.5);
		_refLineView->SetWidthLine(4);

		_refLineControl->SetModelView( _refLineModel , _refLineView );
		vtkInteractorStyleBaseView* style = (vtkInteractorStyleBaseView*)viewer2D->GetInteractorStyleBaseView();
		style->AddInteractorStyleMaracas( _refLineControl );
		_refLineModel->SetCloseContour(false);
		_refLineControl->CreateNewManualContour();

//AD: Inicializar el mirroring con una linea ya pintada
	/*
		double z = _refLineControl->GetZ();

		int imageDim[3];
		image->GetDimensions(imageDim);
		double x = (double) imageDim[0]/2;
		double y1 = (double) (imageDim[1]/2)+15;
		double y2 = (double) (imageDim[1]/2)-15;

		_refLineControl->AddPoint(x,y1,z);
		_refLineControl->AddPoint(x,y2,z);
		_refLineControl->SetCompleteCreation(true);

		_refLineModel->AddPoint(x,y1,z);
		_refLineModel->AddPoint(x,y2,z);
		_refLineModel->UpdateSpline();

		_refLineView->UpdateViewPoint(0);
		_refLineView->UpdateViewPoint(1);
	*/

		_refLineControl->SetActive(true);
		_refLineView->RefreshContour();
	}
}

//Hides the referenceLine
void wxContourMainFrame::refLineHide()
{
	if (_refLineControl!=NULL)
	{
		if (_refLineControl->GetActive())
		{
			_refLineView->RemoveCompleteContourActor();
			_refLineControl->SetEditable(false);
			_refLineControl->SetActive(false);

			RefreshInterface();
		}
	}
}

//Shows the referenceLine
void wxContourMainFrame::refLineShow()
{
	if (_refLineControl!=NULL)
	{
		if (_refLineControl->GetActive()==false)
		{
			wxVtkBaseView * viewer2D = _theViewPanel->getWxVtkBaseView();

			_refLineView->SetModel( _refLineModel );
			_refLineView->SetWxVtkBaseView( viewer2D );
			_refLineView->SetRange( 2 );
			_refLineView->SetZ( 1200 );

			_refLineControl->SetModelView( _refLineModel , _refLineView );
			vtkInteractorStyleBaseView* style = (vtkInteractorStyleBaseView*)viewer2D->GetInteractorStyleBaseView();
			style->AddInteractorStyleMaracas( _refLineControl );
			_refLineControl->CreateNewManualContour();
			_refLineControl->SetActive(true);
			_refLineView->RefreshContour();

			RefreshInterface();
		}
	}
}

void wxContourMainFrame::refLineChangeWidth(int width)
{
	_refLineView->SetWidthLine(width);
	_refLineView->RefreshContour();

	RefreshInterface();
}


void wxContourMainFrame::onMirror()
{
   	//AD:02-09
	std::vector<std::string> currentSelection = _theViewPanel->getSelectedObjects();
	std::vector<std::string> filterCurrentSelection;

	std::vector<int> tempVector;
	_instantPanel->getInstant( tempVector );
    _performingOperation->reset();
	_performingOperation->setStartCommand( COPY );
	_performingOperation->setStartOperationInstantVector( tempVector );
	_performingOperation->setKeyNamesOperationElems( currentSelection );

	char theStartCommand = _performingOperation->getStartCommand();
	if (  theStartCommand == COPY )
	{
		//JCP 20-10-08 Undo redo implementation
		saveState();
		//JCP 20-10-08 Undo redo implementation
		std::vector<int> tempVector;
		_instantPanel->getInstant( tempVector );
		_performingOperation->setEndOperationInstantVector ( tempVector );
		std::vector<std::string> elems = _performingOperation->getKeyNamesOperationElems();
		int i,size = elems.size();
		for( i=0; i<size; i++ )
		{
			createMirrorContourOf( elems[i], tempVector, i>0 );
		}
	}

	//deleteContour( _refName );
	//_refName = "";
}


void wxContourMainFrame::showAxis(bool show)
{
	_theViewPanel->SetVisibleAxis(show);
	_theViewPanel->Refresh();
}


void wxContourMainFrame::onRigidPressed(){
	std::vector<std::string> currentSelection = _theViewPanel->getSelectedObjects();
	int elementsSelected = currentSelection.size();

	if ( elementsSelected >= 1 ){
		//JCP 20-10-08 Undo redo implementation
		saveState();
		//JCP 20-10-08 Undo redo implementation

		std::vector<int> tempVector;
		_instantPanel->getInstant( tempVector );
		Instant instant(&tempVector);

		int i , size=currentSelection.size();
		for ( i=0 ; i<size ; i++ )
		{
			kernelManager->changeContourOfManager(currentSelection[i], &instant);
		} // i
	}
}

void wxContourMainFrame::onWidthOfContour(double width){

	_theViewPanel->removeSceneContours();
	_theViewPanel->SetWidthContour(width);

	//_theViewPanel->getSceneManager()->SetWidthContour( width );

	RefreshInterface();
}

int wxContourMainFrame::getColorWindow()
{
	/*
	double range[2];
	vtkImageData * img = getImageData();
	img->GetScalarRange(range);

	std::cout<<"Val 1: "<<range[0]<<" Val 2: "<<range[1]<<std::endl;

	return (int)range[1];
	*/
	return _theViewPanel->getColorWindow();
}

int wxContourMainFrame::getWindowLevel()
{
	/*
	double range[2];
	vtkImageData * img = getImageData();
	img->GetScalarRange(range);

	std::cout<<"Val 1: "<<range[0]<<" Val 2: "<<range[1]<<std::endl;

	return (int)range[1];
	*/
	return _theViewPanel->getWindowLevel();
}

void wxContourMainFrame::onBrigthnessColorWindowLevel(int colorwindow,int windowlevel){
	_theViewPanel->onBrigthnessColorWindowLevel(colorwindow, windowlevel);

	RefreshInterface();
}

void wxContourMainFrame::onInterpolation(bool interpolate){
	_theViewPanel->onInterpolation(interpolate);
	RefreshInterface();
}

void wxContourMainFrame::onChangeInstant(std::string name,int actual){
	_instantPanel->setConceptValue( name, actual );
}


void wxContourMainFrame::resetAppend(){
	kernelManager->resetAppend();

}


void wxContourMainFrame::onSpreadAdd(){
	std::vector<double> vecX;
	std::vector<double> vecY;
	std::vector<double> vecZ;
	_theViewPanel->GetPointsOfActualContour(&vecX , &vecY , &vecZ );
	std::vector<int> tempVector;
	_instantPanel->getInstant( tempVector );
	std::string val = kernelManager->onSpreadAdd(&vecX , &vecY , &vecZ, tempVector);
	interfMainPanel::getInstance()->appendStringSpread(val);
}


void wxContourMainFrame::onSpreadAddAll(){
//EED02
	std::vector<int> tempVector;
	_instantPanel->getInstant( tempVector );
	int minZ,maxZ;
    minZ	= 0;
    maxZ	= interfMainPanel::getInstance()->GetImageDataSizeZ();
	int z;
	int sizeLstContourThings;
	for ( z=minZ ; z<=maxZ ; z++ )
	{
		tempVector[1]=z;
		Instant instant(&tempVector);
		std::vector<ContourThing**> lstContourThings = kernelManager->getOutlinesAtInstant( &instant );
		sizeLstContourThings = lstContourThings.size();
		if (sizeLstContourThings>=1)
        {
            std::vector<double> vecX;
            std::vector<double> vecY;
            std::vector<double> vecZ;
            ContourThing **contourthing = lstContourThings[0];
			manualBaseModel *cModel				=  (*contourthing)->getModel();
			int i,size = cModel->GetNumberOfPointsSpline();
			double x,y,z;
			for (i=0; i<size; i++)
			{
				cModel->GetSpline_i_Point(i, &x, &y, &z);
				vecX.push_back(x);
				vecY.push_back(y);
				vecZ.push_back(z);
			} // for i
            std::string val = kernelManager->onSpreadAdd(&vecX , &vecY , &vecZ, tempVector);
            interfMainPanel::getInstance()->appendStringSpread(val);
        }// if sizeLstContourThings
    } // for z
}


void wxContourMainFrame::onSpreadGo(int type){
	//JCP 20-10-08 Undo redo implementation
	saveState();
	//JCP 20-10-08 Undo redo implementation
	wxBusyCursor wait;
	std::vector<double> vecCtrlPointX;
	std::vector<double> vecCtrlPointY;
	std::vector<double> vecCtrlPointZ;
	double  minZ,maxZ;
	int z;

	std::vector<int> tempVector;
	_instantPanel->getInstant( tempVector );
//		tempVector[1];

	kernelManager->getMaxMinZ(&minZ,&maxZ);
//JSTG_16-07-08_----------------------------------------------------------------
	//_contourPropagation->setInterpolationNumber(maxZ-minZ+1);
	kernelManager->CalculeSplinePropagation();

	double		totalZ = maxZ-minZ+1;
	double		porcent;
	wxString	tmpString;
//--------------------------------------------------------------------
	for ( z=(int)minZ ; z<=(int)maxZ ; z++ )
	{
		porcent = 100.0* (z-minZ)/totalZ;
		int numero = (int)(z-minZ+1)/(int)totalZ;
		std::string stringtemp = "  "+kernelManager->intToString(porcent)+"%            "+kernelManager->intToString(numero)+"            "+kernelManager->intToString(z);

		interfMainPanel::getInstance()->setStringSpread(stringtemp);

		int typeofcontour = 1;
		std::string theName;
		manualBaseModel* manModelContour = kernelManager->GetPoints(z, type, &vecCtrlPointX,&vecCtrlPointY,&vecCtrlPointZ, theName,typeofcontour, tempVector);

		if( manModelContour!=NULL ){
			double spc[3];//Si no hay imagen pero hay contornos que spacing se pone por default
			this->_theViewPanel->getSpacing(spc);
			//Adding the manualContourControler to interface objects structure
			//Adding the manualViewContour to interface objects structure
			//_theViewPanel->getSceneManager()->setControlActiveStateOfALL( false );//This call is being done here because if the ROI is created underneath the previously created ROIS will still be active.
			_theViewPanel->configureViewControlTo( theName, manModelContour,spc,typeofcontour ) ;
		} // if addedModel
	}
	if(z > maxZ){
		porcent = 100.0;
		int numero = (int)(z-minZ+1)/(int)totalZ;
		std::string stringtemp = "  "+kernelManager->intToString(porcent)+"%            "+kernelManager->intToString(numero)+"            "+kernelManager->intToString(z);

		interfMainPanel::getInstance()->setStringSpread(stringtemp);
	}// for z
	//RefreshInterface();
}

void wxContourMainFrame::getInstantVector(std::vector<int>& tempVector){

}

std::vector<std::string> wxContourMainFrame::getOutlinesName(int slide){
	std::vector<int> tempVector;
	_instantPanel->getInstant(tempVector);
	//Asignation of slide number should be different ex by name
	tempVector[1]=slide;
	return kernelManager->getOutlinesNameAtInstant(tempVector);
}


void wxContourMainFrame::SetScalarRange(int grayRangeMin, int grayRangeMax)
{
	_contourextractdata->SetScalarRange(grayRangeMin,grayRangeMax);
}


void wxContourMainFrame::onInformationContourLabels(int typeContourGroup,int selection,int minimumZ,int maximumZ,int grayRangeMin, int grayRangeMax)
{

	wxString tempString;
	int maxContourGroup	=	0;

	_contourextractdata ->SetTypeOperation( typeContourGroup % 3 );

	std::vector<manualBaseModel*> lstManConMod;
	std::vector<manualBaseModel*> lstManConModTmp;
	std::vector<manualBaseModel*> lstManConModExp;
	std::vector<double> pLstValue;
	std::vector<double> pLstValuePosX;
	std::vector<double> pLstValuePosY;
	std::vector<double> pLstValuePosZ;

	int		resultSize;
	int		resultGrayRangeCount;
	double	resultMin;
	double	resultMax;
	double	resultAverage;
	double	resultStandardeviation;

	std::vector<int> tempVector;
	_instantPanel->getInstant( tempVector );

	int z;
	int ii,sizeLstContourThings;


	int minZ,maxZ;
	double totalZ;
	double porcent;
	wxString tmpString;


	if (selection==0 ) // actual slice
	{
		int actualSlice = tempVector[1];
		minZ	= actualSlice;
		maxZ	= actualSlice;
	}	else  {  // slice range
		minZ	= minimumZ;
		maxZ	= maximumZ;
	}


	totalZ	= maxZ-minZ+1;

	_contourextractdata->InitVolumeStatistics();

// For each slice..
	for ( z=minZ ; z<=maxZ ; z++ )
	{

		porcent = 100.0* (z-minZ)/totalZ;
		tmpString.Printf(_T("  %d %c            %d/%d             %d"), (int)porcent , 37 , z-minZ+1, (int)totalZ ,z);

		interfMainPanel::getInstance()->setStringInfoPanel(tmpString);
		//_staticTextInformation->SetLabel(tmpString);

		//Extraction data from contours of each slice
		_contourextractdata->SetZtoBeAnalys(z);

		tempVector[1]=z;
		Instant instant(&tempVector);
		std::vector<ContourThing**> lstContourThings = kernelManager->getOutlinesAtInstant( &instant );
		sizeLstContourThings = lstContourThings.size();

		lstManConMod.clear();
		for (ii=0 ; ii<sizeLstContourThings ; ii++)
		{
			ContourThing **contourthing = lstContourThings[ii];
			lstManConMod.push_back( (*contourthing)->getModel() );
		}

		lstManConModExp =  kernelManager->ExploseEachModel( lstManConMod );

		tempString.Printf(_T("%d - %d"),z, sizeLstContourThings);
		interfMainPanel::getInstance()->setRowLabelInfoPanel(z, tempString);
		//_grid->SetRowLabelValue(z, tempString );
//EED004
		int iContourGroup,sizeContourGroup;
		if (typeContourGroup==3) // contour separete
		{
			sizeContourGroup=lstManConModExp.size();
			if ( maxContourGroup<sizeContourGroup )
			{
				maxContourGroup=sizeContourGroup;
			}
		} else {  // contour AND OR XOR
			sizeContourGroup=1;
			maxContourGroup=1;
		}

		int tmpIntA;

		for( iContourGroup=0 ; iContourGroup<sizeContourGroup ; iContourGroup++ ){
			lstManConModTmp.clear();



			if (typeContourGroup==3) // contour separete
			{
				lstManConModTmp.push_back( lstManConModExp[iContourGroup]);
			} else {  // contour AND OR XOR
				lstManConModTmp = lstManConModExp;
			}

			_contourextractdata->SetLstManualContourModel( lstManConModTmp );
			_contourextractdata->SetScalarRange(grayRangeMin,grayRangeMax);

			pLstValue.clear();
			pLstValuePosX.clear();
			pLstValuePosY.clear();
			pLstValuePosZ.clear();


			int numberOfPixels;
			_contourextractdata->GetValuesInsideCrown(  &numberOfPixels,
														&pLstValue,
														&pLstValuePosX,
														&pLstValuePosY,
														&pLstValuePosZ);

			resultSize=numberOfPixels;
			// Statistics of each slice.
			_contourextractdata->Statistics( &pLstValue,
											grayRangeMin,
											grayRangeMax,
											&resultGrayRangeCount,
											&resultSize,
											&resultMin,
											&resultMax,
											&resultAverage,
											&resultStandardeviation);

			if (interfMainPanel::getInstance()->getNumberColsInformationPanel()<_numberOfVariablesStatistics*(iContourGroup+1)  )
			{
				interfMainPanel::getInstance()->appendColsInformationPanel(_numberOfVariablesStatistics);
			}

			tmpIntA=_numberOfVariablesStatistics*iContourGroup ;

			tempString.Printf(_T("%d"),numberOfPixels);

			interfMainPanel::getInstance()->setCellValueInfoPanel(z, tmpIntA, tempString);

			tempString.Printf(_T("%d"),resultGrayRangeCount);
			interfMainPanel::getInstance()->setCellValueInfoPanel(z, tmpIntA+1, tempString);

			tempString.Printf(_T("%f"),resultMin);
			interfMainPanel::getInstance()->setCellValueInfoPanel(z, tmpIntA+2, tempString);

			tempString.Printf(_T("%f"),resultMax);
			interfMainPanel::getInstance()->setCellValueInfoPanel(z, tmpIntA+3, tempString);

			tempString.Printf(_T("%f"),resultAverage);
			interfMainPanel::getInstance()->setCellValueInfoPanel(z, tmpIntA+4, tempString);

			tempString.Printf(_T("%f"),resultStandardeviation);
			interfMainPanel::getInstance()->setCellValueInfoPanel(z, tmpIntA+5, tempString);


		} // for iContourGroup
	} // for z

	// Print Volume Statistics


	int		vol_rCountRange;
	int		vol_rsize;
	double	vol_minValue;
	double	vol_maxValue;
	double	vol_average;
	double	vol_standardeviation;

	if (selection!=0 ) // actual slice
	{

		_contourextractdata->GetVolumeStatistics(&vol_rCountRange, &vol_rsize,
												 &vol_minValue, &vol_maxValue,
												 &vol_average, &vol_standardeviation);

		interfMainPanel::getInstance()->setRowLabelInfoPanel(maxZ+2, _T("Total:"));

		tempString.Printf(_T("%d"),vol_rsize);
		interfMainPanel::getInstance()->setCellValueInfoPanel(maxZ+2, 0, tempString);

		tempString.Printf(_T("%d"),vol_rCountRange);
		interfMainPanel::getInstance()->setCellValueInfoPanel(maxZ+2, 1, tempString);

		tempString.Printf(_T("%f"),vol_minValue);
		interfMainPanel::getInstance()->setCellValueInfoPanel(maxZ+2, 2, tempString);

		tempString.Printf(_T("%f"),vol_maxValue);
		interfMainPanel::getInstance()->setCellValueInfoPanel(maxZ+2, 3, tempString);

		tempString.Printf(_T("%f"),vol_average);
		interfMainPanel::getInstance()->setCellValueInfoPanel(maxZ+2, 4, tempString);

		tempString.Printf(_T("%f"),vol_standardeviation);
		interfMainPanel::getInstance()->setCellValueInfoPanel(maxZ+2, 5, tempString);
	}
	//-----------------------------------------

	int iTitleGroup;
	wxString tmpTitleString;
	int tmpIntB;
	for ( iTitleGroup=0 ; iTitleGroup<maxContourGroup ; iTitleGroup++ )
	{
		tmpIntB =_numberOfVariablesStatistics*iTitleGroup;
		tmpTitleString.Printf(_T("%d-Size Data"),iTitleGroup);
		interfMainPanel::getInstance()->setColLableInfoPanel(tmpIntB + 0, tmpTitleString);

		interfMainPanel::getInstance()->setColLableInfoPanel(tmpIntB + 0, tmpTitleString );
		interfMainPanel::getInstance()->setColLableInfoPanel( tmpIntB + 1, _T("Size Range") );
		interfMainPanel::getInstance()->setColLableInfoPanel( tmpIntB + 2, _T("Min") );
		interfMainPanel::getInstance()->setColLableInfoPanel( tmpIntB + 3, _T("Max") );
		interfMainPanel::getInstance()->setColLableInfoPanel( tmpIntB + 4, _T("Average") );
		interfMainPanel::getInstance()->setColLableInfoPanel( tmpIntB + 5, _T("St.Dev.") );
		interfMainPanel::getInstance()->setColLableInfoPanel( tmpIntB + 6, _T(" ") );
	}// for title
	interfMainPanel::getInstance()->setStringInfoPanel( _T("") );
}

//AD: 29-05-09
void wxContourMainFrame::onSaveResults(std::string directory,std::string namefile, std::string filename,
	int typeContourGroup, int selection, int minZ, int maxZ, bool XYZValues, bool contourImage, bool statistics)
{
	if (XYZValues)
	{
		SaveValuesXYZ( directory , namefile, typeContourGroup );
	}

	if (contourImage)
	{
		vtkImageData * mask;
		vtkImageData * value;
		this->getMaskValue(&mask, &value, typeContourGroup,selection,minZ,maxZ);
		this->SaveImageResult( directory , namefile, mask, value);
	}

	if (statistics)
	{
		std::ostringstream name;
		name << filename << ".xls";


		FILE *pFile=fopen(name.str().c_str(),"w+");


		wxString tmpString;
		int i,j,maxX;

//		int sizeZ = _theViewPanel->GetImageDataSizeZ();
//		int maxY=sizeZ+2;

		maxX= interfMainPanel::getInstance()->getNumberColsInformationPanel();//this->_grid->GetNumberCols();

		// -- Title --
		int iTitle,sizeTitle = (maxX / _numberOfVariablesStatistics);
		for ( iTitle=0; iTitle<sizeTitle ; iTitle++)
		{
				// fprintf(pFile,"-- \t %d-Size \t SizeRange \t Min \t Max \t Ave \t StDv \t" , iTitle,tmpString.c_str() );
				fprintf(pFile,"slice\t %d-Size \t SizeRange \t Min \t Max \t Ave \t StDv \t" , iTitle );
		}
		fprintf(pFile,"\n\n" );



		if (selection==0 ) // actual slice
		{
			std::vector<int> tempVector;
			_instantPanel->getInstant( tempVector );
			int actualSlice = tempVector[1];
			minZ	= actualSlice;
			maxZ	= actualSlice;
		}

		// Stadistics...
		for ( j=minZ; j<=maxZ ; j++)
		{
			fprintf(pFile,"%d\t" , j );
			for (i=0 ; i<maxX ; i++){
				tmpString = interfMainPanel::getInstance()->getCellValue(j, i);//_grid->GetCellValue( j , i );
				fprintf(pFile,"%s\t" , (const char *)(tmpString.mb_str()) );
			} // for i
			fprintf(pFile,"\n"  );
		} // for j


		// Total of stadistics.....
		if (selection!=0)
		{
			fprintf(pFile,"\n Total:\t"  );
			for (i=0 ; i<maxX ; i++){
				tmpString = interfMainPanel::getInstance()->getCellValue(maxZ+2, i);//_grid->GetCellValue( maxZ+2 , i );
				fprintf(pFile,"%s\t" , (const char *)(tmpString.mb_str()) );
			} // for i
			fprintf(pFile,"\n"  );
		}

		fclose(pFile);
	}
}

//AD: 29-05-09
void wxContourMainFrame::SaveValuesXYZ(std::string directory,std::string namefile,int typeContourGroup)
{
	wxBusyCursor wait;

	//int typeContourGroup = this->_radiolstboxContourGroup->GetSelection();
	_contourextractdata ->SetTypeOperation( typeContourGroup % 3 );

	std::vector<manualBaseModel*> lstManConMod;
	std::vector<manualBaseModel*> lstManConModTmp;
	std::vector<manualBaseModel*> lstManConModExp;
	std::vector<double> pLstValue;
	std::vector<double> pLstValuePosX;
	std::vector<double> pLstValuePosY;
	std::vector<double> pLstValuePosZ;

	std::vector<int> tempVector;
	_instantPanel->getInstant( tempVector );

	int sizeZ = _theViewPanel->getSceneManager()->GetImageDataSizeZ();
	int z;
	int ii,sizeLstContourThings;


	int minZ,maxZ;
	double totalZ;
	double porcent;
	wxString tmpString;
	minZ	= 0;// _mbarrange->GetStart();
	maxZ	= sizeZ;//_mbarrange->GetEnd();
	totalZ	= maxZ-minZ+1;


// For each slice..
	for ( z=0 ; z<sizeZ ; z++)
	{

		porcent = 100.0* (z-minZ)/totalZ;

		tmpString.Printf(_T("Saving Values"));
		tmpString.Printf(_T("  %d %c            %d/%d             %d"), (int)porcent , 37 , z-minZ+1, (int)totalZ ,z);
		interfMainPanel::getInstance()->setStringInfoPanel(tmpString);
		//_staticTextInformation->SetLabel(tmpString);


		//Extraction data from contours of each slice
		_contourextractdata->SetZtoBeAnalys( z);

		tempVector[1]=z;
		Instant instant(&tempVector);
		std::vector<ContourThing**> lstContourThings = kernelManager->getOutlinesAtInstant(&instant);//this->_modelManager->getOutlinesAtInstant( &instant );
		sizeLstContourThings = lstContourThings.size();

		lstManConMod.clear();
		for (ii=0 ; ii<sizeLstContourThings ; ii++)
		{
			ContourThing **contourthing = lstContourThings[ii];
			lstManConMod.push_back( (*contourthing)->getModel() );
		}
		lstManConModExp =  kernelManager->ExploseEachModel( lstManConMod );


//EED004

		int iContourGroup,sizeContourGroup;
		if (typeContourGroup==3) // contour separete
		{
			sizeContourGroup=lstManConModExp.size();
		} else {  // contour AND OR XOR
			sizeContourGroup=1;
		}

		for( iContourGroup=0 ; iContourGroup<sizeContourGroup ; iContourGroup++ ){
			lstManConModTmp.clear();
			if (typeContourGroup==3) // contour separete
			{
				lstManConModTmp.push_back( lstManConModExp[iContourGroup]);
			} else {  // contour AND OR XOR
				lstManConModTmp = lstManConModExp;
			}

			_contourextractdata->SetLstManualContourModel( lstManConModTmp );

			pLstValue.clear();
			pLstValuePosX.clear();
			pLstValuePosY.clear();
			pLstValuePosZ.clear();
			int numberOfPixels;
			_contourextractdata->GetValuesInsideCrown(	&numberOfPixels,
														&pLstValue,
														&pLstValuePosX,
														&pLstValuePosY,
														&pLstValuePosZ);

			std::string temp = directory + "/" + namefile + "-slice";
			temp = temp + kernelManager->intToString(z) + "-cont" + kernelManager->intToString(iContourGroup);
			temp = temp + ".txt";

			// LG 14/01/09 : using crea
			wxString filename = crea::std2wx(temp);
			/*filename.Printf(_T("%s"),directory.c_str());
			filename.append(_T("\\"));
			filename.append(_T("%s"),namefile.c_str());
			filename.append(_T("-slice"));
			filename.append(_T("%d"),z);
			filename.append(_T("-cont"));
			filename.append(_T("%d"),iContourGroup);
			filename.append(_T(".txt"));*/
			//			filename.Printf(temp.c_str());



			FILE *pFile=fopen((const char *)filename.mb_str(),"w+");
			fprintf(pFile,"value \t x \t y \t z\n"  );
			int iLstValue,sizeLstValue=pLstValue.size();
			for (iLstValue=0 ; iLstValue<sizeLstValue ; iLstValue++ )
			{
				fprintf(pFile,"%f\t %f\t %f\t %f\n", (float)pLstValue[iLstValue] , (float)pLstValuePosX[iLstValue], (float)pLstValuePosY[iLstValue], (float)z );
			}
			fclose(pFile);
		} // for  iContourGroup
	} // for z
	interfMainPanel::getInstance()->setStringInfoPanel(_T(""));
	//_staticTextInformation->SetLabel( _T("") );

}

void wxContourMainFrame::getMaskValue(vtkImageData ** mask,vtkImageData ** value,int typeContourGroup, int selection, int minZ, int maxZ){
	wxBusyCursor wait;

	//int typeContourGroup = this->_radiolstboxContourGroup->GetSelection();
	if (typeContourGroup==3)
	{
		typeContourGroup=1;
	}
	_contourextractdata ->SetTypeOperation( typeContourGroup % 3 );

	std::vector<manualBaseModel*> lstManConMod;
	std::vector<manualBaseModel*> lstManConModTmp;
	std::vector<manualBaseModel*> lstManConModExp;

	std::vector<int> tempVector;
	_instantPanel->getInstant( tempVector );

    vtkImageData *imagedata = _theViewPanel->getImageData();
	int ext[6];
	imagedata->GetExtent(ext);
	int sizeZimage = ext[5]-ext[4]+1;
	int z;
	int ii,sizeLstContourThings;


	double totalZ;
	double porcent;

	wxString tmpString;


	if (selection==0 ) // actual slice
	{
		int actualSlice = tempVector[1];
		minZ	= actualSlice;
		maxZ	= actualSlice;
	}

	totalZ	= maxZ-minZ;


	// cleanning image before range
	for (z=0; z<minZ; z++){
		_contourextractdata->ResetImageResult(z);
	}
	// cleanning image after range
	for (z=maxZ+1; z<sizeZimage; z++){
		_contourextractdata->ResetImageResult(z);
	}


// For each slice..
	for ( z=minZ ; z<=maxZ ; z++)
	{

		porcent = 100.0* (z-minZ)/totalZ;
		tmpString.Printf(_T("Saving Values"));
		tmpString.Printf(_T("%d %c            %d/%d             %d"), (int)porcent , 37 , z-minZ+1, (int)totalZ ,z);
		interfMainPanel::getInstance()->setStringInfoPanel(tmpString);

		//Extraction data from contours of each slice
		_contourextractdata->SetZtoBeAnalys( z);

		tempVector[1]=z;
		Instant instant(&tempVector);
		std::vector<ContourThing**> lstContourThings = kernelManager->getOutlinesAtInstant( &instant );
		sizeLstContourThings = lstContourThings.size();

		lstManConMod.clear();
		for (ii=0 ; ii<sizeLstContourThings ; ii++)
		{
			ContourThing **contourthing = lstContourThings[ii];
			lstManConMod.push_back( (*contourthing)->getModel() );
		}
		lstManConModExp =  kernelManager->ExploseEachModel( lstManConMod );


		int iContourGroup,sizeContourGroup;
		if (typeContourGroup==3) // contour separete
		{
			sizeContourGroup=lstManConModExp.size();
		} else {  // contour AND OR XOR
			sizeContourGroup=1;
		}

		for( iContourGroup=0 ; iContourGroup<sizeContourGroup ; iContourGroup++ ){
			lstManConModTmp.clear();
			if (typeContourGroup==3) // contour separete
			{
				lstManConModTmp.push_back( lstManConModExp[iContourGroup]);
			} else {  // contour AND OR XOR
				lstManConModTmp = lstManConModExp;
			}

			_contourextractdata->SetLstManualContourModel( lstManConModTmp );
			_contourextractdata->CalculateImageResult(); // with actual Z

		} // for  iContourGroup
	} // for z

	(*value) = _contourextractdata->GetVtkImageValueResult();
	(*mask)  = _contourextractdata->GetVtkImageMaskResult();

}

void wxContourMainFrame::SaveImageResult(std::string directory,std::string namefile, vtkImageData* mask,vtkImageData* value)
{

	double spc[3];
	kernelManager->GetSpacing(spc,0);   // returns the spacing of the first image
	
	std::string temp = directory + "/" + namefile + "-image-Value.mhd";

	wxString filename = crea::std2wx(temp);

// Image Value
	
	vtkImageChangeInformation *valueChInfo = vtkImageChangeInformation::New();
	valueChInfo->SetInput(value);
	valueChInfo->SetSpacingScale(spc);	
	vtkMetaImageWriter *writerValueImage = vtkMetaImageWriter::New( );
	writerValueImage->SetInput( valueChInfo->GetOutput() );
	writerValueImage->SetFileName( (const char *)filename.mb_str() );
	writerValueImage->SetFileDimensionality( 3 );
	writerValueImage->SetCompression(false);
	writerValueImage->Write( );

// Image Mask
	temp = directory + "/" + namefile + "-image-Mask.mhd";

	// LG 14/01/09 : using crea
	filename = crea::std2wx(temp);
	//	filename.Printf(_T(temp.c_str()));


	vtkImageChangeInformation *maskChInfo = vtkImageChangeInformation::New();
	maskChInfo->SetInput(mask);
	maskChInfo->SetSpacingScale(spc);	
	vtkMetaImageWriter *writerMaskImage = vtkMetaImageWriter::New( );
	writerMaskImage->SetInput( maskChInfo->GetOutput() );
	writerMaskImage->SetFileName( (const char *)filename.mb_str() );
	writerMaskImage->SetFileDimensionality( 3 );
	writerMaskImage->SetCompression(false);
	writerMaskImage->Write( );

	interfMainPanel::getInstance()->setStringInfoPanel( _T("") );

}



void wxContourMainFrame::onChangeInstantInstantPanel(std::string name,int value, int minshow, int maxshow){
	if( name.compare( _theViewPanel->getVerticalConceptName() ) == 0){
		_theViewPanel->setActualVertical( value);
	}
	else if( name.compare( _theViewPanel->getHorizontalConceptName() ) == 0|| _instantPanel->getIfConceptCheckedAt( name, 0 ) )	{
		_theViewPanel->setHorizontalConcept( name, minshow, maxshow, minshow, maxshow, value);
	}

	changeInstant();
}

void wxContourMainFrame::onSnakePressed(){
	std::vector<double> vecX;
	std::vector<double> vecY;
	std::vector<double> vecZ;
	_theViewPanel->GetPointsOfActualContour( &vecX , &vecY , &vecZ );

	if (vecX.size()!=0){
		std::vector<int> tempVector;
		_instantPanel->getInstant( tempVector );
		int i,size=vecZ.size();
		int actualSlice = tempVector[1];
		for ( i=0 ; i<size ; i++ )
		{
			vecZ[i] = actualSlice;
		} // for

		wxDialog* dialog = new wxDialog(this, -1, wxString(_T("Snake")));
		wxPanel* panel = new wxPanel(dialog,-1);
		//		wxStaticText* sttext = new wxStaticText(panel, -1, wxString(_T("Panel para snake")));
         new wxStaticText(panel, -1, wxString(_T("Panel para snake")));
		dialog->ShowModal();
	} // if

}

void wxContourMainFrame::saveFileWithContoursAutomatique(){
	std::string filename = kernelManager->getCurrentFileName();
	if(filename.compare("")!=0){
		saveFileWithContours(filename);
	}else{
		onSave();
	}
}
void wxContourMainFrame::ShowToolsPanel(bool show){
	_pannew->Show(show);
}



void wxContourMainFrame::SetContourGroup(int contourGroup)
{
	_contourGroup = contourGroup;
}


wxPanel *wxContourMainFrame::getMaskImageViewPanel(wxWindow *parent)
{

	if 	(_viewMaskImagePanel==NULL)
	{
		_contourextractdata = new ContourExtractData(true);
		_contourextractdata->SetImage( _theViewPanel->getImageData() );
//		double range[2];
//		_theViewPanel->getImageData()->GetScalarRange(range);
		//int min = (int)floor (range[0]);
		//int max = (int)ceil (range[1]);
		int min = 254;
		int max = 256;
		_viewMaskImagePanel = new ThresholdImageViewPanel( parent, -1, -1 , 0);
		_viewMaskImage = new ThresholdImageView();
		_viewMaskImage->SetImage(_contourextractdata->GetVtkImageMaskResult() );
		_viewMaskImage->SetminMaxValue( min, max);
		_viewMaskImage->SetBaseColor( 0,0,1 );
		_viewMaskImagePanel->SetThresholdImageView( _viewMaskImage );
		_viewMaskImage->SetwxVtkBaseView( _theViewPanel->getWxVtkBaseView() );
	}
	return _viewMaskImagePanel;
}


wxPanel *wxContourMainFrame::getColorLayerImageViewPanel(wxWindow *parent)
{
	if 	(_viewColorLayerImagePanel==NULL)
	{
		double range[2];
		_theViewPanel->getImageData()->GetScalarRange(range);
		int min = (int)floor (range[0]);
		int max = (int)ceil (range[1]);
		_viewColorLayerImagePanel = new ColorLayerImageViewPanel( parent, min, max, 100, 1);
		_viewColorLayerImagePanel->GetColorLayerImageViewManager()->SetwxVtkBaseView( 0 , _theViewPanel->getWxVtkBaseView() );
	}
	return _viewColorLayerImagePanel;
}


wxPanel *wxContourMainFrame::getThresholdImageViewPanel(wxWindow *parent)
{
	if 	(_viewThresholdImagePanel==NULL)
	{
		double range[2];
		_theViewPanel->getImageData()->GetScalarRange(range);
		int min = (int)floor (range[0]);
		int max = (int)ceil (range[1]);
		_viewThresholdImagePanel = new ThresholdImageViewPanel( parent, min, max , 1);
		_viewThresholdImage = new ThresholdImageView();
		_viewThresholdImage->SetImage( _theViewPanel->getImageData() );
		_viewThresholdImage->SetminMaxValue( min, max);
		_viewThresholdImage->SetBaseColor( 1,0,0 );
		_viewThresholdImagePanel->SetThresholdImageView( _viewThresholdImage );
		_viewThresholdImage->SetwxVtkBaseView( _theViewPanel->getWxVtkBaseView() );
	}
	return _viewThresholdImagePanel;
}

//CMRU 17-08-09-----------------------------------------------------------------------------------------------
int wxContourMainFrame::getType ()
{
	int tipo = 0;
	std::vector<std::string> currentSelection = _theViewPanel->getSelectedObjects();

	if(!currentSelection.empty())
	{
		std::string cloneName = currentSelection [0];
		manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(cloneName);
		tipo = manualModel-> GetTypeModel();
	}
	return tipo;
}

double wxContourMainFrame::getContourSizeInPixels()
{
	double contourSize = 0;

	std::vector<std::string> currentSelection = _theViewPanel->getSelectedObjects();	if(!currentSelection.empty())
	if(!currentSelection.empty())
	{
		std::string cloneName = currentSelection [0];

		manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(cloneName);//_modelManager->getOutlineByKeyName( cloneName )->getModel();
		contourSize = manualModel-> GetPathSize();
	}
	return contourSize;
}
manualBaseModel * wxContourMainFrame::getContour ()
{
	std::vector<std::string> currentSelection = _theViewPanel->getSelectedObjects();

	if(!currentSelection.empty())
	{
		std::string cloneName = currentSelection [0];
		manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(cloneName);//_modelManager->getOutlineByKeyName( cloneName )->getModel();
		return manualModel;
	}
	return NULL;
}
void wxContourMainFrame::onPrintLabel (wxString label, manualBaseModel* manualModel)
{
	std::string labelAscii(label.ToAscii());
	int pos = labelAscii.find(" ");

	int j;

	for (j=0 ; pos != string::npos;j++)
	{
		labelAscii.replace( pos, 1, "_" );
		pos= labelAscii.find(" ");
	}

	manualModel -> SetLabel(labelAscii);
}
void wxContourMainFrame::onInsertCalculation(manualBaseModel* manualModel)
{
	double sizeInPixel = manualModel ->GetPathSize();
	double onePixelRealSize = interfMainPanel::getInstance()->GetPixelValue();;
	double realContourSize = sizeInPixel*onePixelRealSize;
	manualModel ->SetRealSize(realContourSize);
}

double wxContourMainFrame::onePixelSize( double value)
{
	return _onePixelSize = value;
}

std::string wxContourMainFrame::GetFileLocation()
{
	return _fileLocation;
}

void wxContourMainFrame::SetFileLocation(std::string newFileLocation)
{
	_fileLocation = newFileLocation;
	std::cout<<"GETFILELOCATION:"<<_fileLocation<<std::endl;
}
//------------------------------------------------------------------------------------------------------------








void wxContourMainFrame::FlipSelectedContours(int flipDirection)
{
	printf("EED wxContourMainFrame::FlipSelectedContours  flipDirection=%d  \n",  flipDirection ); 
	FlipLstOfContours( 
	                    (std::vector<std::string>)_theViewPanel->getSceneManager()->getSelectedObjects() , 
	                    flipDirection
	                  );	
		
}

void wxContourMainFrame::FlipActualSliceContours(int flipDirection)
{
	printf("EED wxContourMainFrame::FlipActualSliceContours  flipDirection=%d  \n",  flipDirection );	
	FlipLstOfContours( 
	                    (std::vector<std::string>)_theViewPanel->getSceneManager()->GetlstContoursNameActualSlice() , 
	                    flipDirection
	                  );	
}

void wxContourMainFrame::FlipAllContours(int flipDirection)
{
	printf("EED wxContourMainFrame::FlipAllContours  flipDirection=%d  \n",  flipDirection );
	FlipLstOfContours( 
	                    kernelManager->GetLstNameThings() , 
	                    flipDirection
	                  );
}

void wxContourMainFrame::FlipLstOfContours(std::vector<std::string> lstNameThings, int flipDirection)
{
	int ext[6];
	getImageData()->GetExtent(ext); 	
	int sizeX = ext[1]-ext[0];
	int sizeY = ext[3]-ext[2];

	
	int i,sizeLstNameThings;
	int ii,sizeLstPoints;
	
	sizeLstNameThings	= lstNameThings.size();	
	for (i=0 ; i<sizeLstNameThings ; i++)
	{
		printf("EED wxContourMainFrame::FlipAllContours contour=%d \n", i );
		manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(lstNameThings[i]);
		if (flipDirection==0)
		{
			manualModel->Transform_Ax_Plus_B(-1,sizeX,1,0 );
		} else {
			manualModel->Transform_Ax_Plus_B(1,0,-1,sizeY );
		}
	}// for i  list of Things

	//-- Static Contours

	lstNameThings		= kernelManager->GetLstNameThingsStatic();
	sizeLstNameThings	= lstNameThings.size();
	for (i=0 ; i<sizeLstNameThings ; i++)
	{
		manualBaseModel * manualModel = kernelManager->getOutlineByKeyName(lstNameThings[i]);
		if (flipDirection==0)
		{
			manualModel->Transform_Ax_Plus_B(-1,sizeX,1,0 );
		} else {
			manualModel->Transform_Ax_Plus_B(1,0,-1,sizeY );
		}
	}// for i  list of static things	
}

void wxContourMainFrame::FlipContours(int typeContourFlip, int flipDirection)
{
	printf("EED wxContourMainFrame::FlipContours( %d , %d ) \n",typeContourFlip,  flipDirection );

	saveState();
	
	if (typeContourFlip==0) // 
	{
		FlipSelectedContours(flipDirection);
	}

	if (typeContourFlip==1) // 
	{
		FlipActualSliceContours(flipDirection);
	}
	
	if (typeContourFlip==2) // 
	{
		FlipAllContours(flipDirection);
	}
	RefreshInterface();
}





