/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "wxContourViewPanel.h"

#include "wxContourMainFrame.h"
//----------------------------------------------------------------------------------------------------------------
// Other includes
//----------------------------------------------------------------------------------------------------------------
//#include "ConceptDataWrap.h"

//this should be eliminated at some point
//#include "wxContourEventHandler.h"
//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file wxContourViewPanel.cxx */

//----------------------------------------------------------------------------------------------------------------
// Throwed Events definition
//----------------------------------------------------------------------------------------------------------------

DEFINE_EVENT_TYPE( wxINSTANT_CHANGE )


	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	/*{

		showingVID = theShowingImage;
		int gapH = 20;
		int gapV = 10;
		createHorizontalBar(1,80);
		createVerticalBar(1,200);
		createViewPanel();

		wxFlexGridSizer * panelSizer = new wxFlexGridSizer(3,1,0,0);
		panelSizer->AddSpacer(gapV);
		panelSizer -> AddGrowableCol(1);
		panelSizer->Add(theViewPanel, 1, wxEXPAND);
		panelSizer->AddSpacer(gapV);

		wxFlexGridSizer * downSizer = new wxFlexGridSizer(1,3,gapV,gapH);
		downSizer->Add(_verticalBar, 1, wxEXPAND);
		//downSizer->AddSpacer(gapH);
		downSizer -> AddGrowableCol(1);
		downSizer->Add(panelSizer, 1, wxEXPAND|wxALL|wxCENTER);
		//downSizer->AddSpacer(gapH);
		outSizer = new wxFlexGridSizer(3,1,1,1);
		outSizer->Add(_horizontalBar, 1, wxEXPAND);
		outSizer -> AddGrowableRow(1);
		outSizer -> AddGrowableCol(1);
		outSizer->Add(downSizer, 1, wxEXPAND);

		_horizontalBar->setDeviceBlitStart( _verticalBar->GetWidth() + gapH, gapV);
		_horizontalBar->setDeviceEndMargin( gapH+10 );

		//Connecting the events to the horizontal bar
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR,(wxObjectEventFunction) (wxCommandEventFunction) &wxContourViewPanel::onBarrange_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR_ACTUAL,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onActualChange_Bar_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR_START,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onStartChange_Bar_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onEndChange_Bar_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_SELECTION_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onSelectionEnd_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR_MOVED,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onMovedBar_Horizontal );

		//Connecting the events to the vertical bar
		Connect(_verticalBar->GetId(),wxEVT_TSBAR,(wxObjectEventFunction) (wxCommandEventFunction) &wxContourViewPanel::onBarrange_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_TSBAR_ACTUAL,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onActualChange_Bar_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_TSBAR_START,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onStartChange_Bar_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_TSBAR_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onEndChange_Bar_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_SELECTION_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onSelectionEnd_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_TSBAR_MOVED,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onMovedBar_Vertical );


		this->SetAutoLayout( true );
		SetSizer( outSizer );
		this->Layout();

		SetSize(900,700);
		theViewPanel->SetSize(800,600);
		theViewPanel->GetWindow(1)->SetSize(800,600);

		outSizer->Fit( this );
		SetBackgroundColour(wxColour(255,0,0));

	}*/
	//:wxScrolledWindow(parent, -1, pos, size, style)
	wxContourViewPanel :: wxContourViewPanel ( vtkImageData * theShowingImage, wxWindow *parent, const wxPoint& pos, const wxSize& size,long style, int vertStart, int vertEnd, int horzStart, int horzEnd )
	:wxPanel(parent, -1, pos, size, style)
	{
		theShowingImage->GetSpacing(last_spacing);
		showingVID = theShowingImage;
		int gapH = 20;
		int gapV = 10;
		_verticalConceptName = "";
		_horizontalConceptName = "";
		createHorizontalBar(1,80);
		createVerticalBar(1,200);
		createViewPanel();
		_eventHandler = NULL;

		wxFlexGridSizer * panelSizer = new wxFlexGridSizer(1, 4, gapV, gapH);
		panelSizer -> AddGrowableCol(2);
		panelSizer -> AddGrowableRow(2);
		panelSizer->Add(_verticalBar, 1, wxGROW);
		panelSizer->AddSpacer(gapV);
		panelSizer->Add(theViewPanel, 1, wxGROW);
		panelSizer->AddSpacer(gapV);

		outSizer = new wxFlexGridSizer(3, 1, gapH, gapV);
		outSizer -> AddGrowableCol(1);
		outSizer -> AddGrowableRow(1);
		outSizer->Add( _horizontalBar, 1, wxGROW);
		outSizer->Add( panelSizer, 1, wxGROW);
		outSizer->AddSpacer(gapH);

		_horizontalBar->setDeviceBlitStart( _verticalBar->GetWidth() + 2*gapH, gapV);
		_horizontalBar->setDeviceEndMargin( 2*gapH+10 );

		//Connecting the events to the horizontal bar
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR,(wxObjectEventFunction) (wxCommandEventFunction) &wxContourViewPanel::onBarrange_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR_ACTUAL,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onActualChange_Bar_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR_START,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onStartChange_Bar_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onEndChange_Bar_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_SELECTION_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onSelectionEnd_Horizontal );
		Connect(_horizontalBar->GetId(),wxEVT_TSBAR_MOVED,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onMovedBar_Horizontal );

		//Connecting the events to the vertical bar
		Connect(_verticalBar->GetId(),wxEVT_TSBAR,(wxObjectEventFunction) (wxCommandEventFunction) &wxContourViewPanel::onBarrange_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_TSBAR_ACTUAL,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onActualChange_Bar_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_TSBAR_START,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onStartChange_Bar_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_TSBAR_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onEndChange_Bar_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_SELECTION_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onSelectionEnd_Vertical );
		Connect(_verticalBar->GetId(),wxEVT_TSBAR_MOVED,(wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onMovedBar_Vertical );


		this->SetSizer( outSizer );
		this->SetAutoLayout( true );
		this->Layout();

		//SetSize(1900,1900);
		//theViewPanel->SetSize(800,600);
		//theViewPanel->GetWindow(1)->SetSize(800,600);

		//outSizer->Fit( this );

		initializeScenceManager();
	}


	wxContourViewPanel :: ~wxContourViewPanel()
	{
		delete _sceneManager;
	}

	void wxContourViewPanel::initializeScenceManager(){

		//_theViewPanel = theViewPanel;
		//_theViewPanel->setWxEventHandler( this );

		double spc[3];
		this->getSpacing(spc);
		_sceneManager		= new wxVtkBaseView_SceneManager ( this->getWxVtkBaseView(), this, spc  );

		Connect( this->GetId(), wxINSTANT_CHANGE, (wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onChangeInstant );
        Connect( wxID_ANY, wxEVT_START_CREATE_MULT_ROI, (wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onCreateMultipleROI );
		Connect( wxID_ANY, wxEVT_START_CREATE_ROI, (wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onCreateROI );
		Connect( wxID_ANY, wxEVT_STOP_CREATE_ROI, (wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onStopCreateROI );
		Connect( wxID_ANY, wxEVT_CHANGED_DEEP, (wxObjectEventFunction) (wxCommandEventFunction)  &wxContourViewPanel::onChangedDeep );
		Connect( wxID_ANY,  wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContourViewPanel :: onActionButtonPressed );

	}

	wxVtkBaseView_SceneManager* wxContourViewPanel::getSceneManager(){
		return _sceneManager;
	}

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

	void wxContourViewPanel :: setWxEventHandler( wxEvtHandler * theEventHandler )
	{
		_eventHandler = theEventHandler;
	}

	void wxContourViewPanel :: createHorizontalBar(int horzStart, int horzEnd)
	{
		_horizontalBar = new mBarRange(this, 1500,80);
		_horizontalBar -> setVisibleLabels (true);
		_horizontalBar -> setRepresentedValues (horzStart, horzEnd);
		_horizontalBar -> setActiveStateTo(true);
		_horizontalBar -> SetActual( horzStart );
		_horizontalBar -> setDeviceBlitStart (10,10);
		_horizontalBar -> setDeviceEndMargin (10);
	}

	void wxContourViewPanel :: createVerticalBar(int vertStart, int vertEnd)
	{
		_verticalBar = new mBarRange(this, 1500,40);
		_verticalBar -> SetOrientation(false);
		_verticalBar -> setVisibleLabels (false);
		_verticalBar -> setRepresentedValues (vertStart, vertEnd);
		_verticalBar -> setActiveStateTo(true);
		_verticalBar -> SetActual( vertStart );
		_verticalBar -> setDeviceBlitStart (10,10);
		_verticalBar -> setDeviceEndMargin (10);
	}
	//------------------------------------------------------------------------------------------------------------

	void wxContourViewPanel::createViewPanel()
	{
		std::vector<int> * numViews = new std::vector<int> ();
		numViews->push_back(0);
		theViewPanel = new wxMaracas_N_ViewersWidget( this, showingVID, numViews );
		SetVisibleAxis(false);

		theViewPanel->SetBackgroundColour(wxColour(0,0,0));

		theViewPanel->SetSize(800,600);
		theViewPanel->GetWindow(1)->SetSize(800,600);

	}
	//------------------------------------------------------------------------------------------------------------

	void wxContourViewPanel::changeImage(vtkImageData* img){

		theViewPanel->SetImage(img);

	}
	wxVtkMPR2DView * wxContourViewPanel::GetwxVtkMPR2DView()
	{
		return (wxVtkMPR2DView *) (theViewPanel->GetwxVtkBaseView(1));
	}

	//------------------------------------------------------------------------------------------------------------
	void wxContourViewPanel::SetVisibleAxis(bool ok)
	{
		GetwxVtkMPR2DView()->SetVisibleAxis(ok);
	}

	//------------------------------------------------------------------------------------------------------------
	int wxContourViewPanel::GetX()
	{
		return  GetwxVtkMPR2DView()->GetVtkmprbasedata()->GetX();
	}
	//------------------------------------------------------------------------------------------------------------
	int wxContourViewPanel::GetY()
	{
		return  GetwxVtkMPR2DView()->GetVtkmprbasedata()->GetY();
	}
	//------------------------------------------------------------------------------------------------------------
	int wxContourViewPanel::GetZ()
	{
		return  GetwxVtkMPR2DView()->GetVtkmprbasedata()->GetZ();
	}

	//------------------------------------------------------------------------------------------------------------
	void wxContourViewPanel::Refresh()
	{
		GetwxVtkMPR2DView()->GetRenWin()->Render();
	}


	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events from the horizontal bar
	//------------------------------------------------------------------------------------------------------------

	/**
	* Handles the event wxEVT_TSBAR from the horizontal bar
	*/
	void wxContourViewPanel :: onBarrange_Horizontal(wxCommandEvent& event)
	{

	}
	/**
	* Handles the event wxEVT_TSBAR_ACTUAL from the horizontal bar
	*/
	void wxContourViewPanel :: onActualChange_Bar_Horizontal(wxCommandEvent& event)
	{

		int actual = getActualHorizontal();

		wxContourMainFrame::getInstance()->onChangeInstant(_horizontalConceptName, actual);

		//JCP 26 - 11 - 08
		//int nxActual_h = getActualHorizontal();


		//if (_eventHandler!=NULL)
		//{
			//-------------------------------------------------
			//  Sending the event of wxINSTANT_CHANGE
			//-------------------------------------------------
		//	wxCommandEvent newevent(wxINSTANT_CHANGE,GetId());

		//	ConceptDataWrap * cWrap = new ConceptDataWrap( _horizontalConceptName );
		//	cWrap->setActualValue( nxActual_h );

		//	newevent.SetClientData( (void *)cWrap );
		//	_eventHandler->ProcessEvent(newevent);

		//}
		//JCP 26 - 11 - 08
	}
	/**
	* Handles the event wxEVT_TSBAR_START from the horizontal bar
	*/
	void wxContourViewPanel :: onStartChange_Bar_Horizontal(wxCommandEvent& event)
	{
//		int nxStart_h = getStartHorizontal();
	}
	/**
	* Handles the event wxEVT_TSBAR_END from the horizontal bar
	*/
	void wxContourViewPanel :: onEndChange_Bar_Horizontal(wxCommandEvent& event)
	{
//		int nxEnd_h = getEndHorizontal();
	}
	/**
	* Handles the event wxEVT_SELECTION_END from the horizontal bar
	*/
	void wxContourViewPanel :: onSelectionEnd_Horizontal(wxCommandEvent& event)
	{

	}
	/**
	* Handles the event wxEVT_TSBAR_MOVED from the horizontal bar
	*/
	void wxContourViewPanel :: onMovedBar_Horizontal(wxCommandEvent& event)
	{
//		int nxStart_h = getStartHorizontal();
//		int nxEnd_h = getEndHorizontal();
	}


	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events from the vertical bar
	//------------------------------------------------------------------------------------------------------------

	/**
	* Handles the event wxEVT_TSBAR from the vertical bar
	*/
	void wxContourViewPanel :: onBarrange_Vertical(wxCommandEvent& event)
	{

	}
	/**
	* Handles the event wxEVT_TSBAR_ACTUAL from the vertical bar
	*/
	void wxContourViewPanel :: onActualChange_Bar_Vertical(wxCommandEvent& event)
	{
		int actual = getActualVertical();
		wxContourMainFrame::getInstance()->onChangeInstant(_verticalConceptName, actual);
		//JCP 26 - 11 - 08
		/*
		int nxActual_v = getActualVertical();

		if (_eventHandler!=NULL)
		{
			//-------------------------------------------------
			//  Sending the event of wxINSTANT_CHANGE
			//-------------------------------------------------
			wxCommandEvent newevent(wxINSTANT_CHANGE,GetId());

			ConceptDataWrap * cWrap = new ConceptDataWrap( _verticalConceptName );
			cWrap->setActualValue( nxActual_v );

			newevent.SetClientData( (void *)cWrap );
			_eventHandler->ProcessEvent(newevent);
		}*/
		//JCP 26 - 11 - 08
	}
	/**
	* Handles the event wxEVT_TSBAR_START from the vertical bar
	*/
	void wxContourViewPanel :: onStartChange_Bar_Vertical(wxCommandEvent& event)
	{
//		int nxStart_v = getStartVertical();
	}
	/**
	* Handles the event wxEVT_TSBAR_END from the vertical bar
	*/
	void wxContourViewPanel :: onEndChange_Bar_Vertical(wxCommandEvent& event)
	{
//		int nxEnd_v = getEndVertical();
	}
	/**
	* Handles the event wxEVT_SELECTION_END from the vertical bar
	*/
	void wxContourViewPanel :: onSelectionEnd_Vertical(wxCommandEvent& event)
	{

	}
	/**
	* Handles the event wxEVT_TSBAR_MOVED from the vertical bar
	*/
	void wxContourViewPanel :: onMovedBar_Vertical(wxCommandEvent& event)
	{
//		int nxStart_v = getStartVertical();
//		int nxEnd_v = getEndVertical();
	}


	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------

	/**
	* Sets the represented values of the vertical bar
	* @param minRepresented In the minimum represented value of the bar
	* @param maxRepresented In the maximum represented value of the bar
	*/
	void wxContourViewPanel :: setVerticalRepresentedValues( int minRepresented, int maxRepresented )
	{
		if( _verticalBar != NULL && _useVerticalBar )
		{
			_verticalBar -> setRepresentedValues( minRepresented, maxRepresented );
		}
	}

	/**
	* Sets the represented values of the horizontal bar
	* @param minRepresented In the minimum represented value of the bar
	* @param maxRepresented In the maximum represented value of the bar
	*/
	void wxContourViewPanel :: setHorizontalRepresentedValues( int minRepresented, int maxRepresented )
	{
		if( _horizontalBar != NULL && _useHorizontalBar )
		{
			_horizontalBar -> setRepresentedValues( minRepresented, maxRepresented );
		}
	}

	/**
	* Gets the StartVertical value
	* @return The StartVertical
	*/
	int wxContourViewPanel :: getStartVertical()
	{
		return _verticalBar->GetActual();
	}
	/**
	* Gets the EndVertical value
	* @return The EndVertical
	*/
	int wxContourViewPanel :: getEndVertical()
	{
		return _verticalBar->GetEnd();
	}
	/**
	* Gets the ActualVertical value
	* @return The ActualVertical
	*/
	int wxContourViewPanel :: getActualVertical()
	{
		return _verticalBar->GetActual();//GetEnd();
	}

	/**
	* Sets the StartVertical value
	* @param nwValue The new value for the StartVertical
	*/
	void wxContourViewPanel :: setStartVertical( int nwValue )
	{
		 _verticalBar->SetEnd( nwValue );
	}
	/**
	* Sets the EndVertical value
	* @param nwValue The new value for the EndVertical
	*/
	void wxContourViewPanel :: setEndVertical( int nwValue )
	{
		 _verticalBar->SetEnd( nwValue );
	}
	/**
	* Sets the ActualVertical value
	* @param nwValue The new value for the ActualVertical
	*/
	void wxContourViewPanel :: setActualVertical( int nwValue )
	{
		 _verticalBar->SetActual( nwValue );
	}

	/**
	* Gets the StartHorizontal value
	* @return The StartHorizontal
	*/
	int wxContourViewPanel :: getStartHorizontal()
	{
		return _horizontalBar->GetStart();
	}
	/**
	* Gets the EndHorizontal value
	* @return The EndHorizontal
	*/
	int wxContourViewPanel :: getEndHorizontal()
	{
		return _horizontalBar->GetEnd();
	}
	/**
	* Gets the ActualHorizontal value
	* @return The ActualHorizontal
	*/
	int wxContourViewPanel :: getActualHorizontal()
	{
		return _horizontalBar->GetActual();
	}

	/**
	* Sets the StartHorizontal value
	* @param nwValue The new value for the StartHorizontal
	*/
	void wxContourViewPanel :: setStartHorizontal( int nwValue )
	{
		_horizontalBar->SetStart( nwValue );
	}
	/**
	* Sets the EndHorizontal value
	* @param nwValue The new value for the EndHorizontal
	*/
	void wxContourViewPanel :: setEndHorizontal( int nwValue )
	{
		_horizontalBar->SetEnd( nwValue );
	}
	/**
	* Sets the ActualHorizontal value
	* @param nwValue The new value for the ActualHorizontal
	*/
	void wxContourViewPanel :: setActualHorizontal( int nwValue )
	{
		_horizontalBar->SetActual( nwValue );
	}

	/**
	* Sets the horizontal concept values and name
	* @param theHorizontalConcept The name of the concept for setting at the horizontal bar
	* @param minRepresent The minRepresent value of the concept for setting at the horizontal bar
	* @param maxRepresent The maxRepresent value of the concept for setting at the horizontal bar
	* @param minShowed The minShowed value of the concept for setting at the horizontal bar
	* @param maxShowed The maxShowed value of the concept for setting at the horizontal bar
	* @param actualShow The actualShow value of the concept for setting at the horizontal bar
	*/
	void wxContourViewPanel :: setHorizontalConcept( std::string theHorizontalConcept, int minRepresent, int maxRepresent, int minShowed, int maxShowed, int actualShow )
	{
		setHorizontalConceptName( theHorizontalConcept );
		setHorizontalRepresentedValues( minRepresent, maxRepresent );
		setActualHorizontal( actualShow );
		setStartHorizontal( minShowed );
		setEndHorizontal( maxShowed );
	}

	/**
	* Sets the vertical concept values and name
	* @param theVerticalConcept The name of the concept for setting at the vertical bar
	* @param minRepresent The minRepresent value of the concept for setting at the vertical bar
	* @param maxRepresent The maxRepresent value of the concept for setting at the vertical bar
	* @param minShowed The minShowed value of the concept for setting at the vertical bar
	* @param maxShowed The maxShowed value of the concept for setting at the vertical bar
	* @param actualShow The actualShow value of the concept for setting at the vertical bar
	*/
	void wxContourViewPanel :: setVerticalConcept( std::string theVerticalConcept, int minRepresent, int maxRepresent, int minShowed, int maxShowed, int actualShow )
	{
		setVerticalConceptName( theVerticalConcept );
		setVerticalRepresentedValues( minRepresent, maxRepresent );
		setActualVertical( actualShow );
		setStartVertical( minShowed );
		setEndVertical( maxShowed );
	}


	/**
	* Sets the horizontal concept name
	* @param theHorizontalConcept The name of the concept for setting at the horizontal bar
	*/
	void wxContourViewPanel :: setHorizontalConceptName( std::string theHorizontalConcept )
	{
		_horizontalConceptName = theHorizontalConcept;
	}

	/**
	* Gets the horizontal concept name
	* @return _horizontalConceptName The name of the concept for setting at the horizontal bar
	*/
	std::string wxContourViewPanel :: getHorizontalConceptName(  )
	{
		return _horizontalConceptName;
	}

	/**
	* Sets the vertical concept name
	* @param theVerticalConcept The name of the concept for setting at the vertical bar
	*/
	void wxContourViewPanel :: setVerticalConceptName( std::string theVerticalConcept )
	{
		_verticalConceptName = theVerticalConcept;
	}

	/**
	* Gets the vertical concept name
	* @return _verticalConceptName The name of the concept for setting at the vertical bar
	*/
	std::string wxContourViewPanel :: getVerticalConceptName(  )
	{
		return _verticalConceptName;
	}

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	void wxContourViewPanel :: getSpacing( double * spacing  )
	{
		spacing[0] = last_spacing[0];
		spacing[1] = last_spacing[1];
		spacing[2] = last_spacing[2];
	}

	wxVtkBaseView* wxContourViewPanel :: getWxVtkBaseView()
	{
		return theViewPanel->GetwxVtkBaseView(1);
	}

	double wxContourViewPanel :: getCurrentDeep()
	{
//EED 08/04/2008
//		return theViewPanel->GetZ(1);
		return theViewPanel->GetZ();
		//return GetZ();
	}


	bool wxContourViewPanel::isEditableCControler(std::string theKeyName){
		return _sceneManager->isEditableCControler(theKeyName);
	}

	void wxContourViewPanel::removeFromScene(std::string theKeyName){

		_sceneManager->deleteCViewerCControler(theKeyName);


	}

	void wxContourViewPanel::onChangeInstant(wxCommandEvent& event){
		ConceptDataWrap * dataConcept = NULL;
		if ( GetId() == event.GetId() )
		{
			dataConcept = (ConceptDataWrap *)event.GetClientData();
			int value = dataConcept->getActualValue();
			//_instantPanel->setConceptValue( dataConcept->getName(), value );
			wxContourMainFrame::getInstance()->setConceptValue( dataConcept->getName(), value );
		}
		else
		{
			dataConcept = wxContourMainFrame::getInstance()->getLastConceptData();
			if( dataConcept->getName().compare( getVerticalConceptName() ) == 0)
			{
				setActualVertical( dataConcept->getActualValue());
				//_theViewPanel->setVerticalConcept( dataConcept->getName(), dataConcept->getMinShowedValue()/*dataConcept->getMinValue()*/, /*dataConcept->getMaxValue()*/ dataConcept->getMaxShowedValue(), dataConcept->getMinShowedValue(), dataConcept->getMaxShowedValue(), dataConcept->getActualValue());
			}
			else if( dataConcept->getName().compare( getHorizontalConceptName() ) == 0|| wxContourMainFrame::getInstance()->getIfConceptCheckedAt( dataConcept->getName(), 0 ) )
			{
				setHorizontalConcept( dataConcept->getName(), dataConcept->getMinShowedValue()/*dataConcept->getMinValue()*/, /*dataConcept->getMaxValue()*/ dataConcept->getMaxShowedValue(), dataConcept->getMinShowedValue(), dataConcept->getMaxShowedValue(), dataConcept->getActualValue());
			}
		}
		wxContourMainFrame::getInstance()->changeInstant();
	}

	void wxContourViewPanel::onCreateMultipleROI (wxCommandEvent& event){
	}
	void wxContourViewPanel::onCreateROI (wxCommandEvent& event){
	}
	void wxContourViewPanel::onStopCreateROI (wxCommandEvent& event){
	}
	void wxContourViewPanel::onChangedDeep (wxCommandEvent& event){
		double val = getCurrentDeep();
		//setActualVertical( (int)val );
		wxContourMainFrame::getInstance()->onChangeDeep((int)val);
		//_instantPanel->setConceptValue( "Axe Depth", (int)val );

//		changeInstant();
	}
	void wxContourViewPanel::changeDeep(){
		double val = getCurrentDeep();
		setActualVertical( (int)val );
	}
	void wxContourViewPanel::onActionButtonPressed(wxCommandEvent& event){


		std::vector<std::string> currentSelection = _sceneManager->getSelectedObjects();
//		int elementsSelected = currentSelection.size();
		bool ctrlKey = _sceneManager->isCtrlPressed();
		char toolCommand = _sceneManager->getLastKeyCode();


		if ( toolCommand == 3 && ctrlKey ) //'C' || 'c'
		{
			wxContourMainFrame::getInstance()->onCopy();
		}
		else if(  toolCommand == 22 && ctrlKey ) //'V' || 'v'
		{
			wxContourMainFrame::getInstance()->onPaste();
		}
		else if(  toolCommand == 8 || (toolCommand==127) ) // backspace Delete
		{
			wxContourMainFrame::getInstance()->onDeleteContour();
		}
		else if(  toolCommand == 14 && ctrlKey ) //'N' || 'n'
		{
			//toolCommand = &(CREATE_CONTOUR_KEY);
		}
		else if(  toolCommand == 15 && ctrlKey ) //'O' || 'o'
		{
			wxContourMainFrame::getInstance()->onLoad();
		}
		else if(  toolCommand == 19 && ctrlKey ) //'S' || 's'
		{
			wxContourMainFrame::getInstance()->saveFileWithContoursAutomatique();
		}else if( toolCommand == 26 ){
			wxContourMainFrame::getInstance()->onUndo();
		}else if( toolCommand == 25 ){
			wxContourMainFrame::getInstance()->onRedo();
		}
	}

	void wxContourViewPanel::removeSceneContours(){
		_sceneManager->removeSceneContours();
	}

	void wxContourViewPanel::addNameWrapperToScene(){
		int size = wxContourMainFrame::getInstance()->getNamesWrappingSize();
		for(int i = 0; i < size;i++){
			std::string name = wxContourMainFrame::getInstance()->getNameWrapping(i);
			_sceneManager->addToScene(name, true, true, true, false, false );
		}
	}

	std::vector<std::string> wxContourViewPanel::getSelectedObjects(){
		return _sceneManager->getSelectedObjects();
	}

	void wxContourViewPanel::RefreshInterface(){
		getWxVtkBaseView()->Refresh();
	}

	vtkImageData* wxContourViewPanel::getImageData(){
		return _sceneManager->GetImageData();
	}

	void wxContourViewPanel::configureViewControlTo(std::string theName,manualBaseModel* manModelContour,double* spc,int typeofcontour)
	{
		_sceneManager->configureViewControlTo(theName, manModelContour, spc, typeofcontour);
	}

	int wxContourViewPanel::GetImageDataSizeZ()
	{
		return _sceneManager->GetImageDataSizeZ();
	}

	void wxContourViewPanel::GetImageDataRange(double *range)
	{
		_sceneManager->GetImageDataRange(range);
	}

	void wxContourViewPanel::SetWidthContour(double width )
	{
		_sceneManager->SetWidthContour( width );
	}

	int wxContourViewPanel::getColorWindow()
	{
		wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)getWxVtkBaseView();
		vtkImageViewer2 *imageviewer = wxvtk2dbaseview->_imageViewer2XYZ->GetVtkImageViewer2();
		int colorwindow = (int)imageviewer->GetWindowLevel()->GetLevel();
		return colorwindow;
	}

	int wxContourViewPanel::getWindowLevel()
	{
		wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)getWxVtkBaseView();
		vtkImageViewer2 *imageviewer = wxvtk2dbaseview->_imageViewer2XYZ->GetVtkImageViewer2();
		int windowlevel = (int)imageviewer->GetWindowLevel()->GetWindow();
		return windowlevel;
	}

	void wxContourViewPanel::onBrigthnessColorWindowLevel(int colorwindow,int windowlevel)
	{
		wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)getWxVtkBaseView();
		vtkImageViewer2 *imageviewer = wxvtk2dbaseview->_imageViewer2XYZ->GetVtkImageViewer2();
		imageviewer->SetColorWindow(colorwindow);
		imageviewer->SetColorLevel(windowlevel);
	}

	void wxContourViewPanel::onInterpolation(bool interpolate)
	{
		wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)getWxVtkBaseView();
		vtkImageViewer2 *imageviewer = wxvtk2dbaseview->_imageViewer2XYZ->GetVtkImageViewer2();

		if (interpolate){
			imageviewer->GetImageActor()->InterpolateOn();
		} else {
			imageviewer->GetImageActor()->InterpolateOff();
		}
	}

	void wxContourViewPanel::GetPointsOfActualContour( std::vector<double> *vecX, std::vector<double> *vecY, std::vector<double> *vecZ )
	{
		_sceneManager->GetPointsOfActualContour(vecX, vecY, vecZ);
	}

	void wxContourViewPanel::setImageSlice(int z){
		vtkInteractorStyleBaseView* stylebaseview = (vtkInteractorStyleBaseView*) _sceneManager->getWxVtkViewBase()->GetInteractorStyleBaseView();
		wxVtk2DBaseView* baseview = (wxVtk2DBaseView*)stylebaseview->GetWxVtk2DBaseView();
		baseview->SetActualSlice(z);
		RefreshInterface();
	}

