/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "wxContour_ButtonsBar.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file wxConceptControl.cxx */


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include "wxContour_ActionCommandsID.h"

#include <string>
#include "wx/toolbar.h"
#include "wx/log.h"
#include "wx/image.h"
#include "wx/filedlg.h"
#include "wx/spinctrl.h"
#include "wx/srchctrl.h"
#include <wx/wx.h>
//------------------------------------------------------------------------------------------------------------
// Generated events declaration and definition
//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

	wxContour_ButtonsBar :: wxContour_ButtonsBar( wxWindow* parent, wxWindowID id, const wxPoint& pos , const wxSize& size, long style, const wxString& name )
	//:wxToolBar(parent, id, pos, size, style, name)
	:wxPanel( parent, id)//, pos, size, style, name)
	{
		//SetToolBitmapSize(wxSize(16,16));
	std::string as = (char)wxContour_ActionCommandsID::CREATE_TOOL +"";
        _createContour_Button = new wxButton( this, -1, _T("+ New Contour"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator, wxString(as.c_str(),wxConvUTF8));
//		_createContour_Button->SetToolTip(_T("CTRL-N"));
		Connect( _createContour_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		as = (char)wxContour_ActionCommandsID::DELETE_TOOL +"";
		_delete_Button = new wxButton( this, -1, _T("+ Delete"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
		_delete_Button->SetToolTip(_T("BACK SPACE or DELETE key"));
		Connect( _delete_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

/*		
		_hideContour_Button = new wxButton( this, -1, "Hide Contour", wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator, wxContour_ActionCommandsID::HIDE_TOOL );
		Connect( _hideContour_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		_show_Button = new wxButton( this, -1, _T("Show"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator, wxContour_ActionCommandsID::SHOW_TOOL );
		Connect( _show_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 
*/
		as = (char)wxContour_ActionCommandsID::COPY_TOOL +"";
		_copy_Button = new wxButton( this, -1, _T("Copy"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
		_copy_Button->SetToolTip(_T("CTRL-C"));
		Connect( _copy_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		as = (char)wxContour_ActionCommandsID::PASTE_TOOL +"";
		_paste_Button = new wxButton( this, -1, _T("Paste"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
		_paste_Button->SetToolTip(_T("CTRL-V"));
		Connect( _paste_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		as = (char)wxContour_ActionCommandsID::CHANGE_TOOL +"";
		_change_Button = new wxButton( this, -1, _T("    <-->  "), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
		_change_Button->SetToolTip(_T("CTRL-K"));
		Connect( _change_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		as = (char)wxContour_ActionCommandsID::SAVE_TOOL +"";
		_save_Button = new wxButton( this, -1, _T("Save"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
		_save_Button->SetToolTip(_T("CTRL-S"));
		Connect( _save_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		as = (char)wxContour_ActionCommandsID::OPEN_TOOL +"";
		_open_Button = new wxButton( this, -1, _T("Open"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
		_open_Button->SetToolTip(_T("CTRL-O"));
		Connect( _open_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		as = (char)wxContour_ActionCommandsID::SPREAD_TOOL +"";
		_spread_Button = new wxButton( this, -1, _T("+ Spread"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
//		_spread_Button->SetToolTip(_T("CTRL-XXXXXXX"));
		Connect( _spread_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		as = (char)wxContour_ActionCommandsID::AUTOMATIQUESEGMENTATION_TOOL +"";
		_automatiqueSegmentation_Button = new wxButton( this, -1, _T("+ Segmentation"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
//		_automatiqueSegmentation_Button->SetToolTip(_T("CTRL-XXXXXXX"));
		Connect( _automatiqueSegmentation_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		as = (char)wxContour_ActionCommandsID::INFORMATIONCONTOUR_TOOL +"";
		_informationContour_Button = new wxButton( this, -1, _T("+ Information"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
//		_informationContour_Button->SetToolTip(_T("CTRL-XXXXXXX"));
		Connect( _informationContour_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		as = (char)wxContour_ActionCommandsID::INTERFACECONFIGURATION_TOOL +"";
		_interfaceConfiguration_Button = new wxButton( this, -1, _T("+ Configuration"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
//		_informationContour_Button->SetToolTip(_T("CTRL-XXXXXXX"));
		Connect( _interfaceConfiguration_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 


//Test button Methods A-B-C in  Juan Carlos Prieto 22-09-08
		as = (char)wxContour_ActionCommandsID::TEST_TOOL +"";
		_interfaceTest_Button = new wxButton( this, -1, _T("+ Test"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator,  wxString(as.c_str(),wxConvUTF8));
//		_informationContour_Button->SetToolTip(_T("CTRL-XXXXXXX"));
		Connect( _interfaceTest_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 


/*
		_spread_Button = new wxButton( this, -1, _T("Spread"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator, wxContour_ActionCommandsID::SPREAD_TOOL );
		Connect( _spread_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 
		_select_Button = new wxButton( this, -1, _T("Select"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator, wxContour_ActionCommandsID::SELECT_TOOL );
		Connect( _select_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		_edit_Button = new wxButton( this, -1, _T("Edit"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator, wxContour_ActionCommandsID::EDIT_TOOL );
		Connect( _edit_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		_undo_Button = new wxButton( this, -1, _T("Undo"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator, wxContour_ActionCommandsID::UNDO_TOOL );
		Connect( _undo_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 

		_redo_Button = new wxButton( this, -1, _T("Redo"), wxDefaultPosition, wxDefaultSize, 0,wxDefaultValidator, wxContour_ActionCommandsID::REDO_TOOL );
		Connect( _redo_Button->GetId(),   wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxContour_ButtonsBar:: onActionButtonPressed ); 
*/
		wxFlexGridSizer * panelSizer = new wxFlexGridSizer(9);
		panelSizer -> Add( _createContour_Button, 1, wxGROW );
/*
		panelSizer -> Add( _hideContour_Button, 1, wxGROW );
		panelSizer -> Add( _show_Button, 1, wxGROW );
*/
		panelSizer -> Add( _change_Button	, 1, wxGROW );
		panelSizer -> Add( _copy_Button		, 1, wxGROW );
		panelSizer -> Add( _paste_Button	, 1, wxGROW );
		panelSizer -> Add( _delete_Button	, 1, wxGROW );
		panelSizer -> Add( _save_Button		, 1, wxGROW );
		panelSizer -> Add( _open_Button		, 1, wxGROW );
		panelSizer -> Add( _spread_Button	, 1, wxGROW );
		panelSizer -> Add( _automatiqueSegmentation_Button	, 1, wxGROW );
		panelSizer -> Add( _informationContour_Button		, 1, wxGROW );
		panelSizer -> Add( _interfaceConfiguration_Button	, 1, wxGROW );
		panelSizer -> Add( _interfaceTest_Button	, 1, wxGROW );
		
/*
		panelSizer -> Add( _select_Button, 1, wxGROW );
		panelSizer -> Add( _edit_Button, 1, wxGROW );
		panelSizer -> Add( _undo_Button, 1, wxGROW );
		panelSizer -> Add( _redo_Button, 1, wxGROW );
*/
		
		SetSizer( panelSizer );
/*
		this->AddControl( _createContour_Button );
		AddSeparator();
		this->AddControl( _hideContour_Button );
*/
		SetSize( wxSize( 1500, 80));
		this->SetAutoLayout( true );
		this->Layout();		
	}

	wxContour_ButtonsBar :: ~wxContour_ButtonsBar(  )
	{
		_eventHandler = NULL;
		/*delete	_createContour_Button;
		delete  _delete_Button;
		delete  _hideContour_Button;
		delete  _show_Button;
		delete  _copy_Button;
		delete  _paste_Button;
		delete  _spread_Button;
		delete  _select_Button;
		delete  _edit_Button;
		delete  _undo_Button;
		delete  _redo_Button;*/		
	}
	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events
	//------------------------------------------------------------------------------------------------------------
	void wxContour_ButtonsBar :: onActionButtonPressed( wxCommandEvent& event )
	{
		if(_eventHandler!=NULL)
		{
			std::string theStr = std::string( ((wxButton *)event.GetEventObject())->GetName().ToAscii());
			const char * toolCommand = theStr.c_str();
			event.SetId( GetId() );
			event.SetEventObject( this );
			event.SetClientData( (void *) toolCommand);
			_eventHandler->ProcessEvent( event );
		}
	}		
	
	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------
	void wxContour_ButtonsBar :: sendEnvent( WXTYPE theEventType )
	{
		wxCommandEvent cevent( theEventType, GetId() );
		cevent.SetEventObject( this );
		_eventHandler->ProcessEvent( cevent );
	}


	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------

	
	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

	void wxContour_ButtonsBar :: setWxEventHandler( wxEvtHandler * theEventHandler )
	{
		_eventHandler = theEventHandler;
	}
	
	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------
	

