/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "wxInstantChooserPanel.h"
#include "wxContourMainFrame.h"

//Test JCP 13-10-08
//#include "wxContourEventHandler.h"
//Test JCP 13-10-08

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------

//----------------------------------------------------------------------------------------------------------------
// Throwed Events definition
//----------------------------------------------------------------------------------------------------------------


DEFINE_EVENT_TYPE( wxINSTANT_CHOOSER_CHANGE )
	

/** @file wxInstantChooserPanel.cxx */

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	


	wxInstantChooserPanel :: wxInstantChooserPanel (wxWindow * parent, std::string title, bool theOrientation, bool resolutionALL,std::string configurationElem, std::string groupConfig )
	:wxPanel(parent, -1, wxPoint(20,20), wxDefaultSize, wxTAB_TRAVERSAL)
	{
		_lastConceptUpdated = NULL;		
		_concepts = new std::vector<wxConceptControl*>();
		_resolutionOverALL = resolutionALL;
		_configuration = configurationElem;
		//--- groupConfig -> format: ("## ## # ## "), #:any positive integer number, : space needed between the numbers and at the end of the string.
		setVerticalMaxSelectedNums( groupConfig );
		
		//_configuration = "CCCc";
		//setVerticalMaxSelectedNums( "1 2 3 3 ");//groupConfig );

		SetSize(300,300);
		_outSizer = new wxFlexGridSizer ( 1, 10, 10);
		_orientation = theOrientation;
		initializeResolutionSlider();
		_actualInstant=new std::map<std::string,int>();
		
		wxFlexGridSizer * resolutionSizer = new wxFlexGridSizer( 3,1,10,10 );
		resolutionSizer->AddSpacer(10);
		resolutionSizer->Add( _resolutionSlider, 1, wxEXPAND | wxGROW );
		resolutionSizer->AddSpacer(10);
		
		wxFlexGridSizer * sizer = new wxFlexGridSizer( 1,2,10,10 );
		sizer->Add( _outSizer, 1, wxEXPAND| wxGROW );
		sizer->Add( resolutionSizer, 1, wxEXPAND | wxGROW );
		SetSizer( sizer );
		Connect( wxID_ANY,  wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxInstantChooserPanel:: onCheckBoxClicked ); 		

	}

	wxInstantChooserPanel ::wxInstantChooserPanel (wxWindow * parent,wxWindowID id ,std::string title, const wxPoint& pos, const wxSize& size , bool theOrientation, std::string configurationElem , std::string groupConfig  )
		:wxPanel(parent, id ,pos, size)	
	{
		_lastConceptUpdated = NULL;		
		_concepts = new std::vector<wxConceptControl*>();
		_resolutionOverALL = false;
		_configuration = configurationElem;
		//--- groupConfig -> format: ("## ## # ## "), #:any positive integer number, : space needed between the numbers and at the end of the string.
		setVerticalMaxSelectedNums( groupConfig );
		
		SetSize(size);
		_outSizer = new wxFlexGridSizer ( 1, 10, 10);
		_orientation = theOrientation;
		initializeResolutionSlider();
		_actualInstant=new std::map<std::string,int>();
		wxFlexGridSizer * sizer = new wxFlexGridSizer( 1,2,10,10 );
		sizer->Add( _outSizer, 1, wxEXPAND| wxGROW );
		sizer->Add( _resolutionSlider, 1, wxEXPAND | wxGROW );
		SetSizer( sizer );
		Connect( wxID_ANY,  wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxInstantChooserPanel:: onCheckBoxClicked ); 		
	}

	wxInstantChooserPanel :: ~wxInstantChooserPanel()
	{
		int size,i;
		//deleting the _concepts
		if(_concepts!=NULL)
		{
			size=_concepts->size();
			for(i=0; i< size ; i++)
				{
					delete (*_concepts)[i];
				}
			_concepts->clear();
		}
		_verticalMaxSelected.clear();
		//deleting the actual instant
		_actualInstant->clear();
	}

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------
	
	/**
	* Adds a concept to the instant managment. PRE: The concept doesn't exists in the included _concepts->
	* @param aConceptName 
	* @param minV
	* @param maxV
	* @param actualV
	*/
	void wxInstantChooserPanel :: addConcept(std::string aConceptName, int minV, int maxV, int actualV)
	{
		wxConceptControl * nwConcept = new wxConceptControl(this, _orientation, minV, maxV, actualV, aConceptName, _configuration);
		_concepts->push_back( nwConcept );
		_lastConceptUpdated = nwConcept;
		_outSizer->Add(nwConcept, wxEXPAND);
		Connect(nwConcept->GetId(), wxEVT_CONCEPT_RELEASE, (wxObjectEventFunction) (wxCommandEventFunction)  &wxInstantChooserPanel::onConceptRelease );
	}

	void wxInstantChooserPanel :: setWxEventHandler( wxEvtHandler * theEventHandler )
	{
		_eventHandler = theEventHandler;
	}

	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: onResolutionSlider(wxScrollEvent& event)
	{
		std::string lasConcept = _lastConceptUpdated->getName();
		int value = _lastConceptUpdated->getActualValue();
		int min = _lastConceptUpdated->getMinValue();
		int max = _lastConceptUpdated->getMaxValue();
		int delta = (int) (pow((double) 2, _resolutionSlider->GetValue() ));
		int minTmp   = value - delta/2;
		int maxTmp   = value + delta/2;
		if (minTmp<min)
			{
				minTmp = min;	
			}
		if (maxTmp>max)
			{
				maxTmp = max;
			}			
		_lastConceptUpdated->setRange( minTmp,maxTmp );

		if (! _resolutionOverALL)
		{
			changeResolutionAtConceptControl( _lastConceptUpdated );
		}
		else
		{
			for(int i=0; i< (int)(_concepts->size()); i++)
			{
				changeResolutionAtConceptControl( (*_concepts)[i] );
			}
		}		

	}
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: onCheckBoxClicked( wxCommandEvent& event )
	{
		/*int groupID = (int)event.GetClientData();
		wxConceptControl * eventConcept = (wxConceptControl *)event.GetEventObject();
		if ( eventConcept->getIfChecked( groupID ) )
		{
			int i,size = _concepts->size();
			wxConceptControl * aConcept = NULL;
			int accum = 0;		
			for( i=0; i<size; i++)
			{
				accum+= (*_concepts)[i]->getIfChecked( groupID ) ? 1 :0;
			}		
			for( i=0; i<size && _verticalMaxSelected[groupID] < accum; i++)
			{
				aConcept = (*_concepts)[i]; 
				if( aConcept!= eventConcept )
				{
					if( aConcept->getIfChecked( groupID ) )
					{	
						aConcept->clearCheckAt( groupID );
						accum--;
					}					
				}
			}					
		}*/

		int groupID = *(int*)event.GetClientData();
		wxConceptControl * eventConcept = (wxConceptControl *)event.GetEventObject();
		if ( eventConcept->getIfChecked( groupID ) )
		{
			int size = _concepts->size();
			wxConceptControl * aConcept = NULL;
//			int accum = 0;

			for(int i = 0; i < eventConcept->getNumCheckBox();i++){
				if(i!=groupID){
					eventConcept->clearCheckAt(i);
				}
			}
			for(int i=0; i<size; i++)
			{
				aConcept = (*_concepts)[i]; 
				if( aConcept!= eventConcept )
				{
					if( aConcept->getIfChecked( groupID ) )
					{	
						aConcept->clearCheckAt( groupID );
					}					
				}
			}			
		}
	}

	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: onConceptRelease( wxCommandEvent& event )
	{
		_lastConceptUpdated = (wxConceptControl*) event.GetEventObject();

		std::vector<int> theInstant;
        getInstant( theInstant );
		//-------------------------------------------------
		//  Sending the event of wxINSTANT_CHOOSER_CHANGE
		//-------------------------------------------------
		wxCommandEvent newevent(wxINSTANT_CHOOSER_CHANGE,GetId());  
		//this->onChangeInstant(newevent);
		ConceptDataWrap * dataConcept = getLastConceptData(); 
		if(getIfConceptCheckedAt( dataConcept->getName(), 0 )){
			wxContourMainFrame::getInstance()->onChangeInstantInstantPanel(dataConcept->getName(), dataConcept->getActualValue(), dataConcept->getMinShowedValue(), dataConcept->getMaxShowedValue());
		}
		//((wxContourEventHandler*)_eventHandler)->onChangeInstant(newevent);
		//_eventHandler->ProcessEvent(newevent);
	}

	void wxInstantChooserPanel :: onChangeInstant( wxCommandEvent& event ){
		
	}

	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------
		
	ConceptDataWrap * wxInstantChooserPanel :: getLastConceptData()
	{
		ConceptDataWrap * conceptData = new ConceptDataWrap();
		if( _lastConceptUpdated != NULL)
		{
			conceptData -> fillData( _lastConceptUpdated->getName(), _lastConceptUpdated->getMinValue(), _lastConceptUpdated->getMaxValue(), _lastConceptUpdated->getMinShowedValue(), _lastConceptUpdated->getMaxShowedValue(), _lastConceptUpdated->getActualValue());
		}
		return conceptData;
	}

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	void wxInstantChooserPanel :: setInstant(std::vector<int> choiceInstant)
	{		
		int max = _concepts->size();
		if( (int)(choiceInstant.size()) == max )
		{
			int i = 0;
			while(i< max)
			{
				(*_concepts)[i]->setActualValue( choiceInstant[i] );
				i++;
			}
		}
	}
	
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: getInstant(std::vector<int> & choiceInstant)
	{
		if(_concepts!=NULL)
		{
			int i = 0;

			int size=_concepts->size();
			while( i< size )
			{
				choiceInstant.push_back( ((*_concepts))[i]->getActualValue());
				i++;
			}
		}		
	}
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: setInstant(std::map<std::string,int>* _actualInstant )
	{
		int size,i;
		size=_concepts->size();
		std::map<std::string,int>::iterator iteratorActualInstant;
		wxConceptControl* concepti;
		std::string nameConcepti;
		for(i=0;i<size;i++)
		{
			concepti=(*_concepts)[i];
			nameConcepti=concepti->getName();
			iteratorActualInstant=_actualInstant->find(nameConcepti);
			if(iteratorActualInstant!=_actualInstant->end())
			{
				int actualValue=iteratorActualInstant->second;
				concepti->setActualValue(actualValue);
			}
			nameConcepti.clear();
		}
	}
	//------------------------------------------------------------------------------------------------------------
	std::map<std::string,int>* wxInstantChooserPanel :: getInstantData()
	{
		int size,i=0;	
		wxConceptControl* concepti;
		if(_concepts!=NULL)
		{
			bool isEmpty=_actualInstant->empty();
			if(!isEmpty) _actualInstant->clear();
			size=_concepts->size();
			while( i< size )
			{
				concepti=(*_concepts)[i];
				_actualInstant->insert(std::pair<std::string,int>(concepti->getName(),concepti->getActualValue()));
				i++;
			}
		}
		return _actualInstant;		
	}
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: getInstantData(std::map<std::string,int> & choiceInstantData)
	{
		int i = 0,size;
		size=_concepts->size();
		while(i< size)
		{
			choiceInstantData.insert(std::pair < std::string, int> ((*_concepts)[i]->getName(), (*_concepts)[i]->getActualValue()));
			i++;
		}
	}
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: setResolutionRangeWithLasUpdate()
	{
		int minShow = _lastConceptUpdated->getMinShowedValue();
		int maxShow = _lastConceptUpdated->getMaxShowedValue();
		_resolutionSlider->SetRange( minShow, maxShow );
	}

	
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: refreshConceptLabels()
	{
		
	}
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: setConfiguration(std::string aConfiguration)
	{
		_configuration = aConfiguration;
	}
	//------------------------------------------------------------------------------------------------------------
	std::string wxInstantChooserPanel :: getConfiguration()
	{
		return _configuration;
	}
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: setResolutionOverAll( bool condition )
	{
		_resolutionOverALL = condition;
	}
	//------------------------------------------------------------------------------------------------------------
	bool wxInstantChooserPanel :: getIfResolutionOverAll()
	{
		return _resolutionOverALL;
	}

   //------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: initializeResolutionSlider()
	{	
		_resolutionSlider = new wxSlider(this , -1,5,1,8,wxDefaultPosition, wxSize(25,45), wxSL_LEFT | wxSL_AUTOTICKS  );		
		Connect( _resolutionSlider->GetId(), wxEVT_COMMAND_SLIDER_UPDATED, wxScrollEventHandler(wxInstantChooserPanel::onResolutionSlider));//(wxObjectEventFunction) &wxInstantChooserPanel::onResolutionSlider ); 
	}
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: changeResolutionAtConceptControl( wxConceptControl * theConceptToUpdate )
	{
		int value = theConceptToUpdate->getActualValue();
		int min = theConceptToUpdate->getMinValue();
		int max = theConceptToUpdate->getMaxValue();
		int delta = (int) (pow((double) 2, _resolutionSlider->GetValue() ));
		int minTmp   = value - delta/2;
		int maxTmp   = value + delta/2;
		if (minTmp<min)
		{
			minTmp = min;	
		}
		if (maxTmp>max)
		{
			maxTmp = max;
		}			
		theConceptToUpdate->setRange( minTmp,maxTmp );
	}

	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: setVerticalMaxSelectedNums( std::string groupMaxVertNums )
	{
		int endSub;
		std::string::size_type numberIndex = groupMaxVertNums.find(" ", 0);
		std::string::size_type start = 0;
		while( numberIndex != std::string::npos ) 
		{	
            endSub = numberIndex;
			std::string number = groupMaxVertNums.substr( 0, endSub );
			groupMaxVertNums.erase( 0, endSub+1 ); 
			int intReturn = atoi(number.c_str());			
			if( intReturn>0 )
				_verticalMaxSelected.push_back(intReturn);	
			else
				_verticalMaxSelected.push_back( 1 );	
			start += numberIndex;
			numberIndex = groupMaxVertNums.find(" ", endSub);			
		}				
	}
	//------------------------------------------------------------------------------------------------------------
	void wxInstantChooserPanel :: setConceptValue( std::string theConceptName, int theValue )
	{
		int i, size = _concepts->size();
		bool setted = false;
		for ( i=0; i<size && !setted; i++ )
		{	
			if( (*_concepts)[i]->getName().compare( theConceptName ) == 0 )
			{
				(*_concepts)[i]->setActualValue( theValue );
				setted = true;
			}
		}
	}
	
	//------------------------------------------------------------------------------------------------------------
	int wxInstantChooserPanel :: getConceptValue( std::string theConceptName )
	{
		int i, size = _concepts->size();
		int value = -1;
		for ( i=0; i<size && value==-1; i++ )
		{	
			if( (*_concepts)[i]->getName().compare( theConceptName ) == 0 )
			{
				value = (*_concepts)[i]->getActualValue(  );
			}
		}
		return value;
	}
	//------------------------------------------------------------------------------------------------------------
	ConceptDataWrap * wxInstantChooserPanel :: getConceptDataOf( std::string theConceptName )
	{
		ConceptDataWrap * conceptData = new ConceptDataWrap();

		int i, size = _concepts->size();
		int value = -1;
		for ( i=0; i<size && value==-1; i++ )
		{	
			if( (*_concepts)[i]->getName().compare( theConceptName ) == 0 )
			{		
				conceptData -> fillData( (*_concepts)[i]->getName(), (*_concepts)[i]->getMinValue(), (*_concepts)[i]->getMaxValue(), (*_concepts)[i]->getMinShowedValue(), (*_concepts)[i]->getMaxShowedValue(), (*_concepts)[i]->getActualValue());			
			}
		}
		return conceptData;
	}
	//------------------------------------------------------------------------------------------------------------
	bool wxInstantChooserPanel :: getIfConceptCheckedAt( std::string theConceptName, int atChecksPosition )
	{
		bool isChecked = false;

		int i,size = _concepts->size();
//		wxConceptControl * aConcept = NULL;			
		for ( i=0; i<size && !isChecked; i++ )
		{	
			if( (*_concepts)[i]->getName().compare( theConceptName ) == 0 )
			{		
				isChecked = (*_concepts)[i]->getIfChecked( atChecksPosition );
			}
		}

		return isChecked;
	}
	 
	 
	void wxInstantChooserPanel::addConcepts(std::vector<std::string> conceptNameVect,std::vector<int> conceptSizeVect){
		int i=0;
		int max = conceptNameVect.size();			
		for( ; i<max; i++)
		{
			if( conceptNameVect[i].compare("Axe Depth") == 0 )
			{
				addConcept( conceptNameVect[i], 0, conceptSizeVect[i], 1);					
			} else {
				addConcept( conceptNameVect[i], 1, conceptSizeVect[i], 1);
			} // if
		}
	}
	
