/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "wxVtkBaseView_SceneManager.h"
#include "wxVtk2DBaseView.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file wxVtkBaseView_SceneManager.cxx */


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include "wxContour_ActionCommandsID.h"

//------------------------------------------------------------------------------------------------------------
// Generated events declaration and definition
//------------------------------------------------------------------------------------------------------------

DEFINE_EVENT_TYPE( wxEVT_START_CREATE_MULT_ROI )	
DEFINE_EVENT_TYPE( wxEVT_STOP_CREATE_MULT_ROI )	
DEFINE_EVENT_TYPE( wxEVT_START_CREATE_ROI )
DEFINE_EVENT_TYPE( wxEVT_STOP_CREATE_ROI )
DEFINE_EVENT_TYPE( wxEVT_DELETE_ROI )
DEFINE_EVENT_TYPE( wxEVT_SELECTED_MULT_ROI )	
DEFINE_EVENT_TYPE( wxEVT_SELECTED_ROI )	
DEFINE_EVENT_TYPE( wxEVT_UNSLECTED_ROI )	
DEFINE_EVENT_TYPE( wxEVT_MANUAL_HIDED_ROI )
DEFINE_EVENT_TYPE( wxEVT_MANUAL_SHOWED_ROI )
DEFINE_EVENT_TYPE( wxEVT_EDITING_ROI )	
DEFINE_EVENT_TYPE( wxEVT_MOVING_ROI )	
DEFINE_EVENT_TYPE( wxEVT_MOVING_ROI_POINT )	
DEFINE_EVENT_TYPE( wxEVT_SELECTED_ROI_POINT )	
DEFINE_EVENT_TYPE( wxEVT_UNSELECTED_ROI_POINT )	
DEFINE_EVENT_TYPE( wxEVT_CHANGED_DEEP )	


	wxVtkBaseView_SceneManager :: wxVtkBaseView_SceneManager( wxVtkBaseView * theWxBaseViewToManage, wxEvtHandler * theEventHandler, double * spc )
	{
		
		_lastInteraction				= NULL;
		_lastInteractionName				= "";
		_eventHandler					= theEventHandler;
		_leftClickCount					= 0;
		_rigthClickCount				= 0;
		
		_contours_ViewControl				= new std::map< std::string, ContourWrap_ViewControl * >();
		_sceneContours_ViewControl			= new std::map< std::string, ContourWrap_ViewControl * >();
		_workingGroup					= new std::map< std::string, ContourWrap_ViewControl * >();

		_creatingMULT_ROI				= false;
		_editingROI					= false;
		_toIncludeAtInteractionGroup			= false;
		_waiting					= false;
		_creatingROI					= false;
		_drawingSelectionROI				= false;
		SetWidthContour(1.0);
		
		_wxVtk_BaseView = theWxBaseViewToManage;
		if( _wxVtk_BaseView!=NULL )
		{
			vtkInteractorStyleBaseView* theInteractorStyleBaseView = (vtkInteractorStyleBaseView*)_wxVtk_BaseView->GetInteractorStyleBaseView();
			theInteractorStyleBaseView->AddInteractorStyleMaracas( this );
			SetVtkInteractorStyleBaseView( theInteractorStyleBaseView );			
		}
		configureSelectionROI( spc );
	}
	//------------------------------------------------------------------------------------------------------------
	wxVtkBaseView_SceneManager :: ~wxVtkBaseView_SceneManager()
	{
		std::map <std::string, ContourWrap_ViewControl *>::iterator iter = _contours_ViewControl->begin(); 
		int size = _contours_ViewControl->size();
		for ( int i = 0; i<size; iter++ )
		{
			_contours_ViewControl->erase( iter );
			i++;
		}
		_contours_ViewControl->clear();		
		delete _contours_ViewControl;		
		_workingGroup->clear();
		delete _lastInteraction;
		delete _workingGroup;
		//delete _contours_ViewControl;
	}

	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events
	//------------------------------------------------------------------------------------------------------------

		
	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: sendEnvent( WXTYPE theEventType, std::string text )
	{
		if ( _eventHandler != NULL )
		{
			wxCommandEvent cevent( theEventType );
			cevent.SetString( wxString( text.c_str(), wxConvUTF8) );
			_eventHandler->ProcessEvent( cevent );
		}
	}


	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: setWxEventHandler( wxEvtHandler * theEventHandler )
	{
		_eventHandler = theEventHandler;
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: setWxVtkViewBase( wxVtkBaseView * theBaseView )
	{
		_wxVtk_BaseView = theBaseView;
	}

	//------------------------------------------------------------------------------------------------------------
	wxVtkBaseView * wxVtkBaseView_SceneManager :: getWxVtkViewBase()
	{
		return _wxVtk_BaseView;
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: configureViewControlTo( std::string theKeyName, manualBaseModel * manModelContour, double * spc,int typeContour)
	{
		//setControlActiveStateOfALL( false );
		_creatingROI = true;
		_waiting = false;	
		if( _lastInteraction!=NULL )
		{
			_lastInteraction->getControler()->SetEditable( false );
			_lastInteraction->getViewer()->Refresh();
			_lastInteraction->getControler()->SetActive( false );
			this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
		}


		manualContourBaseControler *manContourControl;
		manualViewBaseContour		*manViewerContour;

		// Creating the view manualViewContour and the manualContourControler
		// NOTE: The model is created in the KernelManagerContour class, factoryManualContourModel method
		if (typeContour==1)
		{
			manContourControl	= new manualContourControler();
			manViewerContour	= new manualViewContour();
		}

		if (typeContour==2)
		{
			manContourControl	= new manualRoiControler();
			manViewerContour	= new manualViewRoi();
		}

		if (typeContour==3)
		{
			manContourControl	= new manualCircleControler();
			manViewerContour	= new manualViewCircle();
		}

		if (typeContour==4)
		{
			manContourControl	= new manualRoiControler();
			manViewerContour	= new manualViewBullEye();
		}

		if (typeContour==6)
		{
			manContourControl	= new manualLineControler();
			manViewerContour	= new manualViewLine();
		}

		//Points
		if (typeContour==7)
		{
			manContourControl	= new manualContourControler();
			manViewerContour	= new manualViewPoints();
		}

		//Polygon
		if (typeContour==10)
		{
			manContourControl	= new manualContourControler();
			manViewerContour	= new manualViewContour();
		}



        _lastInteraction = insertWrap( theKeyName, manContourControl, manViewerContour );
		_lastInteractionName = theKeyName;

		//Configuring the relations between the contour members representation			
		manViewerContour->SetModel( manModelContour );
		manViewerContour->SetWxVtkBaseView( _wxVtk_BaseView );
		manViewerContour->SetRange( _widthOfControlPoint );
		manViewerContour->SetZ( -900 );	

		manViewerContour->SetSpacing(spc);

		manViewerContour->SetColorNormalContour(0, 0, 1);
		manViewerContour->SetColorEditContour(0.5, 0.5, 0.5);
		manViewerContour->SetColorSelectContour(1, 0.8, 0);
		manViewerContour->SetWidthLine(_widthOfContour);

		manContourControl->SetModelView( manModelContour , manViewerContour );
		manContourControl->Configure();
		int i,sizeLstPoints = manModelContour->GetSizeLstPoints();
		for ( i=0; i<sizeLstPoints; i++ )
		{
			manViewerContour->AddPoint();
		}

		manContourControl->CreateNewManualContour();
		manViewerContour->RefreshContour();			
		addToScene( theKeyName );
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: configureSelectionROI( double * spc )
	{
		_controlerSelectionROI = new manualRoiControler();
		_viewerSelectionROI = new manualViewRoi();
		_modelSelectionROI = new manualContourModel();
		
		_viewerSelectionROI->SetModel( _modelSelectionROI );
		_viewerSelectionROI->SetWxVtkBaseView( _wxVtk_BaseView );
		_viewerSelectionROI->SetRange( 2 );
		_viewerSelectionROI->SetZ( -900 );
		_viewerSelectionROI->SetColorNormalContour(0.6, 0.8, 0);

		_viewerSelectionROI->SetSpacing( spc );

		_controlerSelectionROI->SetModelView( _modelSelectionROI , _viewerSelectionROI );
		((vtkInteractorStyleBaseView*)_wxVtk_BaseView->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _controlerSelectionROI );
		_controlerSelectionROI->SetActive(false);
	}

	//------------------------------------------------------------------------------------------------------------
	ContourWrap_ViewControl * wxVtkBaseView_SceneManager :: insertWrap( std::string theKeyName, manualContourBaseControler * manContourControl, manualViewBaseContour  * manViewerContour )
	{	
		ContourWrap_ViewControl * newContourWrap = new ContourWrap_ViewControl(manContourControl, manViewerContour);
		if(_contours_ViewControl == NULL)
		{
			_contours_ViewControl = new std::map< std::string, ContourWrap_ViewControl * >();
		}
		_contours_ViewControl->insert(std::pair <std::string, ContourWrap_ViewControl *> ( theKeyName, newContourWrap ));
		return newContourWrap;
	} 
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: desconfigureViewControlOf( std::string theKeyName )
	{
		
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: removeWrap( std::string theKeyName )
	{
		std::map<std::string, ContourWrap_ViewControl *> :: iterator iter;
		iter = _contours_ViewControl->find( theKeyName );
		_contours_ViewControl->erase( iter );
		_lastInteraction=NULL;
		_lastInteractionName = "";
		_workingGroup->clear();
		this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
		this->_vtkInteractorStyleBaseView->EvaluateToRefresh();
	} 
	//------------------------------------------------------------------------------------------------------------
	ContourWrap_ViewControl * wxVtkBaseView_SceneManager :: getContourWrap_ViewControlOf ( std::string theName )
	{
		std::map<std::string, ContourWrap_ViewControl *> :: iterator iter;
		iter = _contours_ViewControl->find( theName );
		return iter->second;
		//return iter->first;
	}
	//------------------------------------------------------------------------------------------------------------
	ContourWrap_ViewControl * wxVtkBaseView_SceneManager :: getContourWrap_ViewControlOf ( std::string theName, std::map<std::string, ContourWrap_ViewControl *> * theMap )
	{
		std::map<std::string, ContourWrap_ViewControl *> :: iterator iter;
		iter = theMap->find( theName );
		return iter->second;
	}
	//------------------------------------------------------------------------------------------------------------
	manualContourBaseControler * wxVtkBaseView_SceneManager :: getControlerOf( std::string theName )
	{
		return getContourWrap_ViewControlOf ( theName )->getControler();
	}
	//------------------------------------------------------------------------------------------------------------
	manualViewBaseContour * wxVtkBaseView_SceneManager :: getViewerOf( std::string theName )
	{
		return getContourWrap_ViewControlOf ( theName )->getViewer();
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: set_creatingMULT_ROI( bool condition )
	{
		_creatingMULT_ROI = condition;
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: set_editingROI( bool condition )
	{
		_editingROI = condition;
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: set_toIncludeAtInteractionGroup( bool condition )
	{
		_toIncludeAtInteractionGroup = condition;
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: set_waiting( bool condition )
	{
		_waiting = condition;
	}
	//------------------------------------------------------------------------------------------------------------
	bool wxVtkBaseView_SceneManager :: get_creatingMULT_ROI(  )
	{
		return _creatingMULT_ROI;
	}
	//------------------------------------------------------------------------------------------------------------
	bool wxVtkBaseView_SceneManager :: get_editingROI(  )
	{
		return _editingROI;
	}
	//------------------------------------------------------------------------------------------------------------
	bool wxVtkBaseView_SceneManager :: get_toIncludeAtInteractionGroup(  )
	{
		return _toIncludeAtInteractionGroup;
	}

	//------------------------------------------------------------------------------------------------------------
	bool wxVtkBaseView_SceneManager :: get_waiting(  )
	{
		return _waiting;
	}

	//------------------------------------------------------------------------------------------------------------
	bool wxVtkBaseView_SceneManager :: get_creatingROI()
	{
		return _creatingROI;
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: set_creatingROI( bool condition )
	{
		_creatingROI = condition;
	}

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	void wxVtkBaseView_SceneManager :: createCopyContourOf( std::string anExistingKName, std::string cloneName, manualBaseModel * manualModel, bool append )
	{
		if ( !append )
		{
			setControlActiveStateOf( _workingGroup, false );
			_workingGroup->clear();
		}
        std::map <std::string, ContourWrap_ViewControl *>::iterator iter; 


		iter = _contours_ViewControl->find( anExistingKName );

		manualBaseModel			*cModule	= manualModel;
		manualViewBaseContour		*cViewer	= iter->second->getViewer()->Clone();
		manualContourBaseControler	*cControl	= iter->second->getControler()->Clone(  );

		cViewer->SetModel(cModule);
		cControl->SetModelView( cModule , cViewer );
		cControl->CreateNewManualContour();
		cControl->SetActive( true );	
		cControl->SetEditable( false );		

        cViewer->RefreshContour();     
		cViewer->Refresh();
		this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
		this->_vtkInteractorStyleBaseView->EvaluateToRefresh();

		_lastInteraction = insertWrap( cloneName, cControl, cViewer );
		_workingGroup->insert(std::pair <std::string, ContourWrap_ViewControl *> ( cloneName, _lastInteraction ));		
        addToScene( cloneName );
	}

	//------------------------------------------------------------------------------------------------------------

	void wxVtkBaseView_SceneManager :: removeFromScene( ContourWrap_ViewControl * contourWRP, bool visualization, bool control )
	{
		if( contourWRP == _lastInteraction )
		{
			_lastInteraction = NULL;
			_lastInteractionName = "";
		}


		((vtkInteractorStyleBaseView*)_wxVtk_BaseView->GetInteractorStyleBaseView())->RemoveInteractorStyleMaracas( contourWRP->getControler() );

		contourWRP->getControler()->SetActive( control );	
		contourWRP->getControler()->SetEditable( false );		

		if ( !visualization && control )
		{
			contourWRP->getViewer()->RemoveControlPoints( );
			contourWRP->getViewer()->RemoveTextActor( );
		}
		if ( visualization )
		{
			contourWRP->getViewer()->RemoveCompleteContourActor();			
		}
		
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: removeFromScene( std::string theKeyName, bool visualization , bool control )
	{

		std::map<std::string, ContourWrap_ViewControl *> :: iterator iter;
		iter = _sceneContours_ViewControl->find( theKeyName );
		if (iter != _sceneContours_ViewControl->end())
		{
			ContourWrap_ViewControl * contourWRP =	 iter->second;
			removeFromScene( contourWRP );	
			_sceneContours_ViewControl->erase(iter);
		}	
	}


	//------------------------------------------------------------------------------------------------------------
	std::vector<std::string> wxVtkBaseView_SceneManager::GetlstContoursNameActualSlice()
	{
		std::vector<std::string> lstContoursNameActualSlice;
		std::map <std::string, ContourWrap_ViewControl *>::iterator iter = _sceneContours_ViewControl->begin(); 
		int i,size = _sceneContours_ViewControl->size();
		for ( i = 0; i<size; i++ )
		{
			lstContoursNameActualSlice.push_back( iter->first );
			iter++;
		}
		return lstContoursNameActualSlice;
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: removeSceneContours( )
	{
		std::map <std::string, ContourWrap_ViewControl *>::iterator iter = _sceneContours_ViewControl->begin(); 
		int size = _sceneContours_ViewControl->size();
		for ( int i = 0; i<size; i++ )
		{
			removeFromScene( iter->second );
			iter++;
		}
		_sceneContours_ViewControl->clear();


		//Removing the selection rectangle to avoid showing when it's innecesary
		_controlerSelectionROI->SetActive( false );		
		_viewerSelectionROI->RemoveCompleteContourActor();	
	}

	void wxVtkBaseView_SceneManager::removeAllOutlines()
	{
		manualViewBaseContour		* cViewer;
		manualContourBaseControler	* cControler;

		std::map <std::string, ContourWrap_ViewControl *>::iterator iter; 
		int i,size=_contours_ViewControl->size();
		for (i=0;i<size;i++)
		{
			iter = _contours_ViewControl->begin(); 
			cControler	= iter->second->getControler();
			cViewer		= iter->second->getViewer();
			removeWrap( iter->first );
			delete cViewer;
			delete cControler;
		}// for

	}


	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: addToScene( std::string theKeyName, bool append, bool visualization, bool control, bool ifActive, bool ifShowCtrlPoints )
	{
		if( !append )
		{
			removeSceneContours();			
		}
		ContourWrap_ViewControl * contourWRP =	getContourWrap_ViewControlOf( theKeyName );
		_sceneContours_ViewControl->insert(std::pair <std::string, ContourWrap_ViewControl *> ( theKeyName, contourWRP ) );		

		addToScene( theKeyName, contourWRP, true, visualization, control, ifActive, ifShowCtrlPoints);
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: addToScene( std::string theKeyName, ContourWrap_ViewControl * contourWRP, bool append, bool visualization, bool control, bool ifActive, bool ifShowCtrlPoints )
	{
		if( !append )
		{
			removeSceneContours();			
		}		
		_sceneContours_ViewControl->insert(std::pair <std::string, ContourWrap_ViewControl *> ( theKeyName, contourWRP ) );		
		if ( visualization )
		{
			contourWRP->getViewer()->AddCompleteContourActor( ifShowCtrlPoints );
		}

		if( control )
		{
			((vtkInteractorStyleBaseView*)_wxVtk_BaseView->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( contourWRP->getControler() );
		}
		if( ifActive )
		{
			contourWRP->getControler()->SetActive( true );	
			contourWRP->getViewer()->RemoveTextActor();
		}
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: removeFromScene( std::vector< std::string> theKeyNameVector, bool visualization, bool control  )
	{
		int i, size = theKeyNameVector.size();
		for( i=0; i< size; i++ )
		{
			removeFromScene( theKeyNameVector[i], visualization, control );
		}
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: addToScene( std::vector< std::string> theKeyNameVector, bool append, bool visualization, bool control, bool ifActive, bool ifShowCtrlPoints )
	{
		int i, size = theKeyNameVector.size();
		for( i=0; i< size; i++ )
		{
			addToScene( theKeyNameVector[i], append, visualization, control, ifActive, ifShowCtrlPoints );
		}
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: setControlActiveStateOfALL( bool stateCondition )
	{
		setControlActiveStateOf( _contours_ViewControl, stateCondition );			
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: setControlActiveStateOf( std::string theKeyName, bool stateCondition )
	{
		ContourWrap_ViewControl * contourWRP =	getContourWrap_ViewControlOf( theKeyName );
		setControlActiveStateOf( contourWRP, stateCondition );
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: setControlActiveStateOf( ContourWrap_ViewControl * contourWRP, bool stateCondition )
	{
		contourWRP->getControler()->SetActive( stateCondition );	
		contourWRP->getControler()->SetEditable( false );		
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: setVisibleStateOf( std::string theKeyName, bool stateCondition )
	{
		ContourWrap_ViewControl * contourWRP =	getContourWrap_ViewControlOf( theKeyName );
//		contourWRP->getViewer()->SetVisible( stateCondition );
		if ( contourWRP!=NULL )
			removeFromScene( contourWRP, false, stateCondition );
	}

	//------------------------------------------------------------------------------------------------------------
	std::vector< std::string > wxVtkBaseView_SceneManager :: getSelectedObjects()
	{
		std::vector< std::string > selectedObjects;
		std::map <std::string, ContourWrap_ViewControl *>::iterator iter = _workingGroup->begin(); 
		int size = _workingGroup->size();
		for ( int i = 0; i<size; i++ )
		{
//EED???			manualViewBaseContour * viewer = iter->second->getViewer();
			selectedObjects.push_back( iter->first);	

			iter++;
		}	
		return selectedObjects;
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: selectObjects( std::vector< std::string > theExistingObjectsToSelect )
	{
		std::map <std::string, ContourWrap_ViewControl *>::iterator iter = _contours_ViewControl->begin(); 
//EED???		int size = _contours_ViewControl->size();	
//EED???		bool selected;
		/*for ( int i = 0; i<size; i++ )
		{
			selected = false;
			manualViewBaseContour * viewer = iter->second->getViewer();	
			std::vector <std::string >::iterator iterIN;
			int a = 0;
			for( a = 0, iterIN = theExistingObjectsToSelect.begin() ; !selected && a < theExistingObjectsToSelect.size() ; a++ )
			{
				if( iter->first.compare( theExistingObjectsToSelect[i] ) )
				{					
					viewer->SelectAllPoints( true );
					viewer->SelectPosibleContour( true );		
					selected = true;
					theExistingObjectsToSelect.erase( iterIN );					
				}
				if( !selected )
					iterIN++;
			}
		}	*/
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: selectObjects( std::map<std::string, ContourWrap_ViewControl *> * theMap )
	{
		std::map <std::string, ContourWrap_ViewControl *>::iterator iter = theMap->begin(); 
		int size = _contours_ViewControl->size();	
		for ( int i = 0; i<size; i++ )
		{
			manualViewBaseContour * viewer = iter->second->getViewer();	

			viewer->SetSelected( true );
			/*viewer->SelectAllPoints( true );
			viewer->SelectPosibleContour( true );*/		
			
			iter++;
		}	
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: setControlActiveStateOf( std::vector< std::string> &theKeyNameVector, bool controlCondition )
	{
		int i, size = theKeyNameVector.size();
		for( i=0; i< size; i++ )
		{
			setControlActiveStateOf( theKeyNameVector[i], controlCondition );
		}
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: setControlActiveStateOf( std::map<std::string, ContourWrap_ViewControl *> * theMap, bool controlCondition )
	{
		std::map<std::string, ContourWrap_ViewControl *>::iterator iter = theMap->begin();
		int i, size = theMap->size();
		for( i=0; i< size; i++ )
		{
			removeFromScene( iter->second, false, controlCondition );		
			iter++;
		}		
	}

	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	// Inherited Methods
	//------------------------------------------------------------------------------------------------------------

	bool  wxVtkBaseView_SceneManager :: isCtrlPressed()
	{ 
		return _ctrlKey;
	}
	bool  wxVtkBaseView_SceneManager :: isShiftPressed()
	{ 
		return _shiftKey;
	}
	char  wxVtkBaseView_SceneManager :: getLastKeyCode()
	{ 
		return _lastKeyCode;
	}
	bool  wxVtkBaseView_SceneManager :: OnChar()
	{ 

		_ctrlKey = _vtkInteractorStyleBaseView->GetInteractor()->GetControlKey() == 1;
	 	_shiftKey = _vtkInteractorStyleBaseView->GetInteractor()->GetShiftKey() == 1;

		_lastKeyCode = _vtkInteractorStyleBaseView->GetInteractor()-> GetKeyCode();

		wxCommandEvent cevent( wxEVT_COMMAND_BUTTON_CLICKED );
		_eventHandler->ProcessEvent( cevent );
		
				
		/*if( _eventHandler!=NULL )
		{
			char * toolCommand = NULL;

			if ( _lastKeyCode == 3 && ctrlKey ) //'C' || 'c' 
			{
				toolCommand = &(COPY_TOOL);
			}
			else if(  _lastKeyCode == 22 && ctrlKey ) //'V' || 'v' 
			{
				toolCommand = &(PASTE_TOOL);
			}
			else if(  _lastKeyCode == 8 || (_lastKeyCode==127) ) // Delete 
			{
				toolCommand = &(DELETE_KEY);
			}
			else if(  _lastKeyCode == 14 && ctrlKey ) //'N' || 'n' 
			{
				toolCommand = &(CREATE_CONTOUR_KEY);
			}
			else if(  _lastKeyCode == 15 && ctrlKey ) //'O' || 'o' 
			{
				toolCommand = &(OPEN_TOOL);
			}
			else if(  _lastKeyCode == 19 && ctrlKey ) //'S' || 's' 
			{
				toolCommand = &(SAVE_KEY);
			}

			if ( toolCommand!=NULL )
			{
				currentkey = toolCommand;
				wxCommandEvent cevent( wxEVT_COMMAND_BUTTON_CLICKED );
				cevent.SetClientData( (void *) toolCommand);
				_eventHandler->ProcessEvent( cevent );
			}				
		}*/
		
	
	//	long int endtime = clock();		

		return true; 
	}
	//------------------------------------------------------------------------------------------------------------

	bool  wxVtkBaseView_SceneManager :: OnMouseMove()
	{ 

		bool condition = true;  
		int X,Y;
		wxVTKRenderWindowInteractor *_wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		_wxVTKiren->GetEventPosition( X , Y );

		bool ctrlKey = _vtkInteractorStyleBaseView->GetInteractor()->GetControlKey() == 1;
//???	 	bool shiftKey = _vtkInteractorStyleBaseView->GetInteractor()->GetShiftKey() == 1;

		if( _waiting && !ctrlKey )
		{
			sendEnvent( wxEVT_CHANGED_DEEP, "Update");
			//toca ver como decirle al viewer que no se mueva mientras no se este esperando que se pueda mover			
		}
		
		if ( !_creatingROI && !_creatingMULT_ROI )
		{
			
			/*if( ctrlKey || shiftKey )
			{
				
			}
			else
			{
				_toIncludeAtInteractionGroup = false;
			}*/
			
			bool preserveState = _lastInteraction!=NULL? _lastInteraction->getViewer()->GetSelected() : false;
			std::string preservingName = preserveState ? _lastInteractionName : "";

			std::map<std::string, ContourWrap_ViewControl *>::iterator iter = _sceneContours_ViewControl->begin();
			int i, size = _sceneContours_ViewControl->size();
			bool foundOne = false;

			manualContourBaseControler	* control	= _lastInteraction != NULL ? _lastInteraction->getControler() : NULL;
			manualViewBaseContour		* viewer	= NULL;	
			
			
			bool singleMoving = true;
			int selectionSize = _workingGroup->size();
			if( selectionSize > 1 ) 
			{
				//Multiple moving
				
//EED???				bool ckecking = false;
				for( i =0; i<size ; i++ ) 
				{
					control = iter->second->getControler();
					viewer = iter->second->getViewer();
					/*ckecking = */control->SetActive( true );
				}
				if (_lastInteraction != NULL)
				{
					singleMoving = !_lastInteraction->getViewer()->GetSelected();

				}
				if( !singleMoving )
				{
					size = selectionSize;
					iter = _workingGroup->begin();
				}
			}			
			else
			{
				
				_toIncludeAtInteractionGroup = false;
			}
			
			if( ((_lastInteraction != NULL && !control->IsEditable() && !control->IsMoving() ) || _lastInteraction==NULL ))
			{					

				_lastInteraction=NULL;
				for( i =0; i<size ; i++ )
				{
					control = iter->second->getControler();
					viewer = iter->second->getViewer();
//					_wxVtk_BaseView->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( control );
					control->SetActive( true );					
					
					foundOne = control->OnMouseMove();
					foundOne &= viewer->GetPosibleSelected();				
					
					if ( !foundOne && singleMoving )
					{
						control->SetActive( false );
//						_wxVtk_BaseView->GetInteractorStyleBaseView()->RemoveInteractorStyleMaracas( control );
						control->SetPosibleToMove( false );
					}
					else
					{						
						if( _toIncludeAtInteractionGroup && preserveState && _lastInteractionName.compare( preservingName)==0 )
						{
							_lastInteraction->getControler()->SetActive( true );
						}

						_lastInteraction		= iter->second;
						_lastInteractionName	= iter->first;

						viewer->UpdateColorActor();
						control->SetPosibleToMove( true );
						// viewer->AddCompleteContourActor();
					}
					iter++;
				}
				control = NULL;
				viewer = NULL;	
			}				
		}
		return condition;	
	}





	//------------------------------------------------------------------------------------------------------------
	bool  wxVtkBaseView_SceneManager :: OnLeftButtonDown()
	{ 



//EED???		char aa = _vtkInteractorStyleBaseView->GetInteractor()->GetKeyCode();
		bool condition = false;  
		//vtkCommand * theComand = _wxVtk_BaseView ->GetInteractorStyleBaseView()->GetCommand(
//EED???		vtkRenderWindowInteractor		* vtkRWInteractor1	= _wxVtk_BaseView ->GetWxVTKRenderWindowInteractor(); 
//EED???		wxVTKRenderWindowInteractor		* vtkRWInteractor2	= _wxVtk_BaseView ->GetWxVTKRenderWindowInteractor();//GetInteractorStyleBaseView()->GetInteractor();
//EED??		wxVTKRenderWindowInteractorPlus * vtkRWInteractor3	= (wxVTKRenderWindowInteractorPlus*)_wxVtk_BaseView ->GetWxVTKRenderWindowInteractor();//GetInteractorStyleBaseView()->GetInteractor();
		vtkRenderWindowInteractor		* vtkRWInteractor	= _vtkInteractorStyleBaseView->GetInteractor();
		
		bool ctrlKey = vtkRWInteractor->GetControlKey() == 1;
		bool shftKey = vtkRWInteractor->GetShiftKey() == 1;
		_toIncludeAtInteractionGroup = false;
		if ( ctrlKey || shftKey )
		{
			_toIncludeAtInteractionGroup = true;			
		}
		else
		{
			if( _lastInteraction!=NULL && !_toIncludeAtInteractionGroup )
			{
				if( _lastInteraction->getControler()->GetIfCompleteCreation() && !_lastInteraction->getControler()->IsEditable()&& !_lastInteraction->getViewer()->GetPosibleSelected() )
				{
					_lastInteraction->getControler()->SetEditable( false );
					_lastInteraction->getControler()->SetActive( false ); 
					_lastInteraction->getControler()->SetPosibleToMove( false );
					_lastInteraction->getViewer()->Refresh();
					_lastInteraction=NULL;
				}
			}
		}



		if( !_toIncludeAtInteractionGroup )
		{
			_workingGroup->clear();
		}

		if( _lastInteraction!=NULL )
		{
			_toIncludeAtInteractionGroup = !_lastInteraction->getControler()->IsEditable();
			_toIncludeAtInteractionGroup &= _lastInteraction->getViewer()->GetSelected();
			_workingGroup->insert(std::pair <std::string, ContourWrap_ViewControl *> ( _lastInteractionName, _lastInteraction ));	
		}
		if( _creatingMULT_ROI && !_creatingROI && !ctrlKey  && !shftKey )
		{
			_creatingROI = true;
			//setControlActiveStateOf( _contours_ViewControl, false );
			sendEnvent( wxEVT_START_CREATE_ROI, "");
		}			
		condition = true; 

// FILE *ff = fopen("c:/temp/wxVtkBaseView_SceneManagerStadistics.txt","a+");
// fprintf(ff,"EED wxVtkBaseView_SceneManager::OnLeftButtonDown() contours=%d  sceneContour=%d  workingContours=%d\n",
//					_contours_ViewControl->size(), _sceneContours_ViewControl->size(), _workingGroup->size() );
// fclose(ff);


		return condition;	
	} 

	//------------------------------------------------------------------------------------------------------------
	bool  wxVtkBaseView_SceneManager :: OnLeftButtonUp()
	{
		bool condition = false; 
		condition = true; 
				
		if( _drawingSelectionROI )
		{
			setSelection2DROIInternalOutlines();
		}
		return condition;	
	}
	//------------------------------------------------------------------------------------------------------------
	bool  wxVtkBaseView_SceneManager :: OnMiddleButtonDown()
	{
		bool condition = false; 
		condition = true; 
			
		return condition;	
	}
	//------------------------------------------------------------------------------------------------------------
	bool  wxVtkBaseView_SceneManager :: OnMiddleButtonUp()
	{
		bool condition = false; 
		condition = true; 
			
		return condition;	
	}
	//------------------------------------------------------------------------------------------------------------
	bool  wxVtkBaseView_SceneManager :: OnRightButtonDown()
	{
		bool condition = false; 
//EED???		vtkRenderWindowInteractor * vtkRWInteractor = _vtkInteractorStyleBaseView->GetInteractor();
//EED???		bool ctrlKey = vtkRWInteractor->GetControlKey() == 1;
		_waiting = true; 
		
		condition = true; 		
		
		return condition;	
	}
	//------------------------------------------------------------------------------------------------------------
	bool  wxVtkBaseView_SceneManager :: OnRightButtonUp()
	{
		bool condition = false; 
		condition = true; 
		//setControlActiveStateOfALL( false );//************************************************
		if ( _creatingMULT_ROI )
		{
			//setControlActiveStateOfALL( false );
		}
		if( _creatingROI )
		{
			sendEnvent( wxEVT_STOP_CREATE_ROI, "Activate");
			_creatingROI = false;
		}
		else
		{
			if(_lastInteraction!=NULL && !_toIncludeAtInteractionGroup)
			{
				manualContourBaseControler * control = _lastInteraction->getControler();
				//_lastInteraction->getControler()->SetPosibleToMove( false );
				control->SetActive( false );
				control->SetEditable( false );				
				control->SetPosibleToMove( false );
//				_wxVtk_BaseView->GetInteractorStyleBaseView()->RemoveInteractorStyleMaracas( control );
				_lastInteraction->getViewer()->Refresh();			
				this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
			}	
		}
		_waiting = false; 
		return condition;	
	}
	//------------------------------------------------------------------------------------------------------------

	bool  wxVtkBaseView_SceneManager :: OnLeftDClick()
	{
		bool condition = false; 
		condition = true; 
		
		return condition;	
	}
	//------------------------------------------------------------------------------------------------------------
	bool  wxVtkBaseView_SceneManager :: OnRightDClick()
	{ 
		bool condition = false;  condition = true; 
//EED???		vtkRenderWindowInteractor * vtkRWInteractor = _vtkInteractorStyleBaseView->GetInteractor();
		/*vtkRenderWindowInteractor * vtkRWInteractor1 =*/ _vtkInteractorStyleBaseView->OnChar();
//EED???		wxVTKRenderWindowInteractor * wxVtkRWInterator = _wxVtk_BaseView ->GetWxVTKRenderWindowInteractor();
		
		/*if( _waiting )
		{
			sendEnvent( wxEVT_START_CREATE_MULT_ROI, "Multiple");
			set_creatingMULT_ROI( !_creatingMULT_ROI );
			_waiting = false;
		}
		else
			_waiting = true;*/

		return condition;	
	}  
	//------------------------------------------------------------------------------------------------------------
	bool  wxVtkBaseView_SceneManager :: OnMiddleDClick()
	{
		bool condition = false; 
		condition = true; 
		
		return condition;	
	}
	//------------------------------------------------------------------------------------------------------------
	bool  wxVtkBaseView_SceneManager :: OnMouseWheel()
	{
		bool condition = false; 
		condition = true; 
		return condition;	
	}
	//------------------------------------------------------------------------------------------------------------

	void wxVtkBaseView_SceneManager :: drawSelectionROI()
	{
		_drawingSelectionROI = true;
		_workingGroup->clear();
		_controlerSelectionROI->CreateNewManualContour();	
		if (_lastInteraction!=NULL)
		{
			_lastInteraction->getControler()->SetEditable( false );
			_lastInteraction->getControler()->SetActive( false ); 
			_lastInteraction->getControler()->SetPosibleToMove( false );
			_lastInteraction->getViewer()->Refresh();
		}
		std::map<std::string, ContourWrap_ViewControl *>::iterator iter = _workingGroup->begin();
		int i, workSize = _workingGroup->size();
		for( i=0; i< workSize; i++ )
		{
			manualContourBaseControler * control = iter->second->getControler();
			control->SetEditable( false );
			control->SetActive( false );
			control->SetPosibleToMove( false );
			iter->second->getViewer()->Refresh();

			iter++;
		}
		_lastInteraction = NULL;
		_lastInteractionName = "";

		_viewerSelectionROI->AddCompleteContourActor( true );	
		_controlerSelectionROI->SetActive( true );
		
		_viewerSelectionROI->RefreshContour();
		this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: setSelection2DROIInternalOutlines( )
	{
		_drawingSelectionROI = false;
		_workingGroup->clear();
		double minX,minY,maxX,maxY, minX_ROI,minY_ROI,maxX_ROI,maxY_ROI;
		double minZ = -1.0;
		double maxZ = -1.0;
		std::map<std::string, ContourWrap_ViewControl *>::iterator iter = _sceneContours_ViewControl->begin();
		int i, size = _sceneContours_ViewControl->size();
		_viewerSelectionROI->GetMinMax( minX_ROI, minY_ROI, maxX_ROI, maxY_ROI );
		manualViewBaseContour * viewer;
		bool insideRoi = false;
		for ( i=0; i<size; i++ )
		{
			viewer = iter->second->getViewer();
			viewer->GetMinMax( minX, minY, minZ, maxX, maxY, maxZ );
			insideRoi = minX >= minX_ROI && maxX <= maxX_ROI && minY_ROI && maxY <= maxY_ROI;
			if ( insideRoi )
			{
				viewer->SetSelected( true );
				viewer->UpdateColorActor();
				setControlActiveStateOf( iter->second, true );
				_workingGroup->insert(std::pair <std::string, ContourWrap_ViewControl *> ( iter->first, iter->second ));
			}
			iter++;
		}   
		_viewerSelectionROI->RemoveCompleteContourActor( );	
		_controlerSelectionROI->SetActive( false );
	}
	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager :: writeCoords( std::string method )
	{
		FILE *ff = fopen("c:/temp/wxVtkBaseView_SceneManagerStadistics.txt","a+");
		long int start = clock();
#if(WIN32)
		double sg = (double)(start) / (double)CLK_TCK;
#else
		double sg = (double)(start) / CLOCKS_PER_SEC;
#endif
		int tmpPx,tmpPy;
		wxVTKRenderWindowInteractor *wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		wxVTKiren->GetEventPosition( tmpPx , tmpPy );
		fprintf(ff,"::%s (x,y) = (%i, %i) t(sg): %f\n  \n",method.c_str(), tmpPx, tmpPy, sg);
		fclose(ff);
	}


	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager::SaveThingName(FILE *ff, std::string nameThing)
	{
		std::map <std::string, ContourWrap_ViewControl *>::iterator iter = _contours_ViewControl->find(nameThing); 
		manualViewBaseContour		* cViewer;
		manualContourBaseControler	* cControler;
		ContourWrap_ViewControl *conwraviwcont=iter->second;

		cViewer		= conwraviwcont->getViewer();
		cViewer->Save(ff);

		cControler	= conwraviwcont->getControler();
//		cControler->Save(ff);

//		cModel		= cControler->GetManualContourModel();
//		cModel->Save(ff);
	}


	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager::GetPointsOfActualContour( std::vector<double> *vecX, std::vector<double> *vecY, std::vector<double> *vecZ )
	{
		std::vector<std::string> currentSelection = this->getSelectedObjects();
		if (currentSelection.size()>=1){
			
			manualContourBaseControler *cControler	= this->getControlerOf( currentSelection[0] );
			manualBaseModel *cModel				= cControler->GetManualContourModel();
			int i,size = cModel->GetNumberOfPointsSpline();
			double x,y,z;
			for (i=0; i<size; i++) 
			{
				cModel->GetSpline_i_Point(i, &x, &y, &z);
				vecX->push_back(x);
				vecY->push_back(y);
				vecZ->push_back(z);
			}
		}
	}

	//------------------------------------------------------------------------------------------------------------
	vtkImageData *wxVtkBaseView_SceneManager::GetImageData()
	{
		wxVtk2DBaseView *wxvtk2dbaseview =(wxVtk2DBaseView*)_wxVtk_BaseView;
		return wxvtk2dbaseview->GetVtkBaseData()->GetImageData();
	}

	//------------------------------------------------------------------------------------------------------------
	int wxVtkBaseView_SceneManager::GetImageDataSizeZ()
	{
			int ext[6];
			vtkImageData	*imagedata	= GetImageData();
			imagedata->GetExtent(ext);
			int sizeZ = ext[5]-ext[4]+1;

//EED OJO   Machete
//			sizeZ = sizeZ-1;

			return sizeZ;
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager::GetImageDataRange( double *range )
	{
		int ext[6];
		vtkImageData	*imagedata	= GetImageData();
		imagedata->GetExtent(ext);
		int sizeX	= ext[1]-ext[0]+1;
		int sizeY	= ext[3]-ext[2]+1;
		int sizeZ	= GetImageDataSizeZ();
		int sizeXYZ = sizeX*sizeY*sizeZ;
		long int i;
		range[0]=9999999;
		range[1]=-9999999;
		unsigned short *p = (unsigned short *)imagedata->GetScalarPointer(0,0,0);
		for (i=0;i<sizeXYZ;i++)
		{
			if ( p[i]<range[0] ) range[0]=p[i];
			if ( p[i]>range[1] ) range[1]=p[i]; 
		}
	}

	//------------------------------------------------------------------------------------------------------------
	void wxVtkBaseView_SceneManager::SetWidthContour(double width)
	{
		_widthOfContour 	= width;
		_widthOfControlPoint 	= _widthOfContour*_widthOfContour/2;
		manualViewBaseContour		*cViewer;
		ContourWrap_ViewControl		*conwraviwcont;
		std::map <std::string, ContourWrap_ViewControl *>::iterator iter; 
	
		if (_contours_ViewControl!=NULL)
		{
			for (iter=_contours_ViewControl->begin(); iter!=_contours_ViewControl->end(); iter++ )
			{
				conwraviwcont		= iter->second;
				cViewer			= conwraviwcont->getViewer();
				cViewer->SetShowText( false );					// EED 28Mars2011
				cViewer->SetWidthLine( _widthOfContour );
				cViewer->SetRange( _widthOfControlPoint );
			} // for
		} // if 
	}

	bool wxVtkBaseView_SceneManager::isEditableCControler(std::string theKeyName){
		
		ContourWrap_ViewControl* ccon = getContourWrap_ViewControlOf(theKeyName);
		if(ccon != NULL ){
			manualContourBaseControler* cControler = ccon->getControler();
			if(cControler != NULL && cControler->IsEditable() == false){
				return true;
			}
		}
		return false;
	}

	void wxVtkBaseView_SceneManager::deleteCViewerCControler(std::string theKeyName){
		

		ContourWrap_ViewControl* ccon = getContourWrap_ViewControlOf(theKeyName);

		manualViewBaseContour       * cViewer = ccon->getViewer();
		manualContourBaseControler  * cControler = ccon->getControler();

		removeFromScene(theKeyName);
		removeWrap(theKeyName);

		delete cViewer;		
		delete cControler;
	}
	
	
		
