/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "CommandsRegisterStructure.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file CommandsRegisterStructure.cxx */

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------

/*
	* Creates the CommandsRegisterStructure
	*/
	CommandsRegisterStructure :: CommandsRegisterStructure()
	{ 
		actualIndexToExec = -1;		
		lastAction = -1;
	}

	/*
	* Destroys the CommandsRegisterStructure
	*/
	CommandsRegisterStructure :: ~CommandsRegisterStructure()
	{ 
		clearActions();		
	}

//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/**
	* Registers a command in the vector with no verification, is should be well constructed
	* @param theCommand The command to register
	*/
	void CommandsRegisterStructure :: registerCommand(CommandObject * theCommand)
	{
		//int antes =registeredActions.size();
		levelLastToActual(true);
		registeredActions.push_back(theCommand);
		actualIndexToExec = registeredActions.size()-1;
		lastAction = actualIndexToExec;
		//int despues =registeredActions.size();
		//int otr = 0;
	}


	/*
	* Gets the -ACTUAL- command text 
	* @return
	*/
	/*std::string CommandsRegisterStructure :: getActualCommandText()
	{ 
		return !isEmpty() ? getCommandAt(actualIndexToExec)->includeToExecute(): " ";
	}*/

	/*
	* Gets the -LAST- command text 
	* @return
	*/
	/*std::string CommandsRegisterStructure :: getLastCommandText()
	{ 
		return !isEmpty() ? getCommandAt(lastAction)->executeCommand(): " ";
	}*/

	/*
	* Deletes all the registered actions and reinitialize the -ACTUAL- and  -LAST- 
	*/
	void CommandsRegisterStructure ::  clearActions()
	{ 
		if(!registeredActions.empty())
		{
			for(int i=0; i < registeredActions.size(); i++)
			{
				registeredActions[i] = NULL;
			}
			registeredActions.clear();		
			lastAction = -1;		
			actualIndexToExec = -1;
		}
	}

	/*
	* Moves to the the previous position the -ACTUAL- 
	* @return Indicates true if it was done
	*/
	bool CommandsRegisterStructure :: moveBack_Actual()
	{ 
		if ( !isEmpty() &&  hasActualPrevious() )
		{
			actualIndexToExec--;
			return true;
		}
		return false;
	}

	/*
	* Moves to the the next position the -ACTUAL- 
	* @return Indicates true if it was done
	*/
	bool CommandsRegisterStructure :: moveForward_Actual()
	{
		if ( !isEmpty() &&  hasActualNext() )
		{
			actualIndexToExec++;
			return true;
		}
		return false;
	}

	/*
	* Moves to the the previous position the -LAST- 
	* @return Indicates true if it was done
	*/
	bool CommandsRegisterStructure :: moveBack_Last()
	{ 
		if ( !isEmpty() && hasLastPrevious() )
		{
			lastAction--;
			return true;
		}
		return false;
	}

	/*
	* Moves to the the next position the -LAST- 
	* @return Indicates true if it was done
	*/
	bool CommandsRegisterStructure :: moveForward_Last()
	{
		if ( !isEmpty() && hasLastNext() )
		{
			lastAction++;
			return true;
		}
		return false;
	}

	/*
	* Indicates if the -LAST-  has a next action or not
	* @return Returns true if it has
	*/
	bool CommandsRegisterStructure :: hasLastNext()
	{
		int total = registeredActions.size();
		return total > 0 ? total -1 > lastAction : false;
	}

	/*
	* Indicates if the -ACTUAL-  has a next action or not
	* @return Returns true if it has
	*/
	bool CommandsRegisterStructure :: hasActualNext()
	{
		int total = registeredActions.size();
		return total > 0 ? total -1 > actualIndexToExec : false;
	}

	/*
	* Indicates if the -LAST-  has a previous action or not
	* @return Returns true if it has
	*/
	bool CommandsRegisterStructure :: hasLastPrevious()
	{
		return ! 0 < lastAction;
	}

	/*
	* Indicates if the -ACTUAL-  has a previous action or not
	* @return Returns true if it has
	*/
	bool CommandsRegisterStructure :: hasActualPrevious()
	{
		return 0 < actualIndexToExec;
	}

	/*
	* Puts to point CommandsRegisterStructure ::  the -ACTUAL-  up to the -LAST-  .	
	*/
	void CommandsRegisterStructure :: levelActualToLast()
	{ 
		actualIndexToExec = lastAction;
	}

	/*
	* Puts to point CommandsRegisterStructure ::  the -LAST-  up to the -ACTUAL-  and erases automatically the actions after the 
	* referenced last new position of the registered actions if nothing is given by parameter.
	* @clearingAfterActual Indicates if is wondered to erase or not the mentioned range 
	*/
	void CommandsRegisterStructure :: levelLastToActual( bool clearingAfterActual )
	{
		if ( !isEmpty() )
		{
			lastAction = actualIndexToExec;
			if( clearingAfterActual )
			{
				for (int a=registeredActions.size()-1; a>=0 && actualIndexToExec < a; a--)
				{
					if(actualIndexToExec < a)
					{
						registeredActions.pop_back();
					}
				}				
			}			
		}
	}

	/*
	* Clear all the elements in the vector bettween the -LAST-  and the end of the vector
	*/
	void CommandsRegisterStructure ::  clearAll_afterLast()
	{
		for (int a=registeredActions.size()-1; a>=0 && lastAction < a; a--)
		{
			if( lastAction < a )
			{
				registeredActions.pop_back();
			}
		}		
	}

	/*
	* Clear all the elements in the vector bettween the -ACTUAL-  and the start of the vector 	
	*/
	void CommandsRegisterStructure ::  clearAll_beforeActual()
	{ 
		std::vector <CommandObject*>::iterator frontIter;
		for (int a=0; a<registeredActions.size() && lastAction < a; a--)
		{
			frontIter = registeredActions.begin();
			if( actualIndexToExec > a )
			{
				registeredActions.erase(frontIter);
			}
		}	
	}

	/**
	* Indicates if there are actions in the vector of not
	* @return Returns true is there are not registered actions	
	*/
	bool CommandsRegisterStructure :: isEmpty()
	{ 
		return registeredActions.empty();
	}

	/**
	* Indicates the quantity of actions that are registered
	* @return Returns the total amount of registered actions in the vector
	*/
	int CommandsRegisterStructure ::  getCommandsCount()
	{ 
		return registeredActions.size();
	}

	/*
	* Gets the -ACTUAL-   information data pointer
	* @return The pointer to the referenced object by the -ACTUAL- 
	*/
	CommandObject * CommandsRegisterStructure :: getActual_Pointer ()
	{
		return  getCommandAt(actualIndexToExec);
	}

	/*
	* Gets the -LAST-   information data pointer 
	* @return The pointer to the referenced object by the -LAST- 
	*/
	CommandObject * CommandsRegisterStructure ::getLast_Pointer ()
	{ 
		return  getCommandAt(lastAction);
	}

	/*
	* Gets the command at the given position 
	* @return The pointer to the referenced object by the position
	*/
	CommandObject * CommandsRegisterStructure :: getCommandAt(int position)
	{
		if(position< getCommandsCount())
		{
			return registeredActions[position];
		}
		return NULL;
	}

	/*
	* Gets the index of the actualAction in the vector
	* @return actualIndexToExec Is the corresponding index
	*/
	int CommandsRegisterStructure :: getActualIndex()
	{
		return actualIndexToExec;
	}

	/*
	* Gets the index of the lasAction in the vector
	* @return lasAction Is the corresponding index
	*/
	int CommandsRegisterStructure :: getLasIndex()
	{
		return lastAction;
	}

	/*
	* Sets the index of the actualAction in the vector
	* @param newActualIndex Is the corresponding index
	*/
	void CommandsRegisterStructure :: setActualIndex(int newActualIndex)
	{
		actualIndexToExec = newActualIndex;
	}

	/*
	* Sets the index of the lasAction in the vector
	* @param newLasIndex Is the corresponding index
	*/
	void CommandsRegisterStructure :: setLasIndex(int newLasIndex)
	{
		lastAction = newLasIndex;
	}

	/*
	* Gets the registered commands vector size
	* @return Returns the vector size
	*/
	int CommandsRegisterStructure :: getRegistereCommandsCount()
	{
		return registeredActions.size();
	}

	/*
	* Gets the total registered commands 
	* @return Returns the total of commands
	*/
	int CommandsRegisterStructure :: getTotalCommandsCount()
	{
		int totalAccum = 0;
		for( int i=0; i< registeredActions.size(); i++)
		{
			totalAccum+= registeredActions[i]->count();
		}
		return totalAccum;
	}
   
 
