/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "ComposedCommand.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file ComposedCommand.cxx */

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------


	ComposedCommand :: ComposedCommand( )
	{

	}

	ComposedCommand :: ~ComposedCommand( )
	{
		clear();	
	}

//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------
	
	/*
	* Adds a command to the list of command
	* @param nwCommand Is the new command to include
	*/
	void ComposedCommand :: addCommand(CommandObject * nwCommand)
	{	
		internalCommands.push_back(nwCommand);
	}

	/*
	* Virtual method implentation that includes the commands list into the given queue for execution
	* @param executionQueue Is the queue in which is included the command
	*/
	void ComposedCommand :: includeToExecute(std::deque<CommandObject* > &executionQueue)
	{
        std::deque<CommandObject *>::iterator actualCommandIter = internalCommands.end();
		while( actualCommandIter != internalCommands.begin())
		{
			(*actualCommandIter)->includeToExecute(executionQueue);			
			actualCommandIter--;			
		}	
	}

	/*
	* Virtual method implementation that returns 1 as the ExecutableCommand is just one command effective
	* @return The value of commands that represents this
	*/
	int ComposedCommand :: count()
	{
		int count = 0;
		int i =0;
		while( i<internalCommands.size() )
		{
			count += internalCommands[i]->count();	
			i++;
		}
		return count;
	}

	/*
	* Virtual method implentation that that clears the commands inside the composed command calling each one to clean it self
	*/
	void ComposedCommand :: clear()
	{		
		while( internalCommands.size()>0 )
		{
			internalCommands.back()->clear();
			internalCommands.pop_back();
		}
		internalCommands.clear();
	}
		
		
