/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "ContourThing.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file ContourThing.cxx */

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------

	/*
	* Creates a ContourThing 
	*/
	ContourThing :: ContourThing(manualBaseModel * model)
	{
		setModel( model );
	}

	/*
	* Destroys a ContourThing 
	*/
	ContourThing :: ~ContourThing()
	{

	}

//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* 
	*/
	std::string ContourThing :: getName()
	{
		return outlineName;
	}

	/*
	*
	*/
	void ContourThing :: setName(std::string  aName)
	{
		outlineName = aName;
	}

	manualBaseModel * ContourThing ::getModel()
	{
		return theModel;
	}

	void ContourThing :: setModel(manualBaseModel * model)
	{
		theModel = model;
	}

	/*
	* Executes the given command if posible and returns is posible or not
	* @param theSpecificCommand Is the specific command to execute
	* @return Returns if the command was successfuly executed
	*/
	bool ContourThing :: executeCommand (CommandObject * theSpecificCommand)
	{
		return true;
	}

	/*
	* Interprets the given command and constructs the opposite command for returning it
	* @param theSpecificDOCommand Is the specific DO command 
	* @return Returns the UNDO command of the given one
	*/
	CommandObject * ContourThing :: getUndoCommandOf(CommandObject * theSpecificDOCommand)
	{
		ExecutableCommand * unDOcommand = new ExecutableCommand("UNDO command");
		return unDOcommand;
	}
   

